<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

define("ALK_B_ATYPE_LSDIF", true);

// Table : LSDIF_MSG
// msg_etat : 0=ajout, 1=modif, 2=en attente d'envoi, 3=envoyé
// msg_group: 0=groupé, 1=individuel
// msg_type : 0=mailing, 1=synd, 2=newsletter, 3=newsletter editoriale, 4=modèle
$tabTable["lsdif_msg"] = array(
  "msg_id"       => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id"     => array("type" => "int", "dn" => "NOT NULL"),
  "msg_date"     => array("type" => "datetime", "dn" => "NOT NULL"),
  "msg_datenv"   => array("type" => "datetime", "dn" => ""),
  "msg_public"   => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "agent_id"     => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "msg_idfrom"   => array("type" => "int", "dn" => ""),
  "msg_idreply"  => array("type" => "int", "dn" => ""),
  "msg_sujet"    => array("type" => "varchar(255)", "dn" => ""),
  "msg_message"  => array("type" => "text", "dn" => ""),
  "msg_pj"       => array("type" => "varchar(800)", "dn" => ""),
  "msg_etat"     => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "msg_group"    => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "msg_type"     => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  );

$tabPk["lsdif_msg"]["pk_lsdif_msg"] = "msg_id";

$tabIdx["lsdif_msg"] = array(
  "lsdifmsg_appliid_fk" => "appli_id",
  "lsdifmsg_agentid_fk" => "agent_id",
  );

$tabFk["lsdif_msg"] = array(
  "fk_lsdifmsg_appliid" => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
  "fk_lsdifmsg_agentid" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  );

$tabSeq["seq_lsdif_msg"] = "1";

// table association d'un message à une lettre
$tabTable["lsdif_msg_page"] = array(
  "msg_id"         => array("type" => "int", "dn" => "NOT NULL"),
  "page_id"        => array("type" => "int", "dn" => "NOT NULL"),
  "langue_id"      => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
);

$tabPk["lsdif_msg_page"]["pk_lsdif_msg_page"] = "msg_id, page_id";

$tabIdx["lsdif_msg_page"] = array(
  "lsdifmsgpage_msgid_fk"  => "msg_id",
  "lsdifmsgpage_pageid_fk" => "page_id",
  );

$tabFk["lsdif_msg_page"] = array(
  "fk_lsdifmsgpage_msgid"  => array("ffk" => "msg_id", "tpk" => "lsdif_msg", "fpk" => "msg_id"),
  "fk_lsdifmsgpage_pageid" => array("ffk" => "page_id", "tpk" => "gedit_01_page", "fpk" => "page_id"),
  );

// table LSDIF_MSG_LISTE
$tabTable["lsdif_msg_liste"] = array(
  "msg_id"   => array("type" => "int", "dn" => "NOT NULL"),
  "liste_id" => array("type" => "int", "dn" => "NOT NULL"),
);

$tabPk["lsdif_msg_liste"]["pk_lsdif_msg_liste"] = "msg_id, liste_id";

$tabIdx["lsdif_msg_liste"] = array(
  "lsdifmsgliste_msgid_fk"  => "msg_id",
  "lsdifmsgliste_listeid_fk" => "liste_id",
  );

$tabFk["lsdif_msg_liste"] = array(
  "fk_lsdifmsgliste_msgid"   => array("ffk" => "msg_id", "tpk" => "lsdif_msg", "fpk" => "msg_id"),
  "fk_lsdifmsgliste_listeid" => array("ffk" => "liste_id", "tpk" => "sit_liste", "fpk" => "liste_id"),
  );


// Table : LSDIF_DEST
// dest_etat : 0= non envoyé, 1=envoyé par l'appli, 2=envoyé et confirmé par le relai smtp
$tabTable["lsdif_dest"] = array(
  "abonne_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "msg_id"       => array("type" => "int", "dn" => "NOT NULL"),
  "dest_visible" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "dest_etat"    => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  );
$tabPk["lsdif_dest"]["pk_lsdif_dest"] = "abonne_id, msg_id";

$tabIdx["lsdif_dest"] = array(
  "lsdifdest_abonneid_fk" => "abonne_id",
  "lsdifdest_msgid_fk"   => "msg_id",
  );

$tabFk["lsdif_dest"] = array(
  "fk_lsdifdest_abonneid" => array("ffk" => "abonne_id", "tpk" => "sit_abonne", "fpk" => "abonne_id"),
  "fk_lsdifdest_msgid"    => array("ffk" => "msg_id", "tpk" => "lsdif_msg", "fpk" => "msg_id"),
  );

// séquence pour pièces jointes
$tabSeq["seq_lsdif_01_pj"] = "1";

// Table : lsdif_form_bloc
$tabTable["lsdif_form_bloc"] = array(
  "bloc_id"       => array("type" => "int", "dn" => "NOT NULL"),
  "form_titre_fr" => array("type" => "varchar(150)", "dn" => ""),
  "form_titre_en" => array("type" => "varchar(150)", "dn" => ""),
  "form_desc_fr"  => array("type" => "varchar(255)", "dn" => ""),
  "form_desc_en"  => array("type" => "varchar(255)", "dn" => ""),
  );
$tabPk["lsdif_form_bloc"]["pk_lsdif_form_bloc"] = "bloc_id";

$tabIdx["lsdif_form_bloc"] = array(
  "lsdifformbloc_blocid_fk" => "bloc_id",
  );

$tabFk["lsdif_form_bloc"] = array(
  "fk_lsdifformbloc_blocid_fk" => array("ffk" => "bloc_id", "tpk" => "gedit_01_bloc", "fpk" => "bloc_id"),
  );

// Table : lsdif_liste_bloc
$tabTable["lsdif_liste_bloc"] = array(
  "bloc_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "liste_id"   => array("type" => "int", "dn" => "NOT NULL"),
  "liste_rang" => array("type" => "int", "dn" => "default 1 NOT NULL"),
  );
$tabPk["lsdif_liste_bloc"]["pk_lsdif_liste_bloc"] = "bloc_id, liste_id";

$tabIdx["lsdif_liste_bloc"] = array(
  "lsdiflistebloc_blocid_fk"  => "bloc_id",
  "lsdiflistebloc_listeid_fk" => "liste_id",
  );

$tabFk["lsdif_liste_bloc"] = array(
  "fk_lsdiflistebloc_blocid"  => array("ffk" => "bloc_id", "tpk" => "gedit_01_bloc", "fpk" => "bloc_id"),
  "fk_lsdiflistebloc_listeid" => array("ffk" => "liste_id", "tpk" => "sit_liste", "fpk" => "liste_id"),
  );

// vues                                   
$tabView["v_gedit_lsdif_cat"] = "(APPLI_ID, CAT_ID, CAT_INTITULE_FR, CAT_DESC_FR, CAT_INTITULE_EN, CAT_DESC_EN, USER_ID, RIGHT_ID) as
select r.APPLI_ID, l.LISTE_ID as CAT_ID, 
  l.LISTE_INTITULE_FR as CAT_INTITULE_FR, l.LISTE_DESC_FR as CAT_DESC_FR, 
  ".$dbConn->getCast("''", "varchar(255)")." as CAT_INTITULE_EN, ".$dbConn->getCast("''", "varchar(255)")." as CAT_DESC_EN, 
  dr.AGENT_ID, dr.APPLI_DROIT_ID
from LSDIF_MSG r 
  inner join LSDIF_MSG_LISTE ml on r.MSG_ID=ml.MSG_ID
  inner join SIT_LISTE l on ml.LISTE_ID=l.LISTE_ID
  inner join SIT_AGENT_APPLI dr on r.APPLI_ID=dr.APPLI_ID
where r.MSG_TYPE=2";
    
$tabView["v_gedit_lsdif_data"] = "(CONT_ID, APPLI_ID, CAT_ID, DATA_ID, DATA_TYPE, 
 CAT_INTITULE_FR, CAT_INTITULE_EN,
 DATA_TITRE_FR, DATA_DESCL_FR, DATA_DESC_FR,
 DATA_TITRE_EN, DATA_DESCL_EN, DATA_DESC_EN,
 DATA_DATEPDEB, DATA_DATEPFIN, DATA_DATEMAJ, DATA_VALIDEPUB, DATA_VALIDESYND,
 USER_ID, RIGHT_ID) as
select ac.CONT_ID, ac.APPLI_ID, 0 as CAT_ID, l.LISTE_ID as DATA_ID, 0 as DATA_TYPE,
  l.LISTE_INTITULE_FR as CAT_INTITULE_FR,  ".$dbConn->getCast("''", "varchar(255)")." as CAT_INTITULE_EN,
  l.LISTE_INTITULE_FR as DATA_TITRE_FR, l.LISTE_DESC_FR as DATA_DESCL_FR, ".$dbConn->getCast("''", "varchar(255)")." as DATA_DESC_FR,
  ".$dbConn->getCast("''", "varchar(255)")." as DATA_TITRE_EN, ".$dbConn->getCast("''", "varchar(255)")." as DATA_DESCL_EN, ".$dbConn->getCast("''", "varchar(255)")." as DATA_DESC_EN,  
  ".$dbConn->getDateCur()." as DATA_DATEPDEB, ".$dbConn->getDateCur()." as DATA_DATEPFIN,
  ".$dbConn->getDateCur()." as DATA_DATEMAJ, 1 as DATA_VALIDEPUB, 1 as DATA_VALIDESYND,
  dr.AGENT_ID, dr.APPLI_DROIT_ID
from LSDIF_MSG f 
  inner join LSDIF_MSG_LISTE ml on ml.MSG_ID=f.MSG_ID
  inner join SIT_LISTE l on ml.LISTE_ID=l.LISTE_ID
  inner join SIT_AGENT_APPLI dr on f.APPLI_ID=dr.APPLI_ID
  inner join SIT_APPLI_CONT ac on dr.APPLI_ID=ac.APPLI_ID
where f.MSG_TYPE=2";

//   Type application
$tabIns[] = "INSERT INTO SIT_APPLI_TYPE (ATYPE_ID, ATYPE_ID_DIST, ATYPE_INTITULE, ATYPE_ABREV, ATYPE_URL, ATYPE_URL_ADMIN,".
  " ATYPE_URL_SITE, ATYPE_DROIT, ATYPE_DISPO, ATYPE_DESC, ATYPE_URL_TARGET, ATYPE_COMPATIBLE, ATYPE_LOGO, ATYPE_ADMIN_LOGO)".
  " VALUES (6, -1, 'Mailing', 'lsdif', '', '', NULL, 0, 1, '', '', 1, 'picto06_lsdif.gif', '')";

//   constante php
$tabIns[] = "delete from SIT_CONSTANTE where ATYPE_ID=6";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (-1,-1,'ALK_B_ATYPE_LSDIF','true',3,'Module installé',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (6,-1,'ALK_B_LSDIF_SEARCHUSERBYSPACE','false',3,'Réduire la liste des utilisateurs de lannuaire aux invités de lespace',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (6,-1,'ALK_B_LSDIF_EDITOR_LONGDESC','true',3,'Rédiger le message avec CKEditor',0)";  
?>