<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet
Module fournissant l'interface d'authentification Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once("../../lib/lib_session.php");

AlkRequest::readToken();

$strLogin = AlkRequest::getToken("l", "");
$strPwd   = AlkRequest::getToken("p", "");
$iRes     = AlkRequest::getToken("r", "0");

$strTokenValid = AlkRequest::getEncodeParam("l=".$strLogin."&p=".$strPwd."&r=1");

// vérification du token
define("ALK_B_ATYPE_ANNU", true);
  
$oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
$dsAgent = $oQueryAnnu->getDs_ficheAgentByLoginPwd($strLogin, $strPwd);
$agent_id = "-1";
if( $drAgent = $dsAgent->getRowIter() ) {
  $agent_id = $drAgent->getValueName("AGENT_ID");
} 

if( $agent_id == "-1" ) {
  // attaque probable, on quitte brusquement
  header($_SERVER["SERVER_PROTOCOL"]." 404 Not Found");
  echo "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">
    <html><head>
    <title>404 Not Found</title>
    </head><body>
    <h1>Not Found</h1>
    <p>The requested URL was not found on this server.</p>
    </body></html>";
  exit(); 
}

if( $iRes == "1" ) {
  // cas modif du mot de passe
  /** mot de passe crypté */
  $strPwd = AlkRequest::_POST("strPwd", "");
  if( $strPwd != "" ) { 
    $oQueryActionAnnu = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
    $oQueryActionAnnu->updateUserPwd($agent_id, $strPwd);
  } else {
    // attaque probable, on quitte brusquement
    header($_SERVER["SERVER_PROTOCOL"]." 404 Not Found");
    echo "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">
      <html><head>
      <title>404 Not Found</title>
      </head><body>
      <h1>Not Found</h1>
      <p>The requested URL was not found on this server.</p>
      </body></html>";
    exit(); 
  }
} else {
  /** chargement des constantes */
  define("ALK_B_ATYPE_ESPACE", true);
  AlkFactory::loadConstants(-1, -1);
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<title>Administration GEOPAL</title>
<meta name="language" content="FR"/>
<link rel="stylesheet" href="../../styles/home.css" type='text/css'/>
<meta name="ROBOTS" content="NOINDEX, NOFOLLOW"/>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<script type='text/javascript' src='../../lib/lib_js.js'></script>
<script type='text/javascript' src='../../lib/lib_crypt.js'></script>
<script type='text/javascript' src='lib/index.js'></script>
</head>
<body class="home" onload="onLoadWindChgPwd();">
<form id="formLogin" name="formLogin" method="post" action="" onsubmit="validIdent()">
  
  <div align="center">
    <div class="homeBackgound">
     <fieldset class='homeFieldSet'>

<?php

echo ( $iRes == "0"
  ? "      <div class='homeFrameErr' style='text-align:center; padding-top:10px;'>\n".
    "         <span class='homeTxt'>Veuillez saisir<br/>votre nouveau mot de passe.</span>\n".
    "      </div>\n".
    "      <div class='homeFrameLogin'>\n".
    "        <label class='homeLabel' for='strLogin'>Identifiant</label>\n".
    "        <input class='homeCtrl' id='strLogin' name='strLogin' value=\"".$strLogin."\" disabled='disabled' type='text' size='15' maxlength='80'/>\n".
    "      </div>\n".
  
    "      <div class='homeFramePwd'>\n".
    "        <label class='homeLabel' for='strPwd2'>Mot de passe</label>\n".
    "        <input type='hidden' id='strPwd' name='strPwd' value=''/>".
    "        <input type='hidden' id='pwdMinLen' name='pwdMinLen' value='".ALK_ANNU_LG_MIN_PWD."'/>".
    "        <input type='hidden' id='tokenValid' name='tokenValid' value='".$strTokenValid."'/>".
    "        <input class='homeCtrl' id='strPwd2' name='strPwd2' type='password' value='' size='15' maxlength='80'/>\n".
    "      </div>\n".
    "      <div class='homeFramePwd2'>\n".
    "        <label class='homeLabel' for='strPwd3'>Vérification</label>\n".
    "        <input class='homeCtrl' id='strPwd3' name='strPwd3' type='password' value='' size='15' maxlength='80'/>\n".
    "      </div>\n".
  
    "      <div class='homeFrameBt2'>\n".
    "        <input id='btValider' name='btValider' type='image' src='../../media/images/ok.gif' value='Valider'/>\n".
    "      </div>\n"
    
  : "      <div class='homeFrameErr' style='text-align:center; padding-top:10px;'>\n".
    "         <span class='homeTxt'>Votre mot de passe a été modifié avec succès.<br/><br/>".
    "         <a class='homeLink' onclick=\"javascript:document.formLogin.submit()\" href='#'>Se connecter...</a>.</span>\n".
    "         <input type='hidden' id='windSize' name='windSize' value=''/>\n".
    "         <input type='hidden' id='strLogin' name='strLogin' value=\"".$strLogin."\"/>\n".
    "         <input type='hidden' id='strPwd' name='strPwd' value=\"".$strPwd."\"/>\n".
    "      </div>\n" ).

  "     </fieldset>\n".
  "    </div>\n" .
  "  </div>\n" .
  "</form>\n".
  "</body></html>\n";

?>
