<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet
Module fournissant l'interface d'authentification Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once("../../lib/lib_session.php");

$err = AlkRequest::_GETint("err", "");
$strPrevUrl = AlkRequest::_GET("url", "");

$strHost = $_SERVER["HTTP_HOST"];
if( ALK_ROOT_URL != "http://".$strHost ) {
  header("location: ".ALK_ROOT_URL."/index.php");
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<title>Administration GEOPAL</title>
<meta name="language" content="FR"/>
<link rel="stylesheet" href="../../styles/home.css" type='text/css'/>
<meta name="ROBOTS" content="NOINDEX, NOFOLLOW"/>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<script type='text/javascript' src='../../lib/lib_js.js'></script>
<!--<script type='text/javascript' src='../../lib/jquery/jquery-ui-1.8.2.custom.css'></script>
<script type='text/javascript' src='../../lib/jquery/jquery-1.4.2.min.js'></script>
<script type='text/javascript' src='../../lib/jquery/jquery-ui-1.8.2.custom.min.js'></script>
<script type='text/javascript' src='../../lib/lib_js_jquery.js'></script>-->
<script type='text/javascript' src='../../lib/lib_crypt.js'></script>
<script type='text/javascript' src='lib/index.js'></script>
</head>
<body class="home" onload="onLoadWind();">
<form id="formLogin" name="formLogin" method="post" action="" onsubmit="validIdent('<?php echo $strPrevUrl; ?>')">
  <input type="hidden" id="windSize" name="windSize" value=""/>
  <input type="hidden" id="strPwd" name="strPwd" value=""/>
  <div align="center">
    <div class="homeBackgound">
     <fieldset class='homeFieldSet'>

<?php

$strTokenHelp = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_CONTACT."&iSSheet=".ALK_SHEET_NONE);
$strTokenPwd  = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_CREATEUSER."&iSSheet=".ALK_SHEET_NONE."&err=0");
$strTokenInsc = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_CREATEUSER."&iSSheet=".ALK_SHEET_NONE."&err=1");
if( $err != "" ) {
  $strHtml = "";
  
  switch( $err ) {
  case "1":
    $strHtml = "Authentification refusée.<br/>".
      "Essayez &agrave; nouveau, ou si vous continuez à ne pas y arriver,".
      " <a class='homeLink' href='#' onclick=\"javascript:help('".$strTokenHelp."')\">contactez un administrateur</a>.";
    break;
  case "2":
     $strHtml = "Votre session a expiré.<br/>Veuillez vous réauthentifier.<br/>";
     break;
  case "3":
     $strHtml = "Vous n'êtes invité à aucun espace.<br/>".
       "Veuillez contacter <a class='homeLink' href='#' onclick=\"javascript:help('".$strTokenHelp."')\">".
       "l'administrateur</a> pour qu'il paramètre votre compte.<br/>";
     break;
  case "4":
     $strHtml = "Votre compte est désactivé.<br/>Veuillez renseigner <a class='homeLink' href='#'".
       " onclick=\"javascript:getLogin('".$strTokenInsc."')\">ce formulaire</a> pour le réactiver.<br/>&nbsp;";
     break;
  case "5":
     $strHtml = "Votre compte est en cours de validation.<br/>Il sera prochainement activé.<br/>&nbsp;";
     break;
  case "6":
     $strHtml = "Vos droits ne vous ont pas permis d'atteindre une fonctionnalité.<br/>".
       "Veuillez vous réauthentifier.<br/>&nbsp;";
  case "7":
     $strHtml = "L'adresse de la page demandée est non valide.<br/>".
       "Veuillez vous réauthentifier.<br/>&nbsp;";
  }
  if( $strHtml != "" ) echo "      <div class='homeFrameErr homeErr'>".$strHtml."</div>\n";
} else {
   echo "      <div class='homeFrameErr' style='text-align:center; padding-top:10px;'>".
     "<span class='homeTxt'>Veuillez saisir votre identifiant<br/>".
     " et votre mot de passe.</span></div>\n";
}

$strPathFileName = ALK_ALKANET_ROOT_PATH."scripts/ident/configurer_navigateur.pdf";

echo 
  "      <div class='homeFrameLogin'>\n".
  "        <label class='homeLabel' for='strLogin'>Identifiant</label>\n".
  "        <input class='homeCtrl' id='strLogin' name='strLogin' type='text' size='15' maxlength='80'/>\n".
  "      </div>\n".

  "      <div class='homeFramePwd'>\n".
  "        <label class='homeLabel' for='strPwd2'>Mot de passe</label>\n".
  "        <input class='homeCtrl' id='strPwd2' name='strPwd2' type='password' size='15' maxlength='80'/>\n".
  "      </div>\n".

  "      <div class='homeFrameBt'>\n".
  "        <input id='btValider' name='btValider' type='image' src='../../media/images/ok.gif' value='Valider'/>\n".
  "      </div>\n".

  "      <div class='homeFrameOubli'>\n".
  "        <a class='homeLink' href='#' onclick=\"javascript:getLogin('".$strTokenPwd."')\">Mot de passe oublié?</a>\n".
  "      </div>\n".

 /* "      <div class='homeFrameHelp'>\n".
  "        <a class='homeLink' href='#' onclick=\"javascript:getLogin('".$strTokenInsc."')\">Vous souhaitez vous inscrire</a>\n".
  "      </div>\n".*/

  ( file_exists($strPathFileName) && is_file($strPathFileName) 
    ? "      <div class='homeFramePdf'>\n".
      "        <a class='homeLink' href='configurer_navigateur.pdf' target='windPDF'>Information pour configurez son navigateur</a>\n".
      "      </div>\n"
    : "" ).

  "     </fieldset>\n".
  "    </div>\n" .
  "  </div>\n" .
  "</form>\n".
  "</body></html>\n";

?>
