{*licence 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::CEdit
Module consultation éditoriale..
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

licence*}
{strip}
{php}
if( !defined("ALK_B_ATYPE_ESPACE") ) define("ALK_B_ATYPE_ESPACE", true);
if( !defined("ALK_B_ATYPE_IEDIT") ) define("ALK_B_ATYPE_IEDIT", true);

$this->assign("alkAlkanetRootUrl", ALK_ALKANET_ROOT_URL);

$user_id     = AlkFactory::getSProperty("user_id", "-1");
$data_id     = AlkRequest::getToken("data_id", AlkRequest::_GETint("data_id", "-1"));
$iAddComment = AlkRequest::_GETint("ac", 0);

$this->assign ('iAddComment', $iAddComment);

$oAppliIEdit = AlkFactory::getAppli(ALK_ATYPE_ID_IEDIT);
$tabData = $oAppliIEdit->getDataContents($data_id, TASSOC_BYDATA+TASSOC_TOUTETATPUB, $user_id); 

foreach($tabData[0]["data_pj"] as $iKey => $tabPj) {
  $tabData[0]["data_pj"][$iKey]["ssize"] = getFileSize($tabPj["size"]);
  $strKey = "xsmall";
  $strPathFile_small = getImageNameByPattern($tabPj["strPathFile"], $strKey);
  $tabData[0]["data_pj"][$iKey]["strPathFile_small"] = ( $strPathFile_small != $tabPj["strPathFile"] ? $strPathFile_small : "" );
  $strUrlFile_small = getImageNameByPattern($tabPj["strUrlFile"], $strKey);
  $tabData[0]["data_pj"][$iKey]["strUrlFile_small"] = ( $strUrlFile_small != $tabPj["strUrlFile"] && file_exists($strPathFile_small) ? $strUrlFile_small : "" );
  $strKey = "large";
  $strPathFile_large = getImageNameByPattern($tabPj["strPathFile"], $strKey);
  $tabData[0]["data_pj"][$iKey]["strPathFile_large"] = ( $strPathFile_large != $tabPj["strPathFile"] ? $strPathFile_large : "" );
  $strUrlFile_large = getImageNameByPattern($tabPj["strUrlFile"], $strKey);
  $tabData[0]["data_pj"][$iKey]["strUrlFile_large"] = ( $strUrlFile_large != $tabPj["strUrlFile"] && file_exists($strPathFile_large) ? $strUrlFile_large : "" );
  $tabData[0]["data_pj"][$iKey]["strUrlDownload"] = ALK_ALKANET_DOWNLOAD."?token=".AlkRequest::getEncodeParam("&cont_id=".$tabData[0]["cont_id"]."&appli_id=".$tabData[0]["appli_id"]."&user_id=".AlkFactory::getSProperty("user_id", -1)."&data_id=".$tabData[0]["data_id"]."&pj_id=".$tabPj["pj_id"]."&tableName=IEDIT_PJ");
  $tabData[0]["data_pj"][$iKey]["strUrlDownloadForSite"] = ALK_ALKANET_ROOT_URL."getliendoc.php?n=".$tabData[0]["cont_id"]."/".extractFileName($tabPj["strUrlFile"]);
}
//print_r($tabData);
$this->assign('data', $tabData[0]);
$this->assign('strPageLg', 'FR');
$this->assign('strPjTarget', 'target="_blank"');
$this->assign('tabLang', $GLOBALS["tabLg"]);

/* récupère les classifications de la donnée */
$tabClassif = array();
$oDbConn = AlkFactory::getDbConn();
require_once(ALK_ALKANET_ROOT_PATH."libconf/classes/alkquerydataged.class.php");
$oQueryDataGed = new AlkQueryDataGed($oDbConn);
$tabDataClassementGed = $oQueryDataGed->getTabDataClassementGedById($data_id);
if ( isset($tabDataClassementGed["Espace"]) ) {
  $tabClassif["Espace"] = $tabDataClassementGed["Espace"];
}
$appli_id_iedit = $tabData["0"]["appli_id"];
$oAppliCollab = AlkFactory::getAppli(ALK_ATYPE_ID_COLLAB);
$dsClassifType = $oAppliIEdit->oQuery->getDsTypeClassif($appli_id_iedit, $tabData["0"]["data_type"]);
while( $drClassifType = $dsClassifType->getRowIter() ) {
  $classiftype_id       = $drClassifType->getValueName("CLASSIFTYPE_ID");
  $classiftype_intitule = $drClassifType->getValueName(AlkFactory::getDBCurrentLanguageField("CLASSIFTYPE_INTITULE"));
  $iMultiple            = $drClassifType->getValueName("CLASSIFTYPE_MULTIPLE");
  $classiftype_rang     = $drClassifType->getValueName("CLASSIFTYPE_RANG");
  
  $dsClassif = $oAppliIEdit->oQuery->getDsClassifByDataId($tabData[0]["data_id"], $classiftype_id, 0, -1, true);
  while ( $drClassif = $dsClassif->getRowIter() ) {
    $tabClassif[$classiftype_intitule][] = $drClassif->getValueName("CLASSIF_PATH".ALK_LG_BDD);
  }
}
if ( isset($tabDataClassementGed["Activité"]) ) {
  $tabClassif["Activité"] = $tabDataClassementGed["Activité"];
}
$this->assign('tabClassif', $tabClassif);

// récupère la nature du document (activité, source, catégorie, sous-catégorie, collection, rubrique, année, numéro, thème, sous-thème)
$tabDataInfoGed = $oQueryDataGed->getTabDataInfoGedByIdForConsult($data_id);
//print_r($tabDataInfoGed);
$this->assign('tabDataInfoGed', $tabDataInfoGed);

if(file_exists(ALK_ALKANET_ROOT_PATH."styles/collab.css") && is_file(ALK_ALKANET_ROOT_PATH."styles/collab.css")){
  $this->_tpl_vars["oPanel"]->addScriptCss("collab.css");
} else { 
  $this->_tpl_vars["oPanel"]->addScriptCss("../scripts/collab/templates/collab.css");
}

$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_js.js");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_js.php");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_jsaddon.js");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_ajax.js");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formcheck.js");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formdate.js");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formnumber.js");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formselect.js");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_form.js");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formtxt.js");
$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."libconf/lib/lib_comment.js");

$this->_tpl_vars["oPanel"]->addScriptJs(ALK_ALKANET_ROOT_URL."libconf/lib/jquery.lightbox-0.5.js");

$GLOBALS["oHtmlPage"]->addScriptCss("extranet/jquery-ui-1.8.16.custom.css");
$GLOBALS["oHtmlPage"]->addScriptCss("ged.css");
$this->_tpl_vars["oPanel"]->addScriptCss("jquery.lightbox-0.5.css");
$this->_tpl_vars["oPanel"]->addJs("//<![CDATA[
      //jQuery.noConflict();  

      var lighBoxOpts = {
          'imageLoading'  :   '/media/site/lightbox/lightbox-ico-loading.gif',
          'imageBtnPrev'  :   '/media/site/lightbox/lightbox-btn-prev.gif',
          'imageBtnNext'  :   '/media/site/lightbox/lightbox-btn-next.gif',
          'imageBtnClose' :   '/media/site/lightbox/lightbox-btn-close.gif',
          'imageBlank'    :   '/media/site/lightbox/lightbox-blank.gif',
          'txtOf'         :   'sur',
          'slideshow'     :    false,
          'nextSlideDelay':    5000
      }
      
      $(function() {
        //jQuery('a.lightbox').lightBox(lighBoxOpts);
        $('a.lightbox').lightBox(lighBoxOpts);
        $('#tabs').tabs();
      });
          
      //]]>");

$strKey = "xsmall";
$data_visuel_defaut = $str_path.getImageNameByPattern($this->_tpl_vars["data"]["data_visuel"], $strKey);
$this->assign('data_visuel_defaut', $data_visuel_defaut);
  
$strKey = "large";
$data_visuel_large = $str_path.getImageNameByPattern($this->_tpl_vars["data"]["data_visuel"], $strKey);
$this->assign('data_visuel_large', $data_visuel_large);

$iNbImgDiaporamaParLigne = 999;
$this->assign('iNbImgDiaporamaParLigne', $iNbImgDiaporamaParLigne);

{/php}

{if $data}
<div id="collab_viewer">
  {if $data.data_datedeb!="" or $data.data_datefin!=""}
  <!--
  <p>
    <strong>{if $data.data_datedeb!=""}{$data.data_datedeb}{/if}{if $data.data_heuredeb!="00:00"}&nbsp;{$data.data_heuredeb}{/if}
           {if $data.data_datefin!=""} &ndash; {$data.data_datefin}{if $data.data_heurefin!="00:00"}&nbsp;{$data.data_heurefin}{/if}{/if}</strong>
  </p>
  -->
  {/if}
  <h2>{$data.data_title}</h2>
  
  <!-- <div id="separateur"></div> -->
  {if $data.data_visuel != ""}
    <p>
      {if $data.data_nbpj>0}
        {assign var=iCptMedia value=0}
        {foreach from=$data.data_pj item="pj" name="pjs"}
          {if $pj.strNameAff|lower|contains:'.jpg' or $pj.strNameAff|lower|contains:'.gif' or $pj.strNameAff|lower|contains:'.png'} 
            {assign var=iCptMedia value=$iCptMedia+1}
          {/if}
        {/foreach}
      {/if}
         
      <a href="{$data_visuel_large}" title="{if $data.data_visuel_pj_title != ""}{$data.data_visuel_pj_title}{else}{$data.data_title}{/if}" class="lightbox">
        <img src="{$data_visuel_defaut}" alt="{if $data.data_visuel_pj_title != ""}{$data.data_visuel_pj_title}{else}{$data.data_title}{/if}" title="{if $data.data_visuel_pj_title != ""}{$data.data_visuel_pj_title}{else}{$data.data_title}{/if}" class="normale" />
        {if $iCptMedia>1 && 1==0}<br/>Afficher le diaporama{/if}
      </a>
      <!-- <br /><span class="illustration">Légende de l'image, légende, légende de l'image, légende, légende de l'image</span> -->
    </p>
  {/if}
  
  {if $data.data_desc != ""}
    <p><strong>{$data.data_desc|nl2br}</strong></p>
  {/if}
  {if $data.data_descl != "" }
    <p>{$data.data_descl}</p>
  {/if}
  {if $data.data_datedeb!=""}
    <p>
      {t}Date : {/t}{$data.data_datedeb}{/if}
      {if $data.data_heuredeb!="00:00"}&nbsp;{$data.data_heuredeb}{/if}
      {if $data.data_datefin!=""} &ndash; {$data.data_datefin}{if $data.data_heurefin!="00:00"}&nbsp;{$data.data_heurefin}{/if}
    </p>
  {/if}
  {if $data.data_lieu != "" }
    <p>{t}Lieu : {/t}{$data.data_lieu}</p>
  {/if}
  {if $data.data_auteur != "" }
    <p>{t}Auteur : {/t}{$data.data_auteur}</p>
  {/if}
  {if $data.data_dateparution != "" }
    <p>{t}Date : {/t}{$data.data_dateparution}</p>
  {/if}

  {if $data.data_url != ""}
    <h3>{t}En savoir plus :{/t}</h3>
    <ul class="liens"><li><a href="{if not $data.data_url|contains:'http://'}http://{/if}{$data.data_url}" target="_blank" class="">{$data.data_url}</a></li></ul>
  {/if}
  
  <div id="tabs">
    <ul>
      <li><a href="#data_pjs">{t}Données{/t}</a></li>
      <li><a href="#data_classement">{t}Classement{/t}</a></li>
      <li><a href="#data_classification">{t}Indexation{/t}</a></li>
    </ul>
    
    <div id="data_pjs">
      {if $data.data_nbpj>0}
        {if $data.data_type == ALK_ATYPE_ID_DOC}
          {if !$data.data_typedoc || $data.data_typedoc && $data.data_typedoc == ALK_IEDIT_TYPEDOC_DOC_CLASSIF_ID }
          <ul class="liens">
            {foreach from=$data.data_pj item="pj" name="pjs"}
              <li><a title="{t 1=$pj.strNameAff}Télécharger %1{/t}" href="{$pj.strUrlDownload}" {$strPjTarget}><img src="{$alkAlkanetRootUrl}media/images/{$pj.iconFile}" alt="" border="0" /> {$pj.strNameAff}</a>
              {$pj.ssize},&nbsp;{t 1=$data.data_version}version %1{/t}, {t 1=$pj.date}mis à jour le %1{/t}
              <h3>Lien à utiliser sur le site</h3>
              {$pj.strUrlDownloadForSite}<br/><br/><br/>
              </li> 
            {/foreach}  
          </ul>
          {/if}
          {if $data.data_typedoc && $data.data_typedoc == ALK_IEDIT_TYPEDOC_IMG_CLASSIF_ID }
            <ul class="liens">
            {foreach from=$data.data_pj item="pj" name="pjs"}
              <li style="margin-bottom:12px;">
                {if $pj.strUrlFile_small != "" }
                  <a href="{$pj.strUrlFile_large}" {$strPjTarget} class="{if $pj.strUrlFile_large != ""}lightbox{/if}" title="{if $pj.pj_title != ""}{$pj.pj_title}{else}{$pj.strNameAff}{/if} - {$pj.pj_desc}">
                    <img alt="" src="{$pj.strUrlFile_small}"/>
                  </a>
                {/if}
                <div>
                <a title="{t}Télécharger{/t}" href="{$pj.strUrlDownload}" {$strPjTarget}><b>{if $pj.pj_title != ""}{$pj.pj_title}{else}{$pj.strNameAff}{/if}</b></a>{if $pj.pj_lang != "" } ({$tabLang[$pj.pj_lang]}){/if}<br/>
                {if $pj.pj_desc != "" }{$pj.pj_desc|nl2br}<br/>{/if}
                {if $pj.pj_auteur != "" }{t}Auteur : {/t}{$pj.pj_auteur}<br/>{/if}
                {if $pj.pj_copyright != "" }{t}Copyright : {/t}{$pj.pj_copyright}<br/>{/if}
                {if $pj.pj_datecreafile != "" }{t}Date : {/t}{$pj.pj_datecreafile}<br/>{/if}
                {t 1=$data.data_version}version %1{/t}, {t 1=$pj.date}mis à jour le %1{/t}
                <h3>Lien à utiliser sur le site</h3>
                {$pj.strUrlDownloadForSite}<br/><br/><br/>
                </div>
              </li> 
            {/foreach}  
          </ul>
          {/if}
        {else}
          <ul class="liens">
            {foreach from=$data.data_pj item="pj" name="pjs"}
              <li><a href="{$pj.strUrlDownload}" {$strPjTarget}><img src="{$alkAlkanetRootUrl}/media/images/{$pj.iconFile}" alt="" border="0" /></a>&nbsp;
                  <a href="{$pj.strUrlDownload}" {$strPjTarget}>{$pj.strNameAff}</a>
                  {$pj.ssize}, mis &agrave; jour le {$pj.date}</li> 
            {/foreach}  
          </ul>
        {/if}
      {/if}
    </div>
    
    <div id="data_classement">
      {if $tabClassif|@count > 0 }
        {foreach from=$tabClassif key="classiftype_intitule" item="tabClassif"}
          <h3>{$classiftype_intitule}</h3>
          {foreach from=$tabClassif item="classif_intitule"}
            <ul><li>{$classif_intitule}</li></ul>
          {/foreach}
        {/foreach}
      {/if}
    </div>
    
    <div id="data_classification">
      {foreach from=$tabDataInfoGed key="type_info_ged_intitule" item="tabDataInfoGed"}
        {if $tabDataInfoGed|@count > 0 }
          <h3>{$type_info_ged_intitule}</h3>
          <ul>
          {foreach from=$tabDataInfoGed item="info_ged_intitule"}
            <li>{$info_ged_intitule}</li>
          {/foreach}
          </ul>
        {/if}
      {/foreach}
    </div>
    
  </div>
  
  {if ($data.data_type == ALK_ATYPE_ID_DOC or $data.data_type == ALK_ATYPE_ID_ACTU) and $data.data_bcommentaire==1}
    {include file='../../../scripts/gedit/templates/alkhtmlbloccomment.tpl' bComment=1 idAppli=$data.appli_id idAppliComment=$data.data_idapplicomment data_id=$data.data_id formName=formProperty bAddComment=$iAddComment}
  {/if}
</div>
{else}
  Fiche indisponible.
{/if}
{/strip}