/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

function assoc2Bloc(strToken, bloc_typeassoc, bSaveOnly)
{
  var f = document.formDataSelect;
  var oCtrlA = f.appli_id_filter;
  var oCtrlT = f.cat_id_filter;
  var oCtrlE = f.page_nb_elements;
  var strValueT, strValueA;
  if( bloc_typeassoc == 1 && oCtrlA && oCtrlA.selectedIndex<1 ) {
    alkAlert("Vous devez sélectionner une application.");
    return;
  }
  if( bloc_typeassoc == 2 && oCtrlT && oCtrlT.selectedIndex<1 ) {
    alkAlert("Vous devez sélectionner une catégorie ou l'équivalent.");
    return;
  }
  if( bloc_typeassoc == 3 ) {
    var bCoche = false;
    var oCb = f.elements["listData[]"];
    if( oCb && typeof(oCb.length)=="undefined" ) {
      bCoche = oCb.checked;
    } else if( oCb ) {
      for(i=0; i<oCb.length; i++) {
         bCoche = bCoche || oCb[i].checked;
      }
    }
    
    if( !bCoche && !bSaveOnly ) {
      alkAlert("Vous devez cocher au moins un élément de la liste.");
      return;
    }
  }

  // vérification des propriétés du bloc
  var oCtrlHiddenVFP = document.getElementById("validFProperties");
  if( oCtrlHiddenVFP ) {
    var bRes = eval(oCtrlHiddenVFP.value);
    if( !bRes ) {
  	  return;
    }
  }
  
  // calcul de la valeur de strOrder
  f.bloc_ordre.value = CalculateBlocOrder();
  
  // calcul de la valeur du bloc_desc
  strValueA = ( oCtrlA && oCtrlA.selectedIndex> 0 ? oCtrlA.options[oCtrlA.selectedIndex].text : "tous" );	  
  if( bloc_typeassoc == 1){
  	f.bloc_desc.value =  strValueA;
  }else if( bloc_typeassoc == 2) {
  	strValueT = ( oCtrlT && oCtrlT.selectedIndex> 0 ? oCtrlT.options[oCtrlT.selectedIndex].text : "tous" );
  	f.bloc_desc.value = strValueA + "<br/><i>" +  strValueT+ "</i>";
  }
  f.page_nb_elements = oCtrlE;
  f.action = ALK_ALKANET_SQL+"?token="+strToken;
  f.submit();
}

function onChangeCombo(strToken)
{
  var f = document.formDataSelect;
  var oCtrlC = f.cont_id_filter;
  var oCtrlA = f.appli_id_filter;
  var oCtrlT = f.cat_id_filter;
  var oCtrlE = f.page_nb_elements;
  var idc = ( oCtrlC && oCtrlC.selectedIndex>=0 ? oCtrlC.options[oCtrlC.selectedIndex].value : -1 ); 
  var ida = ( oCtrlA && oCtrlA.selectedIndex>=0 ? oCtrlA.options[oCtrlA.selectedIndex].value : -1 );
  var idt = ( oCtrlT && oCtrlT.selectedIndex>=0 ? oCtrlT.options[oCtrlT.selectedIndex].value : -1 );
  var ide = oCtrlE;
  
  var strParam = "&idc="+idc+"&ida="+ida+"&idt="+idt+"&ide="+ide; 
  var oAjax = new AlkAjax('nameChangeCombo', 'fnLoadChangeCombo', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_AJAX+'?token='+strToken+strParam, null);
}

function fnLoadChangeCombo(strRes)
{
  var f = document.formDataSelect;
  var oCtrlA = f.appli_id_filter;
  var oCtrlC = f.cat_id_filter;
  var oCtrlE = f.page_nb_elements;
  
  oRes = eval("("+strRes+")");
  
  if( oCtrlA && oRes.tabAppli != null ) { 
    updateComboFromTabAlkAjax(oCtrlA, oRes.tabAppli, true, false)
  }
  if( oCtrlC && oRes.tabCat != null ) { 
    updateComboFromTabAlkAjax(oCtrlC, oRes.tabCat, true, false);
  }
  var oDiv = document.getElementById("layerDataList");
  if ( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv );
  oDiv.innerHTML = oRes.strHtmlDataList;
}

/**
 * calcule le type assoc
 * @return une chaine séparée par des virgules
 */
function CalculateBlocOrder()
{
	var oUl = document.getElementById("sortable");	
	if(!oUl) return;
	var tabLi = oUl.childNodes;
	var taborder = new Array();
	// parcours des li , ainsi on garde l'ordre de tri des champs
	for(var i=0; i<tabLi.length;i++){
	  var strNomChamp = tabLi[i].id.toString()+"_hidden";
	  var oCtrlHidden = document.getElementById(strNomChamp);
	  if( oCtrlHidden ) {
	    taborder[taborder.length] = oCtrlHidden.value;
	  }
	}
	
	return taborder.join(',');
}

function DisableFields()
{
	var oSelect = document.getElementById("bloc_filtrecal");
	if(!oSelect) return;
	var oDateDebut = document.getElementById("bloc_datedeb");
	var oDateFin   = document.getElementById("bloc_datefin");
	if (oSelect.options[oSelect.selectedIndex].value=="134217728"||
	    oSelect.options[oSelect.selectedIndex].value=="268435456"||
	    oSelect.options[oSelect.selectedIndex].value=="536870912"||
	    oSelect.options[oSelect.selectedIndex].value=="0") {
	  oDateDebut.disabled="disabled";
	  oDateFin.disabled="disabled";
	} else {
	  oDateDebut.disabled="";
	  oDateFin.disabled="";
	}
}

function initRank()
{
  jQuery(function() {
    jQuery( '#sortable' ).sortable({
      revert: true
    });
    jQuery( '#draggable' ).draggable({
      connectToSortable: '#sortable',
      helper: 'clone',
      revert: 'invalid'
    });
    jQuery( 'ul, li' ).disableSelection();
  });
}

function changeOrder(strHiddenId, iValue, iNextValue)
{
  var oCtrlAClic = document.getElementById(strHiddenId+iValue.toString());
  var oStyle = ( oCtrlAClic.style ? oCtrlAClic.style : oCtrlAClic );
  oStyle.display = "none";
  
  var oCtrlHidden = document.getElementById(strHiddenId+"_hidden");
  if( oCtrlHidden ) {
    oCtrlHidden.value = iNextValue;
  }
  
  var oNewCtrlA = document.getElementById(strHiddenId+iNextValue.toString());
  if( oNewCtrlA ) {
    oStyle = ( oNewCtrlA.style ? oNewCtrlA.style : oNewCtrlA );
    oStyle.display = "";
  }
}

/**
 * active la complétion sur le titre du bloc
 */
function initCompletion(){
  eval(tabLang);
  for (var i=0; i<tabLang.length;i++){
  	var InputText = "bloc_nom"+tabLang[i];
    $(document).ready(function() {   
    $("input#"+InputText).autocomplete({
      source: tabTitle
    });
    $("input#"+InputText).autocomplete("option", "minLength", 0);
    $("input#"+InputText).autocomplete("option", "autoFocus", true);
    $("input#"+InputText).autocomplete("option", "delay", 0);
    
  });
}
}

function fillBlocNom(formName){
  eval(tabLang);
  var f = eval ("document."+formName);
  if (!f) return;
  for (var i=0; i<tabLang.length;i++){
  	var InputName = "bloc_nom"+tabLang[i];
  	document.getElementById(InputName).value = f.title.value;
  } 
  
}