<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale..
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_CEdit
 * @class AlkHtmlCEditPage
 * Classe d'affichage de la partie consultation 
 */
class AlkHtmlCEditPage extends AlkHtmlForm
{
  protected $iNiveauMenuAppli;
  protected $page_id;
  protected $page_liste;
  protected $liste_id;
  protected $rootpage_id;
  protected $page_titre;
  protected $page_titre_court;
  protected $page_lg;
  protected $page_date_maj;
  protected $page_parent;
  protected $page_niveau;
  protected $page_arbre;
  protected $page_titre_nav;
  protected $page_mots_cles;
  protected $page_desc;
  protected $page_visuel;
  protected $page_bandeau;
  protected $page_atype_id;
  protected $page_ptype_id;
  protected $page_appli_id;
  protected $page_visible_menu;
  protected $page_url_redirection;
  protected $page_target_redirection;
  protected $page_url;
  protected $page_target;
  protected $page_nb_elements;
  
  protected $tabParcours;
  protected $tabPageUrl;
  
  protected $appli_id_gedit;
  protected $appli_id_consult;
  protected $page_template;
  protected $bTemplate;
  
  protected $bModeRewriteUrl;
  protected $strPathModule;

  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formGeditC");
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
    
    $this->iNiveauMenuAppli = 0;
    $this->page_id          = "-1";
    $this->page_liste       = "0";
    $this->liste_id         = "-1";
    $this->rootpage_id      = "-1";
    $this->page_titre       = "";
    $this->page_titre_court = "";
    $this->page_lg          =  ALK_LG_BDD;
    $this->page_date_maj    = "";
    $this->page_parent      = "-1";
    $this->page_niveau      = "-1";
    $this->page_arbre       = "";
    $this->page_titre_nav   = "";
    $this->page_mots_cles   = "";
    $this->page_desc        = "";
    $this->page_visuel        = "";
    $this->page_bandeau        = array();
    $this->page_atype_id    = "";
    $this->page_ptype_id    = "";
    $this->page_appli_id    = "";
    $this->page_cat_id      = "";
    $this->page_visible_menu= "";
    $this->page_url_redirection    = "";
    $this->page_target_redirection = "_self";
    $this->page_url         = "";
    $this->page_target      = "_self";
    $this->page_nb_elements = "-1";
    $this->tabParcours      = array();
    $this->tabPages         = array();
    
    $this->initData();
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { /** rien à faire */ } 
  
  /**
   * Initialise les valeurs d'appli_id pour gedit et cedit
   */
  protected function initIds()
  {
    $this->strPathModule     = "gedit";
    $this->bModeRewriteUrl   = true;
    $this->appli_id_gedit    = $this->oAppli->appli_id;
    $this->appli_id_consult  = $this->oAppli->appli_id;
    $this->rootpage_id       = "-1";
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function initData() 
  {    
    $this->initIds();
    $this->bTemplate = true;
    $this->page_id      = "-1";
    $this->page_template  = "";

    $user_id = AlkFactory::getSProperty("user_id");

    /** @TODO Revoir pour prendre en compte un param de visibilité des onglets **/
    if( defined("ALK_INTERFACE_TYPE") && substr(ALK_INTERFACE_TYPE, 0, 8) == "internet" ) {
      $this->bSheetVisible = false;
    }
        
    $this->bModeRewriteUrl = !$this->bSheetVisible;
    
    // eviter de multiplier les requêtes mettant en jeu la vue V_GEDIT_USER_RIGHT_PAGE
    // - effectuer la requête une fois (getArboAutorise())
    // - déduire les autres infos à partir des éléments collectés avec cette première requête
    $this->setTabPages();

    if( !empty($this->tabPages) ) {
      $tabPageId = array_keys($this->tabPages);

      if( $this->rootpage_id ==-1 ) {
        $this->rootpage_id = substr($tabPageId[0], 1);
      }
      $this->page_id = AlkRequest::getToken("page_id", $this->rootpage_id) ;
      if( $this->page_id != "-1" && isset($this->tabPages["_".$this->page_id]) ) {
        $this->page_liste              = $this->tabPages["_".$this->page_id]["page_liste"];
        $this->liste_id                = $this->tabPages["_".$this->page_id]["liste_id"];
        $this->page_template           = $this->tabPages["_".$this->page_id]["page_template"];
        $this->page_titre              = $this->tabPages["_".$this->page_id]["page_titre"];
        $this->page_titre_court        = $this->tabPages["_".$this->page_id]["page_titre_court"];
        $this->page_date_maj           = $this->tabPages["_".$this->page_id]["page_date_maj"];
        $this->page_parent             = $this->tabPages["_".$this->page_id]["page_parent"];
        $this->page_niveau             = $this->tabPages["_".$this->page_id]["page_niveau"];
        $this->page_arbre              = $this->tabPages["_".$this->page_id]["page_arbre"];
        $this->page_titre_nav          = $this->tabPages["_".$this->page_id]["page_titre_nav"];
        $this->page_mots_cles          = $this->tabPages["_".$this->page_id]["page_mots_cles"];
        $this->page_desc               = $this->tabPages["_".$this->page_id]["page_desc"];
        $this->page_atype_id           = $this->tabPages["_".$this->page_id]["page_atype_id"];
        $this->page_ptype_id           = $this->tabPages["_".$this->page_id]["page_ptype_id"];
        $this->page_appli_id           = $this->tabPages["_".$this->page_id]["page_appliid"];
        $this->page_cat_id             = $this->tabPages["_".$this->page_id]["page_catid"];
        $this->page_visible_menu       = $this->tabPages["_".$this->page_id]["page_visible_menu"];
        $this->page_url_redirection    = $this->tabPages["_".$this->page_id]["page_url_redirection"];
        $this->page_target_redirection = $this->tabPages["_".$this->page_id]["page_target_redirection"];
        $this->page_url                = $this->tabPages["_".$this->page_id]["page_url"];
        $this->page_target             = $this->tabPages["_".$this->page_id]["page_target"];
        $this->page_visuel             = $this->tabPages["_".$this->page_id]["page_visuel"];
        $this->page_bandeau            = $this->tabPages["_".$this->page_id]["page_bandeau"];
        $this->page_nb_elements        = $this->tabPages["_".$this->page_id]["page_nb_elements"];
        
      
        $this->setTabParcours();
        
        // chargement du template lié à la page
        if( $this->page_template != "" ) {
          if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_TEMPLATE.$this->page_template) &&
              is_file(ALK_ALKANET_ROOT_PATH.ALK_ROOT_TEMPLATE.$this->page_template) ) {
            $this->setTemplate(ALK_ROOT_TEMPLATE, $this->page_template);
          } 
          elseif( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."".$this->strPathModule."/templates/".$this->page_template) &&
                    is_file(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."".$this->strPathModule."/templates/".$this->page_template) ) { 
            $this->setTemplate($this->strPathModule, $this->page_template);
          } 
          else {
            $this->bTemplate = false;
          }
        }
      } else {
        $this->page_id = "-1";
      }
    }
    if( $this->page_id == "-1" && $this->rootpage_id != -1 ) {
      // redirection à l'accueil en cas de non droit ou de page inexistante
      header("Cache-Control: no-cache");
      $strHtml = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">".
        "<html>".
        "<head>".
        "<title></title>".
        "<script type='text/javascript'>".
        " function onWindLoad() { window.location = '".ALK_ROOT_URL."'; }".
        "</script>".
        "</head><body onload=\"onWindLoad()\"></body></html>";
      exit();
    }
  } 
  
  /**
   * Traitement 
   */
  public function doSql() { /** rien à faire */ } 
  
  /**
   * Construction de la liste 
   */
  public function setContents()
  {
    global $strPageCur;
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $bAffInAlkanet = !( strpos($_SERVER["PHP_SELF"], ALK_ALKANET) === false );

    // $GLOBALS["ALK_GEDIT_TYPEASSOC"] est défini dans scripts/alkanet/alkanet_site.php 
    // puis eventuellement personnalisé selon les templates utilisés
    $defaultTypeAssoc = ( isset($GLOBALS["ALK_GEDIT_TYPEASSOC"]) 
                          ? $GLOBALS["ALK_GEDIT_TYPEASSOC"]
                          : TASSOC_PUBLIE);

    if( $this->page_id != "-1" ) {

      $oAppliGedit = AlkFactory::getAppli(ALK_ATYPE_ID_GEDIT, $this->appli_id_gedit);

      if( $this->rootpage_id != -1 ) {
        /* Assignation des infos de la page courante */
        $this->assign("strPageTitre", $this->page_titre);
        $this->assign("strPageTitreCourt",$this->page_titre_court);
        $this->assign("strPageLg", $this->page_lg);
        $this->assign("strDirLg", strtolower(substr($this->page_lg, 1)));
        $this->assign("idPage", $this->page_id);
        $this->assign("idPageRacine", $this->rootpage_id);
        $this->assign("bPageAbonnement", ($this->page_liste == "1" ? true : false));
        $this->assign("idListe", $this->liste_id);         
        $this->assign("strPageUrl", $this->page_url);
        $this->assign("strPageTemplate", $this->page_template);
        $this->assign("strPageDateMaj", $this->page_date_maj);
        $this->assign("iPageNiveau", $this->page_niveau);
        $this->assign("idPageParent", $this->page_parent);
        $this->assign("strPageArbre", $this->page_arbre);
        $this->assign("strPageTitreNav", $this->page_titre_nav);
        $this->assign("strPageMotsCles", $this->page_mots_cles);
        $this->assign("strPageDesc", $this->page_desc);
        $this->assign("tabPageImgVisuel", $this->page_visuel);
        $this->assign("tabPageImgBandeau", $this->page_bandeau);
        $this->assign("idATypePage", $this->page_atype_id);
        $this->assign("idPTypePage", $this->page_ptype_id);
        $this->assign("idAppliPage", $this->page_appli_id);
        $this->assign("idCatPage", $this->page_cat_id);
        $this->assign("bPageVisibleMenu", $this->page_visible_menu);
        $this->assign("idAppliGEdit", $this->appli_id_gedit);
        $this->assign("bComment", false);
        $this->assign("idAppliComment", "-1");
        $this->assign("iPageNbElements", $this->page_nb_elements);
        
        // Vérification de l'autorisation de déposer des commentaires sur la page 
        // assignation au template de 2 variables bComment et idAppliComment
        if( defined("ALK_B_ATYPE_COMMENT") && ALK_B_ATYPE_COMMENT ) {
          $oAppliComment = AlkFactory::getAppli(ALK_ATYPE_ID_COMMENT, $this->appli_id_gedit);
          $dsComment = $oAppliComment->oQuery->GetDs_Autorisation(-1, $this->appli_id_gedit, $this->page_id, "", "");
          if ( $drComment = $dsComment->GetRowIter()) {
            $this->assign("bComment", true);
            $this->assign("idAppliComment", $drComment->GetValueName("APPLI_ID"));
          }   
        }

        // assign des données sur le template sélectionné
        if( $this->bTemplate ) {
          $this->assignByRef("oAppliGedit", $oAppliGedit);
          $tabBlocs = $oAppliGedit->getGEditArray($this->page_id, $defaultTypeAssoc, $this->page_lg, false);
          if( empty($tabBlocs) && $this->tabPages["_".$this->page_id]["nbFilsVisibleMenu"]>0 ) {
            //Redirection vers la première page fille si elle existe
            $idPageFille = $this->tabPages["_".$this->page_id]["tabFilsVisibleMenuId"][0];
            $strUrlPageFille = $this->tabPages["_".$idPageFille]["page_url"];
              
            // redirection vers la page fille 
            header("location:".$strUrlPageFille);
            exit();
          } else {
            // le template est déjà associé (initData), association du tableau de données
            $this->assign("tabBlocsPage", $tabBlocs);
            $this->assign("tabParcours", $this->tabParcours);
            $this->assign("tabPages", $this->tabPages);
            $this->assign("urlAccueil", ( isset($this->tabParcours[0]["page_url"]) ? $this->tabParcours[0]["page_url"] : "" ));
          }
          $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmlupload.js");
          $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formcheck.js");
          $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formdate.js");
          $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formnumber.js");
          $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
          $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_form.js");
        } else {
          $this->setLabelDesc("<br/><br/><br/>Impossible d'afficher la page sans spécifier un modèle de page.");
        } 
      } else {
        $this->setLabelDesc("<br/><br/><br/>Il faut sélectionner une page éditoriale racine publiable à l'aide de l'administration.");     
      }
    } else {
      $this->setLabelDesc("<br/><br/><br/>Il faut sélectionner une page éditoriale racine publiable à l'aide de l'administration.");
    }
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."gedit/help/geditc_01_page.htm");   
  }

  /**
   * Mémorise dans le tableau tabParours, la liste des pages successives pour atteindre la page courante
   */
  private function setTabParcours()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    
    $tabPageId = explode("-", substr($this->page_arbre, 1, -1));
    // on retire la page 0
    $tabPageId = array_slice($tabPageId, 1, count($tabPageId)-1);
      
    if( !empty($tabPageId) ) {
      foreach($tabPageId as $page_id) {
        $this->tabParcours[] = 
          array("page_id"         => $page_id,
                "page_url"        => $this->tabPages["_".$page_id]["page_url"],
                "page_target"     => $this->tabPages["_".$page_id]["page_target"],
                "page_titre"      => $this->tabPages["_".$page_id]["page_titre"],
                "page_titre_court"=> $this->tabPages["_".$page_id]["page_titre_court"],
                "page_niveau"     => $this->tabPages["_".$page_id]["page_niveau"],
                "page_arbre"      => $this->tabPages["_".$page_id]["page_arbre"],
                "page_parent"     => $this->tabPages["_".$page_id]["page_parent"],
                "page_visuel"     => $this->tabPages["_".$page_id]["page_visuel"],
                "page_bandeau"   => $this->tabPages["_".$page_id]["page_bandeau"]);
      }
    }
  }
  
 /**
   * Mémorise dans le tableau tabPages, la liste des pages accessibles publiées avec la clé _[PAGE_ID]
   * Ce tableau permet de retrouver l'url réécrite de chaque page, permet d'afficher le plan du site, 
   * permet de créer le tableau pour l'affichage du menu sans refaire de requête
   */
  private function setTabPages()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $strModeBrouillon = AlkRequest::_GET("mode", "");
    $bBrouillon = ( $strModeBrouillon == "brouillon" ? false : true ); 
    
    $oQueryGedit = AlkFactory::getQuery(ALK_ATYPE_ID_GEDIT);
    $dsPage = $oQueryGedit->getArboAutorise($user_id, $this->appli_id_gedit, $bBrouillon, -1, true, -1, -1, -1, $this->bModeRewriteUrl);
    $dsPage->setTree("PAGE_ID", "ID_PERE");
    
    $cpt = 0;
    while ($drPage = $dsPage->getRowIter()){
      $page_id        = $drPage->getValueName("PAGE_ID");
      $liste_id       = $drPage->getValueName("LISTE_ID");
      $strTitre       = $drPage->getValueName("NOM".$this->page_lg);
      $strTitreCourt  = $drPage->getValueName("NOM_COURT".$this->page_lg);
      $page_url_redir = $drPage->getValueName("PAGE_URL_REDIRECTION");
      
      // construit l'url de redirection gérée par le module Link
      $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
      if ( $oAppliLink ) {
        $oDsLinks = $oAppliLink->getDsLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $page_id, -1, -1);
        if ( $oDrLinks = $oDsLinks->getRowIter() ) {
          $page_url_redir = $this->oAppli->getLink(ALK_LTYPE_ID_PAGE, null, $page_id, null, array("lg" => $this->page_lg)); // demande le lien de la page courante
        }
      }
      
      $page_target    = $drPage->getValueName("PAGE_TARGET_REDIRECTION");
      if( $this->bModeRewriteUrl ) {
        $page_url     = $drPage->getValueName("PAGE_URL".$this->page_lg);
        $page_url = (substr($page_url,0,1) == "/" ? ALK_ALKANET_ROOT_URL.substr($page_url, 1) : $page_url);
      } else {
        $strToken = AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=".$this->appli_id_consult.
                                               "&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_FORM."&page_id=".$page_id);
        $page_url = ALK_ALKANET."?token=".$strToken;
      }
      $page_parent    = $drPage->getValueName("ID_PERE");
      
      //Recupération du page_visuel et du page_bandeau
      $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      // traitement des visuels
      $dsPJ = $oQueryEspace->getDsListePJ("GEDIT_PJ", $page_id);
      $pj_page_visuel_name = array();
      $pj_page_bandeau_name = array();
      while( $drPJ = $dsPJ->getRowIter() ){
        switch($drPJ->getValueName("PJ_CHAMP")){
          case "page_visuel" :
            $pj_page_visuel_name[] = $drPJ->getValueName("FILENAME");
            break;
          case "page_bandeau":
            $pj_page_bandeau_name[] = $drPJ->getValueName("FILENAME");
            break;
          default:
            break;
        }
      }
      $this->tabPages["_".$page_id] = 
        array("page_id"                => $page_id,
              "page_liste"             => $drPage->getValueName("PAGE_LISTE"),
              "liste_id"               => ( $liste_id != "" ? $liste_id : "-1" ), 
              "page_url"               => ( $page_url_redir !="" ? $page_url_redir : $page_url ),
              "page_target"            => ( $page_target != "0" ? "_blank" : "_self" ),
              "page_titre"             => $strTitre,
              "page_titre_court"       => $strTitreCourt,
              "page_niveau"            => $drPage->getValueName("NIV"),
              "page_arbre"             => $drPage->getValueName("ARBRE"),
              "page_alias"             => $drPage->getValueName("PAGE_ALIAS"),
              "page_parent"            => $page_parent,
              "page_visible_menu"      => $drPage->getValueName("PAGE_VISIBLE_MENU"),
              "page_template"          => $drPage->getValueName("PAGE_TEMPLATE"),
              "page_appliid"           => $drPage->getValueName("PAGE_APPLIID"),
              "page_catid"             => $drPage->getValueName("PAGE_CATID"),
              "page_atype_id"          => $drPage->getValueName("ATYPE_ID"),
              "page_ptype_id"          => $drPage->getValueName("PTYPE_ID"),
              "page_date_maj"          => $drPage->getValueName("PAGE_DATEMAJ"),
              "page_titre_nav"         => $drPage->getValueName("PAGE_TITRENAV".$this->page_lg),
              "page_mots_cles"         => $drPage->getValueName("PAGE_MOTCLE".$this->page_lg),
              "page_desc"              => $drPage->getValueName("PAGE_DESC".$this->page_lg),
              "page_visuel"            => $pj_page_visuel_name,
              "page_bandeau"           => $pj_page_bandeau_name,
              "page_nb_elements"       => $drPage->getValueName("PAGE_NB_ELEMENTS"),
              "page_url_redirection"   => $page_url_redir,
              "page_target_redirection"=> $page_target,
              "nbFils"                 => 0,
              "tabFilsId"             => array(),
              "nbFilsVisibleMenu"     => 0,
              "tabFilsVisibleMenuId"  => array()); 
      if( isset($this->tabPages["_".$page_parent]) ) {
        $this->tabPages["_".$page_parent]["nbFils"]++;
        $this->tabPages["_".$page_parent]["tabFilsId"][] = $page_id;
        if ($drPage->getValueName("PAGE_VISIBLE_MENU")==1){
          $this->tabPages["_".$page_parent]["nbFilsVisibleMenu"]++;
          $this->tabPages["_".$page_parent]["tabFilsVisibleMenuId"][] = $page_id;
        }
      }
    }
  } 
  
  /**
   *  Retourne le code html l'entête du formulaire
   *
   * @return Retourne un string
   */
  protected function getHtmlHeader()
  {
    return "";
  }
  
  /**
   *  Retourne le code html de la fin du formulaire
   *
   *  Retourne un string
   */
  protected function getHtmlFooter()
  {
    return "";
  }
}
?>