<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

define("ALK_B_ATYPE_GEDIT", true);

/**
 * la version 3.4.0_RELEASE correspond à la marquée 3.3.7
 */
$strNum = "3.4.0";
$tabIns[$strNum][] = "";

/**
 * EMA : adaptation normes W3C
 *     : ajout des fonctionnalités filemanager
 *     : ajout ligne dans SIT_DATATYPE
 *     : déplacement des classes de gestion des pages et des définitions gérées initialement dans l'éditeur
 *     : alkquerygedit : ajout fonction getDsUrlPageGlossaire()
 *     : alkhtmlformgedit.class.php : chargement de la jquery treeview + drag and drop + application du wordwrap sur l'url
 *     : alkhtmlformgedit.js        : ajout méthode dragAndDropPages()
 *     : ajout bloc de type document éditorial
 *     : alkhtmlformgedit.class.php : mise à jour du tableau tabTypeBloc 
 *     : alkappligedit.class.php    : modif getPanel() + getGEditData()
 *     : alkhtmlpopudataselect      : correction pluriel + changement des private /protected en public pour les besoin d'un héritage
 *     :                            : ajout champ saisie du nom de bloc
 *     : alkquerygedit + alkquerygedit_action : modif des méthodes getDsBlocById + updateBlocColumns + getBlocByPageId pour rajouter la gestion du bloc_nom
 *     :                                       suppression du champ BLOC_TITRE dans GEDIT_01_BLOC
 *     :                                      : modif setRightsOnAppli (correction bug lié à l'enregitrement des droits)
 *     : corrections sur le traitement des titres de bloc : ajout complétion jquery
 *     : ajout champ BLOC_DESC + modif enregistrement dans les query
 * PCT : modif gestion des droits avec héritage du parent
 * MTO : alkhtmlformgedit.class.php : correction chemin relatif du chargement de la feuille de style classes/form/treeview.css
 * ASN : getHtmlBlocContenu ajout d'une constante permettant de choisir de limiter ou non la hauteur du div contenant la liste des blocs
 */
$strNum = "3.4.1";
$tabIns[$strNum][] = "";

$tabAlterTable[$strNum]["gedit_01_page"] = array(
  array("action" => "add", 
        "column" => "PAGE_RACINE_DROIT", 
        "type" => "int", "length" => "", "default" => "", "nullable"  => 0),
); 
$tabIns[$strNum][] = "update GEDIT_01_PAGE set PAGE_RACINE_DROIT=PAGE_ID where PAGE_NIVEAU=1";

for($iNiv=2; $iNiv<10; $iNiv++) {
  if( ALK_BDD_TYPE == ALK_SGBD_MYSQL ) {
    $tabIns[$strNum][] = "update GEDIT_01_PAGE d, GEDIT_01_PAGE s" .
      " set d.PAGE_RACINE_DROIT = if( d.PAGE_PUBLIC = 1, s.PAGE_RACINE_DROIT, d.PAGE_ID)" .
      " where s.PAGE_ID = d.PAGE_PARENT and d.PAGE_NIVEAU=".$iNiv;
  } else {
    $tabIns[$strNum][] = "update GEDIT_01_PAGE d" .
    " set PAGE_RACINE_DROIT = " .
      " (select ".$dbConn->compareSql("d.PAGE_PUBLIC", "=", "1", "s.PAGE_RACINE_DROIT", "d.PAGE_ID")." as PAGE_RACINE_DROIT" .
      "  from GEDIT_01_PAGE s".
      "  where s.PAGE_ID = d.PAGE_PARENT)".
    " where PAGE_NIVEAU=".$iNiv;
  }
}

$tabIdx[$strNum]["gedit_01_page"] = array("geditpage_pagebrouillon_fk" => "page_brouillon",
                                          "geditpage_pageparent_fk" => "page_parent",
                                          "geditpage_pagerdroit_fk" => "page_racine_droit");

$tabIns[$strNum][] = "INSERT INTO SIT_DATATYPE (DATATYPE_ID, ATYPE_ID, DATATYPE_INTITULE, TABLE_REF, TABLE_ALIAS," .
  " FIELD_PK, FIELDS_TEXT, SELECTING_WHERE, SELECT_APPLI_ID, SELECT_ATYPE_ID, APPLI_GEOLOC, APPLI_SEARCH, APPLI_MDATA, APPLI_STAT) " .
                     " VALUES(26, 23, 'Page éditoriale', 'GEDIT_01_PAGE', 'gpage', 'PAGE_ID', 'PAGE_TITRE_FR|PAGE_TITRE_EN|PAGE_TITRE_PT|PAGE_TITRE_ES', " .
  " 'PAGE_ID in " .
  " (select p.PAGE_ID" .
  "  from GEDIT_01_PAGE p" .
  "   inner join V_GEDIT_USER_RIGHT_PAGE r on p.PAGE_ID=r.PAGE_ID" .
  "  where p.PAGE_VALIDEPUB=1 and p.PAGE_BROUILLON is null and r.RIGHT_ID>0)',".
  " '__ALIAS__.APPLI_ID', 'atype.ATYPE_ID::inner join SIT_APPLI atype on (__ALIAS__.APPLI_ID=atype.APPLI_ID)', 0, 0, 0, 1)";

$tabIns[$strNum][] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23, -1,'ALK_B_GEDIT_DOC','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs de type document éditorial")."',1)";
$tabIns[$strNum][] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (21, 88, 'Document Editorial')";

$tabAlterTable[$strNum]["GEDIT_01_BLOC"] = array(
  array("action" => "drop", 
        "column" => "BLOC_TITRE")
);

$tabIns[$strNum][] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23, -1,'ALK_B_GEDIT_BLOC_OVERFLOW','true',3,'".$dbConn->analyseSql("Limiter en hauteur la taille du div listant les blocs de la page")."',1)";


/**
 * EMA : ajout champ bloc_limit dans GEDIT_01_BLOC + prise en compte de l'enregistrement dans les classes concernées
 *     : alkhtmlformgedit.class.php      : changement url front office (pour l'apercu)
 *     : alkquerygedit.class.php         : modif getPageUrl pour prendre en compte la nouvelle constante de l'url FRONT_OFFICE
 *     :  popupdataselect                : ajout combo des noms prédéfinis de blocs
 * MTO : alkquerygedit_action.class.php  : correction addPageAbonnement() et delPageAbonnement()
 * EMA :                                 : modif setRightsOnAppli()
 *     : alkappligedit.class.php : modif createListeAbonnes() pr prendre en compte le test sur l'existence du module LSDIF
 *     : Gestion du cache
 */    
$strNum = "3.4.2";
$tabIns[$strNum][] = "";

$tabAlterTable[$strNum]["GEDIT_01_BLOC"] = array(
  array("action" => "add",
        "column" => "BLOC_DESC", 
        "type" => "varchar", "length" => "512", "default" => "", "nullable"  => 0),
  array("action" => "add", 
        "column" => "BLOC_LIMIT", 
        "type" => "int", "length" => "", "default" => "-1", "nullable"  => 0),
);

/**
 * EMA : Corrections
 */
$strNum = "3.4.3";
$tabIns[$strNum][] = "";

/**
 * EMA : Corrections
 * ASN : alkformgeditform.class.php	: modification getBlockPage ajout contrôle sur template de la page (désormais obligatoire)
 *       alkhtmlformgeditform.js		: modification publier ajout de la vérification des champs olibgatoires du formulaire avant validation  
 * EMA : alkqueryGEdit : modif pour rajouter les colonnes DESC et MOT CLE 
 *     : alktmlceditpage : Gestion de la langue sur la récupération du mot clé
 */
$strNum = "3.4.4";
$tabIns[$strNum][] = "";

/** 
 * PCT : Alkhtmlformceditpage : prise en compte de la constante ALK_B_GEDIT_CONSULT, suppression de la constante ALK_B_GEDIT_PAGE_TEMPLATE
 *       pour systématiser l'utilisation des templates dans gedit, d'activer si possible le mode consultation en back-office 
 *       et refonte des templates et cedit.css dans le répertoire templates.
 * ASN/EMA : alkquerygedit::getPrimaryTokenData() : optimisation requête
 * 		 : alkhtmlpopupdataselect : modification	addBlocNom  correction bug avec le titre du bloc
 * EMA : alkhtmllistdef.class.php : modif getHtmlDataList()
 *     : alkappligedit.class.php  : modif setTabSheets()
 *     : Modif entrée SIT_DATATYPE
 * ASN : alkappligedit.class.php  : modification setTabSheets pour intégration du nouveau filemanager
 * 			 alkhtmlformgeditform.js  : modification OpenFileManager pour intégration du nouveau filemanager 
 */
$strNum = "3.4.5";
$tabIns[$strNum][] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (23, -1, 'ALK_B_GEDIT_CONSULT', 'false', 'Disponibilité de la consultation', 3, 1)";
$tabIns[$strNum][] = "delete from SIT_CONSTANTE where CONST_INTITULE='ALK_B_GEDIT_PAGE_TEMPLATE'";


/**
 * EMA : correction entrée  dans le SIT_DATATYPE
 */
$strNum = "3.4.6";
$tabIns[$strNum][] = "update SIT_DATATYPE set SELECTING_WHERE='PAGE_ID in " .
                     " (select p.PAGE_ID" .
                     "  from GEDIT_01_PAGE p" .
                     "   inner join V_GEDIT_USER_RIGHT_PAGE r on p.PAGE_ID=r.PAGE_ID" .
                     "   where p.PAGE_VALIDEPUB=1 and p.PAGE_BROUILLON is null and r.RIGHT_ID>0".
                     "   and p.APPLI_ID =_APPLI_ID_ and r.USER_ID=_USER_ID_) order by INTITULE' where DATATYPE_ID=26";

/**
 * ASN : alkhtmlformgeditfom.class.php : setData valeur du rang de la page calculé automatiquement lors de la création d'une page
 * 			 alkquerygedit.class.php	 :  ajout de la méthode getNextRang
 * 			 alkhtmllistpage.clas.php  :  setContents : suppression du label vide
 */
$strNum = "3.4.7";
$tabIns[$strNum][] = "";

/**
 * EMA : alkquerygedit_action : modif mineure sur updateBlocColumn()
 * ASN : alkhtmltagcloudform.class.php : modif mineure (cosmetique)
 *  
 */
 
 $strNum = "3.4.8";
 $tabIns[$strNum][] = "";
 
/**
 * EMA : alkquerygedit_action : modif updatePage()
 */
$strNum = "3.4.9";
$tabIns[$strNum][] = "";

/**
 * MTO : alkquerygedit_action.class.php : correction addPage()
 *       alkappligedit.class.php, alkhtmlformgeditform.class.php : correction deprecated
 * ASN : alkformgeditform.class.php : correction bug setData nettoyage de l'alias non effectué en modification
 */
$strNum = "3.4.10";
$tabIns[$strNum][] = "";

/**
 * EGD : alkhtmlgeditform.class.php : ajout du traitement de bloc de type Evenement et ajout de la constante dans SIT_CONSTANTE ALK_B_GEDIT_EVENT
 * BFE : alkappligedit.class.php : ajout de la méthode getHelp permettant d'obtenir l'intitulé de la rubrique d'aide associée à l'appli 
 */
$strNum = "3.4.11";
$tabIns[$strNum][] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
    " values (23,-1,'ALK_B_GEDIT_EVENT','true',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs évènements site")."',1)";

/**
 * BFE : alkhtmllistpage.class.php : correction fonction deprecated PHP 5.3 
 */
$strNum = "3.4.12";
$tabIns[$strNum][] = "";

/**
 * ASN : alkquerygeditaction.class.php : correction fonction updateBlocColumn probleme lors de la mise à jour du bloc avec des dates de début et de fin vides
 * 			alkappligedit.class.php : l'onglet gestionnaire de fichier n'apparait que si ALK_B_MEDIA_SHARED est faux   
 * EGD : Mise à jour de la vue v_gedit_user_right_page pour pouvoir voir dans l'arborescence gedit une page de type Outils de collaboration(87)
 *       non associée à une application Collab
 *     : alkquerygedit.class.php : correction de la requete dans la fonction getDsListData() prise en compte d'un nouveau parametre optionnel permettant de ne pas prendre la CAT_ID
 *     : alkhtmlpopupdataselect.class.php : modification de la méthode getHtmlDataList() pour appeler getDsListData() avec le parametre de recupération de la CAT_ID à false
 */
$strNum = "3.4.13";
$tabDropView[$strNum][] = "v_gedit_user_right_page";
$tabView[$strNum]["v_gedit_user_right_page" ] = " (CONT_ID, APPLI_ID, USER_ID, PAGE_ID, RIGHT_ID) as
  select ac.CONT_ID, ac.APPLI_ID, agc.AGENT_ID as USER_ID, p.PAGE_ID, ".
  $dbConn->compareSql("p.ATYPE_ID", "=", "87", 
                      $dbConn->compareSql("agc.CONT_ADMIN", "=", "1",
                                          "4",
                                          "1"), 
                      "d.DROIT_ID")." as RIGHT_ID
  from GEDIT_01_DROIT d 
    inner join SIT_AGENT_CONT agc on agc.AGENT_ID=d.AGENT_ID
    inner join SIT_APPLI_CONT ac  on ac.CONT_ID=agc.CONT_ID
    inner join GEDIT_01_PAGE  p   on (p.PAGE_ID=d.PAGE_ID and (p.appli_id = ac.appli_id and p.atype_id <> 87 or (p.page_appliid = ac.appli_id or p.page_appliid = (-1)) and p.atype_id = 87))
  where p.PAGE_ID>0";
                      
/**
 * ASN : ajout d'un type de bloc pour les événements   
 * EGD : Modification de l'intitulé des application de type gedit
 */      
$strNum = "3.4.14";               
$tabIns[$strNum][] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (22, 89, 'Evénement')";
$tabIns[$strNum][] = "update SIT_APPLI_TYPE set ATYPE_INTITULE= 'Pages' WHERE ATYPE_ID=23 AND ATYPE_ID_DIST=-1 AND ATYPE_ABREV ='gedit'";

/**
 * EGD : alkhtmlformgeditform.class.php : Modification de la methode getBlockForm() pour permettre de rechercher une page du site pour renseigner le champ url de redirection
 *    + alkhtmllistpage.class.php : modification du setContents() pour un meilleur affichage de l'arbre et ajout de la possibilité de renvoyé une url courte si le token bWithRootUrl=false
 *    + alkquerygedit.class.php : modification de la méthode getArboAutorise() pour récupérer plus d'informations utile à la création de l'arbre de page
 */      
$strNum = "3.4.15";               
$tabIns[$strNum][] = "";

/**
 * ASN : alkappligedit.class.php : Modification de la méthode getGEditBlocContents avec ajout de l'url du flux RSS dans les données du bloc RSS assignées au template
 *  + modification de 04_gedit.sql.php pour ajout du type de page webapp
 */
$strNum = "3.4.16";               
$tabIns[$strNum][] = "";

/**
 * EGD : alkhtmllistpage.js : Correction sur la selection d'une page de l'arborescence dans l'editeur par prise en compte de l'iframe
 *       alkhtmlformgeditform.class.php : les champs d'upload pour le visuel et le bandeau d'une page s'ouvre maintenant sur le répertoire racine de l'espace même si les images sont toujours déposées dans le dossier visuel
 *     + la suppression de la page d'accueil n'est plus possible par l'interface et une page possedant au moins une page fille ne peut être supprimé que par un animateur de l'espace
 *       alkquerygedit.class.php : ajout de la methode getNbPageFilleByPageId($page_id)  qui retourne le nombre de page fille (seulement de premier niveau, pas les petites filles)
 * EGD : Ajout de la possibilité d'avoir des visuels associés au page en GEDIT, lors d'un patch, il faut veiller à ce que le répertoire "/visuel/" existe dans /upload/gedit/cont_id/ ou dans /upload/espace/cont_id/ si ALK_B_MEDIA_SHARED est activé
 *      + Création de la table GEDIT_PJ
 *      + alkhtmlformgeditform.class.php : ajout de deux blocs upload de fichiers dans l'onglet propriété de la gestion de page
 *      + alkhtmlceditpage.class.php : ajout des nouvelles informations de la page aux tableaux de variables tabPages et tabParcours
 *      + alkquerygedit_action.class.php : modification de la fonction publishRestoreDraftPage, prise en compte d'un nouveau paramètre, le répertoire d'upload par défaut des pj et gestion des brouillons pour les pj des pages gedit
 *      + ajout de 2 constantes permettant de définir le nombre de visuels et bandeau associable à une page, mise à zéro, ces constantes désactive le composant
 *      + alkhtmlceditpage.class.php : modification de la méthode initData() pour prendre en compte la constante ALK_ROOT_TEMPLATE déjà défini dans /lib/app_conf_alkanet.php
 *      + alkhtmlformgeditform.class.php : modification de la méthode getPageTemplate() pour prendre en compte la constante ALK_ROOT_TEMPLATE déjà défini dans /lib/app_conf_alkanet.php
 *      + alkquerygedit.class.php : getTabListGeditAppliType() pour prendre en compte la constante ALK_ROOT_TEMPLATE déjà défini dans /lib/app_conf_alkanet.php
 */      
$strNum = "3.4.17";               
$tabIns[$strNum][] = "";
$tabTable[$strNum]["gedit_pj"] = array(
  "pj_id" => array("type" => "int", "dn" => "NOT NULL"),
  "pj_champ" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "data_id" => array("type" => "int", "dn" => "NOT NULL"),
  "pj_name" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  "pj_file" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  "pj_type" => array("type" => "int", "dn" => ""),
  "pj_taille" => array("type" => "int", "dn" => "DEFAULT 0"),
  "pj_duration" => array("type" => "float", "dn" => ""),
  "pj_bitrate" => array("type" => "int", "dn" => ""),
  "pj_lang" => array("type" => "int", "dn" => "DEFAULT 1"),
  "pj_datecrea" => array("type" => "datetime", "dn" => ""),
  "pj_agentcrea" => array("type" => "int", "dn" => ""),
  "pj_datecreafile" => array("type" => "datetime", "dn" => ""),
  "pj_title" => array("type" => "varchar(64)", "dn" => ""),
  "pj_copyright" => array("type" => "varchar(128)", "dn" => ""),
  "pj_auteur" => array("type" => "varchar(32)", "dn" => ""),
  "pj_desc" => array("type" => "varchar(2000)", "dn" => ""),
  "pj_keywords" => array("type" => "varchar(64)", "dn" => ""),
  );
$tabPk[$strNum]["gedit_pj"]["pk_gedit_pj"] = "pj_id";
$tabIdx[$strNum]["gedit_pj"] = array(
  "geditpj_dataid_fk" => "data_id",
  "geditpj_pjagentcrea_fk" => "pj_agentcrea",
  );
$tabFk[$strNum]["gedit_pj"] = array(
  "fk_geditpj_dataid" => array("ffk" => "data_id", "tpk" => "gedit_01_page", "fpk" => "page_id"),
  );
$tabIns[$strNum][] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_TYPE, CONST_LABEL, CONST_ADMIN)".
  " values (23, -1,'ALK_GEDIT_NB_VISUEL','1',1,'".$dbConn->analyseSql("Possibilité de définir le nombre maximum de visuels associables à une page, si égal à zéro, le composant se désactive, -1 pour aucune limite")."',1)";
$tabIns[$strNum][] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_TYPE, CONST_LABEL, CONST_ADMIN)".
  " values (23, -1,'ALK_GEDIT_NB_BANDEAU','1',1,'".$dbConn->analyseSql("Possibilité de définir le nombre maximum d'images de bandeau associables à une page, si égal à zéro, le composant se désactive, -1 pour aucune limite")."',1)";


/**
  * EMA : intégration de jquery dataTable
  *     : fichier impacté : alkhtmlformgeditform.class.php
  *     : ajout d'une nouvelle popup éditeur qui inclut le nom
  *     : ajout classes alkhtmlpopupediteur.class.php + lib alkhtmlpopupediteur.js
  *     : alkappigedit.class.php : ajout entrée dans le getPanel()
  *     : correction rechargement Ajax du bloc après modification
  * EGD : alkhtmlpopupdataselect.class.php : Correction des noms dans les interfaces popup 
  *       alkhtmlformgeditform.class.php : ajout dans l'interface du titre sur les blocs en ayant un pour mieux les identifier
  *       alkquerygedit_action.class.php : ajout dans delPage() des lignes permettant la suppression des bloc form associés a la page et des gedit_pj
  * EMA/EGD : Suppression du bloc éditorial en colonne : Cette possibilité est ramenée dans le popup de définition des propriétés du bloc
  */
$strNum = "3.4.18";               
$tabIns[$strNum][] = "";

/**
 * MTO : alkhtmllistpage.class.php, alkhtmllistpage.js : modifications permettant d'initialiser l'identifiant du lien
 *     : alkappligedit.class.php : ajout fonction getLink() gérant la construction des liens
 *     : alkhtmlceditpage.class.php, alkhtmlformgeditform.class.php, alkquerygedit_action.class.php : gestion de l'url de redirection d'une page avec le module Link
 *     : alkquerygedit.class.php : modification de la fonction getPageUrl() => gestion des liens successifs avec le module Link
 *     : alkappligedit.class.php : devs initialisation des liens pour le module Link
 * EGD : Ajout d'un type de page dans GEDIT_01_PAGE_TYPE pour les pages de syndication
 */
$strNum = "3.4.19";               
$tabIns[$strNum][] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) VALUES (23, 9, 'Syndication', '', 'Data|Page')";

/**
 * EMA : corrections sur les listes Jquery datatable
 *     : remplacement des constantes définissant les chemins vers les modues, /templates/, classes/form, classes/pattern
 */
$strNum = "3.4.20";               
$tabIns[$strNum][] = "";

/**
 * EGD : alkhtmlformgeditform.class.php : correction dans doSql(), cas de suppression, un mauvais paramètre était envoyé à delLinks()
 *     : ajout d'une colonne à la table gedit_01_page pour déterminer le nombre d'éléments à afficher par page
 *     : alkhtmlceditpage.class.php : ajout dans le tabPages et les variables smarty du nombre d'éléments à afficher par page
 *     : alkhtmlformgeditform.class.php : ajout dans le formulaire du champ caché page_nb_elements permettant de connaitre le nombre d'éléments à afficher sur la page
 *     : alkhtmlpopupdataselect.class.php : ajout dans la popup du champ permettant de modifier le nombre d'éléments à afficher par défaut sur une page
 *     : alkquerygedit.class.php : modification de getArboAutorise() et getPageById() pour prendre en compte la nouvelle colonne PAGE_NB_ELEMENTS
 *     : alkquerygedit_action.class.php : modification de updatePage() et dupPage() pour prendre en compte la nouvelle colonne PAGE_NB_ELEMENTS
 *     : alkquerygedit.class.php : getTabListGeditAppliType() suppression de la récupération des templates en session
 *     : alkhtmlformgeditform.class.php : setContents() modification de l'affichage, le rang n'est plus visible dans l'onglet Propriété d'une page
 *                                      + les pages de l'arbre sont maintenant triable si on est animateur de l'espace ou que l'on a les droits maximum sur l'application
 *     : alkhtmlformgeditform.js : ajout du jquery sortable sur l'arbre de page et retrait du draggable, droppable
 *     + modification du nom du bloc iedit en bloc article pour unifier les noms avec l'interface
 *     : alkquerygedit.class.php : ajout de la fonction getRangById() permettant de récupérer le rang de la page passée en paramètre
 *     : alkquerygedit_action.class.php : ajout de la fonction updatePageRang() qui se charge de remettre les bons rangs sur les pages une fois celles-ci déplacées
 *                                      + modification de updatePage() qui ne prend plus le rang de la page en parametre
 */
$strNum = "3.4.21";               
$tabIns[$strNum][] = "";
$tabAlterTable[$strNum]["gedit_01_page"] = array(
  array("action" => "add", 
        "column" => "PAGE_NB_ELEMENTS", 
        "type" => "int", "length" => "", "default" => "-1", "nullable"  => 0)
);

/**
 * EGD : Ajout d'une constante permmettant de définir si seul les animateurs peuvent modifier les rangs des pages ou si toutes personnes possédant des droits d'administration sur l'appli Gedit peut le faire
 *     + alkhtmlformgeditform.js : il est maintenant possible par le nouveau système de tri des pages de déplacer une page sous une autre même lorsque celle-ci n'a pas encore de page fille.
 * MTO : alkquerygedit_action.class.php : correction addPageAbonnement(), updatePageAbonnement() et delPageAbonnement()
 * EGD : alkhtmlformgeditform.class.php: modification de getBlockArbo() pour envoyé -1 sur l'information de brouillon modifié si la page n'est pas publiée 
 *       + ( nécessite de mettre à jour le module lib qui ajoute la classe à la création de l'arbre)
 *     : alkquerygedit.class.php : modification de la requete SQL de getArboAutorise() pour renvoyé aussi l'état publié ou non d'une page
 *     : alkhtmlformgeditform.class.php:  Modification de l'affichage en cas de langue unique et correction du lien aperçu qui est toujours ouvert dans une nouvelle fenêtre
 *     : alkhtmllistpage.class.php : si on a qu'une seule langue, les liens ne sont pas précédés d'un drapeau
 * MTO : alkquerygedit_action.class.php : modif fonction movePage() => gestion des déplacements vers une application GEDIT d'un espace différent + correction mise à jour de la racine des droits hérités + correction retour cas page publiée
 *     : alkquerygedit_action.class.php : modif fonction addPage() => init page_racine_droit de la page brouillon racine lorsque vaut -1, permet de corriger la gestion des droits sur les pages filles
 *     : alkhtmlformgeditform.class.php : correction validation d'une page brouillon, inutile de recalculer les droits de la page publiée
 * EGD : [MAJ correction] : alkhtmllistpage.class.php : si on a qu'une seule langue, les liens ne sont pas précédés d'un drapeau 
 */
$strNum = "3.4.22";
$tabIns[$strNum][] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_TYPE, CONST_LABEL, CONST_ADMIN)".
  " values (23, -1,'ALK_GEDIT_ALL_ADMIN_MOVE_PAGE','false',3,'".$dbConn->analyseSql("Si vrai, toutes personnes ayant les droits d'administration pourra modifier le rang d'une page, sinon seul les animateurs le peuvent")."',1)";

/**
 * EGD : Ajout de la fonctionnalité permettant de créer un lien vers un contenu iedit 
 *     : alkquerygedit_action.class.php : updatePageRang() : Correction pour MySQL de l'execution de l'ensemble de requete permettant de changer le rang d'un page
 * BFE : alkquerygedit.class.php : getDsListData() correction colonne DATA_NEW absente de V_GEDIT_FORM_DATA    
 */
$strNum = "3.4.23";
$tabIns[$strNum][] = "";
?>