<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_Form
 * @class AlkQueryFormAction
 * Classe de l'application du formulaire
 */
final class AlkQueryFormAction extends AlkQuery
{
  /**
   * Constructeur
   *
   * @param $oDb objet contenant la connexion base de données
   */
  public function __construct(&$oDb)
  {
    parent::__construct($oDb);
  }

  /**
   * Destructeur par défaut
   */
  public function __destruct() { }

  /**
   * Insertion d'un formulaire
   * @return int idenfiant de la formulaire créée 
   */
  public function addFormulaire($tabTitre, $strMail, $strContenu, $appli_id, $dDatePDeb, $dDatePFin, 
                              $bPublication, $bEnvoiAr, $strMsgAr, $bDonneesAr, $strChampMailAr, 
                              $bSondage=0, $bEnvoiPdf=0, $bAlaune=0, $nbrepmax=0, $btSave=0, $form_msg_ar="", $form_secure=0, $form_rep_unique=0)
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");

    $form_id = $this->dbConn->getNextId("FORM_01_FORM", "FORM_ID", "SEQ_FORM_01_FORM");
 
    $strIntituleChamp  = "";
    $strIntituleValues = "";
    $strContenuChamp   = "";
    $strContenuValues  = "";
    $bAr = ALK_B_FORM_AR;
    $bReponse = (defined("ALK_B_FORM_REPONSE") && ALK_B_FORM_REPONSE);
    
    if( $dDatePDeb=="" ) {
      $dDatePDeb ="NULL";
    } else {
      $dDatePDeb = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$dDatePDeb."'");
    }
      
    if( $dDatePFin=="" ) {
      $dDatePFin ="NULL";
    } else {
      $dDatePFin = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$dDatePFin."'");
    }

    foreach($this->tabLangue as $key => $tabLg) {
      $strIntituleChamp  .= " FORM_TITRE".$tabLg["bdd"].", ";
      $strIntituleValues .= "'".$this->dbConn->AnalyseSql($tabTitre[$key])."', ";
      
      $strIntituleChamp  .= " FORM_MSG_AR".$tabLg["bdd"].", ";
      $strIntituleValues .= "'".$this->dbConn->AnalyseSql($form_msg_ar[$key])."', ";
      
      $strContenuChamp .= " FORM_CONTENU".$tabLg["bdd"].", ";
      $strContenuValues .= "'". $this->dbConn->AnalyseSql($strContenu) ."', ";    
    }

    $strArField = "";
    $strArValues = "";
    if( $bReponse || $bAr ) {
      $strArField .= ", FORM_CHAMPMAIL_AR";
                    
      $strArValues .= ", '". $this->dbConn->AnalyseSql($strChampMailAr)."'";
    }    
    if( $bAr ) {
    	$strArField = ", FORM_ENVOI_AR, FORM_CONTENU_AR, FORM_DONNEES_AR";
    								
      $strArValues = ", ".$bEnvoiAr.
        ", '". $this->dbConn->AnalyseSql($strMsgAr)."'".
        ", ".$bDonneesAr;
    }
 
    // ajout de la formulaire
    $strSql = "insert into FORM_01_FORM (".
			"FORM_ID, ".$strIntituleChamp.$strContenuChamp."FORM_DATECREA, FORM_DATEMAJ, AGENT_ID_CREA, ".
			"AGENT_ID_MAJ, FORM_MAIL, FORM_SONDAGE, FORM_ENVOI_PDF, FORM_DATEPDEB, FORM_DATEPFIN, FORM_VALIDEPUB".$strArField.
      (defined("ALK_B_FORM_ALAUNE") && ALK_B_FORM_ALAUNE ? ", FORM_ALAUNE" : "").
			", APPLI_ID, FORM_NBREP_MAX, FORM_BTSAVE, FORM_SECURE, FORM_REP_UNIQUE)".
			" values (". $form_id.
      ", ".$strIntituleValues.$strContenuValues.
			$this->dbConn->GetDateCur() .
      ", ".$this->dbConn->GetDateCur().
      ", ".$user_id.
      ", ".$user_id.
			", '". $this->dbConn->AnalyseSql($strMail) ."'".
			", ".$bSondage.
			", ".$bEnvoiPdf.
      ", ".$dDatePDeb.
      ", ".$dDatePFin.
      ", ".$bPublication.
      $strArValues.
      (defined("ALK_B_FORM_ALAUNE") && ALK_B_FORM_ALAUNE ? ", ".$bAlaune : "").
      ", ".$appli_id.
      ", ".$nbrepmax.
      ", ".$btSave.
      ", ".$form_secure.
      ", ".$form_rep_unique.
      ")";
          
    $this->dbConn->executeSql($strSql);

    return $form_id;
  }
  
  public function UpdateReponseId($rep_id){
    $rep_id++; 
    $strSql = "update SEQUENCE set SEQ_FORM_01_REPONSE=".intval($rep_id);
    $this->dbConn->executeSql($strSql);   
  }
  
  /**
   * Modification d'un formulaire
   */
  public function UpdateFormulaire($form_id, $tabTitre, $strMail, $bCopier, $dDatePDeb, $dDatePFin,
                                   $bPublication, $bEnvoiAr, $strMsgAr, $bDonneesAr, $strChampMailAr, 
                                   $bSondage=0, $bEnvoiPdf=0, $bAlaune=0, $nbrepmax=0, $btSave=0, $form_msg_ar="", $form_secure=0, $form_rep_unique=0 )
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
  	$bAr = ALK_B_FORM_AR;
  	$bReponse = (defined("ALK_B_FORM_REPONSE") && ALK_B_FORM_REPONSE);
    
    $strIntituleValues = "";
    foreach($this->tabLangue as $key => $tabLg) {
      $strIntituleValues .= ( $strIntituleValues==""
                              ? ""
                              : ", ")." FORM_TITRE".$tabLg["bdd"]."='".$this->dbConn->analyseSql($tabTitre[$key])."'" ;
                              
     $strIntituleValues .= ( $strIntituleValues==""
                              ? ""
                              : ", ")." FORM_MSG_AR".$tabLg["bdd"]."='".$this->dbConn->analyseSql($form_msg_ar[$key])."'";
    }
    if( $dDatePDeb=="" ) {
      $dDatePDeb ="NULL";
    } else {
      $dDatePDeb = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$dDatePDeb."'");
    }
      
    if( $dDatePFin=="" ) {
      $dDatePFin ="NULL";
    } else {
      $dDatePFin = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$dDatePFin."'");
    }

  	$strArSql = "";    
  	if ($bReponse || $bAr) {
      $strArSql .= ", FORM_CHAMPMAIL_AR = '". $this->dbConn->AnalyseSql($strChampMailAr) ."'";
    }
    if( $bAr ) {
    	$strArSql .= ", FORM_ENVOI_AR = ".$bEnvoiAr.
        ", FORM_CONTENU_AR = '". $this->dbConn->AnalyseSql($strMsgAr) ."'".
        ", FORM_DONNEES_AR = ".$bDonneesAr;
    }
    
    $strSql = "update FORM_01_FORM set ".
      $strIntituleValues.
		  ", FORM_MAIL='". $this->dbConn->analyseSql($strMail) ."'".
      ", FORM_SONDAGE=". $bSondage.
      ", FORM_ENVOI_PDF=". $bEnvoiPdf.
      ", FORM_DATEPDEB =".$dDatePDeb.
      ", FORM_DATEPFIN =".$dDatePFin.
      ", FORM_VALIDEPUB =".$bPublication.
      ", AGENT_ID_MAJ =".$user_id.
      ", FORM_DATEMAJ =".$this->dbConn->GetDateCur().
      ", FORM_NBREP_MAX=".$nbrepmax.
      ", FORM_BTSAVE=".$btSave.
      ", FORM_SECURE=".$form_secure.
      ", FORM_REP_UNIQUE=".$form_rep_unique.
      (defined("ALK_B_FORM_ALAUNE") && ALK_B_FORM_ALAUNE ? ", FORM_ALAUNE =".$bAlaune : "").
      $strArSql.
		  " where FORM_ID=". $form_id;
      
		$this->dbConn->executeSql($strSql);
    
    if ( $bCopier==1 ) {
      foreach($this->tabLangue as $key => $tabLg) {
        if( $tabLg["bdd"]!="_FR" ) {
          $strSql = "update FORM_01_FORM set".
            " FORM_CONTENU".$tabLg["bdd"]."=FORM_CONTENU_FR".
            ", FORM_JAVASCRIPT".$tabLg["bdd"]."=FORM_JAVASCRIPT_FR".
            " where FORM_ID=". $form_id;
          $this->dbConn->executeSql($strSql);
        }
      }
    }
  }
  
  /**
   * Modification du contenu du formulaire
   * 
   * @param iIdFormulaire       identifiant du formulaire
   * @param strContenu   	 contenu html du formulaire
   */
  public function UpdateFormulaireContenu( $iIdFormulaire, $strContenu, $lang=ALK_LG_BDD )
  {
    $strSql = "update FORM_01_FORM".
      " set FORM_CONTENU".$lang."='". $this->dbConn->analyseSql($strContenu, false) ."'".
      " where FORM_ID=". $iIdFormulaire;
    $this->dbConn->executeSql($strSql);
  }

  /**
   * Suppression d'un formulaire
   * @param form_id  identifiant du formulaire
   */
  public function delFormulaire($form_id)
  {
    $strSql = "delete from FORM_01_FORM_BLOC where FORM_ID=".$form_id;
    $this->dbConn->executeSql($strSql);
    
    //suppression formulaire
    $strSql = "delete from FORM_01_FORM where FORM_ID=".$form_id;
    $this->dbConn->executeSql($strSql, false);   
  }
  
  /**
   * Suppression d'un bloc formulaire
   * @param idForm identifiant du formualire
   * @param idBloc identifiant du bloc
   * @return booleen False si KO, true si OK
   */
  function deleteBlocById($idBloc) 
  {
    $strSql = "delete from FORM_01_FORM_BLOC where BLOC_ID=".$idBloc;
    return $this->dbConn->executeSql($strSql) ;
  }

  /**
   * insere une association d'un formulaire à un bloc
   * @param idBloc   Identifiant du bloc
   * @param idForm   Identifiant du formulaire
   * @return boolean False si KO, true si OK
   */
  function insertFormBloc($idForm, $idBloc)
  {
    $strSql = "insert into FORM_01_FORM_BLOC (BLOC_ID, FORM_ID) values (".$idBloc.", ".$idForm.")";
    return $this->dbConn->executeSql($strSql) ;
  }
  
  /**
   * Modifie l'association d'un formulaire à un bloc
   * @param idBloc   Identifiant du bloc
   * @param form_id  Identifiant du formulaire
   * @return boolean False si KO, true si OK
   */
  function updateFormBloc($idBloc, $form_id)
  {
    $strSql = "update FORM_01_FORM_BLOC".
      " set FORM_ID=".$form_id.
      " where BLOC_ID=".$idBloc;
            
    return $this->dbConn->executeSql($strSql);
  }

  /**
   * Suppression des données de l'appli formulaire
   * @param appli_id  identifiant de l'appli formulaire
   */
  public function delAppli($appli_id)
  { 
    $strSql = "delete from FORM_01_FORM_BLOC where FORM_ID in (select FORM_ID from FORM_01_FORM where APPLI_ID=".$appli_id.")";
    $this->dbConn->executeSql($strSql);
    
    $strSql = "delete from FORM_01_FORM where APPLI_ID=".$appli_id;
    $this->dbConn->executeSql($strSql);
  }

  /**
   * Modifie la propriété d'une information d'un utilisateur à un autre
   *
   * @param agentOld_id   Identifiant de l'utilisateur remplacé
   * @param agentNew_id   Identifiant de l'utilisateur remplaçant
   */
  public function ReplaceUser($agentOld_id, $agentNew_id)
  {
    $strSql = "update FORM_01_FORM set AGENT_ID_CREA=".$agentNew_id." where AGENT_ID_CREA=".$agentOld_id;
    $this->dbConn->executeSql($strSql);

    $strSql = "update FORM_01_FORM set AGENT_ID_MAJ=".$agentNew_id." where AGENT_ID_MAJ=".$agentOld_id;
    $this->dbConn->executeSql($strSql);
  } 
  
  /** Gestion des blocs */
  
  /**
   * Associe un ensemble de données appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc au bloc
   * @param bloc_id     Identifiant du bloc
   * @param tabDataId   Tableau contenant les identifiants des données à associer
   */
  public function assocDataToBloc($bloc_id, $tabDataId)
  {
    foreach($tabDataId as $data_id) {
      if( $data_id!="" && $data_id!="-1" ) {
        $iRank = $this->dbConn->getNextRank("FORM_01_FORM_BLOC", "FORM_RANG", "BLOC_ID=".$bloc_id);
        $strSql = "insert into FORM_01_FORM_BLOC (FORM_ID, BLOC_ID, FORM_RANG)".
          " values (".$data_id.", ".$bloc_id.", ".$iRank.")";
        // accepte l'erreur d'ajout si doublon.
        $this->dbConn->executeSql($strSql, false);
      }
    }
  }

  /**
   * Supprime une association entre une donnée appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc et le bloc
   * @param bloc_id     Identifiant du bloc
   * @param data_id     Identifiant de la données à associer
   */
  public function removeDataFromBloc($bloc_id, $data_id)
  {
    if( $data_id != "-1" ) {
      $this->dbConn->updateRankBeforeDel("FORM_01_FORM_BLOC", "FORM_RANG", "BLOC_ID=".$bloc_id, "FORM_ID=".$data_id." and BLOC_ID=".$bloc_id);
      $strSql = "delete from FORM_01_FORM_BLOC where FORM_ID=".$data_id." and BLOC_ID=".$bloc_id;
    } else {
      $strSql = "delete from FORM_01_FORM_BLOC where BLOC_ID=".$bloc_id;
    }
    $this->dbConn->executeSql($strSql);
  }
  
  /**
   * Met à jour le rang d'une donnée dans un bloc
   * @param bloc_id     Identifiant du bloc
   * @param data_id     Identifiant de la donnée
   * @param iRank       Rang actuel de la donnée
   * @param iDelta      Entier : 1 pour descendre d'un rang, -1 pour monter d'un rang
   */
  public function updateDataRankInBloc($bloc_id, $data_id, $iRank, $iDelta)
  {
    $this->dbConn->switchRank("FORM_01_FORM_BLOC", "FORM_RANG", $iRank, $iDelta, "BLOC_ID=".$bloc_id, "FORM_ID=".$data_id);
  }
  
  /**
   * Suppression d'un bloc de documents
   * @param bloc_id identifiant du bloc
   */
  public function delGEditBloc($bloc_id) 
  {
    $strSql = "delete from FORM_01_FORM_BLOC where BLOC_ID in (".$bloc_id.")";
    $this->dbConn->executeSql($strSql);
  }
  
    /**
   * duplique uniquement les formulaires
   * @param $appli_id_src
   * @param $appli_id
   * @param $iTypeDup
   */
  public function dupAppli($appli_id_src, $appli_id_dest, $iTypeDup){
    
    // ménage avant duplication
    $this->delAppli($appli_id_dest);
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    // on récupère la liste des formulaires
    $strSql = "select * from FORM_01_FORM".
      " where APPLI_ID=".$appli_id_src;
    $dsForm = $this->dbConn->initDataset($strSql);
    
    while($drForm = $dsForm->getRowIter()){
      $form_id = $drForm->getValueName("FORM_ID");
      
      $form_id_new = $this->dbConn->getNextId("FORM_01_FORM", "FORM_ID", "SEQ_FORM_01_FORM");
      
      $strSql = "insert into FORM_01_FORM select ".$form_id_new.
                $this->getMultilingueList("FORM_TITRE", "", true).
                $this->getMultilingueList("FORM_CONTENU", "", true).",".
                " FORM_MAIL, FORM_SONDAGE, ".$this->dbConn->getDateCur().",".$user_id.",NULL,".$user_id.
                $this->getMultilingueList("FORM_JAVASCRIPT", "", true).",".
                " FORM_DATEPDEB, FORM_DATEPFIN,FORM_VALIDEPUB,FORM_VALIDESYND,FORM_ENVOI_AR,FORM_ENVOI_PDF,FORM_DONNEES_AR, FORM_CONTENU_AR,FORM_CHAMPMAIL_AR,".
                $appli_id_dest.",FORM_ALAUNE from FORM_01_FORM where FORM_ID=".$form_id;
      $this->dbConn->executeSql($strSql);
    }
  }
  
}

?>