<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Form
 * @class AlkHtmlPopupApercuForm
 * Classe permettant d'afficher l'apercu d'un formulaire''
 */
class AlkHtmlPopupApercuForm extends AlkHtmlForm
{
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "popupApercuForm"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");  
  } 
   
   /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   * Traitement du formulaire
   */
  public function doSql() { } 
   
 /**
   * Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  { 
  	$idEnt = AlkRequest::getToken("idEnt", "0");
    $strTitre = "Aperçu du formulaire ";
    $dsForm = $this->oAppli->oQuery->GetDs_formulaire($idEnt);
    if( $drForm = $dsForm->getRowIter() ) {
      $strTitre .= "  <i>&quot;".$drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_TITRE"))."&quot;</i>";
    }
    return $strTitre;
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $form_id  = AlkRequest::getToken("form_id",  "-1");

    $tabContent = array();
    $tabContent[0]["cont_id"]    = $cont_id  = AlkRequest::getToken("cont_id",  "-1");
    $tabContent[0]["appli_id"]   = $appli_id = AlkRequest::getToken("appli_id", "-1");
    $tabContent[0]["data_id"]    = $form_id;
    $tabContent[0]["data_rank"]  = 0;
    $tabContent[0]["data_type"]  = 0;
    $tabContent[0]["data_title"]  = "";
    $tabContent[0]["data_text"]  = "";
    $tabContent[0]["data_token"] = "";
    
    if ( $form_id != "" ) {
      $dsForm = $this->oAppli->oQuery->GetDs_formulaire($form_id);
      if( $drForm = $dsForm->GetRowIter() ) {
        $tabContent[0]["data_title"] = $drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
        $tabContent[0]["data_text"]  = $drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_CONTENU"));
        
        $strParamValid = "cont_id=".$cont_id."&appli_id=".$appli_id.
          "&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_RESULTAT."&form_id=".$form_id;
        $tabContent[0]["data_token"] = AlkRequest::getEncodeParam($strParamValid);
      }
    }
  
    if( $tabContent[0]["data_title"] != "" && $tabContent[0]["data_text"] != "" ) {
      $strHtmlForm = "";
      if(isset($tabContent[0]["data_text"])){
        $strHtmlForm = htmlspecialchars_decode(htmlentities($tabContent[0]["data_text"], ENT_NOQUOTES, "UTF-8"));
        if($strHtmlForm != ''){
          $html = str_get_html($strHtmlForm);
          $html->find('span.alkFormBuilder',0)->outertext = '';
          foreach($html->find('input') as $input) {
            $input->outertext = ( preg_match("#/>$#i", $input->outertext) ? $input->outertext : preg_replace("#>$#", "/>",$input->outertext));
          }
          foreach($html->find('div.form_inputText, div.form_inputPassword, div.form_textarea, div.form_combobox, div.form_radio, div.form_checkbox') as $div) {
            $div->tag = "p";
            $div->class = '';
          }
          foreach($html->find('br') as $br) {
            $br->outertext = "<br/>";
          }
          foreach($html->find('div.form_paragraphe, div.form_checkboxGrid, div.form_radioGrid') as $div) {
            $div->outertext = $div->innertext;
          }
          $strHtmlForm = (string)$html->save();
          $strHtmlForm = htmlspecialchars_decode(htmlentities($strHtmlForm, ENT_NOQUOTES, "UTF-8"));
          $strHtmlForm .= "";
          $html->clear();
        }
      }
      $oHtmlCleaner = AlkFactory::getHtmlCleaner();
      $oHtmlCleaner->cleanWithTidy($strHtmlForm, false, true);

      $strPath = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/templates/formulaire.xsl";

      /* transformation xml/xsl permettant d'ajouter les controles de saisie */
      $oXml = AlkFactory::getXml();
      $oXml->setXml("<"."?"."xml version='1.0' encoding='UTF-8'"."?".">
          <form onsubmit='return false;' enctype='multipart/form-data' name='form_".$tabContent[0]["data_id"]."' action='' id='form_".$tabContent[0]["data_id"]."' method='post'>".
          $strHtmlForm.
          "</form>");

      if( function_exists("file_get_contents") ) {
        // existe depuis php 4.3.0
        $oXml->setXsl("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".
        "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">".
        "<xsl:output method=\"xml\" doctype-system=\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\" doctype-public=\"-//W3C//DTD XHTML 1.0 Transitional//EN\" encoding=\"UTF-8\"/>".
        @file_get_contents($strPath));
      }
      $oXml->setTransformation(false);

      $strHtmlForm = mb_ereg_replace("<\?xml[^>]*\?>", "", $oXml->getHtml() );
      $strHtmlForm = mb_ereg_replace("<\!DOCTYPE[^>]*>", "", $strHtmlForm );
      $this->assign('strHtmlForm', $strHtmlForm);
      
      
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmlupload.js");
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formcheck.js");
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formdate.js");
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formnumber.js");
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_form.js");
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_form.js");
      
      $strFileCss = "";
      if(!defined("ALK_CSS_DIR")) define("ALK_CSS_DIR", "");
      if ( file_exists(ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/formulaire.css")){
        $strFileCss = ALK_ROOT_STYLE.ALK_CSS_DIR."/formulaire.css";
      }elseif ( file_exists(ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."formulaire.css")){
        $strFileCss = ALK_ROOT_STYLE."formulaire.css";
      }else{
        $strFileCss = ALK_ROOT_MODULE."form/css/formulaire.css";
      }
      $this->assign("strFileCss", $strFileCss);
      /*
      $strHtml = str_replace("/media/images/ok.gif", ( defined("ALK_VIRTUAL_DIR_BACKOFFICE") ? ALK_VIRTUAL_DIR_BACKOFFICE : ( defined("ALK_VIRTUAL_DIR") ? ALK_VIRTUAL_DIR : ALK_ROOT_DIR ) )."media/images/ok.gif", $strHtml);
      */
      $this->setTemplate("form", "alkhtmlceditpages.tpl");
      $this->assign("strHtmlPage", $strHtmlForm);
      $this->assign("strFileCss", $strFileCss);
    } else {
       $this->setLabelDesc("<br/><br/><br/>"._t("Aucune source html n'est associée au formulaire.")); 
    }
  }

  /**
   *  Retourne le code html l'entête du formulaire
   *
   * @return Retourne un string
   */
  protected function getHtmlHeader()
  {
    return "";
  }
  
  /**
   *  Retourne le code html de la fin du formulaire
   *
   *  Retourne un string
   */
  protected function getHtmlFooter()
  {
    return "";
  }

}
?>