<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/lib/simple_html_dom.php");

/**
 * @package Alkanet_Module_Form
 * 
 * @class AlkHtmlPopupFormulaireForm
 * Classe permettant d'afficher une popup permettant de gérer les formulaires depuis la syndication
 */
class AlkHtmlFormBuilder extends AlkHtmlForm {
  
  protected $strParam;
  protected $form_id;
  protected $repUpload;
  protected $user_id;
  protected $lang;
  
/**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli) {
    parent::__construct($oAppli, "popupFormBuilder"); 
    $this->form_id = AlkRequest::getToken("form_id", -1); 
    $this->user_id = AlkFactory::getSProperty("user_id", "-1");
    $this->lang = AlkRequest::getToken("lang", "_FR");
    $this->repUpload = AlkRequest::getToken("repUpload", "/upload/form/".$oAppli->cont_id."/");
    
    $this->strParam = "&form_id=".$this->form_id."&langFormBuilder=".$this->lang;
    /*
    $this->strTokeClose = AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=".$oAppli->appli_id."&iTypeSheet=".
                                                     ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_NONE.$this->strParam.
                                                     "&applitype_id=".ALK_ATYPE_ID_FORM);*/
    
    $iMode = AlkRequest::getToken("iMode", "-1");
    if( $iMode == "-1" ) {
      $iMode = ( $this->form_id == "-1" ? ALK_FORM_MODE_ADD : ALK_FORM_MODE_UPDATE );
    }
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  }

  protected function setData( $iTypeInit ) {}

  public function doSql() {
    $form_id         = AlkRequest::getToken("form_id",-1);
    $lang         = AlkRequest::getToken("langFormBuilder", "_FR");
    
    // pas d'encodate pour l'instant
    $strTextHtml = AlkRequest::_REQUEST("formulaire", "");
    if($strTextHtml == "" || $form_id == -1 ) die(_t("Erreur lors de l'envoi du formulaire, il est possible que vous ayez été deconnecté"));
    $strFormContenu = AlkRequest::decodeValue($strTextHtml);
    $strFormContenuEncode = htmlspecialchars_decode(htmlentities($strFormContenu, ENT_NOQUOTES, ALK_HTML_ENCODING)); 
    
    $this->oAppli->oQueryAction->UpdateFormulaireContenu($form_id, $strFormContenuEncode, $lang);
    echo getBodyOnLoadExec("", "closeWindow()");
  }
  
  public function getTitle(){
    $form_id = AlkRequest::getToken("form_id", -1); 
    $dsForm = $this->oAppli->oQuery->GetDs_formulaire($form_id);
    $strFormName = _t("Édition du formulaire")." : \t\" ";
    if($drForm = $dsForm->getRowIter()){
      $strFormName .= $drForm->getValueName("form_titre".$this->lang);
    }
    $strFormName .= " \"";
    return $strFormName;
  }
  
  protected function setContents() {
    $this->setData(ALK_INIT_MODE_DATAROW);
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    if(!defined("ALK_B_FORM_FIELDSET_COLONNE") ) define("ALK_B_FORM_FIELDSET_COLONNE", false);
    
    $this->addScriptCss(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/css/alkhtmlformbuilder.css");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/jquery/jquery.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/jquery/ui/minified/jquery-ui.min.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/jquery/handlebars.min.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/alkhtmlformbuilder.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/editor/ckeditor.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/editor/adapters/jquery.js");
    
    $oPanelListFields = AlkHtmlFactory::getHtmlPanel($this->form_id);
    $this->addPanel($oPanelListFields);
    $oPanelListFields->setTemplate("form", "alkhtmlformbuilder.tpl");
    
    
    //On récupère puis on assign ici au template précedemment ajouté le formulaire chargé depuis la base de données
    $futur_form = "";
    $dsForm = $this->oAppli->oQuery->GetDs_formulaire($this->form_id);
    
    if($drForm = $dsForm->getRowIter()){
      $futur_form = $drForm->getValueName("form_contenu".$this->lang);
      $strForm = $this->transform_form($futur_form);
    }
    //$oPanelListFields->assign("futur_form", $futur_form);
    $oPanelListFields->assign("futur_form", $strForm);
    
    //On assign ici au template précedemment ajouté le formulaire chargé depuis la base de données
    $tabFormulaireLoad = array();
    
     $dsForms = $this->oAppli->oQuery->getDsListFormById($this->oAppli->cont_id,TASSOC_EMPTY, $this->user_id, $this->lang);
    
    while($drForms = $dsForms->getRowIter()){
      $tabTmp = array();
      if($this->form_id == $drForms->getValueName("data_id")) continue;
      $tabTmp["form_name"] = $drForms->getValueName("data_titre".$this->lang);
      $tabTmp["form_content"] = $this->transform_form($drForms->getValueName("data_descl".$this->lang));
      $tabFormulaireLoad[] = $tabTmp;
    }
    $oPanelListFields->assign("tabFormulaireLoad", $tabFormulaireLoad);
    
    $oPanelTemplate = AlkHtmlFactory::getHtmlPanel("dialog_template_customizer");
    $this->addPanel($oPanelTemplate);
    $oPanelTemplate->setTemplate("form", "alkhtmlformbuilder_template.tpl");
    $oPanelTemplate->assign("form_fieldset_colonne",(ALK_B_FORM_FIELDSET_COLONNE ? 1 : 0));
    
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, $this->strParam);
    $this->addButtonPage("btValid", "javascript:Validation('".$this->getName()."','".ALK_ALKANET_SQL."?token=".$strToken."')", _t("Valider"), _t("Valider"));
    $this->addButtonPage("btPublier", "javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));
    
  }
  
  
  
  
  protected function transform_form($str_form_content) {
    
    if ( !$str_form_content ) return "";
    
    $html = str_get_html($str_form_content);
    $tabAllLabel = array();
    $tabLabelReserved = array();
    $tabRadio = array();
    $tabCheckbox = array();
    $tabForm = array();

    $idText= 0;
    $bIsAFormBuild = false;
    foreach($html->find('span.alkFormBuilder') as $element){
      $bIsAFormBuild = true;
      $element->outertext = '';
    }
    if($bIsAFormBuild){
      foreach($html->find('p.form_paragraphe') as $paragraphe){
        $paragraphe->outertext =  '<div class="form_element form_paragraphe">'.
                                    '<p><textarea  class="ctrl-paragraphe" placeholder="paragraphe" cols="80" rows="3">'.implode(" ", $paragraphe->find('text')).'</textarea></p>'.
                                  '</div>';
      }
      /* //Décommenter pour utiliser CKEditor
      foreach($html->find('div.ctrl-paragraphe') as $paragraphe){
        $paragraphe->outertext =  '<div class="form_element form_paragraphe">'.
                                    //'<p><textarea  class="ctrl-paragraphe" placeholder="paragraphe" cols="80" rows="3">'.implode(" ", $paragraphe->find('text')).'</textarea></p>'.
                                    '<div class="ctrl-paragraphe">'.$paragraphe->innertext.'</div>'.
                                  '</div>';
      }
      // */
      $strForm = $html->save();
    }else{
      foreach($html->find('p') as $paragraphe){
        foreach($paragraphe->find('label') as $label ){ $tabAllLabel[] = $label->innertext; }
      }
      foreach($html->find('p') as $paragraphe){
        foreach($paragraphe->find('text') as $text ){ 
          if($paragraphe->first_child() == null){
            $tabForm[]= array($idText++ => array("type" => "paragraphe", "value" => trim(str_replace("\\n", "", $text->innertext))));
          }
          //$tabAllLabel[] = $label->innertext; 
        }
      }
      foreach($html->find('p') as $paragraphe){
        foreach($paragraphe->find('input[type=text], input[type=file], input[type=date], input[type=email], input[type=tel], input[type=number], input[type=hidden]') as $element ){
          $tabTmp = array();
          $tabTmp[$element->name]["type"] = $element->type;
          $tabTmp[$element->name]["typejs"] = $element->typejs;
          $tabTmp[$element->name]["placeholder"] = $element->placeholder;
          $tabTmp[$element->name]["value"] = $element->value;
          $tabTmp[$element->name]["required"] = ($element->required || $element->obligatoire ? true : false);

          $tmpLabel = $element->prev_sibling();
          if($tmpLabel!=null && in_array( $tmpLabel->innertext, $tabAllLabel) && !in_array( $tmpLabel->innertext, $tabLabelReserved )){
            $tabTmp[$element->name]["label"] = $tmpLabel->innertext;
            $tabLabelReserved[] = $tmpLabel;
          }else{
            $tabTmp[$element->name]["label"] = "";
          }
          $tabForm[]= $tabTmp;
        }
        foreach($paragraphe->find('input[type=password]') as $element ){
          $tabTmp = array();
          $tabTmp[$element->name]["type"] = $element->type;
          $tabTmp[$element->name]["typejs"] = $element->typejs;
          $tabTmp[$element->name]["placeholder"] = $element->placeholder;
          $tabTmp[$element->name]["value"] = $element->value;
          $tabTmp[$element->name]["required"] = ($element->required || $element->obligatoire ? true : false);

          $tmpLabel = $element->prev_sibling();
          if($tmpLabel!=null && in_array( $tmpLabel->innertext, $tabAllLabel) && !in_array( $tmpLabel->innertext, $tabLabelReserved )){
            $tabTmp[$element->name]["label"] = $tmpLabel->innertext;
            $tabLabelReserved[] = $tmpLabel;
          }else{
            $tabTmp[$element->name]["label"] = "";
          }
          $tabForm[]= $tabTmp;
        }
        foreach($paragraphe->find('input[type=radio]') as $element ){
          $ind = (!isset($tabRadio[$element->name]) ? 0 : count($tabRadio[$element->name]) );
          $tabRadio[$element->name]["type"] = "radio";
          $tabRadio[$element->name]["nom"] = $element->name;
          if(!isset($tabRadio[$element->name]["label"]) && $ind == 0) {
            $tmpLabel = $element->prev_sibling();
            if($tmpLabel!=null && in_array( $tmpLabel->innertext, $tabAllLabel) && !in_array( $tmpLabel->innertext, $tabLabelReserved )){
              $tabRadio[$element->name]["label"] = $tmpLabel->innertext;
              $tabLabelReserved[] = $tmpLabel;
            }else{
              $tabRadio[$element->name]["label"] = "";
            }
          }

          $tabRadio[$element->name][$ind]["value"]= $element->value;
          $tmpLabel = $element->next_sibling();
            if($tmpLabel!=null && in_array( $tmpLabel->innertext, $tabAllLabel) && !in_array( $tmpLabel->innertext, $tabLabelReserved )){
              $tabRadio[$element->name][$ind]["label"] = $tmpLabel->innertext;
              $tabLabelReserved[] = $tmpLabel;
            }else{
              $tabRadio[$element->name][$ind]["label"] = "";
            }

          if($element->required || $element->obligatoire){
            $tabRadio[$element->name]["required"]= true;
          }elseif(!isset($tabRadio[$element->name]["required"])){
            $tabRadio[$element->name]["required"] = false;
          }
          if(!in_array( $element->name."_radio", $tabForm )) $tabForm[] = $element->name."_radio";
        }

        foreach($paragraphe->find('input[type=checkbox]') as $element ){
          $ind = (!isset($tabCheckbox[$element->name]) ? 0 : count($tabCheckbox[$element->name]) );
          $tabCheckbox[$element->name]["type"] = "checkbox";
          $tabCheckbox[$element->name]["nom"] = $element->name;
          if(!isset($tabCheckbox[$element->name]["label"]) && $ind == 0) {
            $tmpLabel = $element->prev_sibling();
            if($tmpLabel!=null && in_array( $tmpLabel->innertext, $tabAllLabel) && !in_array( $tmpLabel->innertext, $tabLabelReserved )){
              $tabCheckbox[$element->name]["label"] = $tmpLabel->innertext;
              $tabLabelReserved[] = $tmpLabel;
            }else{
              $tabCheckbox[$element->name]["label"] = "";
            }
          }

          $tabCheckbox[$element->name][$ind]["value"]= $element->value;
          $tmpLabel = $element->next_sibling();
            if($tmpLabel!=null && in_array( $tmpLabel->innertext, $tabAllLabel) && !in_array( $tmpLabel->innertext, $tabLabelReserved )){
              $tabCheckbox[$element->name][$ind]["label"] = $tmpLabel->innertext;
              $tabLabelReserved[] = $tmpLabel;
            }else{
              $tabCheckbox[$element->name][$ind]["label"] = "";
            }

          if($element->required || $element->obligatoire){
            $tabCheckbox[$element->name]["required"]= true;
          }elseif(!isset($tabRadio[$element->name]["required"])){
            $tabCheckbox[$element->name]["required"] = false;
          }
          if(!in_array( $element->name."_checkbox", $tabForm )) $tabForm[] = $element->name."_checkbox";
        }
        foreach($paragraphe->find('select') as $element ){
          $tabTmp = array();
          $tabTmp[$element->name]["type"] = "select";
          $tabTmp[$element->name]["required"] = ($element->required || $element->obligatoire ? true : false);
          $tabTmp[$element->name]["multiple"] = ($element->multiple ? true : false);
          if(!isset($tabTmp[$element->name]["options"])) $tabTmp[$element->name]["options"] = array();
          if(!isset($tabTmp[$element->name]["placeholder"])) $tabTmp[$element->name]["placeholder"] = "";
          
          $tmpLabel = $element->prev_sibling();
          if($tmpLabel!=null && in_array( $tmpLabel->innertext, $tabAllLabel) && !in_array( $tmpLabel->innertext, $tabLabelReserved )){
            $tabTmp[$element->name]["label"] = $tmpLabel->innertext;
            $tabLabelReserved[] = $tmpLabel;
          }else{
            $tabTmp[$element->name]["label"] = "";
          }

          foreach($element->find('option') as $subElement ){
            if($subElement->value == "" && $subElement->innertext != "" && $element->required ) {
              $tabTmp[$element->name]["placeholder"] = $subElement->innertext;
              continue;
            }
            if($subElement->value == "" && $subElement->innertext == "") continue;
            $tabSubTmp= array();
            $tabSubTmp["value"] = $subElement->value;
            $tabSubTmp["text"] = $subElement->innertext;
            $tabTmp[$element->name]["options"][]=$tabSubTmp;
          }
          $tabForm[]= $tabTmp;
        }
        foreach($paragraphe->find('textarea') as $element ){
          $tabTmp = array();
          $tabTmp[$element->name]["type"] = "textarea";
          $tabTmp[$element->name]["placeholder"] = $element->innertext;
          $tabTmp[$element->name]["required"] = ($element->required || $element->obligatoire ? true : false);

          $tmpLabel = $element->prev_sibling();
          if($tmpLabel!=null && in_array( $tmpLabel->innertext, $tabAllLabel) && !in_array( $tmpLabel->innertext, $tabLabelReserved )){
            $tabTmp[$element->name]["label"] = $tmpLabel->innertext;
            $tabLabelReserved[] = $tmpLabel;
          }else{
            $tabTmp[$element->name]["label"] ="";
          }
          $tabForm[]= $tabTmp;
        }
      }
      foreach($tabForm as $ind => $element){
        if((!is_array($element)) && ( stripos( $element, "_checkbox") !== false || stripos( $element, "_radio") !== false )) {
          if( stripos( $element, "_checkbox") !== false) {
            if(isset($tabCheckbox[str_replace("_checkbox", "", $element)])){ 
              $tabForm[$ind] = array();
              $tabForm[$ind][str_replace("_checkbox", "", $element)] = $tabCheckbox[str_replace("_checkbox", "", $element)];
            }
          }else{
            if(isset($tabRadio[str_replace("_radio", "", $element)])) {
              $tabForm[$ind] = array();
              $tabForm[$ind][str_replace("_radio", "", $element)] = $tabRadio[str_replace("_radio", "", $element)];
            }
          }
        }
      }

      $strForm = "";
      foreach($tabForm as $ind => $tablement){
        if(!is_array( $tablement ) || empty($tablement) ) continue;
        foreach($tablement as $nom => $element){
          switch ($element["type"]){
            case "paragraphe":
              $strForm .= '
              <div class="form_element form_paragraphe">
                <p class="ctrl-paragraphe" >'.$element["value"].'</p>
              </div>';
              break;
            case "text": case "file": case "email": case "tel": case "number": case "date": case "hidden":
              $strForm .= '
              <div class="form_element form_inputText">
                <label>'.( $element["label"] !="" ? $element["label"] : _t('Champ texte')).'</label>
                <input class="ctrl-textbox" type="text" jstype="'.$element["type"].'" value="'.$element["value"].'" placeholder="'.$element["placeholder"].'" name="'.$nom.'" '.($element["required"] ? 'required' : '').' />
              </div>';
              break;
            case "password":
              $strForm .= '
              <div class="form_element form_inputPassword">
                <label>'.( $element["label"] !="" ? $element["label"] : _t('Mot de passe')).'</label>
                <input class="ctrl-passwordbox" type="password" jstype="password"  value="'.$element["value"].'" placeholder="'.$element["placeholder"].'" name="'.$nom.'" '.($element["required"] ? 'required' : '').' />
              </div>';
              break;
            case "textarea":
              $strForm .= '
              <div class="form_element form_textarea">
                <label>'.( $element["label"] !="" ? $element["label"] : _t('Zone de texte')).'</label>
                <textarea class="ctrl-textarea" name="'.$nom.'" placeholder="'.$element["placeholder"].'" '.($element["required"] ? 'required' : '').' ></textarea>
              </div>';
              break;
            case "checkbox":
              $strForm .= '
              <div class="form_element form_checkbox" >
                <span class="label">'.( $element["label"] !="" ? $element["label"] : _t('Cases à cocher')).'</span>';
                $strForm .= '<span class="checkable">';
                foreach($element as $tabCheck){
                  if(is_array($tabCheck) && isset($tabCheck["value"])){
                    $strForm .= '<input class="ctrl-checkboxgroup" type="checkbox" name="'.$nom.'" value="'.$tabCheck["value"].'" '.($element["required"] ? 'required' : '').'/><label>'.($tabCheck["label"] != "" ? $tabCheck["label"] : $tabCheck["value"] ).'</label>'.'<br/>';
                  }
                }
                $strForm .= '</span>';
              $strForm .= '</div>';
              break;
            case "radio":
              $strForm .= '
              <div class="form_element form_radio">
                <span class="label">'.( $element["label"] !="" ? $element["label"] : _t('Boutons radio')).'</span>';
                $strForm .= '<span class="checkable">';
                foreach($element as $tabRad){
                  if(is_array($tabRad) && isset($tabRad["value"])){
                    $strForm .= '<input class="ctrl-radiogroup" type="radio" name="'.$nom.'" value="'.$tabRad["value"].'" '.($element["required"] ? 'required' : '').'/><label>'.($tabRad["label"] != "" ? $tabRad["label"] : $tabRad["value"] ).'</label>'.'<br/>';
                  }
                }
                $strForm .= '</span>';
              $strForm .= '</div>';
              break;
            case "select":
              $strForm .= '
              <div class="form_element form_combobox">
                <label>'.( $element["label"] !="" ? $element["label"] : _t('Liste déroulante')).'</label>
                <select class="ctrl-combobox" name="'.$nom.'" >';
                  $strForm .= ($element["required"] && ! $element["multiple"] ? '<option value="" selected disabled>'.$element["placeholder"].'</option>' : '');
                    foreach($element["options"] as $option){
                      $strForm .= '<option value="'.$option["value"].'">'.$option["text"].'</option>';
                    }
                  $strForm .= '
                </select>
              </div>';
              break;
          }
        }
      }
    }
    $html->clear(); 
    unset($html);
    
    return $strForm;
  }
}
?>