<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlPopupProfilRight
 * Classe de gestion de droit par profil sur les applis d'un espace
 */
class AlkHtmlPopupProfilRight extends AlkHtmlForm 
{
  /**
   * Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formProfilRight");

    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
  }

   /**
   * Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql() 
  {
    $cont_id   = AlkRequest::getToken("cont_id", "-1");
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    $profil_id = AlkRequest::getToken("profil_id", "-1");

    $this->oAppli->setProfilRightsOnSpace($cont_id);
    
    echo getBodyOnLoadExec("", "closeWindow();");
    return "";
  }
  
  /**
   * Retourne le titre de la fenêtre
   * @return string
   */
  public function getTitle()
  {
    $profil_id = AlkRequest::getToken("profil_id", "-1");

    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $strProfil = $oQueryAnnu->GetStr_profilIntitule($profil_id);
    
    return _f("Gestion des droits sur le profil - %s -", $strProfil); 
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $iWidthTxt = 30;
    $iWidthLabel = 130;
    $iWidthCtrl  = 300;

    $cont_id = AlkRequest::getToken("cont_id", "-1");

    $profil_id = AlkRequest::getToken("profil_id", "-1");
    
    // modif de l'appli pour prendre en compte le cas où on vient du module collab
    $appli_id = ($this->oAppli->appli_id==-1 ? AlkRequest::getToken("appli_id", "-1") : $this->oAppli->appli_id);
    $this->setLabelDesc(_t("Fixez les droits d'accès aux profils sur les applications de cet espace."));

    $oBlockRight = $this->getRightPanel();
    //$oBlockRight->enableBlock("", "", $iWidthLabel, $iWidthCtrl, false);
    $this->addPanel($oBlockRight);

    
    $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                           "&iSheet=".ALK_SHEET_PROFILRIGHT."iSSheet=".ALK_SHEET_NONE."&profil_id=".$profil_id); 
            
    $oButton = $this->addButtonPage("bt_Valider", "javascript:Valider('".$strToken."')", _t("Valider"), _t("Valider les droits"));
    $this->addSubmitButton($oButton);

    $this->addButtonPage("bt_Annuler", "javascript:closeWindow()", _t("Annuler"), _t("Annuler les modifications"));
        
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlpopupprofilright.js");
  }

  /**
   * Retourne le block liste des applications avec la gestion de droits
   * @return AlkHtmlList
   */
  private function getRightPanel()
  {
    // liste des profils de cet espace
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $profil_id = AlkRequest::getToken("profil_id", "-1");

    $dsAppli = $this->oAppli->oQuery->getProfilAppliRight($cont_id, $profil_id);

    // nombre d'applis
    $nbElt = $dsAppli->getCountTotDr();

    $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, 1, $nbElt, false, "",
                                            _t("Aucune application n'a été créée sur cet espace."));
    $oTabPage->SetColumns(array("left",  "250"),
                          array("center", "50"),
                          array("center", "50"),
                          array("center", "50"),
                          array("center", "50"));

    $oTabPage->AddTitleRow(_t("Application"), _t("Aucun"), _t("Consult."), _t("Admin."), _t("Publi."));
    $oTabPage->setProperty("strTableAlign", "center");

    $strToken = "";

    // selectionne la liste des applis
    $i = 0;
    while( $drAppli = $dsAppli->getRowIter() ) {
      $appli_id  = $drAppli->getValueName("APPLI_ID");
      $strAppli  = $drAppli->getValueName("APPLI_INTITULE");
      $droit_id  = $drAppli->GetValueName("RIGHT_ID");

      $check0 = "-0'";
      $check1 = "-1'";
      $check2 = "-2'";
      $check4 = "-4'";
      switch( $droit_id )	{
      case ALK_APPLI_RIGHT_NONE:	$check0 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_READ:	$check1 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_ADMIN:	$check2 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_PUBLI:	$check4 .= " checked='checked'"; break;
      }
        
      $strBR0 = "<input type='radio' name='listRight[".$i."]' value='".$appli_id."-".$profil_id.$check0."/>";
      $strBR1 = "<input type='radio' name='listRight[".$i."]' value='".$appli_id."-".$profil_id.$check1."/>";
      $strBR2 = "<input type='radio' name='listRight[".$i."]' value='".$appli_id."-".$profil_id.$check2."/>";
      $strBR4 = "<input type='radio' name='listRight[".$i."]' value='".$appli_id."-".$profil_id.$check4."/>";

      $oTabPage->AddRow($strAppli, $strBR0, $strBR1, $strBR2, $strBR4);
      $i++;
    }
    $oTabPage->setProperty("strTableAlign", "center");
    return $oTabPage;
  }  
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return _t("Aucune aide disponible pour cette page."); 
  }
}

?>