<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlPopupPerf
 * Classe affichant la popup de performance  
 */
class alkhtmlPopupPerf extends AlkHtmlForm
{

  /**
   * constructeur par défaut
   * @param oAppli Référence sur l'application courante
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formPerf");  
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
   }
   
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  public function setData($iTypeInit) { }

  /**
   * Traitement du formulaire
   */ 
  public function doSql() { }

  /**
   * retourne le titre / surcharge car pour les popup le gethtml est appelé après
   * @return string 
   */
  public function getTitle()
  {
    $strTitle = _t("Performance réseau"); 
    return $strTitle;
  }  
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    
    $iLarg = 500;

    // fait en sorte que la page fasse 65536 octets
    $strTxt = "<div id='layerPerf' style='margin-top:32px' align='center'>" .
      _t("Veuillez patienter, calcul de performance en cours...")."</div>";
    $this->setLabelDesc($strTxt);        
    
    //$oBtActualiser = $this->addButtonPage("BtClose", "javascript:document.location.reload()", "Actualiser", "Actualiser le calcul");
    $oBtAnnuler    = $this->addButtonPage("BtClose", "javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));
    
    $strTokenPerfEnd = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FORM, ALK_SHEET_NONE);
    $this->addOnload("onLoadWindPerf('".$strTokenPerfEnd."')");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlpopupperf.js");
  }
  
}
?>