<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * classe qui permet aux utilisateurs de se faire inviter dans l'espace
 * @author ematcha
 *
 */
class AlkHtmlPopupGuestUser extends AlkHtmlForm {
  
  protected $mailGuest;
  protected $securecode;
    /**
   * constructeur par défaut
   * @param oAppli  référence sur l'appli associée
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formGuestUser");
    
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=".$iMode);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;    
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, $strAction);
  }
  
  protected function setData($iTypeInit) 
  { 
    $this->mailGuest = new AlkFormData($this, "mailGuest", AlkRequest::getToken("mailGuest", AlkRequest::_POST("mailGuest", "")), ALK_SQL_TEXT);
    $this->securecode = new AlkFormData($this, "securecode", "", ALK_SQL_NONE);
  }
  
  /**
   * Traitements
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    $cont_id = AlkRequest::getToken("cont_id",-1);
    $mailPost = AlkRequest::_POST("mailGuest", "");
    
    $key = AlkRequest::getToken("key", "");

    $strKeyEncrypt = md5("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER.
      "&iSSheet=".ALK_SHEET_NONE."&mailGuest=".$this->mailGuest->value."&ask=1&key=");
    
    if( $mailPost=="" && $key != $strKeyEncrypt ) {
      return "/"; 
    } 
   
    $nomEspace = "";
    $dsEspace = $this->oAppli->oQuery->getDs_ficheEspaceById($cont_id);
    if($drEspace = $dsEspace->getRowIter()){
      $nomEspace = $drEspace->getValueName("CONT_INTITULE");
    }
    
    // on vérifie que le mail du user existe
    $dsAgent = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU)->GetDsAgentByMail($this->mailGuest->value);
    $idAgent = 0;
    if($drAgent = $dsAgent->getRowIter()){
      $idAgent      = $drAgent->getValueName("AGENT_ID");
      $agent_prenom =  $drAgent->getValueName("AGENT_PRENOM");
      $agent_nom    = $drAgent->getValueName("AGENT_NOM");
      $agent_lg     = $drAgent->getValueName("AGENT_LG");
    
      setMailAlkLocale($agent_lg);
    
      $oAlkMail = AlkFactory::getMail();
      $oAlkMail->SetFrom(ALK_APP_TITLE, ALK_MAIL_ADMIN_MAIL);
      $oAlkMail->AddTo($agent_prenom." ".$agent_nom, $this->mailGuest->value);
      $bIsCollabSpace = $this->oAppli->oQuery->Is_CollabSpace($cont_id);
             
      $tabAssoc["msgTitle"] = ($bIsCollabSpace ? _f("Votre participation au groupe de travail %s", $nomEspace) : _f("Votre inscription à l'outil d'administration de l'espace %s", $nomEspace) );
      $tabAssoc["msg"] = ($bIsCollabSpace ? _f("Votre demande de participation a été traitée le %s à %s.", date("d/m/Y"), date("H:i")) : _f("Votre demande d'inscription a été traitée le %s à %s.", date("d/m/Y"), date("H:i")) ).'<br/>';
      
      // information complémentaire
      $tabAssoc["cont_intitule"] = $nomEspace;
      
      // on vérifie qu'il ne se trouve pas déjà dans l'espace
      $dsAgentEspace = $this->oAppli->oQuery->getDs_accesEspaceAgentById($cont_id, $idAgent);
      if( $dsAgentEspace->getCountTotDr() > 0 ) {
        // l'agent existe déjà dans l'espace
        $strType = "ESPACE_CONFIRME_DEJA_INVITE";
        $tabAssoc["msg"] .= _t("Après vérification, il s'avère que vous êtes déjà présent dans cet espace.").'<br/>';
        
        AlkMailing::SendMailType($oAlkMail, $strType, $tabAssoc);
        setCurrentAlkLocale();

        $strTokenInviteEspace = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                          "&agent_nom=".$agent_nom."&agent_prenom=".$agent_prenom."&iSheet=".ALK_SHEET_USER.
                                                          "&iSSheet=".ALK_SHEET_NONE."&ajoute=0");

        return ALK_ALKANET."?token=".$strTokenInviteEspace;
      } else {
        // agent trouvé et non inscrit, on l'inscrit dans l'espace
        $strType = "ESPACE_CONFIRME_INVITATION";
        $this->oAppli->addUserToSpace($idAgent, $cont_id, ALK_PRIV_SPACE_USER);  
        $tabAssoc["msg"] .= _t("Elle a été acceptée.").
          ' '.($bIsCollabSpace ? _f("Vous êtes désormais utilisateur du groupe de travail - %s -.", $nomEspace) : _f("Vous avez désormais accès à l'outil d'administration de l'espace - %s -.", $nomEspace) ).'<br/><br/>';
        
        AlkMailing::SendMailType($oAlkMail, $strType, $tabAssoc);
        setCurrentAlkLocale();

        $strTokenInviteEspace = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                           "&agent_nom=".$agent_nom."&agent_prenom=".$agent_prenom."&iSheet=".ALK_SHEET_USER.
                                                           "&iSSheet=".ALK_SHEET_NONE."&ajoute=1");

        return ALK_ALKANET."?token=".$strTokenInviteEspace;
      }
    } else {
      // agent non trouvé, on lui présente le lien pour s'enregistrer dans l'annuaire
      $strTokenInviteEspace = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                         "&iSheet=".ALK_SHEET_USER."&iSSheet=".ALK_SHEET_NONE."&ajoute=2&mailGuest=".
                                                         $this->mailGuest->value);
      return ALK_ALKANET."?token=".$strTokenInviteEspace;
    }
  }
  
  /**
   * retourne le titre de la popup
   */
  public function getTitle()
  {
    return "Gestion de l'invitation à un espace de travail";
  }
  
  public function setContents()
  {    
    $this->setData(ALK_INIT_MODE_DATAROW);
    $oBlock = $this->addBlock("block_1", "", "", 150, 500, true);
    //$this->setLabel("Gestion de l'invitation à un espace");
    $cont_id = AlkRequest::getToken("cont_id",-1);
    $dsEspace = $this->oAppli->oQuery->getDs_ficheEspaceById($cont_id);
    
   if($drEspace = $dsEspace->getRowIter()){
      $nomEspace = $drEspace->getValueName("CONT_INTITULE");
    }
    
    $ajoute = AlkRequest::getToken("ajoute",-1);
    $agent_nom = AlkRequest::getToken("agent_nom","");
    $agent_prenom = AlkRequest::getToken("agent_prenom","");
    
    if ($ajoute == 0){
      $Html = "<div style='margin-right:auto; margin-left:auto; text-align:center;'>";
      if ($agent_nom !="" || $agent_prenom !="")
         $Html .="L'agent ".$agent_prenom." ".$agent_nom." est";
       else 
        $Html .= "Vous êtes ";
      
      $Html .= " déjà présent dans l'espace ". $nomEspace."</div>";
      $oHtml = AlkHtmlFactory::getHtml($Html);  
      $oBlock->addCtrl($oHtml); 
    } else if ($ajoute==1){
      
      $html = "<div style='margin-right:auto; margin-left:auto; text-align:center;'>";
      if ($agent_nom !="" || $agent_prenom !="")
         $html .="L'agent ".$agent_prenom." ".$agent_nom." est";
       else 
        $html .= "Vous êtes ";
        $html .=" désormais utilisateur de l'espace ".$nomEspace."</div>";
      $oHtml = AlkHtmlFactory::getHtml($html);
      $oBlock->addCtrl($oHtml);
      
     /* $lienFermer = "<a href=\"javascript:closeWindow()\">Fermer</a>";
      $oHtml = AlkHtmlFactory::getHtml($lienFermer);
      $oBlock->addCtrl($oHtml);*/
    
    } else if ($ajoute ==2) {
      
      // on propose le lien pour s'enregistrer dans l'annuaire
       $mailGuest = AlkRequest::getToken("mailGuest",""); 
       
       $html = "<div style='margin-right:auto; margin-left:auto; text-align:center;'>Vous n'êtes pas encore inscrit dans l'annuaire. ".
                "Merci de cliquer sur le lien ci-dessous pour vous inscrire.</div>";
       $oHtml = AlkHtmlFactory::getHtml($html);
       $oBlock->addCtrl($oHtml);
      
       $strTokenInscritpion = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                            "&iSheet=".ALK_SHEET_CREATEUSER."&iSSheet=".ALK_SHEET_NONE."&err=1&mailGuest=".$mailGuest);
       $urlInscription = ALK_ALKANET."?token=".$strTokenInscritpion;
       
       $lienCreer = "<a title='Incription dans l\'annuaire' href=\"javascript:void(OpenWindow('".$urlInscription."',350, 450))\">Incription dans l'annuaire</a>";
       $oHtml = AlkHtmlFactory::getHtml($lienCreer);
       $oBlock->addCtrl($oHtml);      
    } else {
      
      $ask = AlkRequest::getToken("ask", -1);
    
      $oMailGuest = AlkHtmlFactory::getHtmlText($this->mailGuest,"Saisir votre mail",1,60,255);
      if ($ask==1) $oMailGuest->setReadOnly(true);
      $oMailGuest->addValidator(ALK_VERIF_MAIL+ALK_IS_REQUIRED);
      $oBlock->addCtrl($oMailGuest);
    
      $oCtrlSecure = null;
      if ( !(defined("ALK_B_SECURE_MODE") && ALK_B_SECURE_MODE==false) ){
        $oCtrlSecure = AlkHtmlFactory::getHtmlText($this->securecode, "Code de sécurité", 1, 6, 6);
        $oCtrlSecure->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
        $oCtrlSecureImg = AlkHtmlFactory::getHtml("<a title='Un autre code' href=\"javascript:loadSecureImg('sImg".$oCtrlSecure->getGUID()."')\"><image id='sImg".$oCtrlSecure->getGUID()."' src='".ALK_ALKANET_CAPTCHA."' height='25' border='0'></a>");
        $oCtrlSecure->addCtrl($oCtrlSecureImg);
      }
      $oBlock->addCtrl($oCtrlSecure);
          
      //$this->addValidButton("", "", "Valider", "Valider");
      $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iSend=1");
      $oButton = $this->addButtonPage("bt_Valider", "javascript:Valider('".$strToken."')", _t("Valider"), _t("Valider les droits"));
      $this->addSubmitButton($oButton);
      $this->addButtonPage("cancel", "javascript:closeWindow()", "Annuler", "Fermer la fenêtre");
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlpopupguestuser.js");
    
    } 
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_03_agent_admin_list.htm"); 
  }
}
