<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormUserList
 * Classe d'affichage de la page liste des utilisateurs d'un espace
 */
class AlkHtmlFormUserList extends AlkHtmlForm
{
  /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formUserList"); 
    $iMode = AlkRequest::getToken("iMode", AlkRequest::_REQUEST("iMode", ALK_FORM_MODE_UPDATE));
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $cont_id = AlkRequest::getToken("cont_id", -1);
    $appli_id = AlkRequest::getToken("appli_id", -1);
    $iMode = AlkRequest::getToken("iMode", -1);
    $page  = AlkRequest::getToken("page", 1);

    switch( $iMode ) {
    case ALK_FORM_MODE_ADD:  // invitation d'une liste d'utilisateurs à l'espace
      $this->oAppli->addUserToSpace("", $cont_id, ALK_PRIV_SPACE_USER);

      // réaffiche l'outil de sélection
      $strTokenSave  = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=0&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_UTILISATEUR."&iSSheet=". ALK_SHEET_NONE."&iMode=".ALK_FORM_MODE_ADD);
      $strTokenClose = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_UTILISATEUR."&iSSheet=". ALK_SHEET_NONE);
      $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                             "&iSheet=".ALK_SHEET_USERS_LIST."&cont_id_exclude=".$cont_id."&tokenSave=".$strTokenSave.
                                             "&tokenClose=".$strTokenClose);
      break;

    case ALK_FORM_MODE_UPDATE: 
      break;

    case ALK_FORM_MODE_DEL: // retrait d'une liste d'utilisateurs de l'espace
      $this->oAppli->removeUserFromSpace("", $cont_id);
      $strToken  = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_UTILISATEUR."&iSSheet=". ALK_SHEET_NONE."&page=".$page);
      break;
    }
    
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents() 
  { 
    $this->setData(ALK_INIT_MODE_DATAROW);
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlcheckbox.class.php");
    
     /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    AlkFactory::setSQLParamsName();
    
    $cont_id = ($this->oAppli->cont_id==-1 ? AlkRequest::getToken("cont_id",-1) : $this->oAppli->cont_id);
    $this->dsAgent = $this->oAppli->oQuery->getDs_listeAgentByEspace("", $cont_id, "-1", 0, -1);
    $nbElt = $this->dsAgent->getCountTotDr();
    
    $output = array();
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
      $output = array(
            "sEcho" => AlkFactory::getSQLParamsName("sEcho", ""),
            "iTotalRecords" => $this->dsAgent->getCountTotDr(),
            "iTotalDisplayRecords" => $this->dsAgent->getCountTotDr(),
            "aaData" => array()
          );
    AlkFactory::emptySQLParamsName();

    // changement quand on vient de collab
    $cont_id = ($this->oAppli->cont_id==-1 ? AlkRequest::getToken("cont_id",-1) : $this->oAppli->cont_id);
    $appli_id = ($this->oAppli->appli_id==-1 ? AlkRequest::getToken("appli_id",-1): $this->oAppli->appli_id);
    
    $page          = AlkRequest::_GETint("page", "1");
    $iNbEltParPage = ALKRequest::_GETint("nbItemsPerPage", -1);
    
    if( $iNbEltParPage == -1 ) {
      $iNbEltParPage = ( isset($_SESSION["alk_espaceuser_nbeltparpage"]) ? $_SESSION["alk_espaceuser_nbeltparpage"] : ALK_ITEMS_PER_PAGE );
    } 
    $_SESSION["alk_espaceuser_nbeltparpage"] = $iNbEltParPage;
    
    $oBlock = $this->addBlock("block_1","","", 100, 500, true);

    $strParam = "cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER."&iSSheet=".ALK_SHEET_NONE."&key=";
    $strParam .= md5($strParam); 
    $strToken = AlkRequest::getEncodeParam($strParam) ;
    $strUrlToken = ALK_ALKANET."?token=".$strToken;
    
    $this->setLabel(_f("Liste des %s de cet espace de travail", ALK_S_AGENTS));
    $this->setLabelDesc(_f("Cette liste pr&eacute;sente l'ensemble des %s autoris&eacute;s &agrave; utiliser cet espace", ALK_S_AGENTS).".<br>".
                        _f("Il est possible d'ajouter des %s appartenant  &agrave; l'annuaire, retirer des %s, modifier les droits d'acc&egrave;s", ALK_S_AGENTS, ALK_S_AGENTS).".<br/><br/>".
                        "<strong>"._t("Vous pouvez permettre aux agents de s'inviter eux-mêmes à cet espace.")."<br/>".
                        " "._t("Pour celà, envoyez leur un mail incluant le lien ci-dessous").".</strong><br/><br/>".                        
                        "<input class='formCtrl' style='width:450px; border:none; background-color:#736F6E; color:white;' type='text' value=\"".$strUrlToken."\" readonly='readonly'/>"
                        );
    
    $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_UTILISATEUR."&iSSheet=".ALK_SHEET_NONE);
    
       
    $strTokenSave = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_UTILISATEUR."&iSSheet=".ALK_SHEET_NONE."&iMode=".ALK_FORM_MODE_ADD);
    $strTokenClose = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_UTILISATEUR."&iSSheet=".ALK_SHEET_NONE);
    $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                           "&iSheet=".ALK_SHEET_USERS_LIST."&cont_id_exclude=".$cont_id.
                                           "&tokenSave=".$strTokenSave."&tokenClose=".$strTokenClose);
    $oBtAdd  = AlkHtmlFactory::getHtmlButtonPage("javascript:ajout('".$strToken."');", _t("Ajouter"), _f("Ajouter un  à cet espace", ALK_S_AGENT));
    
    $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_UTILISATEUR."&iSSheet=".ALK_SHEET_NONE."&iMode=".ALK_FORM_MODE_DEL."&page=".$page);
    $oBtDel  = AlkHtmlFactory::getHtmlButtonForm("javascript:SupprAll('".$strToken."');", _t("Supprimer"), 
                                                 _f("Retirer les %s sélectionnés de cet espace", ALK_S_AGENTS));
    
    $oCtrlCB = new AlkHtmlCheckbox(null, 0, "iCheckAll", 0, "");
    $oCtrlCB->addEvent("onclick", "SelectAllCB()");

    $tabNbResults = array("0"  => _t("tout"),
                          "20" => "20",
                          "30" => "30",
                          "50" => "50",
                          "100" => "100",
                          "200" => "200",
                          "500" => "500");

    $bPagine = true;
    if( $iNbEltParPage ==0 ) {
      if( $nbElt < 500 ) {
        $bPagine = false;
      } else {
        // interdit la pagination lorsque le nb > 500
        $bPagine = true;
        $iNbEltParPage = 500;
        unset($tabNbResults[0]);
      }
    }
    
    $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet.
                                           "&iSheet=".ALK_SHEET_UTILISATEUR."&iSSheet=".ALK_SHEET_NONE."&iMode=1");
    //$strToken = $this->oAppli->getToken($this->iTypeSheet, ALK_SHEET_UTILISATEUR, ALK_SHEET_NONE);

    /*$oTabPage = AlkHtmlFactory::getHtmlList($this, 1, $page, 1, $bPagine, ALK_ALKANET."?token=".$strToken, 
                                            _f("Aucun %s sur cet espace", ALK_S_AGENT), false, "tabPagine", true, $tabNbResults);*/
                                            
    $oTabPage = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, true, ALK_ALKANET."?token=".$strToken);

    $oTabPage->SetColumns(array("left", 300, "AGENT_NOM", true, true), 
                          array("left", 150, "SERVICE_INTITULE_COURT", true, true), 
                          array("center", 120, "", false, false), 
                          array("center",90, "", false, false));
    $oTabPage->setModeAjax(true);
    $oTabPage->setFilter(true);
    
    $oTabPage->AddTitleRow("<table><tr><td width='105'>".$nbElt." ".ALK_S_AGENT.($nbElt>1 ? "s" : "")."</td></tr></table>",
                           "Service", 
                           $oBtAdd->getHtml(),
                           "<table><tr><td>".$oCtrlCB->getHtml()."</td><td>".$oBtDel->getHtml()."</td></tr></table>");

    $this->addPanel($oTabPage);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformuserlist.js");
    
    if ($this->iMode == 1)
      $this->readData(true, $oTabPage, $output);
  }
  
  
  /***
   * fonction de lecture des données
   */
  private function readData($bModeAjax= false, &$oList, &$output) {
    
    $cont_id = ($this->oAppli->cont_id==-1 ? AlkRequest::getToken("cont_id",-1) : $this->oAppli->cont_id);
    while( $drAgent = $this->dsAgent->getRowIter() ) {
      $agent_id   = $drAgent->getValueName("AGENT_ID");
      $agent_priv = $drAgent->getValueName("USER_PRIV");
      $service_id = $drAgent->getValueName("SERVICE_ID");
      $strAgent   = $drAgent->getValueName("NOM_PRENOM");
      $strServ    = $drAgent->getValueName("SERVICE_INTITULE_COURT");
      $cont_admin = $drAgent->getValueName("CONT_ADMIN");
      $cont_droit = $drAgent->getValueName("CONT_DROIT");
    
      $strAgentNom = '<a href="javascript:OpenPopupFiche(\'agent\', '.$agent_id.')"'.
                     ' title="'._f("Voir la fiche de l'agent %s", $strAgent).'">'.$strAgent.'</a>';
                     
      $strService = '<a href="javascript:OpenPopupFiche(\'service\', '.$service_id.')"'.
                     ' title="'._f("Voir la fiche du service %s", $strServ).'">'.$strServ.'</a>';
    
      if( $cont_admin == "0" ) {
        $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USERRIGHT."&iSSheet=".ALK_SHEET_NONE."&agent_id=".$agent_id);
        $oLinkRight = AlkHtmlFactory::getHtmlButtonForm("javascript:openUserRights('".$strToken."')", _t("Droits"), 
                                                        _f("Afficher les droits de l'agent %s",$strAgent));
        $oLinkRight = $oLinkRight->getHtml();
      } else {
        $oLinkRight = _t("Animateur");
      }
      if( $cont_admin == "1" ) {
        $oCBUser = "&nbsp;";
      } else {
        $oCBUser = new AlkHtmlCheckbox(null, 0, "listUserId[]", -1, "", $agent_id);
        $oCBUser = $oCBUser->getHtml();
      }
       if ($bModeAjax)
        $output["aaData"][] = array($strAgentNom, $strService, $oLinkRight, $oCBUser);
      else
        $oList->addRowByArray(array($strAgentNom, $strService, $oLinkRight, $oCBUser));
    }
    
    if ( $bModeAjax) {
      echo json_encode( $output );
      exit();
    }
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_05_agent_list.htm"); 
  }

}

?>