<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormRechercheForm
 * Classe d'affichage de la page recherche alkanet
 */
class AlkHtmlFormRechercheForm extends AlkHtmlForm
{
	
  protected $sch_page;  
  protected $sch_keywords ;
  protected $sch_author;
  protected $sch_atype_id ;
  protected $sch_datatype_id;
  protected $sch_cont_id ;
  protected $sch_datemin; 
  protected $sch_datemax;
  
  protected $oAppliSearch;
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formSearch");
    $this->iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($this->iMode, ALK_FORM_METHOD_POST, "");
    $this->oAppliSearch = AlkFactory::getAppli(ALK_ATYPE_ID_SEARCH);
  }

  /**
   * Récupère la dernière recherche effectuée grâce à son enregistrement en POST ou 
   * l'enregistre en session
   */
  protected function saveOrRestoreRequest(&$iPage)
  {
    if( !empty($_POST) ) {
      // enregistre les paramètres postés suite à une validation
      $_SESSION["save_search"] = $_POST;
    } else {
      // récupère la dernière recherche
      if( array_key_exists("save_search", $_SESSION) ) {
        if( array_key_exists("sch_cont_id", $_SESSION["save_search"]) && 
            ($_SESSION["save_search"]["sch_cont_id"] == $this->oAppli->cont_id || 
             $_SESSION["save_search"]["sch_cont_id"] == "-1") ) {
          $_POST = $_SESSION["save_search"];
          $iPage = $_SESSION["save_search"]["sch_page"]; 
        } else {
          $_POST = array();
          $iPage = 1;
        }    
      }
    }
  }
  
  /**
   * Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit)
  {
    $iPage = AlkRequest::_REQUESTint("sch_page", 1);
    $this->saveOrRestoreRequest($iPage);

    $this->sch_page        = new AlkFormData($this, "sch_page",        $iPage, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->sch_keywords    = new AlkFormData($this, "sch_keywords",    "");
    $this->sch_author      = new AlkFormData($this, "sch_author",      "");
    $this->sch_atype_id    = new AlkFormData($this, "sch_atype_id",    -1, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->sch_datatype_id = new AlkFormData($this, "sch_datatype_id", -1, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->sch_datemin     = new AlkFormData($this, "sch_datemin",     "");
    $this->sch_datemax     = new AlkFormData($this, "sch_datemax",     "");
    $this->sch_cont_id     = new AlkFormData($this, "sch_cont_id",     $this->oAppli->cont_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    $this->initData(ALK_INIT_MODE_REQUEST, null, REQ_POST);
  }

  /**
   * Traitement du formulaire
   */
  public function doSql() 
  {
    if ( $this->iMode>=10 )
      return $this->doAjax();
    return "";
  }
  
  /**
   * Si iMode>=10. Effectue des actions destinées à un affichage AJAX : echo du résultat
   * @return empty string
   */
  protected function doAjax()
  {
    $strAjax = "";
    switch ( $this->iMode-10 ){
      case 0 : // Mise à jour d'un sélect en fonction de la sélection dans un autre sélect
        $bOnload = true;
        $ctrlSrc = AlkRequest::_GET("ctrlSrc", "");
        $src_id  = AlkRequest::_GETint("src_id", "-1");
        $ctrlDest = "";
        $oDs = null;
        $bAll = false;
        switch ($ctrlSrc){
          case "sch_atype_id" : 
            $oDs = $this->oAppliSearch->oQuery->GetDs_DataTypeByATypeForComboSearch($src_id);
            $bAll = $oDs->getCountTotDr()==1;
            $ctrlDest = "sch_datatype_id";
          break;
        }
        
        $strAjax .= " var formName = '".$this->getName()."';";
        $strAjax .= " var ctrlDestName = '".$ctrlDest."';";
        $strAjax .= " var tabOptions = new Array();";
        if ($ctrlDest!="" && $oDs!=null){
          $strAjax .= " tabOptions[tabOptions.length] = new Array('-1', 'Tous');";
          while ( $oDr = $oDs->GetRowIter() ){
            $text = $oDr->GetValueNum(0);
            $value = $oDr->GetValueNum(1);        
            $strAjax .= " tabOptions[tabOptions.length] = new Array(\"".addslashes($value)."\", \"".addslashes($text)."\");";
          }
        }
      break;
    }
    echo $strAjax;
    return "";
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {    
    $this->setData(ALK_INIT_MODE_REQUEST);
    $bSubmit = AlkRequest::_GETint("s", "0");
    
    $strHtmlSearch = "";                  
    $strHtmlResults = "";
    if( ALK_B_ATYPE_SEARCH == true ) {
      $oRes = null;
      $oBlockSearch =  $this->getHtmlBlockSearch($oRes);
      if( $bSubmit == "1" && !$this->isEmptyCriteria() ) {
        $oBlockResults = $this->getHtmlBlockResultSearch ($oRes);
      }      
    }
  }
  
  /**
   * CallService - Retourne le code HTML du formulaire de recherche général
   * 
   * @param oRes
   * 
   * @return retourne un string html
   */
  protected function getHtmlBlockSearch(&$oRes, $bWithGeoloc=true, $formName="formSearch", $target="footerExec")
  {
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_ajax.js");
    $this->AddScriptJs(AlkFactory::getModuleUrl(ALK_ATYPE_ID_SEARCH)."lib/lib_search.js"); 
    
    $formName = ($bWithGeoloc ? "formSearch" : $formName);
    
    $iWidthTxt = ($bWithGeoloc ? 30 : 17);
    $iWidthSelect = ($bWithGeoloc ? 240 : 140);
    $iWidthLabel = ($bWithGeoloc ? 130 : 100);
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    
    
    $oQuerySearch = AlkFactory::getQuery(ALK_ATYPE_ID_SEARCH);
    
    $oHide = AlkHtmlFactory::getHtmlHidden($this->sch_page);
    
    $oKeywords = AlkHtmlFactory::getHtmlText($this->sch_keywords, _t("Mots-Clés"), 1, $iWidthTxt); 
    
    $oAuthor = AlkHtmlFactory::getHtmlText($this->sch_author, _t("Auteur"), 1, $iWidthTxt);
    $oAuthor->addValidator(ALK_VERIF_TEXT);
    
    $oAType = AlkHtmlFactory::getHtmlSelect($this->sch_atype_id, _t("Type d'application"), 1, $iWidthSelect);
    $oAType->setProperty("tabValTxtDefault", array("-1", _t("Tous")));
    $oAType->setProperty("oValTxt", $oQuerySearch->GetDs_AppliTypeForComboSearch($user_id));   
    $oAType->AddEvent("onchange", "ChangeAppliType(this, '".$formName."', '".$target."')");
    
    $oDatatype = AlkHtmlFactory::getHtmlSelect($this->sch_datatype_id,_t("Type d'informations"), 1, $iWidthSelect);
    $oDatatype->setProperty("tabValTxtDefault", array("-1", "Tous"));   
    $oDatatype->setProperty("oValTxt", $oQuerySearch->GetDs_DataTypeByATypeForComboSearch($this->sch_atype_id->value));
    
    $oWSpace = AlkHtmlFactory::getHtmlRadio($this->sch_cont_id, _t("Espace de travail"));
    $oWSpace->AddRadio($this->oAppli->cont_id, _t("Espace courant"));
    $oWSpace->AddRadio("-1", _t("Tous les espaces"));
    
    $oDateMin = AlkHtmlFactory::getHtmlDate($this->sch_datemin, _t("Créés / Modifiés / Publiés"), "01/01/2000", "");
    $oDateMin->setLabelBefore("du");
    $oDateMin->AddEvent("onfocus", "BlurFocusDate(this, true);");
    $oDateMin->AddEvent("onblur", "BlurFocusDate(this, false);");
   
    $oDateMax = AlkHtmlFactory::getHtmlDate($this->sch_datemax, "au", "01/01/2000", "");
    $oDateMax->AddEvent("onfocus", "BlurFocusDate(this, true);");
    $oDateMax->AddEvent("onblur", "BlurFocusDate(this, false);");
        
    $strTitre = _t("Critères généraux");

    $oBlock = $this->addBlock("block_0", $strTitre, "", "280", "500", true);
    
    $oBlock->AddCtrl($oKeywords);
    $oBlock->AddCtrl($oAuthor);
    $oDateMin->AddCtrl($oDateMax);   
    $oBlock->AddCtrl($oDateMin);
    $oBlock->AddCtrl($oAType);
    $oBlock->AddCtrl($oDatatype);
    $oBlock->AddCtrl($oWSpace);   
        
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE);
    $oBlock->addButtonPage("bt_valider", "javascript:Rechercher('".$this->getName()."', '".$strToken."')", _t("Rechercher"), _t("Lancer la recherche"));
    $oBlock->setTemplate("alkanet", "block_bicolumn.tpl");
  }
  
  /**
   * Renvoit le résultat de la recherche paginée
   * 
   * @param oRes
   * 
   * @return un string html
   */
  protected function getHtmlBlockResultSearch(&$oRes, $bInGeoloc=false, $formName="formSearch")
  { 
    $iFirst = 0; 
    $iLast = -1; 
    $iNbEltParPage = ALK_ITEMS_PER_PAGE; 
    $iNumPage = $this->sch_page->value; 
    
    // utilisé uniquement pour déterminer iNbEltParPage, iNumPage est déjà fixé
    AlkFactory::getIntervalDataByPage($iNbEltParPage, $iNumPage, $iFirst, $iLast);
    $iNumPage = $this->sch_page->value;
    $iFirst = ($iNumPage-1)*$iNbEltParPage;
    $iLast  = $iNumPage*$iNbEltParPage-1;
    
    $dsSearch = $this->oAppliSearch->oQuery->getDsSearch($this, $iFirst, $iLast);
    
    $strMsg = _t("Aucun résultat ne répond à votre recherche");
    $bExit = false;
    if ( $dsSearch->getCountTotDr()>200 ){
      $strMsg = _t("Affinez votre recherche");
      $bExit = true;
    }

    $oList = AlkHtmlFactory::getHtmlList($this, $dsSearch->getCountTotDr(), $iNumPage, $iNbEltParPage, true, "javascript:ChangePageResults('".$formName."', page)", $strMsg, "", "searchResults"); 
    $oList->setProperty("bAffCompteur", true);
    $oList->setProperty("cssList", "");
    $oList->SetColumns(array("left", "100%"));
    $oList->AddRightRow(1);
    $this->addPanel($oList);
    
    $tabFields = array();
    $old_datatype_id = -1;
    $nbDataByCateg = 0;
    while ( $drSearch = $dsSearch->GetRowIter() ){
      $datatype_id      = $drSearch->getValueName("DATATYPE_ID");
      $datatype_intitule= $drSearch->getValueName("DATATYPE_INTITULE");
      $bNewCategory = false;
      if ( $old_datatype_id!=$datatype_id ){
        if ( isset($$oPagine) ){
          $$oPagine->setProperty("iNbRealElt", $nbDataByCateg);
          $$oPagine->setProperty("iNbElt", $nbDataByCateg);
          $$oPagine->setTemplate("search", "search_results.tpl");
        }
        $oPagine = "oPagine".$datatype_id;
        $nbDataByCateg = 0;         
        $$oPagine = AlkHtmlFactory::getHtmlList($this, $nbDataByCateg, 1, $iNbEltParPage, true, "javascript:ChangePageResults('".$formName."', page)", $strMsg, "", "searchResults".$datatype_id); 
        $$oPagine->SetColumns(array("left", "60%"), array("left", "40%") );
        $$oPagine->AddRightRow(1, 1);
        $$oPagine->AddTitleRow(array($datatype_intitule, 2));
        $oList->addRow($$oPagine);
        $bNewCategory = $this->sch_datatype_id->value==-1;
        $old_datatype_id = $datatype_id;
      }
      $nbDataByCateg++;
      $data_id          = $drSearch->getValueName("DATA_ID");
      $appli_id         = $drSearch->getValueName("APPLI_ID");
      $atype_id         = $drSearch->getValueName("ATYPE_ID");
      $cont_id          = $drSearch->getValueName("CONT_ID");
      $cont_intitule    = $drSearch->getValueName("CONT_INTITULE_COURT");  
      $appli_intitule   = $drSearch->getValueName("APPLI_INTITULE");  
      $data_intitule    = $drSearch->getValueName(AlkFactory::getDBCurrentLanguageField("DATA_INTITULE"));  
      $data_desc        = $drSearch->getValueName(AlkFactory::getDBCurrentLanguageField("DATA_DESC"));
      $data_arborescence= $drSearch->getValueName(AlkFactory::getDBCurrentLanguageField("DATA_ARBORESCENCE"));
      $data_author      = $drSearch->getValueName("DATA_AUTHOR");
      $data_datecrea    = $drSearch->getValueName("DATA_DATECREA");
      $data_datemaj     = $drSearch->getValueName("DATA_DATEMAJ");
      $data_datepdeb  = $drSearch->getValueName("DATA_DATEPDEB");
      $data_datepfin  = $drSearch->getValueName("DATA_DATEPFIN");
      $data_url         = $drSearch->getValueName("DATA_URL");
      $data_token       = $drSearch->getValueName("DATA_TOKEN");
      $data_token       = eval("return ".$data_token.";");
      
      $data_token = AlkRequest::getEncodeParam($data_token);
      $data_url   = mb_ereg_replace("__TOKEN__", $data_token, $data_url);
      $data_url   = eval("return ".$data_url.";");
      
    
      $tabFields = array(
        "datatype_intitule",
        "bNewCategory",
        "datatype_id",
        "data_id",
        "appli_id",
        "atype_id",
        "cont_id",
        "appli_intitule",
        "data_arborescence",
        "data_intitule",
        "data_desc",
        "data_author",
        "data_datecrea",
        "data_datemaj",
        "data_datepdeb",
        "data_datepfin",
        "data_url"
      );
      if ( $this->sch_cont_id->value==-1)
        $tabFields[] = "cont_intitule";
      
      $oRow = array();
      foreach ($tabFields as $iField=>$strField){
        $oRow[$iField] = $oRow[$strField] = $$strField;
      }
      
      $$oPagine->addRow($oRow);
    }

    if (isset($$oPagine)){
      $$oPagine->setProperty("iNbRealElt", $nbDataByCateg);
      $$oPagine->setProperty("iNbElt", $nbDataByCateg);
      $$oPagine->setTemplate("search", "search_results.tpl");
    }

  }
  
  /**
   * retourne la valeur de sch_keywords
   * @return string
   */
  public function getSchKeywords()
  {
    return $this->sch_keywords->value;
  }
  /**
   * retourne la valeur de sch_author
   * @return string
   */
  public function getSchAuthor()
  {
    return $this->sch_author->value;
  }
  /**
   * retourne la valeur de sch_datemin
   * @return string
   */
  public function getSchDateMin()
  {
    return $this->sch_datemin->value;
  }
  /**
   * retourne la valeur de sch_datemax
   * @return string
   */
  public function getSchDateMax()
  {
    return $this->sch_datemax->value;
  }
  /**
   * retourne la valeur de sch_cont_id
   * @return int
   */
  public function getSchContId()
  {
    return $this->sch_cont_id->value;
  }
  /**
   * retourne la valeur de sch_atype_id
   * @return int
   */
  public function getSchAtypeId()
  {
    return $this->sch_atype_id->value;
  }
  /**
   * retourne la valeur de sch_datatype_id
   * @return int
   */
  public function getSchDatatypeId()
  {
    return $this->sch_datatype_id->value;
  }
  
  /** 
   * Retourne vrai si les critères sont vides, faux sinon
   * @return boolean
   */
  private function isEmptyCriteria()
  {
    return  $this->sch_page->value == 1 &&
      $this->sch_keywords->value == "" &&
      $this->sch_author->value == "" &&
      $this->sch_atype_id->value == "-1" && 
      $this->sch_datatype_id->value == "-1" &&
      $this->sch_datemin->value == "" &&
      $this->sch_datemax->value == "" &&
      $this->sch_cont_id->value == $this->oAppli->cont_id;
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_01_recherche_form.htm"); 
  }
}
?>