<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormPlanifList
 * Classe d'affichage des tâches planifiées des différentes applications
 */
class AlkHtmlFormPlanifList extends AlkHtmlForm
{

  /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formPlanifList"); 
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $strAction = "";
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
  }

  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) 
  {
    $this->tabJoursSemaine  = $this->oAppli->getTabCronInterval("jourssemaine");
    $this->tabJoursMois     = $this->oAppli->getTabCronInterval("joursmois");
    $this->tabMois          = $this->oAppli->getTabCronInterval("mois");
    
    $this->atype_id = AlkRequest::getToken("atype_id", AlkRequest::_REQUEST("atype_id", -1));
  }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $this->setLabel(_t("Liste des tâches planifiées"));
    
    $oDsTypeAppli = $this->oAppli->oQuery->getDs_listeTypeAppliByListId("", "", -1, true);
    
    while ( $oDrTypeAppli = $oDsTypeAppli->getRowIter() ) {
      $atype_id = $oDrTypeAppli->getValueName("ATYPE_ID");
      $atype_intitule = $oDrTypeAppli->getValueName("ATYPE_INTITULE");
      $this->getHtmlSheet($this, $atype_id, $atype_intitule);
    }
    
    $this->setSelectedSheetByGUID("sheet_".$this->atype_id);
  }
  
  /**
   * Ajoute et retourne l'onglet correspondant au type d'application
   * @param oForm           formulaire dans lequel l'onglet est ajouté
   * @param atype_id        identifiant du type d'application
   * @param atype_intitule  intitulé du type d'application (=intitulé de l'onglet)
   * @return onglet ajouté
   */
  public function getHtmlSheet($oForm, $atype_id, $atype_intitule)
  {
    $this->setData(ALK_INIT_MODE_DEFAULT);
    
    $oSheet = $this->addSheet("sheet_".$atype_id, $atype_intitule);
    
    $nbEltParPage = 10;
    
    $iNumPage = ( $this->atype_id == $atype_id ? AlkRequest::_REQUEST("page", AlkRequest::getToken("page", 1)) : 1);
    $iFirst = ($iNumPage-1)*($nbEltParPage);
    $iLast = $iNumPage*($nbEltParPage)-1;
    $oDsTask = $this->oAppli->oQuery->getDs_listeCronTask($this->oAppli->cont_id, $atype_id,-1, -1, -1, $iFirst, $iLast);
    
    // boucle qui permet d'afficher la dernière page si aucun élément sur la page spécifiée
    while ( $oDsTask->getCountTotDr() == 0 && $iNumPage > 1 ) {
      $iNumPage--;
      $iFirst = ($iNumPage-1)*($nbEltParPage);
      $iLast = $iNumPage*($nbEltParPage)-1;
      $oDsTask = $this->oAppli->oQuery->getDs_listeCronTask($this->oAppli->cont_id, $atype_id,-1, -1, -1, $iFirst, $iLast);
    }
    
    $strUrlPagine = ALK_ALKANET."?token=".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&atype_id=".$atype_id);
    
    $oListTask = AlkHtmlFactory::getHtmlList($oForm, $oDsTask->getCountTotDr(), $iNumPage, $nbEltParPage, true, $strUrlPagine, "Aucune tâche planifiée", false, "tabTask".$atype_id);
    
    $oListTask->setColumns(array("center",  "120"),
                           array("left",    "150"),
                           array("left",    "250"),
                           array("center",  "120"),
                           array("center",  "40"),
                           array("center",  "40")
    );
    
    $strParamRetour = urlencode("&atype_id=".$atype_id."&page=".$iNumPage);
    $strUrlBtAdd = ALK_ALKANET."?token=".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, ALK_SHEET_FORM, "&iMode=".ALK_FORM_MODE_ADD."&atype_id=".$atype_id.
                                                                                                                   "&iTypeSheetRetour=".$this->iTypeSheet.
                                                                                                                   "&iSheetRetour=".$this->iSheet.
                                                                                                                   "&iSSheetRetour=".$this->iSSheet.
                                                                                                                   "&paramRetour=".$strParamRetour);
    $oBtAdd = AlkHtmlFactory::getHtmlButtonForm($strUrlBtAdd, _t("Ajouter"), _t("Ajouter une nouvelle tâche"));
    
    $oListTask->addTitleRowByArray(array(array(_t("Date de création")), array(_t("Action")), array(_t("Détail de la planification")), array(_t("Dernière exécution")), array($oBtAdd->getHtml(), 2, 1)));
    
    while ( $oDrTask = $oDsTask->getRowIter() ) {
      $task_id            = $oDrTask->getValueName("TASK_ID");
      $task_datecrea      = $oDrTask->getValueName("TASK_DATECREA");
      $action_intitule    = $oDrTask->getValueName("ACTION_INTITULE");
      $task_typetask      = $oDrTask->getValueName("TASK_TYPETASK");
      $task_datelastexec  = $oDrTask->getValueName("TASK_DATELASTEXEC");
      
      $strDescPlanif = "";
      switch ( $task_typetask ) {
        case 0 :  // périodique
          $task_jourssemaine  = $oDrTask->getValueName("TASK_JOURSSEMAINE");
          $task_joursmois     = $oDrTask->getValueName("TASK_JOURSMOIS");
          $task_mois          = $oDrTask->getValueName("TASK_MOIS");
          $task_typetime      = $oDrTask->getValueName("TASK_TYPETIME");
          $task_time          = $oDrTask->getValueName("TASK_TIME");
          
          // récupère les jours de la semaine
          $tabJoursSemaine = $this->getTabKeysForBits($this->tabJoursSemaine, $task_jourssemaine, false);
          $strDescPlanif.= (count($tabJoursSemaine) > 0 ? _t("Jours de la semaine")." : ".implode(", ", $tabJoursSemaine)."<br/>" : "" );
          
          // récupère les jours du mois
          $tabJoursMois = $this->getTabKeysForBits($this->tabJoursMois, $task_joursmois, false);
          $strDescPlanif.= (count($tabJoursMois) > 0 ? _t("Jours du mois")." : ".implode(", ", $tabJoursMois)."<br/>" : "" );
          
          // récupère les mois
          $tabMois = $this->getTabKeysForBits($this->tabMois, $task_mois, false);
          $strDescPlanif.= (count($tabMois) > 0 ? _t("Mois")." : ".implode(", ", $tabMois)."<br/>" : "" );
          
          // récupère l'heure
          switch ( $task_typetime ) {
            case 0 :
              $strDescPlanif.= _t("Heure de fréquence")." : ".$task_time;
            break;
            case 1 :
              $strDescPlanif.= _t("Heure fixe")." : ".$task_time;
            break;
          }
          
        break;
        case 1 :  // ponctuelle
          $ponctuelle_date = $oDrTask->getValueName("TASK_DATE");
          $ponctuelle_time = $oDrTask->getValueName("TASK_TIME");
          $strDescPlanif.= ( $ponctuelle_date ? _t("Le ").$ponctuelle_date." " : "" ).( $ponctuelle_time  ? _t("à ").$ponctuelle_time : "" );
        break;
      }
      
      $strLinkUpdate = ALK_ALKANET."?token=".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, ALK_SHEET_FORM, "&iMode=".ALK_FORM_MODE_UPDATE."&task_id=".$task_id.
                                                                                                                       "&iTypeSheetRetour=".$this->iTypeSheet.
                                                                                                                       "&iSheetRetour=".$this->iSheet.
                                                                                                                       "&iSSheetRetour=".$this->iSSheet.
                                                                                                                       "&paramRetour=".$strParamRetour);
      $oBtUpdate = AlkHtmlFactory::getHtmlButtonIcon($strLinkUpdate, "Modifier", _t("Modifier"));
      
      $strLinkDelete = ALK_ALKANET_SQL."?token=".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, ALK_SHEET_FORM, "&iMode=".ALK_FORM_MODE_DEL."&task_id=".$task_id.
                                                                                                                           "&iTypeSheetRetour=".$this->iTypeSheet.
                                                                                                                           "&iSheetRetour=".$this->iSheet.
                                                                                                                           "&iSSheetRetour=".$this->iSSheet.
                                                                                                                           "&paramRetour=".$strParamRetour);
      $oBtDelete = AlkHtmlFactory::getHtmlButtonIcon($strLinkDelete, "Supprimer", _t("Supprimer"));
      
      
      $oListTask->addRowByArray(array($task_datecrea, $action_intitule, $strDescPlanif, $task_datelastexec, $oBtUpdate->getHtml(), $oBtDelete->getHtml()));
    }
    
    $oSheet->addPanel($oListTask);
    
    return $oSheet;
  }
  
  /**
   * Retourne un tableau contenant les clés du tableau passé en paramètre dont les valeurs sont comprises dans le champs de bits passé en paramètre
   * @param tabFrom   tableau clé => valeur
   * @param bits      valeur du champs de bits
   * @param bTous     booléen indiquant si le tableau en entrée possède une clé "Tous" correspondant à la somme de toutes les valeurs du tableau
   *                  dans ce cas là, vérfie si la valeur du champs de bits est égal à "Tous" et retourne uniquement cette clé si égal
   * @return tableau
   */
  protected function getTabKeysForBits($tabFrom=array(), $bits=0, $bTous=true)
  {
    $bits = (int)$bits;
    $tabReturn = array();
    
    if ( $bTous && array_key_exists("Tous", $tabFrom) ) {
      if ( $bits == $tabFrom["Tous"] ) {
        $tabReturn[] = "Tous";
        return $tabReturn;
      }
    }
    
    if ( $bits != 0 ) {
      foreach ( $tabFrom as $key => $value ) {
        if ( ($bits & $value) == $value ) {
          $tabReturn[] = $key;
        }
      }
    }
    $tabReturn = array_diff($tabReturn, array("Tous"));
    
    return $tabReturn;
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_08_planif_list.htm"); 
  }

}
?>