<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormPlanifList
 * Classe de gestion d'une tâche planifiée pour une application
 */
class AlkHtmlFormPlanifForm extends AlkHtmlForm
{

  /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formPlanifForm"); 
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $strAction = "";
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
  }

  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) {
    $this->tabHour = array("00" => "00", "01" => "01", "02" => "02", "03" => "03", "04" => "04", "05" => "05", "06" => "06", "07" => "07", "08" => "08", "09" => "09", "10" => "10",
                           "11" => "11", "12" => "12", "13" => "13", "14" => "14", "15" => "15", "16" => "16", "17" => "17", "18" => "18", "19" => "19", "20" => "20", "21" => "21",
                           "22" => "22", "23" => "23",
    );
    
    $interval = ( defined("ALK_CRON_INTERVAL") ? ALK_CRON_INTERVAL : 15 );
    $nb = 60/$interval;
    $this->tabMin = array();
    for ( $i=0; $i<$nb; $i++ ) {
      $strVal = strval($interval*$i);
      if ( strlen($strVal) < 2 ) {
        $strVal = "0".$strVal;
      } 
      $this->tabMin[$strVal] = $strVal;
    }
    
    $this->tabJoursSemaine  = $this->oAppli->getTabCronInterval("jourssemaine");
    $this->tabJoursMois     = $this->oAppli->getTabCronInterval("joursmois");
    $this->tabMois          = $this->oAppli->getTabCronInterval("mois");
    
    $this->bJoursMois = false;
    $this->bMois = false;
    
    $task_id            = AlkRequest::getToken("task_id", AlkRequest::_REQUEST("task_id", -1));
    $cont_id            = AlkRequest::getToken("cont_id", AlkRequest::_REQUEST("cont_id", 0));
    $atype_id           = AlkRequest::getToken("atype_id", AlkRequest::_REQUEST("atype_id", -1));
    $appli_id           = AlkRequest::getToken("appli_id_task", AlkRequest::_REQUEST("appli_id_task", -1));
    $action_id          = AlkRequest::getToken("action_id", AlkRequest::_REQUEST("action_id", -1));
    $task_typetask      = AlkRequest::getToken("task_typetask", AlkRequest::_REQUEST("task_typetask", 0));
    $task_date          = AlkRequest::getToken("task_date", AlkRequest::_REQUEST("task_date", ""));
    $task_datetime      = AlkRequest::getToken("task_datetime", AlkRequest::_REQUEST("task_datetime", ""));
    $task_jourssemaine  = AlkRequest::getToken("task_jourssemaine", AlkRequest::_REQUEST("task_jourssemaine", array()));
    $task_joursmois     = AlkRequest::getToken("task_joursmois", AlkRequest::_REQUEST("task_joursmois", array()));
    $task_mois          = AlkRequest::getToken("task_mois", AlkRequest::_REQUEST("task_mois", array()));
    $task_typetime      = AlkRequest::getToken("task_typetime", AlkRequest::_REQUEST("task_typetime", 0));
    $task_hour          = AlkRequest::getToken("task_hour", AlkRequest::_REQUEST("task_hour", ""));
    $task_min           = AlkRequest::getToken("task_min", AlkRequest::_REQUEST("task_min", ""));
    
    $this->task_id            = new AlkFormData($this, "task_id", $task_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->cont_id            = new AlkFormData($this, "cont_id", $cont_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->atype_id           = new AlkFormData($this, "atype_id", $atype_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->appli_id           = new AlkFormData($this, "appli_id", $appli_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->action_id          = new AlkFormData($this, "action_id", $action_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->task_typetask      = new AlkFormData($this, "task_typetask", $task_typetask, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->task_date          = new AlkFormData($this, "task_date", $task_date, ALK_SQL_DATETIME, ALK_VERIF_DEFAULT);
    $this->task_jourssemaine  = new AlkFormData($this, "task_jourssemaine[]", $task_jourssemaine, ALK_SQL_NUMBER, ALK_VERIF_ARRAY);
    $this->task_joursmois     = new AlkFormData($this, "task_joursmois[]", $task_joursmois, ALK_SQL_NUMBER, ALK_VERIF_ARRAY);
    $this->task_mois          = new AlkFormData($this, "task_mois[]", $task_mois, ALK_SQL_NUMBER, ALK_VERIF_ARRAY);
    $this->task_typetime      = new AlkFormData($this, "task_typetime", $task_typetime, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->task_hour          = new AlkFormData($this, "task_hour", $task_hour, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->task_min           = new AlkFormData($this, "task_min", $task_min, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->task_time          = new AlkFormData($this, "task_time", $this->task_hour->value.":".$this->task_min->value, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    $this->iTypeSheetRetour = AlkRequest::getToken("iTypeSheetRetour",  AlkRequest::_REQUEST("iTypeSheetRetour", $this->iTypeSheet));
    $this->iSheetRetour     = AlkRequest::getToken("iSheetRetour",      AlkRequest::_REQUEST("iSheetRetour", $this->iSheet));
    $this->iSSheetRetour    = AlkRequest::getToken("iSSheetRetour",     AlkRequest::_REQUEST("iSSheetRetour", ALK_SHEET_LIST));
    $this->paramRetour      = urldecode(AlkRequest::getToken("paramRetour", AlkRequest::_REQUEST("paramRetour", "&atype_id=".$atype_id)));
    
    $oDrData = null;
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $oDsData = $oQuery->getDs_ficheCronTaskById($task_id);
      if( !($oDrData = $oDsData->GetRowIter()) )
        $oDrData = null;
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
    
    $this->initData($iTypeInit, $oDrData, $reqMethod);
    
    if ( !is_null($oDrData) ) {
      $tabTime = explode(":", $this->task_time->value);
      $this->task_hour->value = $tabTime[0];
      $this->task_min->value = $tabTime[1];
    }
  }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    
    if ( $this->iMode != ALK_FORM_MODE_DEL ) {
      
      // récupère les jours de la semaine
      $task_jourssemaine = 0;
      if ( array_key_exists("Tous", $this->tabJoursSemaine) && in_array($this->tabJoursSemaine["Tous"], $this->task_jourssemaine->value) ) {
        $task_jourssemaine = $this->tabJoursSemaine["Tous"];
      } else {
        foreach ( $this->task_jourssemaine->value as $value ) {
          $task_jourssemaine+= $value;
        }
      }
      
      // récupère les jours du mois
      $task_joursmois = 0;
      if ( $this->bJoursMois ) {
        if ( array_key_exists("Tous", $this->tabJoursMois) && in_array($this->tabJoursMois["Tous"], $this->task_joursmois->value) ) {
          $task_joursmois = $this->tabJoursMois["Tous"];
        } else {
          foreach ( $this->task_joursmois->value as $value ) {
            $task_joursmois+= $value;
          }
        }
      }
      
      // récupère les mois
      $task_mois = 0;
      if ( $this->bMois ) {
        if ( array_key_exists("Tous", $this->tabMois) && in_array($this->tabMois["Tous"], $this->task_mois->value) ) {
          $task_mois = $this->tabMois["Tous"];
        } else {
          foreach ( $this->task_mois->value as $value ) {
            $task_mois+= $value;
          }
        }
      }
    }
    
    switch ( $this->iMode ) {
      case ALK_FORM_MODE_ADD :
        $this->oAppli->oQueryAction->addCronTask($this->cont_id->value, $this->atype_id->value, $this->appli_id->value, $this->action_id->value, 
                                                 $this->task_typetask->value, $this->task_date->value, $task_jourssemaine, $task_joursmois, $task_mois, 
                                                 $this->task_typetime->value, $this->task_hour->value.":".$this->task_min->value);
      break;
      case ALK_FORM_MODE_UPDATE :        
        $this->oAppli->oQueryAction->updateCronTask($this->task_id->value, $this->cont_id->value, $this->atype_id->value, $this->appli_id->value, $this->action_id->value, 
                                                    $this->task_typetask->value, $this->task_date->value, $task_jourssemaine, $task_joursmois, $task_mois, 
                                                    $this->task_typetime->value, $this->task_hour->value.":".$this->task_min->value);
      break;
      case ALK_FORM_MODE_DEL :
        $this->oAppli->oQueryAction->deleteCronTask($this->task_id->value);
      break;
    }
    
    return ALK_ALKANET."?token=".$this->oAppli->getToken($this->iTypeSheetRetour, $this->iSheetRetour, $this->iSSheetRetour, $this->paramRetour);
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformplanifform.js");
    
    $this->setData(ALK_INIT_MODE_DATAROW);
    
    switch ( $this->iMode ) {
      case ALK_FORM_MODE_ADD :
        $this->setLabel(_t("Ajout d'une nouvelle tâche planifiée"));
      break;
      case ALK_FORM_MODE_UPDATE :
        $this->setLabel(_t("Modification d'une tâche planifiée"));
      break;
    }
    
    $iWidthLabel = 180;
    $iWidthCtrl  = 390;
    
    //**************** block principal ********************
    // block principal
    $oBlock = $this->addBlock("block_main", "", "", $iWidthLabel, $iWidthCtrl);
    
    // controles cachés
    $oCtrlHidden = AlkHtmlFactory::getHtmlHidden($this->task_id);
    $oCtrlHidden->addDataHidden($this->atype_id);

    // controle de sélection de l'action
    $oCtrlAction = AlkHtmlFactory::getHtmlSelect($this->action_id, "Action");
    $strSql = "select ACTION_INTITULE, ACTION_ID from SIT_CRON_ACTION".( $this->atype_id->value != -1 ? " where ATYPE_ID=".$this->atype_id->value : "" );
    $DsAction = $this->oAppli->oQuery->getDs($strSql);
    $oCtrlAction->setProperty("oValTxt", $DsAction);
    $oCtrlAction->setProperty("tabValTxtDefault", array("-1", _t("Sélectionnez une action")));
    $oCtrlAction->addValidator(ALK_IS_REQUIRED+ALK_VERIF_SELECT, "-1");

    // controle de l'appli
    $oCtrlAppli = AlkHtmlFactory::getHtmlSelect($this->appli_id, "Application");
    $strSqlAppli = "select APPLI_INTITULE, sa.APPLI_ID from SIT_APPLI sa LEFT JOIN SIT_APPLI_CONT sac ON sa.APPLI_ID = sac.APPLI_ID ".( $this->atype_id->value != -1 ? " where ATYPE_ID=".$this->atype_id->value." and CONT_ID=".$this->cont_id->value : "" );
    $DsActionAppli = $this->oAppli->oQuery->getDs($strSqlAppli);
    $oCtrlAppli->setProperty("oValTxt", $DsActionAppli);
    $oCtrlAppli->setProperty("tabValTxtDefault", array("-1", _t("Sélectionnez une application")));
    $oCtrlAppli->addValidator(ALK_VERIF_SELECT, "-1");
    
    // controle de sélection du type de tâche (0 : périodique, 1 : ponctuelle)
    $oCtrlTypeTask = AlkHtmlFactory::getHtmlRadio($this->task_typetask, _t("Type de tâche"));
    $oCtrlTypeTask->addRadio("0", "Périodique");$oCtrlTypeTask->addEventToRadio("0", "onchange", "SwitchTypeTask()");
    $oCtrlTypeTask->addRadio("1", "Ponctuelle");$oCtrlTypeTask->addEventToRadio("1", "onchange", "SwitchTypeTask()");
    $oCtrlTypeTask->addValidator(ALK_IS_REQUIRED+ALK_VERIF_INT);
    
    // controle de saisi d'une date
    $oCtrlDate = AlkHtmlFactory::getHtmlDate($this->task_date, "Le");
    $oCtrlDate->addValidator(ALK_IS_REQUIRED+ALK_VERIF_DATE10);
    
    // controle de saisi du(des) jour(s) de la semaine
    $oCtrlJoursSemaine = AlkHtmlFactory::getHtmlCheckbox($this->task_jourssemaine, _t("Jours de la semaine"));
    foreach ( $this->tabJoursSemaine as $jour => $value ) {
      $oCtrlJoursSemaine->addCheckBox(($this->task_jourssemaine->value & $value), $jour, $value);
    }
    $oCtrlJoursSemaine->setItemsPerLine(4);
    $oCtrlJoursSemaine->addValidator(ALK_IS_REQUIRED+ALK_VERIF_CHECKGROUP);
    
    // controle de saisi du(des) jour(s) du mois
    $oCtrlJoursMois = null;
    if ( $this->bJoursMois ) {
      $oCtrlJoursMois = AlkHtmlFactory::getHtmlCheckbox($this->task_joursmois, _t("Jours du mois"));
      foreach ( $this->tabJoursMois as $jour => $value ) {
        $oCtrlJoursMois->addCheckBox(($this->task_joursmois->value & $value), $jour, $value);
      }
      $oCtrlJoursMois->setItemsPerLine(8);
      $oCtrlJoursMois->addValidator(ALK_VERIF_INT);
    }
    
    // controle de saisi du(des) mois
    $oCtrlMois = null;
    if ( $this->bMois ) {
      $oCtrlMois = AlkHtmlFactory::getHtmlCheckbox($this->task_mois, _t("Mois"));
      foreach ( $this->tabMois as $mois => $value ) {
        $oCtrlMois->addCheckBox(($this->task_mois->value & $value), $mois, $value);
      }
      $oCtrlMois->setItemsPerLine(4);
      $oCtrlMois->addValidator(ALK_VERIF_INT);
    }
    
    // controle de saisi du type d'heure (0 : Fréquence, 1 : Précis)
    $oCtrlTypeTime = AlkHtmlFactory::getHtmlRadio($this->task_typetime, _t("Type d'heure"));
    $oCtrlTypeTime->addRadio("0", _t("Fréquence"));$oCtrlTypeTime->addEventToRadio("0", "onchange", "switchLabelHour()");
    $oCtrlTypeTime->addRadio("1", _t("Fixe"));$oCtrlTypeTime->addEventToRadio("1", "onchange", "switchLabelHour()");
    $oCtrlTypeTime->addValidator(ALK_IS_REQUIRED+ALK_VERIF_INT);
    
    // controle de sélection des heures
    $oCtrlHeure = AlkHtmlFactory::getHtmlSelect($this->task_hour, "");
    $oCtrlHeure->setProperty("tabValTxt", $this->tabHour);
    $oCtrlHeure->setLabelAfter(" H");
    
    // controle de sélection des minutes
    $oCtrlMin = AlkHtmlFactory::getHtmlSelect($this->task_min, "");
    $oCtrlMin->setProperty("tabValTxt", $this->tabMin);
    $oCtrlMin->setLabelAfter(" Min");
    $oCtrlHeure->addCtrl($oCtrlMin);
    
    // ajout des controles au bloc principal
    $oBlock->addCtrl($oCtrlAction);
    $oBlock->addCtrl($oCtrlAppli);
    $oBlock->addCtrl($oCtrlTypeTask);
    $oBlock->addCtrl($oCtrlDate);
    $oBlock->addCtrl($oCtrlJoursSemaine);
    $oBlock->addCtrl($oCtrlJoursMois);
    $oBlock->addCtrl($oCtrlMois);
    $oBlock->addCtrl($oCtrlTypeTime);
    $oBlock->addCtrl($oCtrlHeure);
    //************** fin block principal ******************
    
    // bouton valider
    $strAction = ALK_ALKANET_SQL."?token=".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=".$this->iMode."&appli_id_task=".$this->appli_id->value.
                                                                                                                     "&iTypeSheetRetour=".$this->iTypeSheetRetour.
                                                                                                                     "&iSheetRetour=".$this->iSheetRetour.
                                                                                                                     "&iSSheetRetour=".$this->iSSheetRetour.
                                                                                                                     "&paramRetour=".urlencode($this->paramRetour)
    );
    $this->addValidButton(array(), $strAction);
    
    // bouton annuler
    $this->addCancelButton($this->iTypeSheetRetour, $this->iSheetRetour, $this->iSSheetRetour, $this->paramRetour);
    
    // appelle la fonction javascript qui affiche le block en fonction du type de tâche sélectionné
    $this->addOnload("SwitchTypeTask();");
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_08_planif_form.htm"); 
  }

}
?>