<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormParametreForm
 * Classe de gestion des paramètres pour une application
 */
class AlkHtmlFormParametreForm extends AlkHtmlForm
{
    /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
   
  protected $atype_id;
  protected $appli_id_espace;
  protected $oAppliEspace;
  protected $oQueryEspace;
  protected $appli_id;
   
  public function __construct(AlkAppli $oAppli, $oAppliEspace, $atype_id)
  {
    parent::__construct($oAppli, "formParametreForm"); 
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $strAction = "";
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
    $this->atype_id = $atype_id;
    $this->oAppliEspace = $oAppliEspace;
    $this->appli_id = $this->oAppli->appli_id;
  }
  
  protected function setData($iTypeInit) {
    
  }
  
  /**
   * Traitements Sql
   */
  public function doSql(){
    $this->setData(ALK_INIT_MODE_REQUEST);
    
    $appli_id_courant = AlkRequest::getToken("appli_id_courant", -1);
    $atype_id_courant = AlkRequest::getToken("atype_id_courant", -1);
    $cont_id_courant  = AlkRequest::getToken("cont_id_courant", -1);
    
    $this->oAppliEspace->oQueryAction->updateConstantes($_POST, $appli_id_courant, $cont_id_courant, $atype_id_courant);
    $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id_courant."&appli_id=".$appli_id_courant."&iTypeSheet=".$this->iTypeSheet.
                                            "&iSheet=".$this->iSheet."&iSSheet=".$this->iSSheet."&iMode=".$this->iMode);
    
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /*
   * Contenu du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_REQUEST+ALK_INIT_MODE_DATAROW);
    $user_id = AlkFactory::getSProperty("user_id", -1);
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformparametreform.js");
    $this->setLabel(_t("Gestion des paramètres"));
    
    $strDesc ="";
    $appli_id_courant = $this->oAppli->appli_id;
    $cont_id_courant  = $this->oAppli->cont_id;
    $tabConst = $this->oAppliEspace->oQuery->getTableauListeSitConstantes($this->atype_id, $appli_id_courant, $cont_id_courant);  

    if (count($tabConst) > 0){
      $oBlock = $this->addBlock("block_constantes", "", "", 300, 350);
      $CB = AlkHtmlFactory::getNewHtmlCheckbox($this,"0","sel", -1, _t("Sélectionner toutes les constantes"), 0);
      $CB->addEvent("onclick", "CheckAll(this,'".$this->getName()."')");
      $oBlock->addCtrl($CB);
    }

    $old_intitule = "";
    $i=0;
    $strTitle ="";
    
    foreach($tabConst as  $const_intitule => $tabValues ) {
      $i++;
      $const_valeur     = $tabValues["CONST_VALEUR"];
      $const_type       = $tabValues["CONST_TYPE"];
      $const_label      = $tabValues["CONST_LABEL"];
      $const_admin      = $tabValues["CONST_ADMIN"];
      $appli_id         = $tabValues["APPLI_ID"];
      $strTitle         = $tabValues["CONST_BLOC"];
      $cont_id          = $tabValues["CONT_ID"];

      if ($i==1){
        // on construit un bloc sans se poser de questions
        $oBlock = $this->addBlock("block_constantes".$i,
                                  ($strTitle !="" ? $strTitle : _t("Constantes génériques")), "", 300, 350);
        $old_intitule = $strTitle;
        
      }else {
        
        if ($strTitle != $old_intitule){
          // on a changé d'intitulé
          $oBlock = $this->addBlock("block_constantes".$i,  
                                  ($strTitle !="" ? $strTitle : _t("Constantes génériques")), "", 300, 350);
        }
      }
      
      if ($const_admin ==1){
        // modifiable uniquement par l'utilisateur ALKANTE
        $iModeRead = ( $user_id = ALK_USER_ID_ADMINALK ? "0" : "1");
      }else {
        // modifiable par l'animateur 
        $iModeRead = ( (AlkFactory::isSpaceAnim() || $user_id = ALK_USER_ID_ADMINALK) ? "0" : "1");
      }
    
      if ($user_id = ALK_USER_ID_ADMINALK){
        $strDesc = "<i>".$const_intitule." /".$const_admin."</i>";
      }else {
        $strDesc = "";
      }
      
      $iWidth = "7";
      $iMaxField = "4000";
      switch( $const_type ) {
      case "0": // string
      case "1": // int
      case "4":// expression php
       if ($const_type == "0" || $const_type == "4")
         $iWidth = "30";
       else if ($const_type == "0")
         $iMaxField ="4";
       $oCtrl = AlkHtmlFactory::getNewHtmlText($this, $iModeRead, $const_intitule, $const_valeur, "", 1, $iWidth, $iMaxField);
       break;
      case "2": // date
       $oCtrl = AlkHtmlFactory::getNewHtmlDate($this, $iModeRead, $const_intitule, $const_valeur, "");
        break;

      case "3": // bool
        $oCtrl = AlkHtmlFactory::getNewHtmlRadio($this, $iModeRead, $const_intitule, $const_valeur, "");
        $oCtrl->addRadio("true", "oui");
        $oCtrl->addRadio("false", "non");
        break;
      }
      
      $bChecked = ( ($appli_id_courant == $appli_id && $cont_id_courant == $cont_id) ? 1 : 0);
      $CB = AlkHtmlFactory::getNewHtmlCheckbox($this,"0","const_chk[]", $bChecked, $const_label, 1);
      $CB->addEvent("onclick", "disableField('".$this->getName()."', this,'".$const_intitule."')");
      $CB->addOnLoad("disableField('".$this->getName()."',this,'".$const_intitule."',".$bChecked.")");
      $oCtrl->setLabelAfter($strDesc);
      $CB->addCtrl($oCtrl);
      $oBlock->addCtrl($CB);
      
    }
    
    if (count($tabConst) == 0){
      $oBlock = $this->addBlock("block_constantes", "", "", 300, 350);
      $varCtrl2 = AlkHtmlFactory::getHtml("<div class='txtHelp' style='text-align:center;'> ".
                                               _t("Aucun paramètre administrable trouvé")."</div>");
      $oBlock->addCtrl($varCtrl2, ALK_HTMLFORM_1L1C);
    }
      
   
   if (count($tabConst) > 0){
      // boutons
      $strUrl = ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam("cont_id=1&appli_id=".$this->oAppliEspace->appli_id."&iTypeSheet=".$this->iTypeSheet.
                                           "&iSheet=".$this->iSheet."&iSSheet=".$this->iSSheet."&iMode=".$this->iMode.
                                           "&appli_id_courant=".$appli_id_courant."&atype_id_courant=".$this->oAppli->atype_id.
                                           "&cont_id_courant=".$cont_id_courant);
      $this->addValidButton(array(), $strUrl);
      
     // bouton annuler
     $this->addCancelButton($this->iTypeSheet, $this->iSheet, $this->iSSheet, "");
   } 

    
    
  }
}