<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Editeur
Module éditeur basé sur ckeditor.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmladapter.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."editeur/classes/ckeditor.php");

/**
 * @package Alkanet_Module_Editeur
 * @class AlkHtmlFormEditeurForm
 * Classe d'affichage de lediteur de formulaire
 */
class AlkHtmlFormEditeurForm extends AlkHtmlAdapter
{
  
  /** identifiant ou liste d'identifiant (séparateur pipe) caractérisant l'information concernée */
  protected $idEnt;

  /** nom de la table sql où est enregistré le contenu edit */
  protected $strTable;

  /** nom du champ sql recevant la donnée edit */
  protected $strChampHtml;

  /** nom du champ ou liste de nom de champ (séparateur pipe) correspondant à la clé primaire de strTable */
  protected $strChampId;

  /** chemin relatif du répertoire upload à partir de ALK_ALKANET_ROOT_[PATH|URL] */
  protected $strRepUpload;

  /** =0 par défaut, =1 si outil de formulaire */
  protected $iForm;

  /** =0 par défaut, =1 si reload de la page parente à la fermeture */
  protected $iReload;

  /** Type de toolbar affichée = normal =0, basique = 1 */
  protected $iBasicMenuBar;

  /** gcoedit : identifiant de l'appli chargée de faire les actions Pre et Post update bloc, =-1 par défaut */
  protected $post_appli_id;

  /** gcoedit : identifiant du bloc sur lequel se font les Pre et Post update bloc, =-1 par défaut */
  protected $bloc_id;

  /** ensemble des paramètres nécessaires à l'url de validation */
  protected $strParam;
  
  /** type de bloc **/
  protected $atypeIdBloc;

  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formEditeur");

    $this->idEnt         = AlkRequest::getToken("idEnt","-1");
    $this->strTable      = AlkRequest::getToken("table", "");
    $this->strChampHtml  = AlkRequest::getToken("champsHtml","");
    $this->strChampId    = AlkRequest::getToken("champsId", "");
    $this->strRepUpload  = AlkRequest::getToken("repUpload", "");
    $this->iReload       = AlkRequest::getToken("bReload",  0);
    $this->iForm         = AlkRequest::getToken("bForm", 0);
    $this->iBasicMenuBar = AlkRequest::getToken("bBasicMenuBar", 0);
    $this->post_appli_id = AlkRequest::getToken("post_appli_id", "-1");
    $this->bloc_id       = AlkRequest::getToken("bloc_id", "-1");
    $this->atypeIdBloc   = AlkRequest::getToken("atypeIdBloc", "-1");
    
    $this->strParam = "&applitype_id=".ALK_ATYPE_ID_EDITEUR.
      "&idEnt=".$this->idEnt."&table=".$this->strTable.
      "&champsHtml=".$this->strChampHtml."&champsId=".$this->strChampId.
      "&repUpload=".$this->strRepUpload."&bReload=".$this->iReload."&bForm=".$this->iForm.
      "&bBasicMenuBar=".$this->iBasicMenuBar.
      "&post_appli_id=".$this->post_appli_id."&bloc_id=".$this->bloc_id."&atypeIdBloc=".$this->atypeIdBloc;
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { } 

  /**
   * Traitement 
   */
  public function doSql() 
  { 
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    
    // pas d'encodate pour l'instant
    $strTextHtml = AlkRequest::_REQUEST("TextHtmlencode", "");
    // retire <p>..</p>
    $strTextHtml = mb_ereg_replace("<p>", "", $strTextHtml);
    $strTextHtml = mb_ereg_replace("</p>", "", $strTextHtml);
    /**
     * Récupération de la chaine de caractere encodée qui se trouve entre les 2 balises "|limite|" définies dans alkformediteurform.js
     */

    /**
     * décodage de la chaine encodée
     */
    $strTextHtml = AlkRequest::decodeValue($strTextHtml);
    
    /* cleanage tidy non nécessaire
    $oHtmlCleaner = AlkFactory::getHtmlCleaner();
    $oHtmlCleaner->cleanWithTidy($strTextHtml);*/

    $res = $this->oAppli->oQueryAction->updateContenu($this->idEnt, $this->strTable, 
                                                      $this->strChampHtml, $strTextHtml, $this->strChampId); 
    
    /** gcoedit */
    if( defined("ALK_B_ATYPE_GCOEDIT") && ALK_B_ATYPE_GCOEDIT==true && $this->post_appli_id != "-1" ) {
      $oAppliGCoEdit = AlkFactory::getAppli(ALK_ATYPE_ID_GCOEDIT, $this->post_appli_id);
      $oRes = null;

      $strScript = $oAppliGCoEdit->CallServicePreUpdateBloc($oRes, $this->bloc_id, $user_id, true); 
    }

    
    if ($this->iReload==3){
       // fermeture de la popup avec rechargement ajax
       $this->bloc_id       = AlkRequest::getToken("bloc_id", "-1");
       $this->atypeIdBloc   = AlkRequest::getToken("atypeIdBloc", "-1");
       
       $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&iMode=10&bloc_id=".$this->bloc_id."&atypeIdBloc=".$this->atypeIdBloc);
       $strHtmlJs = "top.updateDataBloc('".$strToken."');";
       echo getBodyOnLoadExec($strHtmlJs);
    }else {
       //code permettant de fermer la popup tout en rappelant la page située en dessous
       // petite astuce avec onload et onunload pour laisser le temps à la page de charger
       echo getBodyOnLoadExec("",
                           "closeWindow(".( $this->iReload ==1 ? "'reload'" : "" ).")");
    }
    
    return "";
  }

  /**
   * Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return "Editeur";
  }
  
  /**
   * Construction de la liste (soit boite de reception soit liste des envois)
   */
  public function setContents()
  {
    $strPathFolder = ALK_ALKANET_ROOT_PATH.$this->strRepUpload;
    
    $bRes = false;
    if( !(file_exists($strPathFolder) && is_dir($strPathFolder)) ) {
      $bRes = @mkdir($strPathFolder, 0770);
    }
    
    $iHeightIcones = 28;
    $iHeightIframe = 500;
    if( $this->iForm==1 ) {
      $iHeightIcones = 46;
      $iHeightIframe = 484;
    }
  
    $oHtmlCleaner = AlkFactory::getHtmlCleaner();
    $strContenu = $this->oAppli->oQuery->getContenu($this->idEnt, $this->strTable, $this->strChampHtml, $this->strChampId); 
    $oHtmlCleaner->getCleanHtml($strContenu, false);

    $tabEventBody = array("onload" => "gestionEvt(); window.focus();");
    $sBasePath = AlkFactory::getModuleUrl(ALK_ATYPE_ID_EDITEUR);

    if( !defined("ALK_CSS_DIR") ) define("ALK_CSS_DIR",  "");
    /* CKEditor */
    $editorName = "TextHtml";
    
    $oCKeditor = new CKEditor();
    $oCKeditor->basePath = $sBasePath."editor/";
    
    if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur_".AlkFactory::getSProperty("cont_id", "-1").".css")){
      $oCKeditor->config['contentsCss'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur_".AlkFactory::getSProperty("cont_id", "-1").".css";
    } elseif( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur.css") ){
      $oCKeditor->config['contentsCss'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur.css";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."editeur_".AlkFactory::getSProperty("cont_id", "-1").".css")){
      $oCKeditor->config['contentsCss'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."editeur_".AlkFactory::getSProperty("cont_id", "-1").".css";
    } elseif( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."editeur.css") ){
      $oCKeditor->config['contentsCss'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."editeur.css";
    } else {
      $oCKeditor->config['contentsCss'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/templates/editeur.css";
    }
    $oCKeditor->config['bodyId'] = ( defined("ALK_EDITEUR_BODYID") ? ALK_EDITEUR_BODYID : "" );
    //$oCKeditor->config['bodyClass'] = ( defined("ALK_EDITEUR_BODYCSS") ? ALK_EDITEUR_BODYCSS : "" );
    
    $oCKeditor->config['height'] = "330"; 
    $oCKeditor->config['AutoDetectLanguage'] = false;
    $oCKeditor->config['DefaultLanguage'] = "fr";
    //Lien vers les gestionnaire de fichiers
    if ( defined("ALK_B_EDITEUR_PDW_FILEBROWSER") && ALK_B_EDITEUR_PDW_FILEBROWSER==true ){ 
      $oCKeditor->config['filebrowserBrowseUrl'] = $sBasePath."editor/pdw_file_browser/index.php?editor=ckeditor&ServerPath=".ALK_VIRTUAL_DIR.$this->strRepUpload."&UrlRoot=".ALK_ROOT_URL;
    } else {
      $oCKeditor->config['filebrowserBrowseUrl'] = $sBasePath."editor/filemanager2/index.html?ServerPath=".ALK_VIRTUAL_DIR.$this->strRepUpload."&UrlRoot=".ALK_ROOT_URL;
    }
    
    if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $oCKeditor->config['templates_files'][] = ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD.ALK_CSS_DIR."/cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.ALK_CSS_DIR."/cktemplate.js")){
      $oCKeditor->config['templates_files'][] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/cktemplate.js";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $oCKeditor->config['templates_files'][] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."cktemplate.js")){
      $oCKeditor->config['templates_files'][] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."cktemplate.js";
    }else {
      $oCKeditor->config['templates_files'][] = ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/cktemplate.js";
    }
     
    if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $oCKeditor->config['stylesSet'] = "styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckstyle.js")){
      $oCKeditor->config['stylesSet'] = "styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckstyle.js";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $oCKeditor->config['stylesSet'] = "styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckstyle.js")){
      $oCKeditor->config['stylesSet'] = "styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckstyle.js";
    }else {
      $oCKeditor->config['stylesSet'] = "styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/ckstyle.js";
    }
    
    if( $this->iForm==1 ) {
      $oCKeditor->config['toolbar'] = "Formulaire";
      
      if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur_form_".AlkFactory::getSProperty("cont_id", "-1").".css")){
        $oCKeditor->config['contentsCss'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur_form_".AlkFactory::getSProperty("cont_id", "-1").".css";
      } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur_form.css")){
        $oCKeditor->config['contentsCss'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur_form.css";
      } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."editeur_form_".AlkFactory::getSProperty("cont_id", "-1").".css")){
        $oCKeditor->config['contentsCss'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."editeur_form_".AlkFactory::getSProperty("cont_id", "-1").".css";
      } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."editeur_form.css")){
        $oCKeditor->config['contentsCss'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."editeur_form.css";
      }else {
        $oCKeditor->config['contentsCss'] = $oCKeditor->config['contentsCss'];
      }
      
    } elseif( $this->iBasicMenuBar == 1 ) {
      $oCKeditor->config['toolbar'] = "Basic";
    } else {
      $oCKeditor->config['toolbar'] = "Full";
    }
    
    if($this->iForm==1 && file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig_form_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $oCKeditor->config['customConfig'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig_form_".AlkFactory::getSProperty("cont_id", "-1").".js";
    }elseif($this->iForm==1 && file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig_form.js")){
      $oCKeditor->config['customConfig'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig_form.js" ;
    } elseif($this->iForm==1 && file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckconfig_form_".AlkFactory::getSProperty("cont_id", "-1").".js")){
     $oCKeditor->config['customConfig'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckconfig_form_".AlkFactory::getSProperty("cont_id", "-1").".js";
    } elseif($this->iForm==1 && file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckconfig_form.js")){
      $oCKeditor->config['customConfig'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckconfig_form.js" ;
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js")){
     $oCKeditor->config['customConfig'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig.js")){
      $oCKeditor->config['customConfig'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig.js" ;
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js")){
     $oCKeditor->config['customConfig'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckconfig.js")){
      $oCKeditor->config['customConfig'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckconfig.js" ;
    } else {
      $oCKeditor->config['customConfig'] = ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/ckconfig.js" ;
    }
    
    ob_start();
    $oCKeditor->editor($editorName, $strContenu);

    $strHtmlCKEdit = ob_get_contents();
    ob_end_clean();

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, $this->strParam);
    
    $oBtValid = AlkHtmlFactory::getHtmlButtonPage("javascript:Validate('".$strToken."')", "Valider", "Valider");
    $oBtCancel = AlkHtmlFactory::getHtmlButtonPage("javascript:closeWindow()", "Fermer", "Fermer");     

    $strHtmlCKEdit = "<form name='".$this->name."' action='' method='post'>".
      "<input type=\"hidden\" name=\"".$editorName."encode\" value=\"\" />".
      $strHtmlCKEdit."<table align='center' width='100%' cellpadding='4'><tr>".
      "<td align='right'>".$oBtValid->getHtml()."</td>".
      "<td align='left'>".$oBtCancel->getHtml()."</td>".
      "</tr></table></form>"; 
    
    $oCtrlHtml = AlkHtmlFactory::getHtml($strHtmlCKEdit);
    
    $this->setComponent($oCtrlHtml, "getHtml");
    $this->addVarJs("ALK_B_EDITEUR_CKEDITOR", "true"); 
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/alkhtmlformediteurform.js");
    $this->addOnLoad("window.onresize = gestionEvt;");
  }
  
}
?>