<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Dico
Module fournissant les pages d'administration de dictionnaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH."classes/pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_Dico
 * 
 * @class AlkQueryDicoAction
 * @brief Ensemble des requetes actions de l'application Dico
 */
class AlkQueryDicoAction extends AlkQuery
{

  /**
   *  Constructeur
   */ 
  public function __construct(&$oDb)
  {
    parent::__construct($oDb);   
  }
   
  /**
   *  Destructeur par défaut
   */
  public function __destruct() { }

  /**
   * Retourne la partie affectation d'une requete update
   * 
   * @param tabValue Tableau contenant les infos (champ, valeur, type) de l'enregistrement
   * @return Retourne un string
   *
  public function _getPartUpdateSql($tabValue, $id)
  {
    $strSql = "";
    while( list($strField, $tabVal) = each($tabValue) ) {
      $idType = $tabVal[0];
      $strValue = $tabVal[1];
      if( $strValue!=ALK_FIELD_NOT_VIEW ) {
        
        switch ($idType){
        case TYPE_STRING : //string
          $strSql .= ", ".$strField."='".$this->dbConn->analyseSql($strValue)."'";
        	break;

        case TYPE_NUMBER : //number
          if( $strValue == "" ) 
            $strSql .= ", ".$strField."=null";
          else 
            $strSql .= ", ".$strField."=".str_replace(",", ".", $strValue);
        	break;

        case TYPE_DATE : //date
          if( $strValue == "" ) 
            $strSql .= ", ".$strField."=null";
          else 
            $strSql .= ", ".$strField."=".$this->dbConn->GetDateFormat("DD/MM/YYYY", "'".$strValue."'");
        	break;

        case TYPE_LISTE : //liste
          $tabDescSql = $tabVal[2];
          $this->deladd_listeJoin($tabDescSql, $strValue, $id);
        	break;

        case TYPE_SQL : //sql
          $strSql .= ", ".$strField."=".$strValue;
        	break;

        case TYPE_TEXT_LISTE : // texte liste
          $tabDescSql = $tabVal[2];
          $chpList = "";
          if (count($tabVal)>3) $chpList = $tabVal[3];
          $this->deladd_textJoin($tabDescSql, $strValue, $chpList, $id);
          break;
        }
      }
    }
    if( $strSql != "" )
      return substr($strSql, 1);
    return "";
  }*/
  
  /**
   * Retourne la partie affectation d'une requete insert
   * 
   * @param tabValue Tableau contenant les infos (champ, valeur, type) de l'enregistrement
   * @return Retourne un string
   *
  public function _getPartInsertSql($tabValue, $id)
  {
    $strListField = "";
    $strListValues = "";
    while( list($strField, $tabVal) = each($tabValue) ) {
      $idType = $tabVal[0];
      $strValue = $tabVal[1];
      if ($idType!=TYPE_SQL && $idType!=TYPE_LISTE) $strListField .= ", ".$strField;
      
      switch ($idType){
      case TYPE_STRING : //string
        $strListValues .= ",'".$this->dbConn->analyseSql($strValue)."'";
      	break;

      case TYPE_NUMBER : //number
        if( $strValue == "" ) 
          $strListValues .= ",null";
        else 
          $strListValues .= ",".str_replace(",", ".", $strValue);
      	break;

      case TYPE_DATE : //date
        if( $strValue == "" ) 
          $strListValues .= ",null";
        else 
          $strListValues .= ", ".$this->dbConn->GetDateFormat("DD/MM/YYYY", "'".$strValue."'");
      	break;

      case TYPE_LISTE : //liste
        $tabDescSql = $tabVal[2];
        $this->deladd_listeJoin($tabDescSql, $strValue, $id);
        break;

      case TYPE_TEXT_LISTE : // texte liste
        $tabDescSql = $tabVal[2];
        $chpList = "";
        if (count($tabVal)>3) $chpList = $tabVal[3];
        $this->deladd_textJoin($tabDescSql, $strValue, $chpList, $id);
      	break;
      }
    }
    if( $strListField != "" && $strListValues != "")
      return "(".substr($strListField, 1).") values (".substr($strListValues, 1).")";
    return "";
  }*/
  
  /**
   * Ajoute une fiche dans un dictionnaire
   * Retourne l'identifiant de la fiche créée
   *
   * @param dico         nom de la table dictionnaire
   * @param strFieldKey  nom du champ clé primaire
   * @param tabValue     Ensemble des valeurs de la table dictionnaire
   * @return int 
   */
  public function add_ficheDico($dico, $strFieldKey, $tabValue, $oldRang, $strFieldRank="ORDRE")
  {
    $id = $this->dbConn->getNextId($dico, $strFieldKey, "SEQ_".$dico);
    $tabValue[$strFieldKey] = array(ALK_SQL_NUMBER, $id);

    // gestion du rang
    if( $oldRang != "-1" ) {
      $iRang = $tabValue[$strFieldRank][1];
      $this->dbConn->updateRank($dico, $strFieldRank, $iRang, true, "");
    }

    $strSql = $this->getPartInsertSql($tabValue);
    $strSql = "insert into ".$dico." ".$strSql;

    $this->dbConn->executeSql($strSql);
    return $id;
  }

  /**
   * Modifie une fiche d'un dictionnaire
   *
   * @param dico         nom de la table dictionnaire
   * @param strFieldKey  nom du champ clé primaire
   * @param tabValue     Ensemble des valeurs de la table dictionnaire
   */
  public function update_ficheDico($dico, $strFieldKey, $id, $tabValue, $oldRang, $strFieldRank="ORDRE")
  {
    // gestion du rang
    if( $oldRang != "-1" ) {
      $iRang = $tabValue[$strFieldRank][1];
      if( $oldRang != $iRang ) {
        $this->dbConn->UpdateRank($dico, $strFieldRank, $oldRang, false, "");
        $this->dbConn->UpdateRank($dico, $strFieldRank, $iRang, true, "");
      }
    }

    $strSql = $this->getPartUpdateSql($tabValue);
    $strSql = "update ".$dico." set ".$strSql." where ".$strFieldKey."=".$id;
    //echo $strSql."<br>";
    $this->dbConn->executeSql($strSql);
  }

  /**
   * Supprime une fiche d'un dictionnaire
   * Retourne le résultat de l'opération : true pour ok, false pour ko
   *
   * @param dico         nom de la table dictionnaire
   * @param strFieldKey  nom du champ clé primaire
   * @param id           identifiant de la clé primaire
   * @return boolean
   */
  public function del_ficheDico($dico, $strFieldKey, $id)
  {

    $strSql = "delete from ".$dico." where ".$strFieldKey."=".$id;   
    return $this->dbConn->executeSql($strSql, false);
  }

  /**
   * Supprime un élément joint.
   * Retourne le résultat de l'opération : true pour ok, false pour ko
   * 
   * @param tabDesc  Paramétrage de la jointure
   * @param id       Identifiant de l'information jointe
   * @return boolean
   */
  public function del_listeJoin($tabDesc, $id)
  {
    $jointable = $tabDesc["jointable"];
    $fromtable = $tabDesc["fromtable"];
    $chpjoin   = $tabDesc["chpjoin"];
    $chpvar    = $tabDesc["chpvar"];
    $chpvalue  = $tabDesc["chpvalue"];
    
    $strSql = "delete from ".$jointable." where ".$chpvar."=".$id;
    
    return $this->dbConn->executeSql($strSql, true);
  }
  
  /**
   * Nettoie puis ajoute des éléments joints
   * Retourne le résultat de l'opération : true pour ok, false pour ko
   *
   * @param tabDesc  Paramétrage de la jointure
   * @param listeAdd Liste d'identifiants joints
   * @param id       Identifiant de l'information jointe
   * @return boolean
   */
  public function deladd_listeJoin($tabDesc, $listeAdd, $id)
  {
    $jointable = $tabDesc["jointable"];
    $fromtable = $tabDesc["fromtable"];
    $chpjoin   = $tabDesc["chpjoin"];
    $chpvar    = $tabDesc["chpvar"];
    $chpvalue  = $tabDesc["chpvalue"];
    
    if( is_string($listeAdd) ) 
      $listeAdd = explode(",", $listeAdd);
    $bReturn = true;
    if( $this->del_listeJoin($tabDesc, $id) ) {
      foreach($listeAdd as $idJoin) {
        $strSql = "insert into ".$jointable." (".$chpvar.", ".$chpjoin.") values (".$id.", ".$idJoin.")";
        $bReturn = $this->dbConn->executeSql($strSql, true);
      }
    } else {
      $bReturn = false;
    }

    return $bReturn;
  }
  
  /**
   * Nettoie puis ajoute des éléments joints
   * Retourne le résultat de l'opération : true pour ok, false pour ko
   *
   * @param tabDesc  Paramétrage de la jointure
   * @param listeAdd Liste d'identifiants joints
   * @param chpList  Liste des champs
   * @param id       Identifiant de l'information jointe
   * @return boolean
   */
  public function del_textJoin($tabDesc, $listeAdd, $chpList, $id)
  {
    $jointable = $tabDesc["jointable"];
    $fromtable = $tabDesc["fromtable"];
    $chpjoin   = $tabDesc["chpjoin"];
    $chpvar    = $tabDesc["chpvar"];
    $chpvalue  = $tabDesc["chpvalue"];
    
    if( is_string($listeAdd) ) 
      $listeAdd = explode(",", $listeAdd);
    if( is_string($chpList) ) 
      $chpList = explode(",", $chpList);

    $iId = -1;
    $iJoin = -1;
    foreach($chpList as $iChamp=>$champ) {
      if( preg_match("!_ID$!", strtoupper($champ)) ) {
        if( strtoupper($champ)!=$chpvar && $iId==-1 ) {
          $iId = $iChamp;
        } elseif (strtoupper($champ)==$chpvar) {
          $iJoin = $iChamp;
        }
      }
    }
    $strDel = "";
    foreach($listeAdd as $strDesc) {
      $tabDesc = explode(",", $strDesc);
      if ($iId>-1 && $tabDesc[$iId]!=-1) 
        $strDel .= ($strDel!="" ? "," : "").$tabDesc[$iId];
    }

    $strSql = "delete from ".$fromtable." where ".$chpvar."=".$id.
      " and ".($strDel=="" ? "1=1" : "IF(".$chpList[$iId]." in (".$strDel."), 0, 1)");
    return $this->dbConn->ExecuteSql($strSql, true);
  }
  
  /**
   * Nettoie puis ajoute des éléments joints
   *
   * @param tabDesc  Paramétrage de la jointure
   * @param listeAdd Liste d'identifiants joints
   * @param chpList  Liste des champs
   * @param id       Identifiant de l'information jointe
   * @return Retourne un booléen
   */
  public function deladd_textJoin($tabDesc, $listeAdd, $chpList, $id)
  {
    $jointable = $tabDesc["jointable"];
    $fromtable = $tabDesc["fromtable"];
    $chpjoin   = $tabDesc["chpjoin"];
    $chpvar    = $tabDesc["chpvar"];
    $chpvalue  = $tabDesc["chpvalue"];
    
    if( is_string($listeAdd) ) 
      $listeAdd = explode(",", $listeAdd);
    if( is_string($chpList) ) 
      $chpList = explode(",", $chpList);

    $iId = -1;
    $iJoin = -1;
    foreach ($chpList as $iChamp=>$champ) {
      if( preg_match("!_ID$!", strtoupper($champ)) ) {
        if (strtoupper($champ)!=$chpvar && $iId==-1)
          $iId = $iChamp;
        else if (strtoupper($champ)==$chpvar)
          $iJoin = $iChamp;
      }
    }
    $strDel = "";
    foreach($listeAdd as $strDesc) {
      $tabDesc = explode(",", $strDesc);
      if ($iId>-1 && $tabDesc[$iId]!=-1) $strDel .= ($strDel!="" ? "," : "").$tabDesc[$iId];
    }
    $bReturn = true;
    $strSql = "delete from ".$fromtable." where ".$chpvar."=".$id.
      " and ".($strDel=="" ? "1=1" : "IF(".$chpList[$iId]." in (".$strDel."), 0, 1)");
    $bReturn = $this->dbConn->ExecuteSql($strSql, true);
    if( $bReturn ) {
      foreach ($listeAdd as $strDesc) {
        $tabDesc = explode(",", $strDesc);
        if ($iId>-1 && $tabDesc[$iId]!=-1){
          $strSet = "";
          $strWhere = "";
          foreach ($tabDesc as $iChamp=>$value){
            $strAffect = $chpList[$iChamp]."=";
            if (is_string($value))
              $strAffect .= "'".$this->dbConn->AnalyseSql($value)."'";
            else 
              $strAffect .= $value;
            if ($iChamp==$iId || $iChamp==$iJoin)
              $strWhere .= ($strWhere!="" ? " and " : "").$strAffect;
            else 
              $strSet .= ($strSet!="" ? ", " : "").$strAffect;
          }
          if ($strSet!="" && $strWhere!=""){
            $strSql = "update ".$fromtable." set ".$strSet." where ".$strWhere;
            $bReturn = $this->dbConn->ExecuteSql($strSql, true);
            if (!$bReturn) break;
          }
        } else {
          $strChamps = "";
          $strValues = "";
          foreach ($tabDesc as $iChamp=>$value){
            if ($iChamp==$iId)
              $value = $this->dbConn->GetNextId($fromtable, $chpList[$iChamp], "SEQ_".$fromtable);
            $strChamps .= ($strChamps!="" ? "," : "").$chpList[$iChamp];
            if (is_string($value))
              $strValues .= ($strValues!="" ? ", " : "")."'".$this->dbConn->AnalyseSql($value)."'";
            else 
              $strValues .= ($strValues!="" ? ", " : "").$value;
          }
          if ($strChamps!="" && $strValues!=""){
            $strSql = "insert into ".$fromtable." (".$strChamps.") values (".$strValues.")";
            $bReturn = $this->dbConn->ExecuteSql($strSql, true);
            if (!$bReturn) break;
          }
        }
      }
    } 
    return $bReturn;        
  }
	
}
?>