<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_Crbn_cat
 * @class AlkQueryCrbn_catAction
 * 
 * Ensemble des requetes actions de l'application
 */
class AlkQueryCrbn_catAction extends AlkQuery
{
  /**
   * Constructeur par défaut
   * 
   * @param dbConn     Classe de connection à la base
   */ 
  public function __construct(&$dbConn)
  {
    parent::__construct($dbConn);
  }

  /**
   * Ajoute une donnée. Retourne son identifiant
   *
   * @param tabQuery tableau contenant l'ensemble des champs utilisés par la requête
   * @return Retourne un entier
   */
  function add_data($tabQuery)
  {
    $tabValue = $tabQuery["field"];
    $tabValue["CHAMP_ID"][1] = $this->dbConn->getNextId("NOM_TABLE", "CHAMP_ID", "SEQ_NOM_TABLE");

    $strSql = "insert into NOM_TABLE ".$this->getPartInsertSql($tabValue);
    $this->dbConn->ExecuteSql($strSql);
    
    return $tabValue["CHAMP_ID"][1];
  }
  
  /**
   * Modifie une donnée
   */
  function update_data($tabQuery, $strTable)
  {
    $tabValue = $tabQuery["field"];   
    $strSql = "delete from ".$strTable.";";
    $strSql.= " insert into ".$strTable." ".$this->getPartInsertSql($tabValue).";";

    $this->dbConn->ExecuteSql($strSql);
  }
  
  function addCommanditaireId($etude_id, $serv_id){
    
    $strSql = " insert into etude_commanditaires (service_id, etude_id) VALUES (".$serv_id.", ".$etude_id.")";
    $this->dbConn->ExecuteSql($strSql);
  }

  function addPartenaireId($etude_id, $serv_id){
    $strSql = " insert into etude_partenaire (service_id, etude_id) VALUES (".$serv_id.", ".$etude_id.")";
    $this->dbConn->ExecuteSql($strSql);
  }  

  /**
   * Suppime une pj
   */
  function del_pj_by_etudeId($etude_id, $strCheminImage)
  {

    $this->DelPjByDataId("ETUDE_PJ", $etude_id, ALK_ALKANET_ROOT_PATH, $strCheminImage, "", true);
       
    //$strSql =  "DELETE from etude_pj where data_id = ".$etude_id;
    //$this->dbConn->ExecuteSql($strUpdate);
  }

  function action_data_on_Post($_POST, $strTableName)
  {   
    $strUpdate = "";
    foreach($_POST as $key => $val){
      if($key != "btValid"){
        $strUpdate.= "UPDATE etude_activation_champ SET etude_activation_champ_statut=".$val." where etude_activation_champ_champ ='".$key."';";
      }       
    } 
    $this->dbConn->ExecuteSql($strUpdate);    
  }
  
    /**
   *  retourne une chaine correspondant au login d'une chaine (inspire du getlogin de l'anuaire)
   *
   * @param strNom     nom d'une personne
   * @param strPrenom  -> vide
   * @return Retourne un string
   */
  public function getLogin($strNom, $strPrenom)
  {
    $iLgPrenom = 1;
    $iLgNom = 13-$iLgPrenom;
    
    $strTmpNom = trim(mb_strtolower($strNom));
    $strTmpPrenom = trim(mb_strtolower($strPrenom));
  
    // enleve les accents
    $strTmpNom = strtr($strTmpNom, "éèêëäàâüùûîïôöç", "eeeeaaauuuiiooc");
    $strTmpPrenom = strtr($strTmpPrenom, "éèêëäàâüùûîïôöç", "eeeeaaauuuiiooc");
  
    // enleve les caractères non compris entre a et z.
    $strTmpNom2 = "";
    for($i=0; $i<mb_strlen($strTmpNom); $i++) {
      $cCar = mb_substr($strTmpNom, $i, 1);
      if( ord($cCar)>=ord("0") && ord($cCar)<=ord("z") )
        $strTmpNom2 .= $cCar;
    }
  
    $strTmpPrenom2 = "";
    for($i=0; $i<mb_strlen($strTmpPrenom); $i++) {
      $cCar = mb_substr($strTmpPrenom, $i, 1);
      if( ord($cCar)>=ord("0") && ord($cCar)<=ord("z") )
        $strTmpPrenom2 .= $cCar;
    }
  
    $strLogin = mb_substr($strTmpPrenom2, 0, $iLgPrenom).mb_substr($strTmpNom2, 0, $iLgNom);
  
    return $strLogin;
  }
  
  
  
  function add_data_champ_sup($tabQuery)
  {
    $tabValue = $tabQuery["field"];
    $strSql= "insert into etude_champ (etude_champ_nom, etude_champ_desc) VALUES ('".$this->dbConn->analyseSql($tabValue["ETUDE_CHAMP_NOM"][1])."','".$this->dbConn->analyseSql($tabValue["ETUDE_CHAMP_DESC"][1])."');";   
    $strSql.= "insert into etude_activation_champ (etude_activation_champ_champ, etude_activation_champ_statut) VALUES ('".$this->dbConn->analyseSql($tabValue["ETUDE_CHAMP_NOM"][1])."',0);";
    
    $bReturn = true;  
    $bReturn = $this->dbConn->executeSql($strSql, true);
    return $bReturn;
  }
  
   function update_data_champ_sup($tabQuery, $etude_champ_nom_old)
  {
    $tabValue = $tabQuery["field"];
    $strSql= "update etude_champ SET etude_champ_desc = '".$this->dbConn->analyseSql($tabValue["ETUDE_CHAMP_DESC"][1])."' where etude_champ_nom ='".$etude_champ_nom_old."';";         
    $this->dbConn->executeSql($strSql, true);
  } 

   function delete_data_champ_sup($tabQuery, $etude_champ_nom_old)
  {
    $tabValue = $tabQuery["field"];
    
    $strSql= "DELETE from etude_activation_champ where etude_activation_champ_champ ='".$this->dbConn->analyseSql($etude_champ_nom_old)."';";   
    $strSql.= "DELETE from etude_champ  where etude_champ_nom ='".$this->dbConn->analyseSql($etude_champ_nom_old)."';";   

    $this->dbConn->ExecuteSql($strSql);   

  }
  
  function updateStatut($etude_id, $statut_id)
  {
    $strSql= "update etude SET etude_statut = ".$statut_id." where etude_id =".$etude_id;
    $this->dbConn->executeSql($strSql, true);
  }
  
  function updateEtudeXml($etude_id, $strXml)
  {
    $strSql= "update etude SET etude_xml = '".$this->dbConn->analyseSql($strXml)."' where etude_id =".$etude_id;
    $this->dbConn->executeSql($strSql);
  }
  
  function updateEtudeContact($etude_id, $contact_id)
  {
    $strSql= "update etude SET etude_contact_service_id = ".$contact_id." where etude_id =".$etude_id;
    $this->dbConn->executeSql($strSql, true);
  }
  
  
  function updateNbConsult($etude_id, $nbConsult, $updateNbConsult)
  {
    $strSql= "update etude SET ".$updateNbConsult." = ".$nbConsult." where etude_id =".$etude_id;

    $this->dbConn->executeSql($strSql, true);
  }
  
  function updateCaractereRegion($etude_id, $valBoolIsRegion){
    $strSql= "update etude SET etude_b_region = ".$valBoolIsRegion." where etude_id =".$etude_id;
    $this->dbConn->executeSql($strSql, true);
  }  
  
  /**
   * Modifie une etude
   */
  function updateEtude($tabQuery, $agent_id, $etude_id)
  {
    $tabData = $tabQuery;

    $strSql =  " update etude SET ".
    "etude_intitule = '".$this->dbConn->AnalyseSql($tabData["ETUDE_INTITULE"][1])."',".   
    "etude_auteurs = '".$this->dbConn->AnalyseSql($tabData["ETUDE_AUTEURS"][1])."',".
    "etude_redacteurs = '".$this->dbConn->AnalyseSql($tabData["ETUDE_REDACTEURS"][1])."',".
    "etude_resume =   '".$this->dbConn->AnalyseSql($tabData["ETUDE_RESUME"][1])."',".
    "etude_mots_cles =  '".(array_key_exists("ETUDE_MOTS_CLES", $tabData) ? $this->dbConn->AnalyseSql($tabData["ETUDE_MOTS_CLES"][1]) : "") ."',".
    "etude_desc_nb_fascicules = ".$tabData["ETUDE_DESC_NB_FASCICULES"][1].",".
    "etude_desc_nb_pages =".$tabData["ETUDE_DESC_NB_PAGES"][1].",".
    "etude_cout =  ".(array_key_exists("ETUDE_COUT", $tabData) && $tabData["ETUDE_COUT"][1]!="" ? $tabData["ETUDE_COUT"][1] : "0").",".
    "etude_prod_periode = '".(array_key_exists("ETUDE_PROD_PERIODE", $tabData) ? $this->dbConn->AnalyseSql($tabData["ETUDE_PROD_PERIODE"][1]): "") ."',".
    "etude_annee_achevement = ".$tabData["ETUDE_ANNEE_ACHEVEMENT"][1].",".
    "etude_annee_maj = ".(array_key_exists("ETUDE_ANNEE_MAJ", $tabData) && $tabData["ETUDE_ANNEE_MAJ"][1]!="" ? $tabData["ETUDE_ANNEE_MAJ"][1] : "null").",".
    "etude_date_publication = ".(array_key_exists("ETUDE_DATE_PUBLICATION", $tabData) ? $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$tabData["ETUDE_DATE_PUBLICATION"][1]."'", true) : "now()") . ",".
    "etude_cote = '".(array_key_exists("ETUDE_COTE", $tabData) ? $this->dbConn->AnalyseSql($tabData["ETUDE_COTE"][1]) : "") ."',".
    "etude_isrn =  '".(array_key_exists("ETUDE_ISRN", $tabData) ? $this->dbConn->AnalyseSql($tabData["ETUDE_ISRN"][1]) : "") ."',".
    "etude_redacteur = '".$this->dbConn->AnalyseSql($tabData["ETUDE_REDACTEUR"][1])."',".
    "etude_agent_id = ".$agent_id.",".
    ($tabData["ETUDE_CONTACT_SERVICE_ID"][1] != -2 ? "etude_contact_service_id = ".$tabData["ETUDE_CONTACT_SERVICE_ID"][1]."," : "").
    "etude_perimetre_principal_intitule = '".$this->dbConn->AnalyseSql($tabData["ETUDE_PERIMETRE_PRINCIPAL_INTITULE"][1])."',".
    "etude_perimetre_secondaire_intitule = '".(array_key_exists("ETUDE_PERIMETRE_SECONDAIRE_INTITULE", $tabData) ? $this->dbConn->AnalyseSql($tabData["ETUDE_PERIMETRE_SECONDAIRE_INTITULE"][1]): "")."',".
    "etude_url =  '".(array_key_exists("ETUDE_URL", $tabData) ? $this->dbConn->AnalyseSql($tabData["ETUDE_URL"][1]) : "") ."',".    
    "etude_date_maj =now(),".
//    "etude_nb_consult = 0,".
//    "etude_nb_telechargement = 0,".
//    "etude_perimetre_principal_geom = null,".
    "etude_droit = ".$tabData["ETUDE_DROIT"][1]."".
    " WHERE etude_id =".$etude_id;

    $this->dbConn->ExecuteSql($strSql);
    
    
  }
  
  /**
   *  met à jour la geometry de l'étude par "union" des geometry correspondant aux codes insee de commune
   *
   * @param $the_geom_union : geomtry union des commune selectionnees
   * @param $etude_id  : id de l'etude
   * 
   */

  function updateTheGeomByEtudeId($the_geom_union, $etude_id, $bUnionAvecPrecedent=false){
    
  	 if($bUnionAvecPrecedent){
	     $strSql =  " update etude SET ".
	        " etude_perimetre_principal_geom = public.st_buffer(public.st_collect(etude_perimetre_principal_geom, '".$the_geom_union."'), 0)".
	        " WHERE etude_id =".$etude_id;
  	 }else{
  	 	 $strSql =  " update etude SET ".
          " etude_perimetre_principal_geom = ".($the_geom_union=="" ? "null" : "'".$the_geom_union."'").
          " WHERE etude_id =".$etude_id;
  	 } 
     $this->dbConn->ExecuteSql($strSql);
     $strSql = "select etude_perimetre_principal_geom from etude where etude_id =".$etude_id;
     $dsGeom = $this->dbConn->initDataset($strSql);
     $geom = "";
     while ($drGeom = $dsGeom->getRowIter()){
     	$geom = $drGeom->getValueName("etude_perimetre_principal_geom");
     }
     return $geom;
     
  }
  
  /**
   * ajout d'une étued
   * @param $tabData tableau de paramètres
   * @return unknown_type
   */
  function addEtude($tabData, $agent_id, $serv_id_new_contact=-1){
  	//sequence
  	$etude_id = $this->dbConn->getNextId("ETUDE", "ETUDE_ID", "SEQ_ETUDE");
  	$strSql=  "insert into etude (etude_id, 
																	etude_intitule,
																	etude_statut,
																	etude_auteurs,
																	etude_redacteurs,
																	etude_resume,
																	etude_mots_cles,
																	etude_desc_nb_fascicules,
																	etude_desc_nb_pages,
																	etude_cout,
																	etude_prod_periode,
																	etude_annee_achevement,
																	etude_annee_maj,
																	etude_date_publication,
																	etude_cote,
																	etude_isrn,
																	etude_url,
																	etude_redacteur,
																	etude_agent_id,
																	etude_contact_service_id,
																	etude_perimetre_principal_intitule,
																	etude_perimetre_secondaire_intitule,
																	etude_date_maj,
																	etude_nb_consult,
																	etude_nb_telechargement,
																	etude_perimetre_principal_geom,
																	etude_droit)values 
															    (".
															    $etude_id.",".
															    "'".$this->dbConn->AnalyseSql($tabData["etude_intitule"])."',".
															    "0,".
															    "'".$this->dbConn->AnalyseSql($tabData["etude_auteurs"])."',".
															    "'".(array_key_exists("etude_redacteurs", $tabData) ? $this->dbConn->AnalyseSql($tabData["etude_redacteurs"]): "") ."',".         
															    "'".$this->dbConn->AnalyseSql($tabData["etude_resume"])."',".
															    "'".(array_key_exists("etude_mots_cles", $tabData) ? $this->dbConn->AnalyseSql($tabData["etude_mots_cles"]) : "") ."',".
															    $tabData["etude_desc_nb_fascicules"].",".
															    $tabData["etude_desc_nb_pages"].",".
															    (array_key_exists("etude_cout", $tabData) ? $tabData["etude_cout"]: "null").",".
															    "'".(array_key_exists("etude_prod_periode", $tabData) ? $this->dbConn->AnalyseSql($tabData["etude_prod_periode"]): "") ."',".
															    $tabData["etude_annee_achevement"].",".
															    (array_key_exists("etude_annee_maj", $tabData) && $tabData["etude_annee_maj"]!="" ? $tabData["etude_annee_maj"] : "null").",".
															    (array_key_exists("etude_date_publication", $tabData) ? "to_timestamp('".$tabData["etude_date_publication"]."', 'DD/MM/YYYY')" : "now()") . ",".
															    //(array_key_exists("etude_date_publication", $tabData) ? $this->dbConn->getDateFormat("DD/MM/YYYY", $tabData["etude_date_publication"], true) : "now()") . ",".
															    "'".(array_key_exists("etude_cote", $tabData) ? $this->dbConn->AnalyseSql($tabData["etude_cote"]) : "") ."',".
															    "'".(array_key_exists("etude_isrn", $tabData) ? $this->dbConn->AnalyseSql($tabData["etude_isrn"]) : "") ."',".
															    "'".(array_key_exists("etude_url", $tabData) ? $this->dbConn->AnalyseSql($tabData["etude_url"]) : "") ."',".
															    "'".(array_key_exists("etude_redacteur", $tabData) ? $this->dbConn->AnalyseSql($tabData["etude_redacteur"]) : "")."',".
															    $agent_id.",".
															    ($tabData["etude_contact_service_id"] != -2 ? $tabData["etude_contact_service_id"] : $serv_id_new_contact).",".
															    "'".$this->dbConn->AnalyseSql($tabData["etude_perimetre_principal_intitule"])."',".
                                  "'".(array_key_exists("etude_perimetre_secondaire_intitule", $tabData) ? $this->dbConn->AnalyseSql($tabData["etude_perimetre_secondaire_intitule"]): "")."',".
                                  "now(),".
                                  "0,".
                                  "0,".
                                  "null,".
                                  $tabData["etude_droit"].")";

  	$this->dbConn->ExecuteSql($strSql);  
    return $etude_id;
  	
  }
  /**
   * ajoute la liaison commanditaire / etude
   * @param $tabCommanditaireService_id
   * @param $etude_id
   * @param $serviceExcept : service pas pris en compte (ex Autres)
   * @return unknown_type
   */
  function addEtudeCommanditaire($tabCommanditaireService_id, $etude_id, $serviceExcept=""){
  	$strSql="";
  	foreach($tabCommanditaireService_id as $key => $value){
  		if($value != $serviceExcept){
  	    $strSql.="insert into etude_commanditaires (etude_id, service_id) values (".$etude_id.",".$value.");";
  		}
    }
  	if($strSql!="")
      $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * supprime la liaison commanditaire / etude
   * @param $etude_id
   * @return unknown_type
   */
  function delEtudeCommanditaire($etude_id){
    $strSql="";
    $strSql.="delete from etude_commanditaires where etude_id =".$etude_id;
    $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * ajoute la liaison commanditaire / etude
   * @param $tabPartenaireService_id
   * @param $etude_id
   * @param $serviceExcept : service pas pris en compte (ex Autres)
   * @return unknown_type
   */
  function addEtudePartenaires($tabPartenaireService_id, $etude_id, $TabExcept=array()){
    $strSql="";
    foreach($tabPartenaireService_id as $key => $value){
      if(!in_array($value, $TabExcept)){
        $strSql.="insert into etude_partenaire (etude_id, service_id) values (".$etude_id.",".$value.");";
      }
    }
    if($strSql!="")
      $this->dbConn->ExecuteSql($strSql);
  }

  /**
   * supprime la liaison partenaire / etude
   * @param $etude_id
   * @return unknown_type
   */
  function delEtudePartenaire($etude_id){
    $strSql="";
    $strSql.="delete from etude_partenaire where etude_id =".$etude_id;
    $this->dbConn->ExecuteSql($strSql);
  }
    
 
  /**
   * ajoute la liaison commanditaire / etude
   * @param $tabPartenaireService_id
   * @param $etude_id
   * @return unknown_type
   */
  function addEtudeThematique($tabTheme, $etude_id, $etude_thematique_type=1){
    $strSql="";
    foreach($tabTheme as $key => $value){
      $strSql.="insert into etude_thematique (etude_id, thematique_id, sous_thematique_id, etude_thematique_type) values (".$etude_id.",".$value.", null, ".$etude_thematique_type.");";
    }
    if($strSql!="")
      $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * ajoute la liaison thematique / etude à partir de la liste concatene theme/ss -theme
   * @param $tabPartenaireService_id
   * @param $etude_id
   * @return unknown_type
   */
  function addEtudeThematiqueConcat($tabTheme, $etude_id, $etude_thematique_type=1){
    $strSql="";
    foreach($tabTheme as $key => $theme){
      
      $tabTh = explode("/", $theme);

     if(isset($tabTh[1]) && $tabTh[1] == -1){
        $tabTh[1] = 'null';
      }
      $strSql.="insert into etude_thematique (etude_id, thematique_id, sous_thematique_id, etude_thematique_type) values (".$etude_id.",".$tabTh[0].", ".$tabTh[1].", ".$etude_thematique_type.");";
    }
    if($strSql!="")
      $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * supprime la liaison thematique / etude
   * @param $etude_thematique_type
   * @param $etude_id
   * @return unknown_type
   */
  function delEtudeThematique($etude_id, $etude_thematique_type){
    $strSql="";
    $strSql.="delete from etude_thematique where etude_id =".$etude_id. "and etude_thematique_type = ".$etude_thematique_type;
    $this->dbConn->ExecuteSql($strSql);
  }
  
  
  /**
   * ajoute la liaison iconographie / etude
   * @param $tabPartenaireService_id
   * @param $etude_id
   * @return unknown_type
   */
  function addIconographie($tabIconographie, $etude_id){
    $strSql="";
    foreach($tabIconographie as $key => $value){
    	if($value!="-1")
        $strSql.="insert into etude_iconographie (etude_id, iconographie_id) values (".$etude_id.",".$value.");";
    }
    if($strSql!="")
      $this->dbConn->ExecuteSql($strSql);  
  }
  
  /**
   * supprime la liaison icono / etude
   * @param $etude_id
   * @return unknown_type
   */
  function delEtudeIconographie($etude_id){
    $strSql="";
    $strSql.="delete from etude_iconographie where etude_id =".$etude_id;
    $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * ajoute la liaison document type / etude
   * @param $tabPartenaireService_id
   * @param $etude_id
   * @return unknown_type
   */
  function addDocumentType($tabDocumentType, $etude_id){
    $strSql="";
    foreach($tabDocumentType as $key => $value){
    	if($value!="-1")
        $strSql.="insert into etude_document_type (etude_id, document_type_id) values (".$etude_id.",".$value.");";
    }
    if($strSql!="")
      $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * supprime la liaison type doc / etude
   * @param $etude_id
   * @return unknown_type
   */
  function delEtudeDocumentType($etude_id){
    $strSql="";
    $strSql.="delete from etude_document_type where etude_id =".$etude_id;
    $this->dbConn->ExecuteSql($strSql);
  }
  
  
  /**
   * ajoute la liaison typologie / etude
   * @param $tabPartenaireService_id
   * @param $etude_id
   * @return unknown_type
   */
  function addTypologie($tabTypologie, $etude_id){
    $strSql="";
    foreach($tabTypologie as $key => $value){
      $strSql.="insert into etude_typologie (etude_id, typologie_id) values (".$etude_id.",".$value.");";
    }
    if($strSql!="")
      $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * supprime la liaison typologie / etude
   * @param $etude_id
   * @return unknown_type
   */
  function delEtudeTypologie($etude_id){
    $strSql="";
    $strSql.="delete from etude_typologie where etude_id =".$etude_id;
    $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * ajoute la liaison methodologie / etude
   * @param $tabPartenaireService_id
   * @param $etude_id
   * @return unknown_type
   */
  function addMethodologie($tabMethodologie, $etude_id){
    $strSql="";
    foreach($tabMethodologie as $key => $value){
    	 if($value!="-1")
         $strSql.="insert into etude_methodologie (etude_id, methodologie_id) values (".$etude_id.",".$value.");";
    }
    if($strSql!="")
      $this->dbConn->ExecuteSql($strSql);  
  }
  /**
   * suppression en cascade de tous les enregistrements liés à l'étude
   * @param $etude_id
   * @return unknown_type
   */
  function delEtude($etude_id){
  	
  	$strSql = "";
  	$strSql.="delete from etude_methodologie where etude_id=".$etude_id.";";
  	$strSql.="delete from etude_typologie where etude_id=".$etude_id.";";
  	$strSql.="delete from etude_iconographie where etude_id=".$etude_id.";";
  	$strSql.="delete from etude_thematique where etude_id=".$etude_id.";";
  	$strSql.="delete from etude_partenaire where etude_id=".$etude_id.";";
  	$strSql.="delete from etude_commanditaires where etude_id=".$etude_id.";";
  	$strSql.="delete from etude_champ_supplementaire where etude_id=".$etude_id.";";
  	//TODO vérifier l'import de ce champ : etude_document_type
  	$strSql.="delete from etude_document_type where etude_id=".$etude_id.";";
  	$strSql.="delete from etude_pj where data_id=".$etude_id.";";
  	$strSql.="delete from etude where etude_id=".$etude_id.";";
  	$this->dbConn->ExecuteSql($strSql); 
  }
  
   /**
   * supprime la liaison methodologie / etude
   * @param $etude_id
   * @return unknown_type
   */
  function delEtudeMethodologie($etude_id){
    $strSql="";
    $strSql.="delete from etude_methodologie where etude_id =".$etude_id;
    $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * supprime la liaison methodologie / etude
   * @param $etude_id
   * @return unknown_type
   */
  function insertEtudeChpSupplementaire($etude_id, $valeur, $nomChp){
    $strSql="";
    $strSql.="insert into etude_champ_supplementaire (etude_id, etude_champ_nom, etude_champ_valeur) values (".$etude_id.", '".$this->dbConn->AnalyseSql($nomChp)."' ,'".$this->dbConn->AnalyseSql($valeur)."');";

    $this->dbConn->ExecuteSql($strSql);
  }
  /**
   * supprime la liaison methodologie / etude
   * @param $etude_id
   * @return unknown_type
   */
  function delEtudeChpSupplementaire($etude_id){
    $strSql="";
    $strSql.="delete from etude_champ_supplementaire where etude_id =".$etude_id;
    $this->dbConn->ExecuteSql($strSql);
  }
  
}

?>