<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @class AlkHtmlFormAdminCrbn_catList
 * @brief Description de la classe
 */
class AlkHtmlFormAdminCrbn_chpsup_catForm extends AlkHtmlForm 
{
  
    /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
   

   
  public function __construct(AlkAppli &$oAppli)
  {

    parent::__construct($oAppli, "formCrbn_catList");

    $this->iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_ADMINISTRATION, ALK_SHEET_FORM, "&iMode=".$this->iModeForm);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;
        
    $this->setProperties($this->iModeForm, ALK_FORM_METHOD_POST, $strAction);
    

  }
  
  protected function setData($iTypeInit) {
    
    
    $etude_champ_nom = AlkRequest::getToken("etude_champ_nom", AlkRequest::_REQUEST("etude_champ_nom", "")); 
        //$this->etude_id                       = new AlkFormData($this, "etude_id", -1, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC); // destiné à recup le nom de la table prodige
    $this->etude_champ_nom                = new AlkFormData($this, "etude_champ_nom", $etude_champ_nom, ALK_SQL_TEXT);
    //$this->etude_champ_valeur             = new AlkFormData($this, "etude_champ_valeur", "", ALK_SQL_TEXT);
    $this->etude_champ_desc               = new AlkFormData($this, "etude_champ_desc", "", ALK_SQL_TEXT);
    //$this->etude_activation_champ_champ   = new AlkFormData($this, "etude_activation_champ_champ", "", ALK_SQL_TEXT);
    //$this->etude_activation_champ_statut  = new AlkFormData($this, "etude_activation_champ_statut", "", ALK_SQL_TEXT);
  
      // initialisation des propriétés par REQUEST ou DATAROW
    $tabData = array(null);
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      
      $oDsData = $this->oAppli->oQuery->getDsByTableName("etude_champ ec " .
                                                             // "left join etude_champ_supplementaire ecs on ec.etude_champ_nom = ecs.etude_champ_nom " .
                                                              "left join etude_activation_champ eac on ec.etude_champ_nom = eac.etude_activation_champ_champ where ec.etude_champ_nom ='".$this->etude_champ_nom->value."'");      
      $tabData[] = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
      
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
      
    foreach ($tabData as $oDrData){
      $this->initData($iTypeInit, $oDrData, $reqMethod);
    }
  }
  
  /**
   * Traitements Sql
   */
  public function doSql(){
    $this->setData(ALK_INIT_MODE_REQUEST);
    $tabQuery = $this->getTabQuery(array());
     
    $strToken = $this->oAppli->getToken($this->iTypeSheet, ALK_SHEET_VALIDATION, $this->iSSheet);
        
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD:
      $bReturn = true;
      $tabQuery["field"]["ETUDE_CHAMP_NOM"][1] = $this->oAppli->oQueryAction->getLogin($tabQuery["field"]["ETUDE_CHAMP_NOM"][1], "");
      $bReturn = $this->oAppli->oQueryAction->add_data_champ_sup($tabQuery);
      if($bReturn!=true){
      	$strToken = $this->oAppli->getToken($this->iTypeSheet, ALK_SHEET_VALIDATION, $this->iSSheet, "&bErrorReq=1");
      }
      break;
      
    case ALK_FORM_MODE_UPDATE:
      $etude_champ_nom_old = AlkRequest::getToken("etude_champ_nom_old", AlkRequest::_REQUEST("etude_champ_nom_old", ""));          
      $tabQuery["field"]["ETUDE_CHAMP_NOM"][1] = $this->oAppli->oQueryAction->getLogin($tabQuery["field"]["ETUDE_CHAMP_NOM"][1], "");
      $this->oAppli->oQueryAction->update_data_champ_sup($tabQuery, $etude_champ_nom_old);
      break;
    
    case ALK_FORM_MODE_DEL:
      $etude_champ_nom_old = AlkRequest::getToken("etude_champ_nom_old", AlkRequest::_REQUEST("etude_champ_nom_old", "")); 
      $this->oAppli->oQueryAction->delete_data_champ_sup($tabQuery, $etude_champ_nom_old);
      break;
    }
    
    // url de retour après traitement

    return ALK_ALKANET."?token=".$strToken;
  }
  
  /*
   * Contenu du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    
    if($this->iModeForm==ALK_FORM_MODE_ADD){
    	$this->setLabel(_t("Ajout d'un champ supplémentaire"));
    }else{
      $this->setLabel(_t("Gestion des champs supplémentaire"));
    }
    $etude_champ_nom_old ="";
    if($this->iModeForm==ALK_FORM_MODE_UPDATE || $this->iModeForm==ALK_FORM_MODE_DEL){
     $etude_champ_nom_old = $this->etude_champ_nom->value;
    }
    
    $oBlock1 = $this->addBlock("block_group1", "Paramètres du champ supplémentaire", "", "100", "390", true);    
    $oCtrlNom = AlkHtmlFactory::getHtmlText($this->etude_champ_desc, "Intitulé du champ affiché", 1, 60, 80);
    $oCtrlNom->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    $oBlock1->addCtrl($oCtrlNom);    
    $oCtrlVal = AlkHtmlFactory::getHtmlText($this->etude_champ_nom, "Intitulé du champ en base de données", 1, 10, 12);
    $oCtrlVal->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, 0, 12);
    $oCtrlVal->setLabelHelp("Texte de 12 caractères maximum, sans accents ni caractères spéciaux correspondant au champ en base de données.");
    if($this->iModeForm==ALK_FORM_MODE_UPDATE){
      $oCtrlVal->setProperty("bDisabled", true);
      
    }
    $oBlock1->addCtrl($oCtrlVal);    
    
    
    $strParam = "cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".$this->iSheet.
      "&iSSheet=".$this->iSSheet."&iMode=".$this->iModeForm.($this->iModeForm == 2 ? "&etude_champ_nom_old=".$etude_champ_nom_old : "");
    $this->addValidButton("", ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($strParam), "Valider", "Valider");
    // bouton supprimer    

    
    // bouton annuler
    $this->addCancelButton($this->iTypeSheet, ALK_SHEET_VALIDATION, $this->iSSheet, ""); 
    // bt suppr
    if($this->iModeForm==ALK_FORM_MODE_UPDATE){
      $strParamSuppr = "cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".$this->iSheet.
      "&iSSheet=".$this->iSSheet."&iMode=".ALK_FORM_MODE_DEL."&etude_champ_nom_old=".$etude_champ_nom_old;
      //$this->addValidButton("", ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($strParamSuppr), "Supprimer", "Supprimer");
      $this->addButton("", ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($strParamSuppr), "Supprimer", "Supprimer");      
    }   
  }

  
  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/help/crbn_cat_01_admin_form.htm");
  }
}
?>