<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @class AlkHtmlFormAdminCrbn_catList
 * @brief Description de la classe
 */
class AlkHtmlFormAdminCrbn_catList extends AlkHtmlForm 
{
  
    /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
   

   
  public function __construct(AlkAppli &$oAppli)
  {

    parent::__construct($oAppli, "formCrbn_catList");

    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_ADMINISTRATION, ALK_SHEET_FORM, "&iMode=".$iModeForm);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;
    $this->bErrorReq = AlkRequest::getToken("bErrorReq", AlkRequest::_REQUEST("bErrorReq", "0")); 
    
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
    

  }
  
  protected function setData($iTypeInit) {
    
    // creation des propriétés AlkFormData

  }
  
  /**
   * Traitements Sql
   */
  public function doSql(){
    $this->setData(ALK_INIT_MODE_REQUEST);
    $tabQuery = $this->getTabQuery(array());
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD:
      break;
      
    case ALK_FORM_MODE_UPDATE:
      $this->oAppli->oQueryAction->action_data_on_Post($_POST);
      break;
    
    case ALK_FORM_MODE_DEL:
      break;
    }
    // url de retour après traitement
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet);
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /*
   * Contenu du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    $this->setLabel(_t("Gestion de l'activation des champs"));   
        
    if($this->bErrorReq == 1){
        $this->setLabelDesc("Il y a eu un problème lors de l'ajout du champ supplémentaire. Peut être que l'alias du champ proposé existait déjà.");
    }else{
    	$this->setLabelDesc("Vous avez la possibilité d'activer ou au contraire désactiver les champs suivants.");
    }

    

    
    $iModeRead = 0;
   
    $dsField = $this->oAppli->oQuery->getDsByTableName("etude_activation_champ where etude_activation_champ_champ not in (select etude_champ_nom from etude_champ)");  
    $oBlock = $this->addBlock("block_champs_activation", "Activation des champs", "", 300, 350);
    while($drField = $dsField->getRowIter()){ // pour chaque champs de la table
      $oCtrlRadio = AlkHtmlFactory::getNewHtmlRadio($this, $iModeRead, $drField->getValueName("etude_activation_champ_champ"), $drField->getValueName("etude_activation_champ_statut"), $drField->getValueName("etude_activation_champ_champ"));
      $oCtrlRadio->addRadio("1", "oui");
      $oCtrlRadio->addRadio("0", "non");      
      $oBlock->addCtrl($oCtrlRadio);
    }
    
 
    $oBlock2 = $this->addBlock("block_champs_sup", "Gestion de champs supplémentaires", "", 300, 350);
    //$bChecked = ( ($appli_id_courant == $appli_id && $cont_id_courant == $cont_id) ? 1 : 0);
    $dsFieldchmpsup = $this->oAppli->oQuery->getDsByTableName("etude_champ ec " .
                                                             // "left join etude_champ_supplementaire ecs on ec.etude_champ_nom = ecs.etude_champ_nom " .
                                                              "left join etude_activation_champ eac on ec.etude_champ_nom = eac.etude_activation_champ_champ ");      
    $bChecked = 1; // a voir en fonction du profil de l'agent?
    $iMaxField ="4";
    $iWidth = "30";
    
    

    
    while($drFieldchmpsup = $dsFieldchmpsup->getRowIter()){ // pour chaque champs de la table    

      $oLinkIntituleChpSup = AlkHtmlFactory::getHtmlButton(ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_FICHE.
      "&iSSheet=".$this->iSSheet."&iMode=".ALK_FORM_MODE_UPDATE."&etude_champ_nom=".$drFieldchmpsup->getValueName("etude_activation_champ_champ")), $drFieldchmpsup->getValueName("etude_activation_champ_champ"), "Modifier", "");

      $oCtrlRadio2 = AlkHtmlFactory::getNewHtmlRadio($this, $iModeRead, $drFieldchmpsup->getValueName("etude_activation_champ_champ"), $drFieldchmpsup->getValueName("etude_activation_champ_statut"), $oLinkIntituleChpSup->getHtml());
      $oCtrlRadio2->addRadio("1", "oui");
      $oCtrlRadio2->addRadio("0", "non");   
      $oBlock2->addCtrl($oCtrlRadio2);
    }

    $oLinkIntitule = AlkHtmlFactory::getHtmlButton(ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_FICHE.
      "&iSSheet=".$this->iSSheet."&iMode=".ALK_FORM_MODE_ADD), "Ajouter un champ supplémentaire", "Ajouter", "Ajouter un champ supplémentaire");

    $oBlock2->addCtrl($oLinkIntitule); 

    $strParam = "cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".$this->iSheet.
      "&iSSheet=".$this->iSSheet."&iMode=2";
    $this->addValidButton("", ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($strParam), "Valider", "Valider");
    // bouton annuler
    $this->addCancelButton($this->iTypeSheet, $this->iSheet, $this->iSSheet, "");    
  }

  
  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/help/crbn_cat_01_admin_form.htm");
  }
}
?>