<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @class AlkHtmlFormAdminCrbn_catForm
 * @brief Description de la classe
 */
class AlkHtmlFormAdminCrbn_catForm extends AlkHtmlForm 
{
  
  protected $table_champ;
  
  /**
   * Constructeur
   * @param oAppli    Application appelante
   */
  public function __construct(AlkAppli &$oAppli) 
  {
    parent::__construct($oAppli, "formCrbn_catForm");

    // configuration du formulaire
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_ADMINISTRATION, ALK_SHEET_FORM, "&iMode=".$iModeForm);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;
    
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
  }
  
  /**
   *  Abstract : Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit)
  {
    $theme_id = AlkRequest::getToken("theme_id", AlkRequest::_REQUESTint("theme_id", "-1"));
    $this->err = AlkRequest::getToken("err", AlkRequest::_REQUESTint("err", "-1"));
    $this->nom_couche_pb = AlkRequest::getToken("nom_couche_pb", AlkRequest::_REQUEST("nom_couche_pb", ""));

    $this->config_table_com = new AlkFormData($this, "config_table_com", -1, ALK_SQL_TEXT); // destiné à recup le nom de la table prodige
    $this->config_wms       = new AlkFormData($this, "config_wms", "", ALK_SQL_TEXT);
    $this->config_layer_wms = new AlkFormData($this, "config_layer_wms", "", ALK_SQL_TEXT);
    $this->config_id_com    = new AlkFormData($this, "config_id_com", "", ALK_SQL_TEXT);
    $this->config_nom_coml  = new AlkFormData($this, "config_nom_coml", "", ALK_SQL_TEXT);
    $this->config_id_epci   = new AlkFormData($this, "config_id_epci", "", ALK_SQL_TEXT);
    $this->config_nom_epci  = new AlkFormData($this, "config_nom_epci", "", ALK_SQL_TEXT);
    $this->config_id_pays   = new AlkFormData($this, "config_id_pays", "", ALK_SQL_TEXT);
    $this->config_nom_pays  = new AlkFormData($this, "config_nom_pays", "", ALK_SQL_TEXT);
    $this->config_id_pnr    = new AlkFormData($this, "config_id_pnr", "", ALK_SQL_TEXT);
    $this->config_nom_pnr   = new AlkFormData($this, "config_nom_pnr", "", ALK_SQL_TEXT);
    $this->config_id_dep    = new AlkFormData($this, "config_id_dep", "", ALK_SQL_TEXT);
    $this->config_nom_dep   = new AlkFormData($this, "config_nom_dep", "", ALK_SQL_TEXT);      
    $this->config_id_reg    = new AlkFormData($this, "config_id_reg", "", ALK_SQL_TEXT);
    $this->config_nom_reg   = new AlkFormData($this, "config_nom_reg", "", ALK_SQL_TEXT);            
    $this->config_id_au    = new AlkFormData($this, "config_id_au", "", ALK_SQL_TEXT);
    $this->config_nom_au   = new AlkFormData($this, "config_nom_au", "", ALK_SQL_TEXT);            
    $this->config_id_bv    = new AlkFormData($this, "config_id_bv", "", ALK_SQL_TEXT);
    $this->config_nom_bv   = new AlkFormData($this, "config_nom_bv", "", ALK_SQL_TEXT);            
    $this->config_id_ze    = new AlkFormData($this, "config_id_ze", "", ALK_SQL_TEXT);
    $this->config_nom_ze   = new AlkFormData($this, "config_nom_ze", "", ALK_SQL_TEXT);            
    $this->config_id_litt    = new AlkFormData($this, "config_id_litt", "", ALK_SQL_TEXT);
    $this->config_nom_litt   = new AlkFormData($this, "config_nom_litt", "", ALK_SQL_TEXT);            
    
    
    // initialisation des propriétés par REQUEST ou DATAROW
    $tabData = array(null);
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      
      $oDsData = $this->oAppli->oQuery->getEtudeConfig();
      $tabData[] = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
      
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
      
    foreach ($tabData as $oDrData){
      $this->initData($iTypeInit, $oDrData, $reqMethod);
    }
  }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    $tabQuery = $this->getTabQuery(array());
        
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD:
             
      break;
      
    case ALK_FORM_MODE_UPDATE:
      $this->oAppli->oQueryAction->update_data($tabQuery, "etude_config");
            
      break;
    
    case ALK_FORM_MODE_DEL:
      break;
      
    case 4 :  // 
      // nom de la couche select
      $couche_donnees        = AlkRequest::getToken("couche_donnees", AlkRequest::_REQUEST("couche_donnees", "")); 

      $tabFields = array();
      $tabFields[] = array(-1, "Sélectionnez un champ");
      
      //$oDsSsCategorie = $this->oAppli->oQuery->getDsDomForComboDomaine("sdom.ssdom_nom", "sdom.pk_sous_domaine", ALK_BDCOM_RESP_FILTR_DOM, ( $dom_id != -1 ? "AND sdom.pk_domaine =".$dom_id : "" ));
      // liste des champs de la table sélectionnée :
      
      $taballFields = array();           
      // champ insee de la couche ou lot si mode tabulaire   
      if($couche_donnees!=-1){
        $ds = $this->oAppli->oQuery->getDsListChmpCoucheByIdForCombo('"'.$couche_donnees.'"', true);    
        $ds->fetchAll();
        $taballFields = $ds->getFields();
      }


      
      if(empty($taballFields)){// le ds est vide la couche n'existe peut être pas
     /*   
        $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&err=1&nom_couche_pb=".$couche_donnees);

        header("location: ".ALK_ALKANET."?token=".$strToken);
        exit();
      */
      
      }else{
      	
        foreach($taballFields as $key => $val){
          $tabFields[] = array($val, $val);
        }

      }
      /*
      while ( $oDrSsCategorie = $oDsSsCategorie->getRowIter() ) {
        $tabFields[] = array($oDrSsCategorie->getValueName("DATATYPE_ID"), html_entity_decode($oDrSsCategorie->getValueName("DATATYPE_INTITULE").(in_array($oDrSsCategorie->getValueName("DATATYPE_INTITULE"), $tabDataLot) ? "(*)" : ""), ENT_NOQUOTES, 'UTF-8'));
      }
      */
      $array["data_res"] = $tabFields;
      
      echo json_encode( $array);  
      exit;
      break;  
    
    }
    
    // url de retour après traitement
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet);
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    
    
    if($this->err == 1){
      if($this->nom_couche_pb != ""){
        $this->setLabel("Il y a eu un problème lors de la lecture de la couche '".$this->nom_couche_pb."'.");
      }
    }else{ 
      $this->setLabel("Formulaire de paramétrage de l'application");
      $this->setLabelDesc("Vous devez tout d'abord renseigner une url de fond de plan WMS et une adresse de réception des messages. <br> Dans un second temps vous devez renseigner des informations géographiques. Pour cela sélectionnez une table contenant les données géograpĥiques de l'application, <br> puis choisissez parmi les champs de cette table les champs correspondant aux paramètres géographiques listés.");
    }
    
    
    $iSelectWidth = "";
    $iWidthSelect = "460";
    $widthTxt = "";

    $strTitle = "";
    $oBlock1 = $this->addBlock("block_group1", "Paramètres généraux", "", "100", "390", true);

    $oCtrlWMS = AlkHtmlFactory::getHtmlText($this->config_wms, "Fond de plan WMS", 1, 60, 80);
    $oCtrlWMS->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    //$oCtrlWMS->addDesc("URL et nom de la couche.");
    $oBlock1->addCtrl($oCtrlWMS);

    $oCtrlLayerWMS = AlkHtmlFactory::getHtmlText($this->config_layer_wms, "Intitule de la couche WMS", 1, 60, 80);
    $oCtrlLayerWMS->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    //$oCtrlWMS->addDesc("URL et nom de la couche.");
    $oBlock1->addCtrl($oCtrlLayerWMS);
    
    $oBlock = $this->addBlock("block_group", "Paramétrage des données géographiques ", "", "100", "390", true);

    $ds3 = $this->oAppli->oQuery->getListTableFromSchema(ALK_PRODIGE_SCHEMA);
    while($dr3 = $ds3->getRowIter()){
      if($dr3->getValueName("tablename") != "")
      $tabValTxt3[html_entity_decode($dr3->getValueName("tablename"), ENT_NOQUOTES, 'UTF-8')] = html_entity_decode($dr3->getValueName("tablename"), ENT_NOQUOTES, 'UTF-8'); 
    }    

    $oCtrlNomTable = AlkHtmlFactory::getHtmlSelect($this->config_table_com, "Nom de la table de données géographiques",1, $iWidthSelect);
    $oCtrlNomTable->setProperty("tabValTxt", $tabValTxt3); 
    $oCtrlNomTable->setProperty("tabValTxtDefault", array("-1", "Sélectionnez une table de données géographiques"));
    $oCtrlNomTable->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, "-1"); 
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=4");
    $oCtrlNomTable->AddEvent("onChange", "ChangeTable('".$strToken."')");
    $oBlock->addCtrl($oCtrlNomTable);
    //$this->addOnload("ChangeTable('".$strToken."')");

    $tabFields = array();
    if($this->config_table_com->value !=-1){
        $ds = $this->oAppli->oQuery->getDsListChmpCoucheByIdForCombo('"'.$this->config_table_com->value.'"', true);    
        $ds->fetchAll();
        $taballFields = $ds->getFields();
    }
    if(empty($taballFields)){// le ds est vide la couche n'existe peut être pas
     /* $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&err=1&nom_couche_pb=".$couche_donnees);
        header("location: ".ALK_ALKANET."?token=".$strToken);
        exit();*/     
    }else{       
        foreach($taballFields as $key => $val){
          $tabFields[html_entity_decode($val, ENT_NOQUOTES, 'UTF-8')] = html_entity_decode($val, ENT_NOQUOTES, 'UTF-8');
        }
    }

  	$oCtrlconfig_id_com = AlkHtmlFactory::getHtmlSelect($this->config_id_com, "Identifiant unique des communes",1, $iWidthSelect);       
    $oCtrlconfig_id_com->setProperty("tabValTxt", $tabFields); 
    $oCtrlconfig_id_com->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));
    $oBlock->addCtrl($oCtrlconfig_id_com);    

    $oCtrlconfig_nom_coml = AlkHtmlFactory::getHtmlSelect($this->config_nom_coml, "Libellé des communes",1, $iWidthSelect);       
    $oCtrlconfig_nom_coml->setProperty("tabValTxt", $tabFields); 
    $oCtrlconfig_nom_coml->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));
    $oBlock->addCtrl($oCtrlconfig_nom_coml);    
    
    $oCtrlconfig_id_epci = AlkHtmlFactory::getHtmlSelect($this->config_id_epci, "Identifiant des EPCI",1, $iWidthSelect);   
    $oCtrlconfig_id_epci->setProperty("tabValTxt", $tabFields); 
    $oCtrlconfig_id_epci->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));    
    $oBlock->addCtrl($oCtrlconfig_id_epci);
    
    $oCtrlconfig_nom_epci = AlkHtmlFactory::getHtmlSelect($this->config_nom_epci, "Libellé des EPCI",1, $iWidthSelect);
    $oCtrlconfig_nom_epci->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_nom_epci->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));       
    $oBlock->addCtrl($oCtrlconfig_nom_epci);    
    
    $oCtrlconfig_id_pays = AlkHtmlFactory::getHtmlSelect($this->config_id_pays, "Identifiant des pays",1, $iWidthSelect); 
    $oCtrlconfig_id_pays->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_id_pays->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));   
    $oBlock->addCtrl($oCtrlconfig_id_pays);    

    $oCtrlconfig_nom_pays = AlkHtmlFactory::getHtmlSelect($this->config_nom_pays, "Libellé des pays",1, $iWidthSelect); 
    $oCtrlconfig_nom_pays->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_nom_pays->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));             
    $oBlock->addCtrl($oCtrlconfig_nom_pays);
    
    $oCtrlconfig_id_pnr = AlkHtmlFactory::getHtmlSelect($this->config_id_pnr, "Identifiant des PNR",1, $iWidthSelect);
    $oCtrlconfig_id_pnr->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_id_pnr->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));                
    $oBlock->addCtrl($oCtrlconfig_id_pnr);
    
    $oCtrlconfig_nom_pnr = AlkHtmlFactory::getHtmlSelect($this->config_nom_pnr, "Libellé des PNR",1, $iWidthSelect);  
    $oCtrlconfig_nom_pnr->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_nom_pnr->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));         
    $oBlock->addCtrl($oCtrlconfig_nom_pnr);

    $oCtrlconfig_id_dep = AlkHtmlFactory::getHtmlSelect($this->config_id_dep, "Identifiant des départements",1, $iWidthSelect);       
    $oCtrlconfig_id_dep->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_id_dep->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));   
    $oBlock->addCtrl($oCtrlconfig_id_dep);    

    $oCtrlconfig_nom_dep = AlkHtmlFactory::getHtmlSelect($this->config_nom_dep, "Libellé des départements",1, $iWidthSelect);    
    $oCtrlconfig_nom_dep->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_nom_dep->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));      
    $oBlock->addCtrl($oCtrlconfig_nom_dep);
    
    $oCtrlconfig_id_reg = AlkHtmlFactory::getHtmlSelect($this->config_id_reg, "Identifiant des régions",1, $iWidthSelect);       
    $oCtrlconfig_id_reg->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_id_reg->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_id_reg);
    
    $oCtrlconfig_nom_reg = AlkHtmlFactory::getHtmlSelect($this->config_nom_reg, "Libellé des régions",1, $iWidthSelect);       
    $oCtrlconfig_nom_reg->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_nom_reg->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_nom_reg);
    
    $oCtrlconfig_id_au = AlkHtmlFactory::getHtmlSelect($this->config_id_au, "Identifiant des aires urbaines",1, $iWidthSelect);       
    $oCtrlconfig_id_au->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_id_au->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_id_au);
    
    $oCtrlconfig_nom_au = AlkHtmlFactory::getHtmlSelect($this->config_nom_au, "Libellé des aires urbaines",1, $iWidthSelect);       
    $oCtrlconfig_nom_au->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_nom_au->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_nom_au);
    
    $oCtrlconfig_id_bv = AlkHtmlFactory::getHtmlSelect($this->config_id_bv, "Identifiant des bassins versants",1, $iWidthSelect);       
    $oCtrlconfig_id_bv->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_id_bv->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_id_bv);
    
    $oCtrlconfig_nom_bv = AlkHtmlFactory::getHtmlSelect($this->config_nom_bv, "Libellé des bassins versants",1, $iWidthSelect);       
    $oCtrlconfig_nom_bv->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_nom_bv->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_nom_bv);
    
    
    $oCtrlconfig_id_ze = AlkHtmlFactory::getHtmlSelect($this->config_id_ze, "Identifiant des zones d'emploi",1, $iWidthSelect);       
    $oCtrlconfig_id_ze->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_id_ze->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_id_ze);
    
    $oCtrlconfig_nom_ze = AlkHtmlFactory::getHtmlSelect($this->config_nom_ze, "Libellé des zones d'emploi",1, $iWidthSelect);       
    $oCtrlconfig_nom_ze->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_nom_ze->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_nom_ze);

    
    $oCtrlconfig_id_litt = AlkHtmlFactory::getHtmlSelect($this->config_id_litt, "Identifiant des zones littorales",1, $iWidthSelect);       
    $oCtrlconfig_id_litt->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_id_litt->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_id_litt);
    
    $oCtrlconfig_nom_litt = AlkHtmlFactory::getHtmlSelect($this->config_nom_litt, "Libellé des zones littorales",1, $iWidthSelect);       
    $oCtrlconfig_nom_litt->setProperty("tabValTxt", $tabFields);     
    $oCtrlconfig_nom_litt->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un champ"));  
    $oBlock->addCtrl($oCtrlconfig_nom_litt);
    

    $strParam = "cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".$this->iSheet.
      "&iSSheet=".$this->iSSheet."&iMode=2";
    $this->addValidButton("", ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($strParam), "Valider", "Valider");
   

    
   // $this->addValidButton("", "", "Valider", "Valider");
    $this->addCancelButton(ALK_TYPESHEET_ADMIN, ALK_SHEET_ADMINISTRATION, ALK_SHEET_FORM, "");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL."scripts/crbn_cat/lib/alkhtmlformadmincrbn_catform.js");
  }
  
  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/help/crbn_cat_01_admin_form.htm");
  }
}
?>