<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/** 
 * SCRIPT DE CREATION SQL - APPLI CRBN_CAT
 */

define("ALK_B_ATYPE_CRBN_CAT", true);

;

// tables iconographie
$tabTable["iconographie"] = array(
  "iconographie_id" => array("type" => "int", "dn" => "NOT NULL"),
  "iconographie_intitule" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["iconographie"]["pk_iconographie"] = "iconographie_id";

$tabIns[] = "

CREATE SEQUENCE seq_etude
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;
    
CREATE SEQUENCE seq_iconographie
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;
--
-- Name: seq_iconographie; Type: SEQUENCE OWNED BY; Schema: public; Owner: user_crbn
--
ALTER SEQUENCE seq_iconographie OWNED BY iconographie.iconographie_id;
";

$tabTable["document_type"] = array(
  "document_type_id" => array("type" => "int", "dn" => "NOT NULL"),
  "document_type_intitule" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["document_type"]["pk_document_type"] = "document_type_id";

$tabIns[] = "
CREATE SEQUENCE seq_document_type
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;
--
-- Name: seq_document_type; Type: SEQUENCE OWNED BY; Schema: public; Owner: user_crbn
--
ALTER SEQUENCE seq_document_type OWNED BY document_type.document_type_id;
";

$tabTable["typologie"] = array(
  "typologie_id" => array("type" => "int", "dn" => "NOT NULL"),
  "typologie_intitule" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["typologie"]["pk_typologie"] = "typologie_id";

$tabIns[] = "
CREATE SEQUENCE seq_typologie
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;
--
-- Name: seq_typologie; Type: SEQUENCE OWNED BY; Schema: public; Owner: user_crbn
--
ALTER SEQUENCE seq_typologie OWNED BY typologie.typologie_id;
";

$tabTable["methodologie"] = array(
  "methodologie_id" => array("type" => "int", "dn" => "NOT NULL"),
  "methodologie_intitule" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["methodologie"]["pk_methodologie"] = "methodologie_id";

$tabIns[] = "
CREATE SEQUENCE seq_methodologie
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;
--
-- Name: seq_methodologie; Type: SEQUENCE OWNED BY; Schema: public; Owner: user_crbn
--
ALTER SEQUENCE seq_methodologie OWNED BY methodologie.methodologie_id;
";

$tabTable["thematique"] = array(
  "thematique_id" => array("type" => "int", "dn" => "NOT NULL"),
  "thematique_intitule" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["thematique"]["pk_thematique"] = "thematique_id";

$tabIns[] = "
CREATE SEQUENCE seq_thematique
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;
--
-- Name: seq_thematique; Type: SEQUENCE OWNED BY; Schema: public; Owner: user_crbn
--
ALTER SEQUENCE seq_methodologie OWNED BY thematique.thematique_id;
";

$tabTable["sous_thematiques"] = array(
  "sous_thematique_id" => array("type" => "int", "dn" => "NOT NULL"),
  "sous_thematique_intitule" => array("type" => "varchar(255)", "dn" => ""),
  "thematique_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["sous_thematiques"]["pk_sous_thematiques"] = "sous_thematique_id";

$tabIdx["sous_thematiques"] = array(
  "idx_sous_thematiques" => "thematique_id",
  );

$tabIns[] = "
CREATE SEQUENCE seq_sous_thematiques
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;
--
-- Name: seq_sous_thematiques; Type: SEQUENCE OWNED BY; Schema: public; Owner: user_crbn
--
ALTER SEQUENCE seq_methodologie OWNED BY sous_thematiques.sous_thematique_id;
";


$tabTable["etude_activation_champ"] = array(
  "etude_activation_champ_champ" => array("type" => "varchar(40)", "dn" => "NOT NULL"),
  "etude_activation_champ_statut" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "thematique_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["etude_activation_champ"]["pk_etude_activation_champ"] = "etude_activation_champ_champ";

$tabTable["etude_champ"] = array(
  "etude_champ_nom" => array("type" => "varchar(12)", "dn" => "NOT NULL"),
  "etude_champ_desc" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  );

$tabPk["etude_champ"]["pk_etude_champ"] = "etude_champ_nom";

$tabTable["etude"] = array(
  "etude_id" => array("type" => "int", "dn" => "NOT NULL"),
  "etude_intitule" => array("type" => "varchar(256)", "dn" => ""),
  "etude_statut" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "etude_auteurs" => array("type" => "varchar(256)", "dn" => ""),
  "etude_redacteurs" => array("type" => "varchar(256)", "dn" => ""),  
  "etude_resume" => array("type" => "varchar(5000)", "dn" => ""),
  "etude_mots_cles" => array("type" => "varchar(1000)", "dn" => ""),    
  "etude_desc_nb_fascicules" => array("type" => "int", "dn" => ""),  
  "etude_desc_nb_pages" => array("type" => "int", "dn" => ""),   
  "etude_cout" => array("type" => "float", "dn" => ""),   
  "etude_prod_periode" => array("type" => "varchar(9)", "dn" => ""), 
  "etude_annee_achevement" => array("type" => "int", "dn" => ""),   
  "etude_annee_maj" => array("type" => "int", "dn" => ""),     
  "etude_date_publication" => array("type" => "datetime", "dn" => ""),     
  "etude_cote" => array("type" => "varchar(20)", "dn" => ""), 
  "etude_isrn" => array("type" => "varchar(36)", "dn" => ""), 
  "etude_redacteur" => array("type" => "varchar(256)", "dn" => ""),   
  "etude_agent_id" => array("type" => "int", "dn" => "NOT NULL"), 
  "etude_contact_service_id" => array("type" => "int", "dn" => "NOT NULL"),   
  "etude_perimetre_principal_intitule" => array("type" => "varchar(255)", "dn" => ""), 
  "etude_perimetre_principal_geom" => array("type" => "geometry", "dn" => ""),    
  "etude_perimetre_secondaire_intitule" => array("type" => "varchar(255)", "dn" => ""),
  "etude_date_maj" => array("type" => "datetime", "dn" => ""), 
  "etude_nb_consult"=> array("type" => "int", "dn" => ""),   
  "etude_nb_telechargement"=> array("type" => "int", "dn" => ""),
  "etude_droit"=> array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "etude_xml"=> array("type" => "text", "dn"=> "")            
  );


$tabIns[$strNum][] = 
          " INSERT into geometry_columns (f_table_catalog, f_table_schema,  f_table_name,  f_geometry_column,   coord_dimension,   srid,  type) values ('', 'alkanet', 'etude', 'etude_perimetre_principal_geom', '2', 2154, 'MULTIPOLYGON');";

$tabPk["etude"]["pk_etude"] = "etude_id";

$tabIdx["etude"] = array(
  "idx_etude" => "etude_agent_id",
  "idx_etude_0" => "etude_contact_service_id",
  );

  

//   Table : etude_PJ
$tabTable["etude_pj"] = array(
    "pj_id" => array("type" => "int", "dn" => "NOT NULL"),
    "pj_champ" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
    "data_id" => array("type" => "int", "dn" => "NOT NULL"),
    "pj_name" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
    "pj_file" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
    "pj_type" => array("type" => "int", "dn" => ""),
    "pj_taille" => array("type" => "int", "dn" => "DEFAULT 0"),
    "pj_duration" => array("type" => "float", "dn" => ""),
    "pj_bitrate" => array("type" => "int", "dn" => ""),
    "pj_lang" => array("type" => "int", "dn" => "DEFAULT 1"),
    "pj_datecrea" => array("type" => "datetime", "dn" => ""),
    "pj_agentcrea" => array("type" => "int", "dn" => ""),
    "pj_datecreafile" => array("type" => "datetime", "dn" => ""),
    "pj_title" => array("type" => "varchar(64)", "dn" => ""),
    "pj_copyright" => array("type" => "varchar(128)", "dn" => ""),
    "pj_auteur" => array("type" => "varchar(32)", "dn" => ""),
    "pj_desc" => array("type" => "varchar(2000)", "dn" => ""),
    "pj_keywords" => array("type" => "varchar(64)", "dn" => ""),
    );

    // sequence utilisée : seq_data_pj

$tabPk["etude_pj"]["pk_etude_pj"] = "pj_id";

$tabIdx["etude_pj"] = array(
  "idx_etude_pj" => "etude_id",
  );  

$tabTable["etude_commanditaires"] = array(
  "etude_id" => array("type" => "int", "dn" => "NOT NULL"),
  "service_id" => array("type" => "int", "dn" => "NOT NULL"),  
  );

$tabPk["etude_commanditaires"]["pk_etude_mo_0"] = "service_id, etude_id";

$tabIdx["etude_commanditaires"] = array(
  "idx_etude_mo" => "etude_id",
  );

$tabTable["etude_partenaire"] = array(
  "etude_id" => array("type" => "int", "dn" => "NOT NULL"),
  "service_id" => array("type" => "int", "dn" => "NOT NULL"),  
  );

$tabIdx["etude_partenaire"] = array(
  "idx_etude_partenaire" => "etude_id",
  "idx_etude_partenaire_0" => "service_id",
  );

$tabTable["etude_thematique"] = array(
  "etude_id" => array("type" => "int", "dn" => "NOT NULL"),
  "thematique_id" => array("type" => "int", "dn" => "NOT NULL"),  
  "sous_thematique_id" => array("type" => "int", "dn" => ""),  
  "etude_thematique_type" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),    
  );

$tabIdx["etude_thematique"] = array(
  "idx_etude_thematique" => "thematique_id",
  "idx_etude_thematique_0" => "sous_thematique_id",
  "idx_etude_thematique_1" => "etude_id",
  );

$tabTable["etude_document_type"] = array(
  "etude_id" => array("type" => "int", "dn" => "NOT NULL"),
  "document_type_id" => array("type" => "int", "dn" => "NOT NULL"),  
  );

$tabPk["etude_document_type"]["pk_etude_document_type"] = "document_type_id, etude_id";

$tabIdx["etude_document_type"] = array(
  "idx_etude_document_type" => "etude_id",
  );

$tabTable["etude_iconographie"] = array(
  "etude_id" => array("type" => "int", "dn" => "NOT NULL"),
  "iconographie_id" => array("type" => "int", "dn" => ""),  
  );

$tabIdx["etude_iconographie"] = array(
  "idx_etude_iconographie" => "iconographie_id",
  "idx_etude_iconographie_0" => "etude_id",
  );


$tabTable["etude_typologie"] = array(
  "etude_id" => array("type" => "int", "dn" => "NOT NULL"),
  "typologie_id" => array("type" => "int", "dn" => ""),  
  );

$tabIdx["etude_typologie"] = array(
  "idx_etude_typologie" => "etude_id",
  "idx_etude_typologie_0" => "typologie_id",
  );


$tabTable["etude_methodologie"] = array(
  "etude_id" => array("type" => "int", "dn" => "NOT NULL"),
  "methodologie_id" => array("type" => "int", "dn" => "NOT NULL"),  
  );

$tabIdx["etude_methodologie"] = array(
  "idx_etude_methodologie" => "etude_id",
  "idx_etude_methodologie_0" => "methodologie_id",
  );

$tabTable["etude_champ_supplementaire"] = array(
  "etude_id" => array("type" => "int", "dn" => "NOT NULL"),
  "etude_champ_nom" => array("type" => "varchar(12)", "dn" => "NOT NULL"),  
  "etude_champ_valeur" => array("type" => "varchar(255)", "dn" => ""), 
  );

$tabIdx["etude_champ_supplementaire"] = array(
  "idx_etude_champ_supplementaire" => "etude_id",
  "idx_etude_champ_supplementaire_0" => "etude_champ_nom",
  );

// cles etrangeres
$tabFk["etude"] = array(
  "fk_etude_sit_agent" => array("ffk" => "etude_agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_etude_sit_service" => array("ffk" => "etude_contact_service_id", "tpk" => "sit_service", "fpk" => "service_id"),
  );

$tabFk["etude_pj"] = array(
  "fk_etude_pj_etude" => array("ffk" => "etude_id", "tpk" => "etude", "fpk" => "etude_id"),
  );

$tabFk["etude_commanditaires"] = array(
  "fk_etude_mo_etude" => array("ffk" => "etude_id", "tpk" => "etude", "fpk" => "etude_id"),
  "fk_etude_commanditaires" => array("ffk" => "service_id", "tpk" => "sit_service", "fpk" => "service_id"),
  );

$tabFk["etude_partenaire"] = array(
  "fk_etude_partenaire_etude" => array("ffk" => "etude_id", "tpk" => "etude", "fpk" => "etude_id"),
  "fk_etude_partenaire" => array("ffk" => "service_id", "tpk" => "sit_service", "fpk" => "service_id"),
  );

$tabFk["sous_thematiques"] = array(
  "fk_sous_thematiques_thematique" => array("ffk" => "thematique_id", "tpk" => "thematique", "fpk" => "thematique_id"),
  );

$tabFk["etude_thematique"] = array(
  "fk_etude_thematique" => array("ffk" => "sous_thematique_id", "tpk" => "sous_thematiques", "fpk" => "sous_thematique_id"),
  "fk_etude_thematique_etude" => array("ffk" => "etude_id", "tpk" => "etude", "fpk" => "etude_id"),
  "fk_etude_thematique_thematique" => array("ffk" => "thematique_id", "tpk" => "thematique", "fpk" => "thematique_id"),
  );
  
$tabFk["etude_document_type"] = array(
  "fk_etude_document_type_etude" => array("ffk" => "etude_id", "tpk" => "etude", "fpk" => "etude_id"),
  "fk_etude_document_type" => array("ffk" => "document_type_id", "tpk" => "document_type", "fpk" => "document_type_id"),
  );

$tabFk["etude_iconographie"] = array(
  "fk_etude_iconographie" => array("ffk" => "iconographie_id", "tpk" => "iconographie", "fpk" => "iconographie_id"),
  "fk_etude_iconographie_etude" => array("ffk" => "etude_id", "tpk" => "etude", "fpk" => "etude_id"),
  );


$tabFk["etude_typologie"] = array(
  "fk_etude_typologie_etude" => array("ffk" => "etude_id", "tpk" => "etude", "fpk" => "etude_id"),
  "fk_etude_typologie_typologie" => array("ffk" => "typologie_id", "tpk" => "typologie", "fpk" => "typologie_id"),
  ); 

  
$tabFk["etude_methodologie"] = array(
  "fk_etude_methodologie_etude" => array("ffk" => "etude_id", "tpk" => "etude", "fpk" => "etude_id"),
  "fk_etude_methodologie" => array("ffk" => "methodologie_id", "tpk" => "methodologie", "fpk" => "methodologie_id"),
  ); 

$tabFk["etude_champ_supplementaire"] = array(
  "fk_etude_champ_supplementaire" => array("ffk" => "etude_id", "tpk" => "etude", "fpk" => "etude_id"),
  "fk_etude_champ_supplementaire_champ_nom" => array("ffk" => "etude_champ_nom", "tpk" => "etude_champ", "fpk" => "etude_champ_nom"),
  ); 

$tabIns[] = "delete from SIT_CONSTANTE where ATYPE_ID=112";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) values (-1,-1,'ALK_B_ATYPE_CRBN_CAT','true',3,'Module installé',0)";

// Type application
$tabIns[] = "INSERT INTO SIT_APPLI_TYPE (ATYPE_ID, ATYPE_ID_DIST, ATYPE_INTITULE, ATYPE_ABREV, ATYPE_URL, ATYPE_URL_ADMIN, ATYPE_URL_SITE,".
  " ATYPE_DROIT, ATYPE_DISPO, ATYPE_DESC, ATYPE_URL_TARGET, ATYPE_COMPATIBLE, ATYPE_LOGO, ATYPE_ADMIN_LOGO)".
  " VALUES(1, -1, 'CRBN Catalogue', 'crbn_cat', '', '', NULL, 0, 0, '', '', 1, 'picto32_form.gif', '')";

$tabTable["etude_config"] = array(
  "config_id" => array("type" => "int", "dn" => "NOT NULL"),
  "config_wms" => array("type" => "varchar(255)", "dn" => ""),  
  "config_layer_wms" => array("type" => "varchar(255)", "dn" => ""),
  "config_id_com" => array("type" => "varchar(255)", "dn" => ""),  
  "config_nom_coml" => array("type" => "varchar(255)", "dn" => ""), 
  "config_id_epci" => array("type" => "varchar(255)", "dn" => ""),  
  "config_nom_epci" => array("type" => "varchar(255)", "dn" => ""), 
  "config_id_pays" => array("type" => "varchar(255)", "dn" => ""),  
  "config_nom_pays" => array("type" => "varchar(255)", "dn" => ""), 
  "config_id_pnr" => array("type" => "varchar(255)", "dn" => ""),  
  "config_nom_pnr" => array("type" => "varchar(255)", "dn" => ""), 
  "config_id_dep" => array("type" => "varchar(255)", "dn" => ""),  
  "config_nom_dep" => array("type" => "varchar(255)", "dn" => ""),   
  "config_id_reg" => array("type" => "varchar(255)", "dn" => ""),  
  "config_nom_reg" => array("type" => "varchar(255)", "dn" => ""), 
  );
// init par valeur vide

$tabIns[] = "INSERT INTO etude_config (config_table_com, config_wms, config_id_com, config_nom_coml, config_id_epci, config_nom_epci," .
    "config_id_pays, config_nom_pays, config_id_pnr, config_nom_pnr, config_id_dep, config_nom_dep, config_id_reg, config_nom_reg)".
    " VALUES (-1, '', '', '', '', '', '', '', '', '', '', '', '', '')";

//

$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (-1, -1, 'ALK_CRBN_RESP_FILTR_DOM', '14', 'Pour filtrer les dom dans vue couche_sdom', 0, 0)";
$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (-1, -1, 'ALK_POSTGRES_BD_PRODIGE', 'PRODIGE', 'Base D. spatiale', 0, 0)";

$tabIns[] = "
set search_path='alkanet';
--
-- Name: crbn_admin_dico; Type: TABLE; Schema: alkanet; Owner: user_crbn; Tablespace: 
--

CREATE TABLE etude_admin_dico (
    dico_id integer NOT NULL,
    dico_table character varying(180) NOT NULL,
    dico_intitule character varying(255) NOT NULL,
    dico_selectsql text NOT NULL,
    dico_pattern character varying(180) NOT NULL,
    dico_colonneslist character varying(255) NOT NULL,
    dico_orderby character varying(255) NOT NULL
);

--
-- Name: TABLE etude_admin_dico; Type: COMMENT; Schema: alkanet; Owner: user_sdi
--

COMMENT ON TABLE etude_admin_dico IS 'Gestion des dictionnaires prÃ©sent dans l''appli';


--
-- Name: COLUMN etude_admin_dico.dico_id; Type: COMMENT; Schema: alkanet; Owner: user_sdi
--

COMMENT ON COLUMN etude_admin_dico.dico_id IS 'Un identifiant unique';


--
-- Name: COLUMN etude_admin_dico.dico_table; Type: COMMENT; Schema: alkanet; Owner: user_sdi
--

COMMENT ON COLUMN etude_admin_dico.dico_table IS 'Le nom de la table correspondant au dictionnaire';


--
-- Name: COLUMN etude_admin_dico.dico_intitule; Type: COMMENT; Schema: alkanet; Owner: user_sdi
--

COMMENT ON COLUMN etude_admin_dico.dico_intitule IS 'L''intitulÃ© utilisÃ© pour l''affichage Ã  l''utilisateur';


--
-- Name: COLUMN etude_admin_dico.dico_selectsql; Type: COMMENT; Schema: alkanet; Owner: user_sdi
--

COMMENT ON COLUMN etude_admin_dico.dico_selectsql IS 'La requÃªte SQL rÃ©cupÃ©rant les informations du dictionnaire';


--
-- Name: COLUMN etude_admin_dico.dico_pattern; Type: COMMENT; Schema: alkanet; Owner: user_sdi
--

COMMENT ON COLUMN etude_admin_dico.dico_pattern IS 'Le pattern utilisÃ© pour afficher les informations du dictionnaire';


--
-- Name: COLUMN etude_admin_dico.dico_colonneslist; Type: COMMENT; Schema: alkanet; Owner: user_sdi
--

COMMENT ON COLUMN etude_admin_dico.dico_colonneslist IS 'Les colonnes utilisÃ©s pour l''affichage';


--
-- Name: COLUMN etude_admin_dico.dico_orderby; Type: COMMENT; Schema: alkanet; Owner: user_sdi
--

COMMENT ON COLUMN etude_admin_dico.dico_orderby IS 'L''ordonnancement des rÃ©sultats';


--
-- Name: etude_admin_dico_champ; Type: TABLE; Schema: alkanet; Owner: user_sdi; Tablespace: 
--

CREATE TABLE etude_admin_dico_champ (
    dico_id integer NOT NULL,
    champ_rang integer NOT NULL,
    champ_intitule character varying(180) NOT NULL,
    champ_colonne character varying(180) NOT NULL,
    champ_longueur integer,
    champ_html character varying(100),
    champ_required character varying(10),
    champ_sql_combo_sql text NOT NULL 
); 
    
INSERT INTO etude_admin_dico VALUES (0, 'iconographie', 'Inventaire iconographique', 'select d.iconographie_intitule as libelle, d.iconographie_id as id from iconographie d order by iconographie_intitule', '|&lt;3&gt;', 'Libellé::300::left', 'libelle');
INSERT INTO etude_admin_dico_champ VALUES (0, 1, 'id', 'iconographie_id', NULL, NULL, NULL, '');
INSERT INTO etude_admin_dico_champ VALUES (0, 2, 'libelle', 'iconographie_intitule', 50, 'text', '1', '');
INSERT INTO etude_admin_dico VALUES (1, 'typologie', 'Inventaire typologique', 'select d.typologie_intitule as libelle, d.typologie_id as id from typologie d order by typologie_intitule', '|&lt;3&gt;', 'Libellé::300::left', 'libelle');
INSERT INTO etude_admin_dico_champ VALUES (1, 1, 'id', 'typologie_id', NULL, NULL, NULL, '');
INSERT INTO etude_admin_dico_champ VALUES (1, 2, 'libelle', 'typologie_intitule', 50, 'text', '1', '');    
INSERT INTO etude_admin_dico VALUES (2, 'methodologie', 'Inventaire methodologique', 'select d.methodologie_intitule as libelle, d.methodologie_id as id from methodologie d order by methodologie_intitule', '|&lt;3&gt;', 'Libellé::300::left', 'libelle');
INSERT INTO etude_admin_dico_champ VALUES (2, 1, 'id', 'methodologie_id', NULL, NULL, NULL, '');
INSERT INTO etude_admin_dico_champ VALUES (2, 2, 'libelle', 'methodologie_intitule', 50, 'text', '1', '');
INSERT INTO etude_admin_dico VALUES (3, 'thematique', 'Inventaire des thèmes', 'select d.thematique_intitule as libelle, d.thematique_id as id , ( case when d.thematique_id in (select thematique_id from SOUS_THEMATIQUES) then 0 else 1 end) as B_SUPPRIMABLE from thematique d order by thematique_intitule', '|&lt;3&gt;', 'Libellé::300::left', 'libelle');
INSERT INTO etude_admin_dico_champ VALUES (3, 1, 'id', 'thematique_id', NULL, NULL, NULL, '');
INSERT INTO etude_admin_dico_champ VALUES (3, 2, 'libelle', 'thematique_intitule', 50, 'text', '1', '');
INSERT INTO etude_admin_dico VALUES (4, 'sous_thematiques', 'Inventaire des sous-thematiques', 'SELECT ssth.SOUS_THEMATIQUE_ID AS id, th.THEMATIQUE_INTITULE AS Thématique, ssth.SOUS_THEMATIQUE_INTITULE as sous_thématique FROM SOUS_THEMATIQUES ssth INNER JOIN THEMATIQUE th ON th.THEMATIQUE_ID = ssth.THEMATIQUE_ID', '|&lt;3&gt;|&lt;4&gt;', 'Sous-thème::150::left|Thématique::150::left', 'libelle');
INSERT INTO etude_admin_dico_champ VALUES (4, 1, 'id', 'sous_thematique_id', NULL, NULL, NULL, '');
INSERT INTO etude_admin_dico_champ VALUES (4, 2, 'sous_thématique', 'sous_thematique_intitule', 50, 'text', '1', '');
INSERT INTO etude_admin_dico_champ VALUES (4, 3, 'Thématique', 'THEMATIQUE_ID', 50, 'combo_num', '1', 'SELECT THEMATIQUE_INTITULE,  THEMATIQUE_ID FROM THEMATIQUE ORDER BY THEMATIQUE_INTITULE');
INSERT INTO etude_admin_dico VALUES (5, 'document_type', 'Inventaire des documents types', 'select d.document_type_intitule as libelle, d.document_type_id as id from document_type d order by document_type_intitule', '|&lt;3&gt;', 'Libellé::300::left', 'libelle');
INSERT INTO etude_admin_dico_champ VALUES (5, 1, 'id', 'document_type_id', NULL, NULL, NULL, '');
INSERT INTO etude_admin_dico_champ VALUES (5, 2, 'libelle', 'document_type_intitule', 50, 'text', '1', '');    

    
INSERT INTO etude_activation_champ VALUES ('etude_mots_cles', '0');  
INSERT INTO etude_activation_champ VALUES ('etude_cout', '0');  
INSERT INTO etude_activation_champ VALUES ('etude_prod_periode', '0');
INSERT INTO etude_activation_champ VALUES ('etude_annee_maj', '0');  
INSERT INTO etude_activation_champ VALUES ('etude_cote', '0');        
INSERT INTO etude_activation_champ VALUES ('etude_isrn', '0');
INSERT INTO etude_activation_champ VALUES ('etude_iconographie', '0');  
INSERT INTO etude_activation_champ VALUES ('etude_document_type', '0');    
INSERT INTO etude_activation_champ VALUES ('etude_perimetre_secondaire_intitule', '0');";    

" CREATE TABLE temp_geom_union (desig_eng text,polygon_geom geometry);".
" INSERT into geometry_columns (f_table_catalog, f_table_schema,  f_table_name,  f_geometry_column,   coord_dimension,   srid,  type) values ('', 'public', 'temp_geom_union', 'polygon_geom', '2', 900913, 'MULTIPOLYGON');";


?>