<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/classes/alksvgtreenodedesc.class.php");

class AlkSvgAnnu extends AlkObject 
{

  public $strPathUpload;
  public $strUrlUpload;
  public $originalHeight;
  public $originalWidth;

  /**
   * Constructeur par défaut
   * @param strPathUpload  chemin de base pour le répertoire upload
   * @param strUrlUpload   url de base pour le répertoire upload
   */
  public function __construct($strPathUpload, $strUrlUpload)
  {
    $this->strPathUpload = $strPathUpload;
    $this->strUrlUpload  = $strUrlUpload;
  }

  /**
   * Retourne l'entete SVG commun à tous les arbres
   *
   * @param iWidth  largeur réelle du SVG
   * @param iHeight auteur réelle du SVG
   * @return string
   */
  protected function getSvgHead($iWidth, $iHeight)
	{
		$strSvg = "<svg ".
      " xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink'".
      " x='0' y='0' width='".$iWidth."' height='".$iHeight."' viewBox='0 0 ".
			$iWidth." ".$iHeight."'>".
			/*" onload='LoadThisSvg(evt)'>".
			"<script><![CDATA[".
			"var bIsLoaded=0;".
			"function LoadThisSvg(evt) { bIsLoaded=1; parent.onLoadSvg(this); }".
			"function IsLoaded() { return bIsLoaded==1; }".
			"]]></script>\n".*/
			"<defs>".
			"<style type='text/css'>".
			".cadreserv {fill:#0965cd; stroke:#000000; stroke-width:.05%;}".
			/*".cadrefonc {fill:#ffbb00; stroke:#000000; stroke-width:.05%;}".*/
      ".cadreutil {fill:#ffbb00; stroke:#000000; stroke-width:.05%;}".
			".cadreTree {fill:#FFFFFF; stroke:#000000; stroke-width:0%;}".
			".pathTxt {fill:none; stroke:none; stroke-width:0.05%}".
			".lien {stroke:#000000; stroke-width:.05%;}".
      ".txtutil     {text-align:center; font-family:arial; font-size:11px; font-weight:bold;   fill:blue; }".
      ".txtutilDesc {text-align:center; font-family:arial; font-size:11px; font-weight:normal; fill:blue; }".
			".txtserv     {text-align:center; font-family:arial; font-size:11px; font-weight:bold; fill: #ffffff; }".
			".txtservDesc {text-align:center; font-family:arial; font-size:11px; font-weight:normal; fill: #ffffff; }".
			/*".txtFonc     {text-align:center; font-family:arial; font-size:11px; font-weight:bold; fill:#000000; }".
			".txtFoncDesc {text-align:center; font-family:arial; font-size:11px; font-weight:bold; fill:#000000; }".*/
			"</style>".
			"</defs>\n".
			"<g id='lyrTreeAsc'>\n".
			"<rect x='0' y='0'".
			" width='".$iWidth."'".
			" height='".$iHeight."'".
			" class='cadreTree'/>\n";
		return $strSvg;
	}

  /**
   * Retourne le code SVG correspondant à l'arbre des descendants
   * du premier noeud présent dans le dataSet
   *
   * @param oDs         DataSet contenant des dataRow avec les colonnes suivantes : ID, NIVEAU, ID_PERE, INTITULE, DESCR, NB_ENF
   * @param strFieldId  Nom du champ identifiant du noeud courant
   * @param strFieldIdp Nom du champ identifiant le noeud parent
   * @return String
   */
  public function getTreeDesc(&$oDs, $strFieldId="ID", $strFieldIdp="ID_PERE")
  {
    $strSvg = "";
    
    if( is_object($oDs) && method_exists($oDs, "getRowIter") && $oDs->getCountTotDr()>0 ) {
      $tabNoeud = array();

      // calculé au moment de la construction
      $tn = null;
      $idParent = -1;
      $nb = $oDs->getCountTotDr();

      while( $oDr = $oDs->getRowIter() ) {
        $id      = $oDr->getValueName($strFieldId);
        $idPere  = $oDr->getValueName($strFieldIdp);
        //$strType = $oDr->getValueName("TYPE");
        if( $idParent == -1 ) {
          $idParent = $id;
        }
        
        $tabNoeud[$id] = new AlkSvgTreeNodeDesc($oDr, $this->strPathUpload, $this->strUrlUpload);
        if( $idParent != $id ) {
          if( array_key_exists($idPere, $tabNoeud) && is_object($tabNoeud[$idPere]) ) {
            $indexAdd = $tabNoeud[$idPere]->AddChild($tabNoeud[$id]);
            if( $indexAdd == -1 ) {
              $tabNoeud[$id] = null;
              unset($tabNoeud[$id]);
            }
          }
          /*else
            echo "pas de ".$idPere."\n";*/
        }
      }

      $tn =& $tabNoeud[$idParent];
      $tn->SetFrame($tn);
      $iMargeX = 20;
      $iMargeY = 20;
      
      $svgWidth = $tn->svgWidth()+2*$iMargeX;
      $svgHeight = $tn->svgHeight()+2*$iMargeY;
      if( $svgWidth*3/4 > $svgHeight )
        $svgHeight = $svgWidth*3/4;
      else
        $svgWidth = $svgHeight*4/3;
      
      $tn->SetPosition($iMargeX, $iMargeY);
      $tabKeys = array_keys($tabNoeud);
      for($i=0; $i<count($tabKeys); $i++) {
        $strSvg .= $tabNoeud[$tabKeys[$i]]->GetSvg();
      }
      
      $this->originalHeight = $svgHeight;
      $this->originalWidth = $svgWidth;
      
      $strSvg .= "</g></svg>";

      $tabNoeud = null;
      $strSvg = "<?xml version='1.0' encoding='".ALK_HTML_ENCODING."'?>\n".
        "<!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.1//EN' 
         'http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd'>\n".
        $this->GetSvgHead($svgWidth, $svgHeight).$strSvg;
    } else {
      $strSvg = "<?xml version='1.0' encoding='".ALK_HTML_ENCODING."'?>\n";
    }
    return $strSvg;
  }
  
  /**
   * Création de l'organigramme en svg puis transformation en png (deux tailles)
   * Retourne un tableau nommmé : ["img" => url du png, "thumb" => url du png vignette]
   * 
   * @return array 
   */
  public function createPNG($oDs, $strFieldId="ID", $strFieldIdp="ID_PERE")
  {
    $strSvg = $this->getTreeDesc($oDs, $strFieldId, $strFieldIdp);
    

    if( !defined("ALK_B_ATYPE_ANNU") ) define("ALK_B_ATYPE_ANNU", true);
    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    
    $lastCRC = $oQueryAnnu->getCRCLastUpdateAnnu();
    $strPathFileSvg = $this->strPathUpload."organigramme_des_services_".$lastCRC.".svg";
    $strPathFilePng = $this->strPathUpload."organigramme_des_services.png";

    if( !(file_exists($strPathFileSvg) && is_file($strPathFileSvg)) ) {
      delFile($this->strPathUpload."organigramme_des_services*");
      
      $hFileSvg = @fopen($strPathFileSvg, "w+");
      if( $hFileSvg ) {
        fwrite($hFileSvg, $strSvg);
        fclose($hFileSvg); 
      } 
  
      $strPathFileThumbPng = $this->strPathUpload."organigramme_des_services-thumb.png";
  
      $strCmd = "convert -background none ".$strPathFileSvg." ".$strPathFilePng;
      exec($strCmd);
      
      $strCmd = "convert -background none ".$strPathFileSvg." -resize 200x200 ".$strPathFileThumbPng;
      exec($strCmd);
    }
    $tabSize = getImageSize($strPathFilePng);
    
    return array("image"      => $this->strUrlUpload."organigramme_des_services.png",
                 "imageSizeW" => $tabSize[0],
                 "imageSizeH" => $tabSize[1],
                 "thumb"      => $this->strUrlUpload."organigramme_des_services-thumb.png");
  }

}


?>