<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopupImportUserLdap
 * 
 * Classe de gestion de l'import des utilisateurs à partir de l'annuaire ldap
 */
class AlkHtmlSynchronisation extends AlkHtmlForm
{
    
  /** Chaîne contenant le log de l'import courant */
  protected $strLogFile;
  protected $strLogScreen;
  
  /**
   *  Constructeur par défaut
   * @param oAppli Référence sur l'appli associée
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formExport");
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE); 
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
    
    $this->strLogFile = "";   
    $this->strLogScreen = "";   
  } 
   
  /**
   *  Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit){ }
  
  /**
   *  Traitement du formulaire
   */
  public function doSql() 
  { 
    switch( $this->iMode ) {
    case "1": // etape 1
      $this->doEtape1();
    break;

    case "2": // etape 2
      $user_id = AlkFactory::getSProperty("user_id", "-1");
      $strUrlLog = AlkFactory::getUploadUrl(ALK_ATYPE_ID_ANNU).$user_id."_log_import_ldap.txt";
      $strPathLog = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU).$user_id."_log_import_ldap.txt";
      if( file_exists($strPathLog) && is_file($strPathLog) ) {
        echo _t("Etape 2").": <a href='".$strUrlLog."' target='_blank'>"._t("Télécharger le fichier de log.")."</a>";
      } else {
        echo _t("Etape 2: Terminé.");
      }
      break;
    }  
    return "";
  }  
  
  /**
   *  Retourne le titre de la poup
   * @return string
   */
  public function getTitle()
  {
    return _f("Synchronisation des utilisateurs à partir de l'annuaire %s",ALK_LDAP_NAME);
  }

  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    // type d'import 
    $service_ldapuid  = ALK_LDAP_BASE_DN_NODE_AGENTS;
    $tabAssoc = unserialize(ALK_LDAP_ASSOC_ANNU);
    $tabKeys = array_keys($tabAssoc);
    $strParam = "&ldapuid=".$service_ldapuid;
    
    // suppression du fichier de log
    $this->delLog();
    $strTokenSynch = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_UTILISATEUR, ALK_SHEET_NONE, "&iMode=1".$strParam);

    // liste des utilisateurs alkanet pour vérifier l'existance / AD 
    $strSql = $this->oAppli->oQuery->getSqlListeAgentForSearch(-1, -1, -1, -1, -1, "", -1, -1, "", -1);
    $dsUserAnnu = $this->oAppli->oQuery->GetDs($strSql);
    $nbUserAnnu = $dsUserAnnu->getCountTotDr();
    $oTabPageAnnu = AlkHtmlFactory::getHtmlList($this, $nbUserAnnu, 1, $nbUserAnnu, false, "", "", "", "tabPagineAnnu"); 
    $oTabPageAnnu->SetColumns(array("left",   "180"),array("left",   "180"));
    $j = 0;
    $nb = 0;
    while( $j < $nbUserAnnu ) {
      $drUserAnnu = $dsUserAnnu->getRowIter();
      $strAgent = "<input type='hidden' name='agent_id[]' value='".$drUserAnnu->getValueName("AGENT_ID")."'>".
        $drUserAnnu->getValueName("AGENT_PRENOM")." ".$drUserAnnu->getValueName("AGENT_NOM");
      $oTabPageAnnu->addRow($strAgent, "<div id='layerEtatAnnu[]'></div>");
      $nb++;
      $j++;
    }
      
    $nbUserAnnu = $nb;
    $oTabPageAnnu->setNbTotItems($nbUserAnnu);
    $this->addPanel($oTabPageAnnu);
      
    // liste des services pour synchroniser les chefs de services
    $dsServiceMangers = $this->oAppli->oQuery->getDsLdapListService();
    $nbServiceMangers = $dsServiceMangers->getCountTotDr();
    $oTabPageMangers = AlkHtmlFactory::getHtmlList($this, $nbServiceMangers, 1, $nbServiceMangers, false, "", "", "", "tabPagineServices"); 
    $oTabPageMangers->SetColumns(array("left",   "180"), array("left",   "200"), array("left",   "120"),array("left",   "120"));  
    $k=0;
    while( $k < $nbServiceMangers ) {
      $manager_id = -1;
      $AgentKey_id = "";
      $strKey = "";
      $service_intitule = "";
      $drServiceMangers = $dsServiceMangers->getRowIter();
      $strService = $drServiceMangers->getValueName("DN");
      
      $strDnServiceSplit = str_replace(",", "", $strService);
      $tabDn = spliti("ou=",$strDnServiceSplit);
      if( is_array($tabDn) && count($tabDn)>2 ) {  
        $strServiceLdapuid = "CN=".$tabDn[1].",".$strService;
      } 
      
      $service_intitule = $this->oAppli->oQuery->get_IntituleServByldapUid($strServiceLdapuid);
      $service_id = $this->oAppli->oQuery->get_IdServByldapUid($strServiceLdapuid);
      if( $drServiceMangers->getValueName("managedby") != "" ) {
        $strCnUser = $drServiceMangers->getValueName("managedby");
        //recherche le key du dn de l'utilisateur
        $AgentKey_id = $this->oAppli->oQuery->getAgentKeyFromLdapDn($strCnUser);
        $dsUserAgent = $this->oAppli->oQuery->getDsUserInfoByLdapKey($AgentKey_id, $tabAssoc[$tabKeys[0]]["field"]);
        if( $drUserAgent = $dsUserAgent->getRowIter() ) {
           $manager_id = $drUserAgent->getValueName("AGENT_ID");
        }
        //afiche le key de l'utilisateur et le service associé
        
      }
      $strServiceManger = "<input type='hidden' name='service_id[]' value='".$service_id."'><input type='hidden' name='manager_id[]' value='".$manager_id."'>".$AgentKey_id;
        $oTabPageMangers->addRow($service_intitule, $strService, $strServiceManger, "<div id='layerEtatLdap[]'></div>");
      $k++;
    }
    $oTabPageMangers->setNbTotItems($nbServiceMangers);
    $this->addPanel($oTabPageMangers);  
      
    // Liste des utilisateurs AD pour vérifier l'existance dans alkanet
    $dsUserLdap = $this->oAppli->oQuery->getDsLdapListUsers($service_ldapuid);
    if( $dsUserLdap->isConnected() ) {
      $nbUser = $dsUserLdap->getCountTotDr();
    } else {
      $nbUser = -2;
    }
    
    if( $nbUser == -2 ) {
      $strHtmlHeader = "<div id='layerHeader' style='padding-top:40px;' align='center'>".
        _f("Impossible de se connecter à l'annuaire %s", ALK_LDAP_NAME).".</div>";
    } 
    else {
      $strHtmlHeader = "<div id='layerHeader' align='left'>".
        "<div id='layerEtape4'>"._t("Synchronisation des utilisateurs").": <a href=\"javascript:execEtape('".
        $strTokenSynch."',".$nbUser.",".$nbUserAnnu.",'".$nbServiceMangers."','".$tabAssoc[$tabKeys[0]]["field"]."')\">".
        _f("Lancer la synchronisation de l'annuaire %s vers cet annuaire.", ALK_LDAP_NAME)."</a></div>".
        "<div id='layerEtape5' style='display: none;'></div>".
        "</div>";
      
      $strMsgNone = _f("Aucun utilisateur n'est présent dans l'annuaire %s %nl dans le service identifié par %s", 
                     ALK_LDAP_NAME, "<br/>", $service_ldapuid);

      $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbUser, 1, $nbUser, false, "", $strMsgNone, "", "tabPagineLdap"); 
      $oTabPage->SetColumns(array("left",   "180"),array("left",   "180"));

      $i = 0;
      $nb = 0;
      while( $i < $nbUser ) {
        $strKey = "";
        $drUserLdap = $dsUserLdap->getRowIter();
        if( $drUserLdap ) {
          $strKey = $drUserLdap->getValueName($tabAssoc[$tabKeys[0]]["field"]);
        }
        
        if( $strKey != "" ) {
          $strAgent = "<input type='hidden' name='agent_key[]' value='".$strKey."'>".
            $drUserLdap->getValueName($tabAssoc["givenname"]["field"])." ".
            $drUserLdap->getValueName($tabAssoc["sn"]["field"]);
          $oTabPage->addRow($strAgent, "<div id='layerEtatLdap[]'></div>");
          $nb++;
        }
        $i++;
      }
      
      $nbUser = $nb;
      $nbUserAnnu = 0;
      $oTabPage->setNbTotItems($nbUser);
      $this->addPanel($oTabPage);
    }
          
    $this->setLabelDesc($strHtmlHeader);
        
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlsynchronisation.js");
    $this->setTemplate("annu", "alkhtmlformsychronisation.tpl");
  }
   
  /**
   * Ajoute un log
   * @param iTypeAction  identifiant du type de l'action  0=rien, 1=màj fiche, 2=ajout fiche, 3=màj fiche et filiation arrive, 4: màj fiche + filiation départ
   * @param strMail      adresse mail de la personne traitée
   * @param strMsg       message complémentaire à l'action
   */  
  private function addLog($iLevel, $strMail, $strMsg)
  {
    $this->strLogFile = $iLevel."\t".$strMail."\t".$strMsg."\r\n";
    $this->strLogScreen = $strMsg;
  }

  /**
   * Suppression du fichier de log 
   */
  private function delLog()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");

    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU);
    delFile($strPathUpload.$user_id."_log_import_ldap.txt");
  }

  /**
   * Enregistrement du log courant dans le fichier associé par concaténation 
   */
  private function saveLog()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");

    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU);
    $hFile = @fopen($strPathUpload.$user_id."_log_import_ldap.txt", "a+");
    if( $hFile ) {
      @fwrite($hFile, $this->strLogFile);
      fclose($hFile); 
    } 
  }
  
  /**
   * Execute l'étape 2 de l'import LDAP
   */
  private function doEtape1()
  {
    // nom du td contenant l'info à afficher
    $iModeSync = AlkRequest::_GET("modeSync", "");
    $strTdName = AlkRequest::_GET("td", "");
    $strKeyValue = AlkRequest::_GET("key", "");
    $strKeyField = AlkRequest::_GET("field", "");
    $agent_id_quit = AlkRequest::_GETint("ida", "-1");
    $iFinSync = AlkRequest::_GETint("iFinSync", "-1");
    
    $bDoAdd        = false;
    $bDoUpdate     = false;
    $bDoNothing    = false;
    $bUserQuitServ = false;
    $bInService    = true;
    $bUpdate = false;
    
    $tabAssoc = unserialize(ALK_LDAP_ASSOC_ANNU);
    $tabKeys = array_keys($tabAssoc);
    $strTokenSynch = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_UTILISATEUR, ALK_SHEET_NONE, "&iMode=1");
    $strHtmlHeader = "Fin de la synchronisation: <a href=\"".ALK_ALKANET."?token=".$strTokenSynch."\">Retourner au mode synchronisation.</a>";
    
    if($iModeSync == 0){
    
      // recherche l'agent dans l'annaire alkante
      $dsUser = $this->oAppli->oQuery->getDsUserInfoByLdapKey($strKeyValue, $strKeyField);
      $nbUser = $dsUser->getCountTotDr();
      $bDoAdd     = ( $nbUser == 0 );
      $bDoUpdate  = ( $nbUser == 1 );
      $bDoNothing = ( $nbUser >  1 );
      
      $tabAssoc = unserialize(ALK_LDAP_ASSOC_ANNU);
  
      // Recherche des information sur le service de l'utilisateur dans LDAP -- Pour l'instant le premier service est pris en compte
      $dsUserLdap = $this->oAppli->oQuery->getDsLdapUserInfo($strKeyValue);
      $strLdapUid = "";
      if( $drUserLdap = $dsUserLdap->getRowIter() ) {
        $serviceLdapUid = $drUserLdap->getValueName("SERVICE_LDAPUID");
         if(is_array($serviceLdapUid)){
           for ($i=0;$i< count($serviceLdapUid)-1;$i++){
            $pos = stripos($serviceLdapUid[$i], ALK_LDAP_BASE_DN_NODE_SERV);
            if($pos !== false){
              $strLdapUid = $serviceLdapUid[$i];
              $i = count($serviceLdapUid);
            }         
           }
         }else{
            $pos = stripos($serviceLdapUid, ALK_LDAP_BASE_DN_NODE_SERV);
            if($pos !== false){
              $strLdapUid = $serviceLdapUid;
            }
         }
      }
      //si pas de service alors ne rien faire
      if($strLdapUid == "" || ($this->oAppli->oQuery->get_IdServByldapUid($strLdapUid) == -1)  ){
        $bDoAdd        = false;
        $bDoUpdate     = false;
        $bDoNothing    = false;
        $bInService    = false;
      }else{
        $service_id  = $this->oAppli->oQuery->get_IdServByldapUid($strLdapUid);
        $tabServTree = $this->oAppli->oQuery->getTabServiceTree($service_id, $strLdapUid, "");
        $serv_niv1 = ( count($tabServTree)>1 ? $tabServTree[1] : "-1" ); 
        $serv_niv2 = ( count($tabServTree)>2 ? $tabServTree[2] : "-1" ); 
        $serv_niv3 = ( count($tabServTree)>3 ? $tabServTree[3] : "-1" ); 
        $serv_niv4 = ( count($tabServTree)>4 ? $tabServTree[4] : "-1" ); 
  
        $tabQuery = array();
        // valeurs par défaut pour les champs complémentaires nécessaires à l'ajout et à la màj
        $tabQuery["SERVICE_ID"]     = array(ALK_SQL_NUMBER, $serv_niv1);
        $tabQuery["AGENT_CIVILITE"] = array(ALK_SQL_TEXT,   "");
        $tabQuery["AGENT_PRIV"]     = array(ALK_SQL_NUMBER, "0");
        $tabQuery["AGENT_VALIDE"]   = array(ALK_SQL_NUMBER, "1");
        $tabQuery["AGENT_ADMINAUTH"]= array(ALK_SQL_NUMBER, "0");
        $tabQuery["PROFIL_ID"]      = array(ALK_SQL_NUMBER, "1");
        $tabQuery["SERV_NIV2"]      = array(ALK_SQL_NUMBER, $serv_niv2);
        $tabQuery["SERV_NIV3"]      = array(ALK_SQL_NUMBER, $serv_niv3);
        $tabQuery["SERV_NIV4"]      = array(ALK_SQL_NUMBER, $serv_niv4);
      }
                
      if( $bDoUpdate && ($drUser = $dsUser->getRowIter()) ) {
        // lecture des informations courantes de l'annuaire alkanet
        foreach($tabAssoc as $strLdapKey => $tabAnnu) {
          if( $tabAnnu["table"] == "SIT_AGENT" || $tabAnnu["table"] == "SIT_ADRESSE" ) {
            $tabQuery[$tabAnnu["field"]] = array(ALK_SQL_TEXT, $drUser->getValueName($tabAnnu["field"]));          
          } 
        }
        // champs complémentaires nécessaires à l'ajout et à la màj
        $tabQuery["SERVICE_ID"]     = array(ALK_SQL_NUMBER, $drUser->getValueName("SERVICE_ID"));
        //$tabQuery["AGENT_CIVILITE"] = array(ALK_SQL_TEXT,   $drUser->getValueName("AGENT_CIVILITE"));
        $tabQuery["AGENT_PRIV"]     = array(ALK_SQL_NUMBER, $drUser->getValueName("AGENT_PRIV"));
        $tabQuery["AGENT_VALIDE"]   = array(ALK_SQL_NUMBER, $drUser->getValueName("AGENT_VALIDE"));
        $tabQuery["PROFIL_ID"]      = array(ALK_SQL_NUMBER, $drUser->getValueName("PROFIL_ID"));
        $agent_id = $drUser->getValueName("AGENT_ID");
      
        //Voir si à quiter le service
        $servldapuid = $this->oAppli->oQuery->getServiceLdapUidByAgent($agent_id);  
      
        $bUserQuitServ = ( $agent_id == $agent_id_quit );
      }
          
      if( $bDoAdd || $bDoUpdate ) {
        // chargement de la fiche utilisateur ldap
        $dsLdapUser = $this->oAppli->oQuery->getDsLdapUserInfo($strKeyValue, ALK_LDAP_BASE_DN_NODE_AGENTS);
        $nbLdapUser = $dsLdapUser->getCountTotDr();
        if( $nbLdapUser == 1 && ($drLdapUser = $dsLdapUser->getRowIter()) ) {
          foreach($tabAssoc as $strLdapKey => $tabAnnu) {
            if( $tabAnnu["table"] == "SIT_AGENT" || $tabAnnu["table"] == "SIT_ADRESSE" ) {
              $strValue = trim($drLdapUser->getValueName($tabAnnu["field"]));
              if( $bDoAdd || $bDoUpdate /*&& $strValue != ""*/ ) {
                $tabQuery[$tabAnnu["field"]] = array(ALK_SQL_TEXT, $strValue);
              }
            } 
          }
          $tabQuery["AGENT_LDAP"] = array(ALK_SQL_NUMBER, 1);
          
          // enregistrement
          if( $bDoAdd ) {
            // ajout de l'utilisateur
            $tabFields = array("field" => $tabQuery, "pk" => array());
            $agent_id = $this->oAppli->addUser($tabFields);
            $this->addLog(2, $strKeyValue, "Fiche ajoutée.");
          } elseif( $bDoUpdate && $agent_id != "-1" ) {
            // modif de l'utilisateur
            $tabQuery["ALK_B_IMPORT"]    = array(ALK_SQL_NONE, 1);
            $tabQuery["AGENT_VALIDEMEM"] = array(ALK_SQL_NUMBER, $tabQuery["AGENT_VALIDE"][1]);
            //$tabQuery["AGENT_LOGIN"]     = array(ALK_SQL_NONE, "");
            $tabQuery["AGENT_LOGINMEM"]  = array(ALK_SQL_NONE, "");
            $tabQuery["PROFIL_IDMEM"]    = array(ALK_SQL_NUMBER, $tabQuery["PROFIL_ID"][1]);
            unset($tabQuery["AGENT_ADMINAUTH"]);
            unset($tabQuery["SERV_NIV2"]);
            unset($tabQuery["SERV_NIV3"]);
            unset($tabQuery["SERV_NIV4"]);
            $tabFields = array("field" => $tabQuery, "pk" => array("AGENT_ID" => array(ALK_SQL_NUMBER, $agent_id)));
            $this->oAppli->updateUser($agent_id, $tabFields);
            
            if( $bUserQuitServ ) {
              // traitement d'un utilisateur qui n'est plus présent sur le service sélectionné
              // recherche le service alkanet correspondant service ldap identifié par $servldapuid 
              $tabServLdapTree = $this->oAppli->oQuery->getTabServiceTree("-1", $servldapuid, "");
              $serv_niv1 = ( count($tabServLdapTree)>1 ? $tabServLdapTree[1] : "-1" ); 
              $serv_niv2 = ( count($tabServLdapTree)>2 ? $tabServLdapTree[2] : "-1" ); 
              $serv_niv3 = ( count($tabServLdapTree)>3 ? $tabServLdapTree[3] : "-1" ); 
              $serv_niv4 = ( count($tabServLdapTree)>4 ? $tabServLdapTree[4] : "-1" ); 
              if( $serv_niv1 != "-1") {
                $this->oAppli->oQueryAction->delAddFiliation($agent_id, "-1", $serv_niv1, $serv_niv2, $serv_niv3, $serv_niv4);
                $this->addLog(4, $strKeyValue, _f("Fiche modifiée. Filiation modifiée. L'utilisateur quitte ce service vers %s", $servldapuid));
              } else {
                $this->addLog(5, $strKeyValue, _f("Fiche modifiée. L'utilisateur n'appartient plus à ce service. Filiation non modifiée car %s n'a pas de correspondance unique dans cet annuaire.", $servldapuid));
              }
            } else {
              // traitement d'un utilisateur qui intègre le service sélectionné
              if( $servldapuid == $strLdapUid ) {
                // pas de modification de filiation
                $this->addLog(1, $strKeyValue, _t("Fiche modifiée."));
              } else {
                // recherche du service alkanet dans ldap, si il n'existe pas, alors on ne change pas la filiation 
                $tabServLdapTree = $this->oAppli->oQuery->getTabServiceTree("-1", $strLdapUid, "");
                $serv_niv1 = ( count($tabServLdapTree)>1 ? $tabServLdapTree[1] : "-1" ); 
                $serv_niv2 = ( count($tabServLdapTree)>2 ? $tabServLdapTree[2] : "-1" ); 
                $serv_niv3 = ( count($tabServLdapTree)>3 ? $tabServLdapTree[3] : "-1" ); 
                $serv_niv4 = ( count($tabServLdapTree)>4 ? $tabServLdapTree[4] : "-1" );
                 
                if( $serv_niv1 != "-1") {
                  $this->oAppli->oQueryAction->delAddFiliation($agent_id, "-1", $serv_niv1, $serv_niv2, $serv_niv3, $serv_niv4);
                  $this->addLog(3, $strKeyValue, _t("Fiche modifiée. Filiation modifiée."));
                  $bUpdate = true;
                } else {
                  $this->addLog(6, $strKeyValue, _f("Fiche modifiée. Filiation non modifiée. L'utilisateur est actuellement associé à un service non lié à %s", ALK_LDAP_NAME));
                  $bUpdate = true;
                }
              }
            }
          } else {
            $this->addLog(0, $strKeyValue, _f("Aucun traitement. Pas de fiche utilisateur unique correspondant à la clé dans l'annuaire %s", ALK_S_DSIT));
            $bUpdate = true;       
          }
        } else {
          if( $dsLdapUser->isConnected() ) {
            $this->addLog(0, $strKeyValue, _f("Aucun traitement. Pas de fiche utilisateur unique correspondant à la clé dans l'annuaire %s.", ALK_LDAP_NAME));
            $bUpdate = true;
          } else {
            $this->addLog(0, $strKeyValue, _f("Aucun traitement. Impossible de se connecter à l'annuaire %s.", ALK_LDAP_NAME));
            $bUpdate = true;
          }         
        }
      } else {
        if($bInService){
           $this->addLog(0, $strKeyValue, _f("Aucun traitement. Pas de fiche utilisateur unique correspondant à la clé dans l'annuaire %s.", ALK_S_DSIT));
           $bUpdate = true;
         }else{
           $this->addLog(0, $strKeyValue, _f("Aucun traitement. L'utilisateur n'est pas lié à un service %s.",ALK_LDAP_NAME));
           $bUpdate = true;
         }
      }
    }else{
      if($iModeSync == 1){
        $dsAgent = $this->oAppli->oQuery->GetStrDs_ficheAgentMail($strKeyValue, true, true, true);
        if( $drAgent = $dsAgent->getRowIter())  {
          $strAgentKey = $drAgent->getValueName($strKeyField);
        }
        $dsUserLdapInfo = $this->oAppli->oQuery->getDsLdapUserInfo($strAgentKey);
        if( $drUserLdapInfo = $dsUserLdapInfo->getRowIter() || ( $strKeyValue < 10 ) ){
          $this->addLog(0, $strKeyValue, _t("Aucun traitement."));
        }else{
          $this->oAppli->delUser($strKeyValue);
          $this->addLog(0, $strKeyValue, _f("Utilisateur %s supprimé.", $strAgentKey));
          $bUpdate = true;
        }        
      }else{
        $manager_id = AlkRequest::_GETint("manager_id", "-1");
        $service_id = AlkRequest::_GETint("service_id", "-1");
        if($manager_id != "-1" && $service_id != "-1"){
          $this->oAppli->oQueryAction->addServiceManager($service_id, $manager_id);
          $this->addLog(0, $strKeyValue, _t("Responsable modifié"));
        }else{
          $bUpdate = true;
          if($manager_id == "-1")
            $this->addLog(0, $strKeyValue, _t("Aucun responsable"));
          if($service_id == "-1")
            $this->addLog(0, $strKeyValue, _t("Service à synchroniser"));
        }
      }
    }
    // enregistre le log
    $this->saveLog();
    
    // retour ajax sur le rendu de l'opération
    if( $strTdName != "" ) { 
      $strHtmlJs = " var oLayer = document.getElementById('".$strTdName."');".
        " if( oLayer ) {".
        "   oLayer.className = ".( ($bUpdate) ? "'select'" : "'ko'" ).";".
        "   oLayer.innerHTML = \"".$this->strLogScreen."\";".
        " }".
        " oLayer = document.getElementById('layerEtape4');".
        " if( oLayer ) {".
        "   oLayer.innerHTML = \"".( ($iFinSync != -1) ? addslashes($strHtmlHeader) : "" )."\";".
        " }";
      echo $strHtmlJs;
    }   
  }
}

?>