<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopupImportUserLdap
 * 
 * Classe de gestion de l'import des utilisateurs à partir de l'annuaire ldap
 */
class AlkHtmlPopupImportUserLdap extends AlkHtmlForm
{
    
  /** Chaîne contenant le log de l'import courant */
  protected $strLogFile;
  protected $strLogScreen;
  
  protected $tabAssoc;
  
  /**
   *  Constructeur par défaut
   * @param oAppli Référence sur l'appli associée
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formExport");
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE); 
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
    
    $this->strLogFile = "";   
    $this->strLogScreen = "";   
    
    $this->tabAssoc = unserialize(ALK_LDAP_ASSOC_ANNU);
  } 
   
  /**
   *  Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit){ }
  
  /**
   *  Traitement du formulaire
   */
  public function doSql() 
  { 
    switch( $this->iMode ) {
    case "4": // etape 4
      $this->doEtape4();
      break;

    case "5": // etape 5
      $user_id = AlkFactory::getSProperty("user_id", "-1");
      $strUrlLog = AlkFactory::getUploadUrl(ALK_ATYPE_ID_ANNU).$user_id."_log_import_ldap.txt";
      $strPathLog = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU).$user_id."_log_import_ldap.txt";
      if( file_exists($strPathLog) && is_file($strPathLog) ) {
        echo "Etape 5: <a href='".$strUrlLog."' target='_blank'>Télécharger le fichier de log.</a>";
      } else {
        echo "Etape 5: Terminé.";
      }
      break;
    }  
    return "";
  }  
  
  /**
   *  Retourne le titre de la poup
   * @return string
   */
  public function getTitle()
  {
    return _f("Import des utilisateurs à partir de l'annuaire %s", ALK_LDAP_NAME);
  }

  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $iSendMail = AlkRequest::_POST("sendMailUser", "0");
    
    // type d'import 
    $iTypeImport = AlkRequest::getToken("imp", "0");
    $tabMailImport = array();
    $bImport = false;

    $tabKeys = array_keys($this->tabAssoc);
    $strLdapKey = $this->tabAssoc[$tabKeys[0]]["field"];
    
    if( $iTypeImport == "1" ) {
      $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU, true);
      $strFullPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU);
      $strFileName = doUpload("imp_fic", $user_id."_", $strPathUpload);
      if( is_string($strFileName) ) {
        $tabMailImport = file($strFullPathUpload.$strFileName);
        if( !$this->verifTabMail($tabMailImport) ) {
          $this->setLabelDesc("<br/><br/>"._t("Le fichier ne doit comporter que des adresses courriels (une par ligne)").
                              ".<br/><br/>"._t("Import annulé."));
          return;
        }
        $bImport = true;
      } else {
        $this->setLabelDesc("<br/><br/>"._t("Impossible d'uploader le fichier.")."<br/><br/>"._t("Import annulé."));
        return;
      }
    }

    // caractéristique du service sélectionné
    $service_id       = AlkRequest::getToken("ids", "-1");
    if( $bImport && AlkFactory::isAnnuAdminServ() ) {
      // les administrateurs de services sont restreints à leur service de niveau 1 en import par mail
      $service_id = AlkFactory::getSProperty("service_id", "-1");
    }
    
    $service_niveau   = AlkRequest::getToken("niv", "1");
    $service_intitule = $this->oAppli->oQuery->getStr_ServiceSigle($service_id, false);
    $service_ldapuid  = AlkRequest::_GET("ldapuid", "");
    $service_ldapdn   = AlkRequest::_GET("ldapdn", "");
    
    $strParam = "&niv=".$service_niveau."&ldapuid=".$service_ldapuid."&ldapdn=".$service_ldapdn."&imp=".$iTypeImport.
      ( !$bImport || $bImport && $service_id!=-1 ? "&ids=".$service_id : "" );
    
    // suppression du fichier de log
    $this->delLog();
        
    $strTokenEtape4 = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_IMPORT_USER, ALK_SHEET_NONE, "&iMode=4".$strParam);
    $strTokenEtape5 = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_IMPORT_USER, ALK_SHEET_NONE, "&iMode=5");
    $idLastTd = "1";
    
    $oCtrlCBMail = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "iCheckMail", $iSendMail, "");

    $oCtrlService = null;
    if( $bImport ) {
      $oCtrlService = AlkHtmlFactory::getNewHtmlSelect(null, 0, "idss", $service_id, "", 1, 450);
      $oCtrlService->setProperty("tabValTxtDefault", array("-1", _t("Sélectionnez un service cible")));
      $oCtrlService->setProperty("oValTxt", $this->oAppli->oQuery->getDsListeServiceForCombo());
      $oCtrlService->setMode( $service_id==-1 ? 0 : 1 );
    }
    
    if( $bImport ) {
      $nbUser = count($tabMailImport);
    } else {
      $dsUserLdap = $this->oAppli->oQuery->getDsLdapListUserFromServ($service_ldapdn, $service_ldapuid, $strLdapKey);
      if( $dsUserLdap->isConnected() ) {
        $nbUser = $dsUserLdap->getCountTotDr();
      } else {
        $nbUser = -2;
      }
    } 
    
    if( $nbUser == -2 ) {
      $strHtmlHeader = "<div id='layerHeader' style='padding-top:40px;' align='center'>".
        _f("Impossible de se connecter à l'annuaire %s",ALK_LDAP_NAME).".</div>";
    } 
    else {
      $strHtmlHeader = "<div id='layerHeader' align='left'>".
        ( $bImport
          ? "<div style='margin-bottom:4px;'>"._f("Si aucune correspondance %s n'est trouvée", ALK_LDAP_NAME).",<br/>".
            _f(" les utilisateurs seront importés vers le service de niveau 1 : %s",$oCtrlService->getHtml())."</div>"
          : "<div style='margin-bottom:4px;'>"._f("Import vers le service de niveau %s : %s", $service_niveau,$service_intitule )."</div>" ).
          _f("Etape 1: Chargement des utilisateurs appartenant au service %s %s de l'annuaire %s terminé", $service_intitule, $service_ldapuid, ALK_LDAP_NAME)."<br/>".
          _f("Etape 2: Veuillez sélectionner les utilisateurs à synchroniser en cochant les cases associées.")."<br/>".
          _f("Etape 3: Cochez la case suivante si vous souhaitez envoyer un courriel à chaque utilisateur ajouté à cet annuaire ").$oCtrlCBMail->getHtml().
          "<div id='layerEtape4'>Etape 4: <a href=\"javascript:execEtape('".
          $strTokenEtape4."', '".$strTokenEtape5."', '".$idLastTd."', ".( $bImport && $service_id==-1 ? "1" : "0" ).")\">".
          _f("Lancer la synchronisation de l'annuaire %s vers cet annuaire", ALK_LDAP_NAME).".</a></div>".
          "<div id='layerEtape5' style='display: none;'></div>".
          "</div>";
      
      
      $strMsgNone = _f("Aucun utilisateur n'est présent dans l'annuaire %s %nl dans le service identifié par %s", ALK_LDAP_NAME, "<br/>", $service_ldapuid);
    
      $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbUser, 1, $nbUser, false, "", $strMsgNone); 
      $oTabPage->SetColumns(array("left",   "400"),
                            array("left",   "300"),
                            array("center", "70"));
      
      $oCtrlCBAll = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "iCheckAll", 0, "");
      $oCtrlCBAll->addEvent("onclick", "SelectAllCB()");
                                  
      $oTabPage->AddTitleRow(array(_f("Liste des utilisateurs liés au service %s ( %s )", ALK_LDAP_NAME, $nbUser), 2, 1), "Sélection");
      $oTabPage->AddTitleRow(_t("Identifiant"), _t("Etat"), $oCtrlCBAll->getHtml());
      $tabKey = array();
      $i = 0;
      $nb = 0;
      
      while( $i < $nbUser ) {
        $agent_key = "";
        if( $bImport ) {
          $agent_key = trim($tabMailImport[$i]);
        } else {
          $drUserLdap = $dsUserLdap->getRowIter();
          if( $drUserLdap ) {
            $agent_key = $drUserLdap->getValueName($strLdapKey);
          }
        }
        if( $agent_key != "" ) {
          
          if( $agent_key != "mail@complementaire.com" ) {
            $strAgent = $agent_key;
            $tabKey[$agent_key] = true; 
            $oCtrlCB = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "agent_key[]", "", "", $agent_key);
          } else {
            $strAgent = "";
            $oCtrlCB = AlkHtmlFactory::getNewHtmlHidden(null, "agent_key[]", "");
          }
          $strAgent .= "<input type='hidden' name='agent_id[]' value=''>";
          $oTabPage->addRow($strAgent, "<div id='layerEtat[]'></div>", $oCtrlCB->getHtml());
          $nb++;
        }
        $i++;
      }
      $nbUser = $nb;
    
      $nbUserAnnu = 0;
      if( !$bImport ) {
        $dsUserLdap = $this->oAppli->oQuery->getDsListUserByServ($service_id);
        while( $drUserLdap = $dsUserLdap->getRowIter() ) {
          $agent_id     = $drUserLdap->getValueName("AGENT_ID");
          $agent_key   = $drUserLdap->getValueName($strLdapKey);
          
          if( !array_key_exists($agent_key, $tabKey) ) {
            $strAgent = $agent_key.
              "<input type='hidden' name='agent_id[]' value='".$agent_id."'>".
              "<input type='hidden' name='agent_key[]' value='".$agent_key."'>";
            if( $nbUserAnnu == 0 ) {
              // ajout séparation
              $oTabPage->addRow(array(_f("Liste des utilisateurs liés au service %s sélectionné et non présent dans %s", ALK_S_DSIT, ALK_LDAP_NAME), 2, 1, _t("entete")));
              $nbUserAnnu++;
            }
            
            $oTabPage->addRow($strAgent, "<div id='layerEtat[]'></div>");
            $nbUserAnnu++;
          }
        }
      }
      $oTabPage->setNbTotItems($nbUserAnnu+$nbUser);
      
      $this->addPanel($oTabPage);
    }
      
    $this->setLabelDesc($strHtmlHeader);
        
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlpopupimportuserldap.js");
  }
  
  /**
   * Vérifie le tableau passé en paramètre.
   * Il doit comporter au moins 1 ligne. Chaque ligne une adresse mail valide.
   * Retourne true si ok, false sinon
   * @param tabMailImport  tableau d'import
   * @return boolean 
   */
  private function verifTabMail(&$tabMailImport)
  {
    if( count($tabMailImport)<1 )
      return false;

    $strRegexp = "^([-!#\$%&'*+./0-9=?A-Z^_`a-z{|}~^?])".
      "+@([-!#\$%&'*+/0-9=?A-Z^_`a-z{|}~^?]+\\.)+[a-zA-Z]{2,6}\$";
    $bOk = true;
    $tabMailRes = array();
    foreach($tabMailImport as $strMail) {
      $strMail = trim($strMail);
      if( $strMail != "" && mb_eregi($strRegexp, $strMail) != 0 ) {
        $tabMailRes[] = $strMail;
      }
    }
    $bOk = !empty($tabMailRes);
    if( count($tabMailRes)==1 ) {
      $tabMailRes[] = "mail@complementaire.com";
    }
    $tabMailImport = $tabMailRes;
    
    return $bOk;
  }
  
  /**
   * Ajoute un log
   * @param iTypeAction  identifiant du type de l'action  0=rien, 1=màj fiche, 2=ajout fiche, 3=màj fiche et filiation arrive, 4: màj fiche + filiation départ
   * @param strMail      adresse mail de la personne traitée
   * @param strMsg       message complémentaire à l'action
   */  
  private function addLog($iLevel, $strMail, $strMsg)
  {
    $this->strLogFile = $iLevel."\t".$strMail."\t".$strMsg."\r\n";
    $this->strLogScreen = $strMsg;
  }

  /**
   * Suppression du fichier de log 
   */
  private function delLog()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");

    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU);
    delFile($strPathUpload.$user_id."_log_import_ldap.txt");
  }

  /**
   * Enregistrement du log courant dans le fichier associé par concaténation 
   */
  private function saveLog()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");

    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU);
    $hFile = @fopen($strPathUpload.$user_id."_log_import_ldap.txt", "a+");
    if( $hFile ) {
      @fwrite($hFile, $this->strLogFile);
      fclose($hFile); 
    } 
  }
  
  /**
   * Execute l'étape 2 de l'import LDAP
   */
  private function doEtape4()
  {
    // nom du td contenant l'info à afficher
    $strTdName = AlkRequest::_GET("t", "");
    $cpt       = AlkRequest::_GET("cpt", "-1");
    $cptMax    = AlkRequest::_GET("nb", "-1");
    $iSendMail = AlkRequest::_GET("sm", "0");
    
    // fixe l'envoi de mail
    $this->oAppli->setSendMail($iSendMail=="1");
    
    // info sur le service courant
    $service_id      = AlkRequest::getToken("ids", AlkRequest::_GETint("ids", "-1"));
    $service_niveau  = AlkRequest::getToken("niv", "1");
    $service_ldapuid = AlkRequest::getToken("ldapuid", "");
    $service_ldapdn  = AlkRequest::getToken("ldapdn", "");
    
    $tabServTree = $this->oAppli->oQuery->getTabServiceTree($service_id, $service_ldapuid, $service_ldapdn);
    $serv_niv1 = ( count($tabServTree)>1 ? $tabServTree[1] : "-1" ); 
    $serv_niv2 = ( count($tabServTree)>2 ? $tabServTree[2] : "-1" ); 
    $serv_niv3 = ( count($tabServTree)>3 ? $tabServTree[3] : "-1" ); 
    $serv_niv4 = ( count($tabServTree)>4 ? $tabServTree[4] : "-1" ); 
    
    // info sur l'utilisateur ldap sélectionné
    $agent_key = AlkRequest::_GET("m", "");
    $agent_id   = "-1";
    
    // info sur l'utilisateur alkanet n'ayant pas de correspondance dans ldap sur le service sélectionné
    $agent_id_quit = AlkRequest::_GETint("ida", "-1");
    
    $bDoAdd        = false;
    $bDoUpdate     = false;
    $bDoNothing    = false;
    $bUserQuitServ = false;
    
    // recherche l'agent dans l'annaire alkante
    $tabLdapKeys = array_keys($this->tabAssoc);
    $strLdapKey = $this->tabAssoc[$tabLdapKeys[0]]["field"];
    
    $dsUser = $this->oAppli->oQuery->getDsUserInfoByLdapKey($agent_key, $strLdapKey);
    $nbUser = $dsUser->getCountTotDr();
    $bDoAdd     = ( $nbUser == 0 );
    $bDoUpdate  = ( $nbUser == 1 );
    $bDoNothing = ( $nbUser >  1 );

    $tabQuery = array();
    // valeurs par défaut pour les champs complémentaires nécessaires à l'ajout et à la màj
    $tabQuery["SERVICE_ID"]     = array(ALK_SQL_NUMBER, $serv_niv1);
    $tabQuery["AGENT_CIVILITE"] = array(ALK_SQL_TEXT,   "");
    $tabQuery["AGENT_PRIV"]     = array(ALK_SQL_NUMBER, "0");
    $tabQuery["AGENT_VALIDE"]   = array(ALK_SQL_NUMBER, "1");
    $tabQuery["PROFIL_ID"]      = array(ALK_SQL_NUMBER, "1");
    $tabQuery["SERV_NIV2"]      = array(ALK_SQL_NUMBER, $serv_niv2);
    $tabQuery["SERV_NIV3"]      = array(ALK_SQL_NUMBER, $serv_niv3);
    $tabQuery["SERV_NIV4"]      = array(ALK_SQL_NUMBER, $serv_niv4);
          
    if( $bDoUpdate && ($drUser = $dsUser->getRowIter()) ) {
      // lecture des informations courantes de l'annuaire alkanet
      foreach($this->tabAssoc as $strLdapKey => $tabAnnu) {
        if( $tabAnnu["table"] == "SIT_AGENT" || $tabAnnu["table"] == "SIT_ADRESSE" ) {
          $tabQuery[$tabAnnu["field"]] = array(ALK_SQL_TEXT, $drUser->getValueName($tabAnnu["field"]));          
        } 
      }
      // champs complémentaires nécessaires à l'ajout et à la màj
      $tabQuery["SERVICE_ID"]     = array(ALK_SQL_NUMBER, $drUser->getValueName("SERVICE_ID"));
      $tabQuery["AGENT_CIVILITE"] = array(ALK_SQL_TEXT,   $drUser->getValueName("AGENT_CIVILITE"));
      $tabQuery["AGENT_PRIV"]     = array(ALK_SQL_NUMBER, $drUser->getValueName("AGENT_PRIV"));
      $tabQuery["AGENT_VALIDE"]   = array(ALK_SQL_NUMBER, $drUser->getValueName("AGENT_VALIDE"));
      $tabQuery["PROFIL_ID"]      = array(ALK_SQL_NUMBER, $drUser->getValueName("PROFIL_ID"));
      $agent_id = $drUser->getValueName("AGENT_ID");
      $bUserQuitServ = ( $agent_id == $agent_id_quit );
    }
        
    if( $bDoAdd || $bDoUpdate ) {
      // chargement de la fiche utilisateur ldap
      if(!ALK_B_LDAP_AD){
        $dsLdapUser = $this->oAppli->oQuery->getDsLdapUserInfo($agent_key, ($bUserQuitServ ? "" : $service_ldapdn));
      }else{
        $dsLdapUser = $this->oAppli->oQuery->getDsLdapUserInfo($agent_key, ALK_LDAP_BASE_DN_NODE_AGENTS);
      }
      
      $nbLdapUser = $dsLdapUser->getCountTotDr();
      if( $nbLdapUser == 1 && ($drLdapUser = $dsLdapUser->getRowIter()) ) {
        foreach($this->tabAssoc as $strLdapKey => $tabAnnu) {
          if( $tabAnnu["table"] == "SIT_AGENT" || $tabAnnu["table"] == "SIT_ADRESSE" ) {
            $strValue = trim($drLdapUser->getValueName($tabAnnu["field"]));
            if( $bDoAdd || $bDoUpdate && $strValue != "" ) {
              $tabQuery[$tabAnnu["field"]] = array(ALK_SQL_TEXT, $strValue);
            }
          } 
        }
        // l'utilisateur ldap est actuellement attaché à ce service, 
        // est différent de $service_ldapuid si $bUserQuitServ=true
        $servldapuid = $drLdapUser->getValueName("SERVICE_LDAPUID");
       
        // enregistrement
        if( $bDoAdd ) {
          // ajout de l'utilisateur
          //Synchronisation avec OpenLdap en SHA-1 des Psswords
          if(array_key_exists("AGENT_PWD", $tabQuery)){
            $tabQuery["AGENT_PWD"][1] = str_replace("{SHA}","",$tabQuery["AGENT_PWD"][1]);
            $tabQuery["AGENT_PWD_ENCRYPT"] = array(ALK_SQL_TEXT, bin2hex(base64_decode($tabQuery["AGENT_PWD"][1])));
          }
          $tabFields = array("field" => $tabQuery, "pk" => array());
          $agent_id = $this->oAppli->addUser($tabFields);
          $this->addLog(2, $agent_key, "Fiche ajoutée.");
        } elseif( $bDoUpdate && $agent_id != "-1" ) {
          // modif de l'utilisateur
          $tabQuery["ALK_B_IMPORT"]    = array(ALK_SQL_NONE, 1);
          $tabQuery["AGENT_VALIDEMEM"] = array(ALK_SQL_NUMBER, $tabQuery["AGENT_VALIDE"][1]);
          $tabQuery["AGENT_LOGIN"]     = array(ALK_SQL_NONE, "");
          $tabQuery["AGENT_LOGINMEM"]  = array(ALK_SQL_NONE, "");
          $tabQuery["PROFIL_IDMEM"]    = array(ALK_SQL_NUMBER, $tabQuery["PROFIL_ID"][1]);
          unset($tabQuery["SERV_NIV2"]);
          unset($tabQuery["SERV_NIV3"]);
          unset($tabQuery["SERV_NIV4"]);
          $tabFields = array("field" => $tabQuery, "pk" => array("AGENT_ID" => array(ALK_SQL_NUMBER, $agent_id)));
          $this->oAppli->updateUser($agent_id, $tabFields);
          
          if( $bUserQuitServ ) {
            // traitement d'un utilisateur qui n'est plus présent sur le service sélectionné
            // recherche le service alkanet correspondant service ldap identifié par $servldapuid 
            $tabServLdapTree = $this->oAppli->oQuery->getTabServiceTree("-1", $servldapuid, "");
            $serv_niv1 = ( count($tabServLdapTree)>1 ? $tabServLdapTree[1] : "-1" ); 
            $serv_niv2 = ( count($tabServLdapTree)>2 ? $tabServLdapTree[2] : "-1" ); 
            $serv_niv3 = ( count($tabServLdapTree)>3 ? $tabServLdapTree[3] : "-1" ); 
            $serv_niv4 = ( count($tabServLdapTree)>4 ? $tabServLdapTree[4] : "-1" ); 
            if( $serv_niv1 != "-1") {
              $this->oAppli->oQueryAction->delAddFiliation($agent_id, "-1", $serv_niv1, $serv_niv2, $serv_niv3, $serv_niv4);
              $this->addLog(4, $agent_key, _f("Fiche modifiée. Filiation modifiée. L'utilisateur quitte ce service vers %s",$servldapuid));
            } else {
              $this->addLog(5, $agent_key, _f("Fiche modifiée. L'utilisateur n'appartient plus à ce service. Filiation non modifiée car %s n'a pas de correspondance unique dans cet annuaire.", $servldapuid));
            }
          } else {
            // traitement d'un utilisateur qui intègre le service sélectionné
            if( $servldapuid == $service_ldapuid ) {
              // pas de modification de filiation
              $this->addLog(1, $agent_key, _t("Fiche modifiée."));
            } else {
              // recherche du service alkanet dans ldap, si il n'existe pas, alors on ne change pas la filiation 
              $tabServLdapTree = $this->oAppli->oQuery->getTabServiceTree("-1", $servldapuid, "");
              $serv_niv1 = ( count($tabServLdapTree)>1 ? $tabServLdapTree[1] : "-1" ); 
              $serv_niv2 = ( count($tabServLdapTree)>2 ? $tabServLdapTree[2] : "-1" ); 
              $serv_niv3 = ( count($tabServLdapTree)>3 ? $tabServLdapTree[3] : "-1" ); 
              $serv_niv4 = ( count($tabServLdapTree)>4 ? $tabServLdapTree[4] : "-1" );
               
              if( $serv_niv1 != "-1") {
                $this->oAppli->oQueryAction-> delAddFiliation($agent_id, "-1", $serv_niv1, $serv_niv2, $serv_niv3, $serv_niv4);
                $this->addLog(3, $$agent_key, _f("Fiche modifiée. Filiation modifiée. L'utilisateur intègre ce service %s", $servldapuid));
              } else {
                $this->addLog(6, $$agent_key, _f("Fiche modifiée. Filiation non modifiée. L'utilisateur est actuellement associé à un service non lié à %s. ", ALK_LDAP_NAME));
              }
            }
          }
        } else {
           $this->addLog(0, $$agent_key, _f("Aucun traitement. Pas de fiche utilisateur unique correspondant à la clé dans l'annuaire %s.",ALK_S_DSIT));
        }
      } else {
        if( $dsLdapUser->isConnected() ) {
          $this->addLog(0, $$agent_key, _f("Aucun traitement. Pas de fiche utilisateur unique correspondant à la clé dans l'annuaire %s.", ALK_LDAP_NAME));
        } else {
          $this->addLog(0, $$agent_key, _f("Aucun traitement. Impossible de se connecter à l'annuaire %s.", ALK_LDAP_NAME));
        }         
      }
    } else {
      $this->addLog(0, $$agent_key, _f("Aucun traitement. Pas de fiche utilisateur unique correspondant à la clé dans l'annuaire %s.",ALK_S_DSIT));
    }
    
    // enregistre le log
    $this->saveLog();
    
    // retour ajax sur le rendu de l'opération
    if( $strTdName != "" ) { 
      $strHtmlJs = " var oLayer = document.getElementById('".$strTdName."');".
        " if( oLayer ) {".
        "   oLayer.className = 'select';".
        "   oLayer.innerHTML = \"".$this->strLogScreen."\";".
        " }".
        " oLayer = document.getElementById('layerEtape4');".
        " if( oLayer ) {".
        "   oLayer.innerHTML = \"Etape 2: ".($cpt+1)." / ".$cptMax."\";".
        " }";
      echo $strHtmlJs;
    }   
  }
}

?>