<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."excel/Workbook.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/classes/alkimportabonne.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlListAbonne
 * Classe de gestion des abonnés.
 */
class AlkHtmlListAbonne extends AlkHtmlForm
{
  /** dataset contenant le résultat de recherche */
  public $dsSearch;

  /** controles des critères */
  protected $rabonne_type;
  protected $rappli_id;
  protected $rliste_id;
  protected $rabonne_nom;
  protected $rabonne_valide;

  /* paramètres du formulaire */
  protected $page;
  protected $nbEltParPage;
  protected $bSearch;
  protected $bUpdateAbo;
  
  protected $oTargetAppli;
  
  /**
   * constructeur par défaut
   * @param oAppli        référence sur l'application
   * @param oTargetAppli  Référence sur l'appli demandant cette fenêtre
   */
  public function __construct(AlkAppli $oAppli, $oTargetAppli)
  {
    parent::__construct($oAppli, "formAbonne");

    $this->oTargetAppli = $oTargetAppli;
    
    $this->iTypeSheet = AlkRequest::getToken("iTypeSheet", ALK_TYPESHEET_CONSULT);
       
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit)
  {    
    $cont_id  = AlkRequest::getToken("cont_id", "-1");
    
    $this->rabonne_type   = new AlkFormData($this, "rabonne_type",     "2", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rappli_id      = new AlkFormData($this, "rappli_id",       "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rliste_id      = new AlkFormData($this, "rliste_id",       "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rabonne_nom    = new AlkFormData($this, "rabonne_nom",       "", ALK_SQL_TEXT);
    $this->rabonne_valide = new AlkFormData($this, "rabonne_valide",   "1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->bSearch        = new AlkFormData($this, "bSearch",          "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    // si liste_id fourni, la recherche s'effectue uniquement sur cette liste (liste_id doit être passé dans chaque token)
    $liste_id = AlkRequest::getToken("liste_id", AlkRequest::_REQUESTint("liste_id", "-1"));
    $this->liste_id       = new AlkFormData($this, "liste_id",   $liste_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    $this->nbEltParPage = AlkRequest::_GETint("nbItemsPerPage", -1);
    $this->page         = AlkRequest::_GETint("page", -1);
    if( $this->nbEltParPage == -1 ) {
      $this->nbEltParPage = ( isset($_SESSION["alk_abonneNbEltParPage"]) ? $_SESSION["alk_abonneNbEltParPage"] : ALK_ITEMS_PER_PAGE ) ;
    } 
    $_SESSION["alk_abonneNbEltParPage"] = $this->nbEltParPage;

    // init en mode request post
    $this->initData($iTypeInit, null, REQ_POST);
    $this->dsSearch = null;
    if( $this->bSearch->value=="1" ) {
      // on vient de valider la recherche
      $this->bSearch->value = "2";
      // enregistre les critères en session lié à l'espace en cours
      $this->page = 1;
      unset($_SESSION["alk_strSqlExportAb"]);
      $_SESSION["alk_strSqlExportAb"] = "";
      $_SESSION["alk_abonneSearchCriteria"] = 
        array($cont_id,
              $this->rabonne_type->value, 
              $this->rappli_id->value,
              $this->rliste_id->value,
              $this->rabonne_nom->value,
              $this->rabonne_valide->value,
              $this->page,
              $this->nbEltParPage);
    } else { 
      // récupération après pagination ou retour sur recherche
      // récupération des anciens critères
      $tabCriteria = ( isset($_SESSION["alk_abonneSearchCriteria"]) ? $_SESSION["alk_abonneSearchCriteria"] : array() );
      if( !empty($tabCriteria) && count($tabCriteria)==8 && $tabCriteria[0] == $cont_id ) {
        $this->bSearch->value = 1;
        list($cont_id,
             $this->rabonne_type->value, 
             $this->rappli_id->value,
             $this->rliste_id->value,
             $this->rabonne_nom->value,
             $this->rabonne_valide->value,
             $page,
             $nbEltParPage) = $tabCriteria;
       
        // vérif de la pagination
        if( $this->page == -1 ) {
          $this->page = ( $page != -1 ? $page : 1 );
          // force le recalcul de la requete
          if( $this->iSSheet == ALK_SHEET_NONE ) unset($_SESSION["alk_strSqlExportAb"]);
        } // sinon pagination en cours

        // vérif du nb elt par page
        if( $this->nbEltParPage != $nbEltParPage ) {
          // force le recalcul de la requete
          if( $this->iSSheet == ALK_SHEET_NONE ) unset($_SESSION["alk_strSqlExportAb"]);
        } // sinon modif du nombre en cours
        
        $tabCriteria[6] = $this->page;
        $tabCriteria[7] = $this->nbEltParPage;

        $_SESSION["alk_abonneSearchCriteria"] = $tabCriteria;
      } else {
        // pas de critères
        $this->bSearch->value = 0;
        unset($_SESSION["alk_strSqlExportAb"]);
        unset($_SESSION["alk_abonneSearchCriteria"]);
      }
    }
    
    $this->bUpdateAbo = ( AlkFactory::isAnnuAdminAll() || AlkFactory::isSpaceAnim() || AlkFactory::isSpaceAnimAll() );
  }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $liste_id = AlkRequest::getToken("liste_id", AlkRequest::_REQUESTint("liste_id", "-1"));
    
    $strUrlReturn = "";
    switch( $this->iSSheet ) {
    case ALK_SHEET_NONE: // export
      $this->doExport();
      break;
      
    case ALK_SHEET_AUTORISATION: // action activation / suppression / désactivation / réactivation
      $iAction = AlkRequest::_GETint("a", "0");
      $tabAbonneId = AlkRequest::_POST("cbAbonneId", array(-1), "is_array");
      $strListAbonneId = implode(",", $tabAbonneId);
      $this->oAppli->oQueryAction->setActionToAbonne($iAction, $strListAbonneId);
      $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&liste_id=".$liste_id);
      $strUrlReturn = ALK_ALKANET."?token=".$strToken;
      break;
    
    case ALK_SHEET_AJOUTER :  // ajout d'abonnés
      // vérification ajax de l'existance d'un abonné, création si n'existee pas
      $strMails = AlkRequest::_POST("ctrlUserList", "");
      
      $oQueryAnnuAction = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
      $oQueryAnnuAction->addAbonneToListe($liste_id, $strMails);
      $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&liste_id=".$liste_id);
      $strUrlReturn = ALK_ALKANET."?token=".$strToken;
      break;
    }

    return $strUrlReturn;
  }
  
  public function getTitle()
  {
    switch ( $this->iTypeSheet ) {
      case ALK_TYPESHEET_POPUP :
        return _t("Gestion des abonnés");
      break;
    }
  }
  
  /**
   * Construction de la liste (soit boite de reception soit liste des envois)
   */
  public function setContents()
  {    
    $this->setData(ALK_INIT_MODE_REQUEST);
    $this->getBlockCriteria();

    $this->setLabel(_t("Recherche sur l'annuaire des abonnés"));
    $this->setLabelDesc(_t("Ce formulaire de recherche vous permet de consulter l'annuaire des abonnés à l'aide des critères suivants."));

    switch( $this->iSSheet ) {
    case ALK_SHEET_IMPORT_USER:
      if( $this->iMode == ALK_FORM_MODE_ADD ) {
        $this->getBlockImport();
      } else {
        $this->getBlockResultImport();
      }
      break;
    case ALK_SHEET_AJOUTER :
        $this->getBlockAjouter();
      break;
    default: 
      if( $this->bSearch->value != "0" ) {
        $this->getBlockResult();
      }
      break; 
    }

    $this->addScriptJs(AlkFactory::getModuleUrl(ALK_ATYPE_ID_ANNU)."lib/alkhtmlformabonne.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    $this->setTemplate("annu", "alkhtmlformrechercheform.tpl");
    
    if ( $this->iTypeSheet == ALK_TYPESHEET_POPUP ) {
      $this->addButtonPage("btClose", "javascript:closeWindow();", _t("Fermer"), _t("Fermer la fenêtre"));
    }
  }

  /**
   *  Construit puis retourne
   * @return AlkHtmlBlock
   */
  private function getBlockCriteria()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    $oQueryAnnu   = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $iSelectWidth = 250;
    $iTxtWidth = 34;

    $oBlockCriteria =& $this->addBlock("blockCriteria", _t("Critères de recherche"), "", 100, $iSelectWidth+10, true);

    $oCtrlHide = AlkHtmlFactory::getHtmlHidden($this->bSearch);

    $rabonne_type = AlkHtmlFactory::getHtmlSelect($this->rabonne_type, _t("Type"), 1);
    $tabEtat = array("0"  => _t("Tous les abonnés"),
                     "1"  => _t("Abonnés de l'annuaire"),
                     "2"  => _t("Abonnés hors annuaire"));
    $rabonne_type->setProperty("tabValTxt", $tabEtat);
    
    $rappli_id = null;
    if ( $this->liste_id->value == -1 ) {
      $rappli_id = AlkHtmlFactory::getHtmlSelect($this->rappli_id, _t("Abonnement"), 1, $iSelectWidth);
      $rappli_id->setProperty("tabValTxtDefault", array("-1", ""));
      $strATypeId = ALK_ATYPE_ID_NEWSLETTER.",".ALK_ATYPE_ID_COMMENT;
      $rappli_id->setProperty("oValTxt", $oQueryEspace->getDsListAppliBySpaceByATypeIdForCombo($user_id, $cont_id, $strATypeId));
    } else {
      $oCtrlHide->addDataHidden($this->rappli_id);
    }
    
    $rliste_id = null;
    if ( $this->liste_id->value == -1 ) {
      $rliste_id = AlkHtmlFactory::getHtmlSelect($this->rliste_id, _t("Liste"), 1, $iSelectWidth);
      $rliste_id->setProperty("tabValTxtDefault", array("-1", ""));
      $rliste_id->setProperty("oValTxt", $oQueryAnnu->getDsListes($user_id, $cont_id, true, 0, -1, AlkFactory::isSpaceAnimAll(), AlkFactory::isSpaceAnim(), false, "0, 3"));
    } else {
      $oCtrlHide->addDataHidden($this->liste_id);
      $oCtrlHide->addDataHidden($this->rliste_id);
    }
    
    $rabonne_nom = AlkHtmlFactory::getHtmlText($this->rabonne_nom,  _t("Nom ou courriel"), 1, $iTxtWidth, 40);

    $rabonne_valide = null;
    if( $this->bUpdateAbo ) {
      $rabonne_valide = AlkHtmlFactory::getHtmlSelect($this->rabonne_valide, _t("Etat"), 1);
      $tabEtat = array("-1" => _t("Tous"),
                       "1"  => _t("Actif"),
                       "0"  => _t("Désactivé"),
                       "-2" => _t("En attente d'activation"));
      $rabonne_valide->setProperty("tabValTxt", $tabEtat);
    }

    $oBlockCriteria->addCtrl($oCtrlHide);
    $oBlockCriteria->addCtrl($rabonne_type);
    $oBlockCriteria->addCtrl($rappli_id);
    $oBlockCriteria->addCtrl($rliste_id);
    $oBlockCriteria->addCtrl($rabonne_nom);
    $oBlockCriteria->addCtrl($rabonne_valide);
    
    $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE);
    $oButton = $this->addButtonPage("btSearch", "javascript:Valider('".$strToken."', true)", _t("Rechercher"), _t("Executer la recherche"));
    $this->addSubmitButton($oButton);
  }

  /**    
   *  Construit puis retourne
   * @return AlkHtmlBlock
   */
  private function getBlockResult()
  {
    $cont_id     = AlkRequest::getToken("cont_id", "-1");
    $user_id     = AlkFactory::getSProperty("user_id", "-1");
    $user_priv   = AlkFactory::getSProperty("user_priv", "0");
    $userServ_id = AlkFactory::getSProperty("service_id", "-1");
    
    if( $this->bSearch->value == "2" || !isset($_SESSION["alk_strSqlExportAb"]) ) {
      // validation de recherche
      $strSql = $this->oAppli->oQuery->getSqlListeAbonneForSearch($cont_id, $this->rabonne_type->value, $this->rappli_id->value,
                                                                  ( $this->liste_id->value != -1 ? $this->liste_id->value : $this->rliste_id->value ), $this->rabonne_nom->value, $this->rabonne_valide->value);
      $_SESSION["alk_strSqlExportAb"] = $strSql;
    } else {
      // pagination ou retour
      $strSql = $_SESSION["alk_strSqlExportAb"];
    }

    $this->dsSearch = $this->oAppli->oQuery->getDs($strSql, ($this->page-1)*$this->nbEltParPage, $this->page*$this->nbEltParPage-1);
                                        
    $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&liste_id=".$this->liste_id->value); 
    $strUrlPagine = ALK_ALKANET."?token=".$strToken;
    $strMsg = _f("Aucune réponse à votre sélection.%nlVeuillez modifier vos critères.", "<br/>");
    $nbElt =  $this->dsSearch->getCountTotDr();
    $strS = ( $nbElt>1 ? "s" : "" ); 

    $oBlockResult = AlkHtmlFactory::getHtmlList($this, $nbElt, $this->page, $this->nbEltParPage, 
                                                true, $strUrlPagine, $strMsg, false, "blockResult", true);
    $strTokenXls = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&iModeExp=1");
    $oLinkExportXls = AlkHtmlFactory::getHtmlButtonIcon("javascript:Export('".$strTokenXls."')", "Export xls", _t("Exporter ce résultat au format Excel"));
    $strTokenCsv = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&iModeExp=0");
    $oLinkExportCsv = AlkHtmlFactory::getHtmlButtonIcon("javascript:Export('".$strTokenCsv."')", "Export csv", _t("Exporter ce résultat au format texte tabulé"));
    $strTokenImport = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_IMPORT_USER, "&liste_id=".$this->liste_id->value);
    $oLinkImport = AlkHtmlFactory::getHtmlButtonIcon(ALK_ALKANET."?token=".$strTokenImport, "Import csv", _t("Importer une liste d'abonnés"));
    $strTokenCreate = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNEFORM, ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_ADD."&liste_id=".$this->liste_id->value);
    $oLinkCreate = AlkHtmlFactory::getHtmlButtonIcon(ALK_ALKANET."?token=".$strTokenCreate, "Add user", _t("Créer un abonné"));
    $strTokenAdd = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_AJOUTER, "&liste_id=".$this->liste_id->value);
    $oLinkAdd = AlkHtmlFactory::getHtmlButtonIcon(ALK_ALKANET."?token=".$strTokenAdd, "Add users", _t("Ajouter des abonnés"));
    $strUrlExport =
      $oLinkExportXls->getHtml().
      //'<a title="Exporter ce résultat au format Excel" href="javascript:Export(\''.$strTokenXls.'\')">Export excel</a> - '.
      $oLinkExportCsv->getHtml().
      //'<a title="Exporter ce résultat au format texte tabulé" href="javascript:Export(\''.$strTokenCsv.'\')">Export texte tab.</a> - '.
      $oLinkImport->getHtml().
      //'<a title="Importer une liste d\'abonnés" href="'.ALK_ALKANET.'?token='.$strTokenImport.'">Importer</a> - '.
      $oLinkCreate->getHtml().
      //'<a title="Créer un abonné" href="'.ALK_ALKANET.'?token='.$strTokenCreate.'">Créer</a>'.
      ( $this->liste_id->value != -1 ? $oLinkAdd->getHtml()/*' - <a title="Ajouter des abonnés à la liste" href="'.ALK_ALKANET.'?token='.$strTokenAdd.'">Ajouter</a>'*/ : '' );
    $oBlockResult->enableBlock(($nbElt==0 ? _t("Aucun") : $nbElt)." "._f("abonné%s trouvé%s", $strS, $strS)." : ".$strUrlExport, "", "1", "400", true);
                 
    $bAffRightRow = false;
    if( $this->bUpdateAbo ) {
      $oBlockResult->SetColumns(array("left", "300"),
                                array("center", "30"),
                                array("right", "80"));
      
      $strTokenCBAction = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_AUTORISATION, "&liste_id=".$this->liste_id->value);
      $strAction = '<input type="checkbox" name="cbAll" value="1" onclick="javascript:onClickCBAll()"/>' .
        '<select class="formCtrl" name="cbaction" size="1" style="width:45px;" onchange="javascript:onChangeCbAction(this, \''.$strTokenCBAction.'\')">'.
        '<option value="-1">--\</option>'.
        '<option title="'._t("Activer").' value="1">'._t("Activer").'</option>'.
        '<option title="'._t("Désactiver").' value="2">'._t("Désact.").'</option>'.
        '<option title="'._t("Réactiver").' value="3">'._t("Réact.").'</option>'.
        '<option title="'._t("Supprimer").' value="4">'._t("Suppr.").'</option>'.
        '</selection>';
      
      $oBlockResult->AddTitleRow(_t("Nom Prénom < courriel >"), _t("Etat"), $strAction);
      $bAffRightRow = true;
    } else {
      $oBlockResult->SetColumns(array("left",   "380"),
                                array("center", "30"));
       
      $oBlockResult->AddTitleRow(_t("Nom Prénom < Couriel >"), _t("Etat"));
    }
  
    while( $drAbonne = $this->dsSearch->getRowIter() ) {
      $idAgent     = $drAbonne->getValueName("AGENT_ID");
      $idAbonne    = $drAbonne->getValueName("ABONNE_ID");
      $strNom      = $drAbonne->getValueName("ABONNE_NOM");
      $strPrenom   = $drAbonne->getValueName("ABONNE_PRENOM");
      $strMail     = $drAbonne->getValueName("ABONNE_MAIL");
      $strTel      = $drAbonne->getValueName("ABONNE_TEL");
      $iValide     = $drAbonne->getValueName("ABONNE_VALIDE");
      $dateInsc    = $drAbonne->getValueName("ABONNE_DATEINSCR");
      $dateDesinsc = $drAbonne->getValueName("ABONNE_DATEDESINSCR");

      $strEtat = ( $iValide == "1" 
                   ? '<img class="alkimgicon alkimgiconon" src="'.ALK_ALKANET_ROOT_URL.'media/images/transp.gif" alt="'._t("Activé").'"/>'
                   : ( $iValide == "0" && $dateDesinsc==""
                       ? '<img class="alkimgicon alkimgiconstandby" src="'.ALK_ALKANET_ROOT_URL.'media/images/transp.gif" alt="'._t("En attente d'activation").'"/>'
                       : '<img class="alkimgicon alkimgiconoff" src="'.ALK_ALKANET_ROOT_URL.'media/images/transp.gif" alt="'._t("Désactivé").'"/>' ));
                
      $strNom = trim($strNom." ".$strPrenom);
      $oBtMail = AlkHtmlFactory::getHtmlButtonIcon("mailto:".$strMail, "courriel", $strMail);
      $oNom_Agent = ( $idAgent!="" && $idAgent != ALK_USER_ID_INTERNET
                      ? AlkHtmlFactory::getHtmlButton("javascript:OpenPopupFiche('agent', ".$idAgent.")", $strNom." &lt;".$strMail."&gt;", _f("Voir la fiche de l'agent %s",$strNom))
                      : AlkHtmlFactory::getHtmlButton("javascript:OpenPopupFiche('abonne', ".$idAbonne.")", $strNom." &lt;".$strMail."&gt;", _f("Voir la fiche de l'abonné %s",$strNom) ));  

      $strNom = $oBtMail->getHtml()." ".$oNom_Agent->getHtml();

      $strBt = '&nbsp;';
      if( $bAffRightRow == true ) { 
        if( AlkFactory::isAnnuAdminAll() && $idAgent != ALK_USER_ID_INTERNET ) {
          $strBt = '';
          $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ($idAgent==$user_id ? ALK_SHEET_FICHE : ALK_SHEET_MODIFIER), 
                                                ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_UPDATE."&agent_id=".$idAgent."&liste_id=".$this->liste_id->value);
          $oModifierAg = AlkHtmlFactory::getHtmlButtonIcon(ALK_ALKANET."?token=".$strToken, 
                                                           "Modifier", _f("Modifier la fiche de l' agent %s",$drAbonne->getValueName("ABONNE_NOM")));
          $strBt .= '&nbsp;'.$oModifierAg->getHtml();
        } else if( $idAgent == ALK_USER_ID_INTERNET ) {
          $strBt = '<input type="checkbox" name="cbAbonneId[]" value="'.$idAbonne.'">';
          $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNEFORM, ALK_SHEET_NONE, 
                                              "&iMode=".ALK_FORM_MODE_UPDATE."&abonne_id=".$idAbonne."&liste_id=".$this->liste_id->value);
          $oModifierAbo = AlkHtmlFactory::getHtmlButtonIcon(ALK_ALKANET."?token=".$strToken, 
                                                         "Modifier", _f("Modifier la fiche de l' abonné %s",$drAbonne->getValueName("ABONNE_NOM")));
          $strBt .= '&nbsp;'.$oModifierAbo->getHtml();
        }
                
        $strToken = $this->oTargetAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_USERRIGHT, ALK_SHEET_LIST, "&abonne_id=".$idAbonne);
        $oAfficher = AlkHtmlFactory::getHtmlButtonIcon("javascript:OpenWindow('".ALK_ALKANET."?token=".$strToken."', 500, 680)", 
                                                       "Afficher", _f("Afficher les abonnements de l' abonné %s",$drAbonne->getValueName("ABONNE_NOM")));

        $strBt .= '&nbsp;'.$oAfficher->getHtml();
        $oBlockResult->addRow($strNom, $strEtat, $strBt);
      } else {
        $oBlockResult->addRow($strNom, $strEtat);
      }
    }
    $this->addPanel($oBlockResult);
  }
  
  /**
   *  Construit puis retourne
   * @return AlkHtmlBlock
   */
  private function getBlockAjouter()
  {
    $strTokenRes = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&liste_id=".$this->liste_id->value);
    
    $strTitle = _t("Importer des abonnés hors annuaire").' / '.
                 ' <a title="'._t("Revenir au résultat de la recherche").'" href="'.ALK_ALKANET.'?token='.$strTokenRes.'">'.
                 _t("Résultat de la recherche").'</a>';
    
    $strDesc = _t("Instructions : Remplir une adresse par ligne.")."<br/>" .
               _t("Celle-ci doit être de la forme NomPrenom&lt;adresse Mail&gt; ou adresse Mail")."<br/>".
                        _t("Exemple 1")." : Administrateur Alkante&lt;alkante@alkante.com&gt;<br/>".
                        _t("Exemple 2")." : alkante@alkante.com";
    
    $oBlockAjouter = $this->addBlock("blockAjouter", $strTitle, $strDesc, "20", "380", true);
    
    $iWidthMemo = 42;
    $iHeightMemo = 20;
    
    $this->ctrlUserList = new AlkFormData($this, "ctrlUserList", "", ALK_SQL_TEXT);
    $oUser = AlkHtmlFactory::getHtmlText($this->ctrlUserList, "",$iHeightMemo, $iWidthMemo+5);
    $oBlockAjouter->addCtrl($oUser);
    
    $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_AJOUTER, "&liste_id=".$this->liste_id->value);
    $oBlockAjouter->addButtonPage("Btajout", "javascript:ajoutSimple('".$this->name."', '".$strToken."');", _t("Ajouter"), _t("Ajouter ce destinataire"));
    
    return $oBlockAjouter;
  }
  
  /**
   *  function d'initialisation appelé par la function export
   */
  private function HeaderingText($filename, $bExcel=true) 
  { 
    $strType = ( $bExcel ? "application/vnd.ms-excel" : "text/plain" );
    AffHeaderFileDownload("", $filename, 0, $strType);
  }
  
  /**
   *  function d'exportation de la liste des agents 
   */
  private function doExport()
  {
    if( !(isset($_SESSION["alk_strSqlExportAb"]) && $_SESSION["alk_strSqlExportAb"]!="") ) { 
      return;
    }
    
    set_time_limit(300); // 5mn
    
    $ag_id = AlkFactory::getSProperty("user_id", "-1");
    $iModeExp = AlkRequest::getToken("iModeExp", "0");
    $bExcel = ( $iModeExp == 1 ? true : false ); 
    
    
    $strExtension = ($bExcel==true ? "xls" : "txt");
  
    // HTTP headers
    $this->HeaderingText($ag_id."_exp.".$strExtension, $bExcel);
    
    $strSep = "\t";
    $strRetLigne = "\r\n";
    
    if ($bExcel==true) {
      // Creating a workbook
      $workbook = new Workbook("-");
      
      // Creating the first worksheet
      $worksheet1 =& $workbook->add_worksheet('Utilisateurs');
      
      // Creating the formats
      $oFormatHeader =& $workbook->add_format();
      $oFormatHeader->set_align('center');
      $oFormatHeader->set_color('black');
      
      $oFormatValue =& $workbook->add_format();
      $oFormatValue->set_color('black');
      
      $iCol = 0;
      $iRow = 0;
      $iHeightRow = 20;
      $iWidthCol = 15;
    }
    /*
    $tabReference = array("MODE", "CLE", "AGENT_ID", "NOM", "PRENOM", "PSEUDO", "MEL", "TEL", 
                          "DATE_INSCR", "VALIDE", "DATE_DESINSCR", 
                          "ADRESSE", "CODE_POSTAL", "VILLE", "PAYS");
    */
    $tabReference = array("MODE", "CLE", "AGENT_ID", "ABONNE_NOM", "ABONNE_PRENOM", "ABONNE_PSEUDO", "ABONNE_MAIL", "ABONNE_TEL", 
                          "DATE_INSCR", "ABONNE_VALIDE", "DATE_DESINSCR", 
                          "ABONNE_ADRESSE", "ABONNE_CP", "ABONNE_VILLE", "ABONNE_PAYS");
                          
    for ($k=0; $k<count($tabReference); $k++) {
      if($bExcel==true){
        $worksheet1->set_row($iRow, $iHeightRow);
        $worksheet1->set_column($iRow, $iCol, $iWidthCol);
        $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($tabReference[$k], ALK_EXPORT_ENCODING, ALK_HTML_ENCODING), $oFormatHeader);
        $iCol++;
      } else {
        echo $tabReference[$k].$strSep;
      }
    }
    
    if( $bExcel==true ) {
      $iCol = 0;
      $iRow++;
    } else {
      echo $strRetLigne;
    }
    
    $strSql = $_SESSION["alk_strSqlExportAb"];
    $dsAbonne = $this->oAppli->oQuery->GetDs($strSql);
    
    $cpt = 0;
    while( $drAbonne = $dsAbonne->getRowIter() ) {
      $idAgent     = $drAbonne->getValueName("AGENT_ID");
      $idAbonne    = $drAbonne->getValueName("ABONNE_ID");
      $strNom      = mb_convert_encoding($drAbonne->getValueName("ABONNE_NOM"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $strPrenom   = mb_convert_encoding($drAbonne->getValueName("ABONNE_PRENOM"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $strPseudo   = mb_convert_encoding($drAbonne->getValueName("ABONNE_PSEUDO"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $strMail     = mb_convert_encoding($drAbonne->getValueName("ABONNE_MAIL"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $strTel      = mb_convert_encoding($drAbonne->getValueName("ABONNE_TEL"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $strAdr      = mb_convert_encoding($drAbonne->getValueName("ABONNE_ADR"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $strCP       = mb_convert_encoding($drAbonne->getValueName("ABONNE_CP"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $strVille    = mb_convert_encoding($drAbonne->getValueName("ABONNE_VILLE"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $strPays     = mb_convert_encoding($drAbonne->getValueName("ABONNE_PAYS"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $iValide     = $drAbonne->getValueName("ABONNE_VALIDE");
      $dateInsc    = $drAbonne->getValueName("ABONNE_DATEINSCR");
      $dateDesinsc = $drAbonne->getValueName("ABONNE_DATEDESINSCR");
      
      $strMode = "";
      $strNom      = mb_ereg_replace($strSep, " ", $strNom);
      $strPseudo   = mb_ereg_replace($strSep, " ", $strPseudo);
      $strPrenom   = mb_ereg_replace($strSep, " ", $strPrenom);
      $strMail     = mb_ereg_replace($strSep, " ", $strMail);
      $strTel      = mb_ereg_replace($strSep, " ", $strTel);
      $dateInsc    = mb_ereg_replace($strSep, " ", $dateInsc);
      $iValide     = mb_ereg_replace($strSep, " ", $iValide);
      $dateDesinsc = mb_ereg_replace($strSep, " ", $dateDesinsc);
      $strAdr      = mb_ereg_replace($strSep, " ", $strAdr);
      $strCP       = mb_ereg_replace($strSep, " ", $strCP);
      $strVille    = mb_ereg_replace($strSep, " ", $strVille);
      $strPays     = mb_ereg_replace($strSep, " ", $strPays);
    
      if( $bExcel==true ) {
        $worksheet1->set_row($iRow, $iHeightRow);
        
        $worksheet1->write_string($iRow, $iCol, $strMode , $oFormatValue);
        $iCol++;
        $worksheet1->write_number($iRow, $iCol, $idAbonne , $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $idAgent , $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $strNom , $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $strPrenom , $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $strPseudo , $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $strMail , $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $strTel , $oFormatValue);
        $iCol++;

        $worksheet1->write_string($iRow, $iCol, $dateInsc , $oFormatValue);
        $iCol++;
        $worksheet1->write_number($iRow, $iCol, $iValide , $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $dateDesinsc , $oFormatValue);
        $iCol++;

        $worksheet1->write_string($iRow, $iCol, $strAdr , $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $strCP , $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $strVille, $oFormatValue);
        $iCol++;
        $worksheet1->write_string($iRow, $iCol, $strPays , $oFormatValue);
        $iCol++;
      } 
      else {
        echo $strMode.$strSep.$idAbonne.$strSep.$idAgent.$strSep.
          $strNom.$strSep.$strPrenom.$strSep.$strPseudo.$strSep.$strMail.$strSep.$strTel.$strSep.
          $dateInsc.$strSep.$iValide.$strSep.$dateDesinsc.$strSep.
          $strAdr.$strSep.$strCP.$strSep.$strVille.$strSep.$strPays;
      }
    
      if($bExcel==true){
        $iCol = 0;
        $iRow++;
      } 
      else {
        echo $strRetLigne;
      }
    }
    
    if($bExcel==true){
      $workbook->close();
    }
  } 

  /**
   * Formulaire permettant de poster le fichier à importer
   */
  private function getBlockImport()
  {
    $strTokenRes = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&liste_id=".$this->liste_id->value);
    $strTokenXls = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&iModeExp=1");
    $strTokenCsv = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&iModeExp=0");

    $strTitle = _t("Importer des abonnés hors annuaire").' / '.
               ' <a title="'._t("Revenir au résultat de la recherche").
               '" href="'.ALK_ALKANET.'?token='.$strTokenRes.'">'._t("Résultat de la recherche").'</a>';

    $strDesc = _t("Pour réaliser un import d'abonnés, vous devez au préalable prendre connaissance du").
              '<a title="'._t("Règles d'importation au format PDF").
              '" href="'.AlkFactory::getModuleUrl(ALK_ATYPE_ID_ANNU).'regles_importation_Abonnes.pdf" target="blank">'.
              _t("format").'</a>.'.
              _t("Un compte rendu est disponible après l'importation.").'<br/>'.
              _t("Exemples de fichier d'import").' :'.
              ' <a href="'.AlkFactory::getModuleUrl(ALK_ATYPE_ID_ANNU).'importAbonnes_ex.txt" target="blank">'._t("exemple 1").'</a>,'.
              ' <a href="'.AlkFactory::getModuleUrl(ALK_ATYPE_ID_ANNU).'importAbonnes_ex2.txt" target="blank">'._t("exemple 2").'</a>.<br/>'.
             ( isset($_SESSION["alk_strSqlExportAb"]) && $_SESSION["alk_strSqlExportAb"]!="" 
              ? _t("L'export fournit également le format attendu pour l'import").' : '.
              ' <a title="'._t("Exporter ce résultat au format Excel").
              '" href="javascript:Export(\''.$strTokenXls.'\')">'._t("Export excel").'</a> - '.
              ' <a title="'._t("Exporter ce résultat au format texte tabulé").
              '" href="javascript:Export(\''.$strTokenCsv.'\')">'._t("Export texte tabulé").'</a>.'
              : '' );
    
    $oBlockImport = $this->addBlock("blockResult", $strTitle, $strDesc, "130", "270", true);
    $oDataFile  = new AlkFormData($this, "importFile", "", ALK_SQL_NONE); 
    $oCtrlFile = AlkHtmlFactory::getHtmlFile($oDataFile, "Sélectionnez un fichier", 33, 255);
    $oCtrlFile->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
    $oBlockImport->addCtrl($oCtrlFile);
    
    // bouton Valider
    $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_IMPORT_USER, "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$this->liste_id->value);   
    $oButton = $this->addButtonPage("bt_Import","javascript:Valider('".$strToken."', false)", _t("Valider"), _t("Démarrer l'import"));
    $this->addSubmitButton($oButton);
  }
  
  /**
   * Exécution de l'import et affichage du résultat 
   */
  private function getBlockResultImport()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    
    $strTokenRes = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&liste_id=".$this->liste_id->value);
    $strTokenImport = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_IMPORT_USER, "&liste_id=".$this->liste_id->value);
    
    $strTitle = _t("Résultat de l'import").' / '.
                ' <a title="'._t("Refaire un import").
                '" href="'.ALK_ALKANET.'?token='.$strTokenImport.'">'._t("Nouvel import").'</a> - '.
                ' <a title="'._t("Revenir au résultat de la recherche").
                '" href="'.ALK_ALKANET.'?token='.$strTokenRes.'">'._t("Résultat recherche").'</a>';
      
      
    $oBlockImport = $this->addBlock("blockResult", $strTitle, "", "100", "300", true);

    //upload du fichier
    $strFileName = DoUpload("importFile", $user_id."_", AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU, true), 0, "");
    if( !is_string($strFileName) ) {
      $strFileName = "";
    }

    $strHtml = '<div style="margin-right:auto; margin-left:auto; text-align:center;">';
    if( $strFileName != "" ) {
      $strUrlFileError = AlkFactory::getUploadUrl(ALK_ATYPE_ID_ANNU).$user_id."_err.txt";
      $strPathFileError = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU).$user_id."_err.txt";
      $strUrlFileWarning = AlkFactory::getUploadUrl(ALK_ATYPE_ID_ANNU).$user_id."_warning.txt";
      $strPathFileWarning = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU).$user_id."_warning.txt";
    
      delFile($strPathFileError);
      delFile($strPathFileWarning);
      
      $strPathFileImport = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU)."/".$strFileName;
  
      $intSeparateur = 9;
      $tabImport = 
        array(array("name" => "MODE",          "oblig" => 1, "type" => array("S","M","C"), "lg" => 1, "index" => 0, "mode" => 1),
              array("name" => "CLE",           "oblig" => 1, "type" => "numeric", "lg" => 10,  "index" => 0 ,"mode" => 0),
              array("name" => "ABONNE_NOM",    "oblig" => 1, "type" => "string",  "lg" => 100, "index" => 0, "mode" => 0),
              array("name" => "ABONNE_PRENOM", "oblig" => 1, "type" => "string",  "lg" => 40,  "index" => 0, "mode" => 0),
              array("name" => "ABONNE_PSEUDO", "oblig" => 0, "type" => "string",  "lg" => 255, "index" => 0, "mode" => 0),
              array("name" => "ABONNE_PWD",    "oblig" => 0, "type" => "string",  "lg" => 20,  "index" => 0, "mode" => 0),
              array("name" => "ABONNE_ADRESSE","oblig" => 0, "type" => "string",  "lg" => 255, "index" => 0, "mode" => 0),
              array("name" => "ABONNE_CP",     "oblig" => 0, "type" => "string",  "lg" => 10,  "index" => 0, "mode" => 0),
              array("name" => "ABONNE_VILLE",  "oblig" => 0, "type" => "string",  "lg" => 40,  "index" => 0, "mode" => 0),
              array("name" => "ABONNE_PAYS",   "oblig" => 0, "type" => "string",  "lg" => 40,  "index" => 0, "mode" => 0),
              array("name" => "ABONNE_MAIL",   "oblig" => 1, "type" => "string",  "lg" => 255, "index" => 0, "mode" => 0),
              array("name" => "ABONNE_TEL",    "oblig" => 0, "type" => "string",  "lg" => 32,  "index" => 0, "mode" => 0),
              array("name" => "ABONNE_VALIDE", "oblig" => 0, "type" => array("0","1"), "lg" => 1, "index" => 0, "mode" => 1),
              array("name" => "AGENT_ID",      "oblig" => 0, "type" => "numeric", "lg" => 11,  "index" => 0, "mode" => 0),
              );
      $bTes = true;
      $intTes = 1;
      $tabSup = array("CLE", "ABONNE_MAIL");
      $tabAjout = array("ABONNE_NOM", "ABONNE_PRENOM", "ABONNE_MAIL");
      $tabModif = array("ABONNE_NOM", "ABONNE_PRENOM", "ABONNE_MAIL");
      $objErreur = new AlkImportError($strPathFileError);
      $objWarning = new AlkImportWarning($strPathFileWarning);
      $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
      $oQueryActionAnnu = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
      $objImport = new AlkImportAbonne($strPathFileImport, $tabImport, $tabSup, $tabAjout, $tabModif, 
                                       $objErreur, $objWarning, $oQueryAnnu, $oQueryActionAnnu, 
                                       $this->oAppli->getProperty("oSpace"), $this->oAppli, $this->liste_id->value);
  
      $iTes = 0;
      $intTest = $objImport->parseFile($intSeparateur);
      if( $intTest == 0 ) {
        $intTes = $objImport->parseLines($intSeparateur);
        if( $intTes == 0 ) {
          $iTes = $objImport->integrate($intSeparateur);
        }
      }
    
      if( $intTes == 0 && $iTes == 0 ) {
        $strHtml .= _t("Importation effectuée avec succès.");
      } else {
        if( $intTes > 0 ) {
          $strHtml .= _t("Importation non effectuée pour cause de fichier mal formaté.");
        }
        if( $iTes > 0 ) {
          $strHtml .= _t("Importation effectuée avec des alertes ou des erreurs.");
        }
        $bFileAlert = @file_exists($strPathFileWarning) && @is_file($strPathFileWarning);
        $bFileError = @file_exists($strPathFileError) && @is_file($strPathFileError);
      
        if( $bFileAlert || $bFileError ) {
          $strHtml .= '<br/><span style="color:red;">Attention</span> :'._t("Vous pouvez consulter");
          
          if( $bFileAlert ) {
            $oLink = AlkHtmlFactory::getHtmlButton($strUrlFileWarning, _t("les alertes"), "", true, "_blank");
            $strHtml .= $oLink->getHtml();
            if( $bFileError )
             $strHtml .=  " et ";
          }
          if( $bFileError ) {
            $oLink = AlkHtmlFactory::getHtmlButton($strUrlFileError, _t("les erreurs"), "", true, "_blank");
            $strHtml .= $oLink->getHtml();
          }
          $strHtml .= '.';
        }
      }
    } else {
      $strHtml .= _t("Importation non effectuée pour cause de fichier non transmis.");
    }    
    $strHtml .= '</div>';
    $otext = AlkHtmlFactory::getHtml($strHtml); 

    $oBlockImport->addCtrl($otext, ALK_HTMLFORM_1L1C);
  }

  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_abonne.htm"); 
  }
   
}
?>