<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormProfilList
 * 
 * Classe de gestion de la liste des profils généraux de l'Annuaire
 */
class AlkHtmlFormProfilList extends AlkHtmlForm 
{
  /** cont_id associé au profil */
  protected $profil_cont_id;
  protected $profil_id;
  
  protected $cont_id;
  protected $appli_id;
  
  
  /**
   * @brief constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formProfilList"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
    $this->profil_cont_id = 0;
    
    $this->cont_id  = AlkRequest::getToken("cont_id", "-1");
    // on vient plus forcément de la gestion des espaces ou de l'annuaire, 
    // prise en compte de l'appli appelante (cas collab)
    $this->appli_id = AlkRequest::getToken("appli_id", "-1");     
  }

  /**
   * Fixe le cont_id associé aux profils gérés
   * @param profil_cont_id  identifiant de l'espace associé aux profils gérés
   */
  public function setContIdAssoc($profil_cont_id)
  {
    $this->profil_cont_id = $profil_cont_id;
  }

  /**
   * @brief Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   * @param iTypeInit  type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   * @brief Appel des actions SQL sur les données du formulaire
   */
  public function doSql() { }

  /**
   * Retourne titre de la popup
   * @return string
   */
  public function getTitle()
  {
    if( $this->profil_cont_id == "0" ) 
      return _t("Gestion des profils généraux");
    return _t("Gestion des profils associés à cet espace");
  }
  
  /**
   * @brief Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $err      = AlkRequest::getToken("err", "0");

    $user_id = AlkFactory::getSProperty("user_id", "-1");       // id de l'agent connecte
    $user_priv = AlkFactory::getSProperty("user_priv", "0");   // id du profil de l'agent connecte
    $service_id = AlkFactory::getSProperty("service_id", "-1"); // id du service de l'agent connecte
    
    if( $this->profil_cont_id == "0" ) {
      $this->appli_id = 0; // appli annuaire
      if( $this->iTypeSheet != ALK_TYPESHEET_POPUP )
        $this->setLabel("Gestion des profils généraux");

      $this->setLabelDesc(_t("Possibilité d'ajouter des profils généraux utilisateurs afin de faciliter la gestion des droits").".<br>".
                          _t("Le profil Utilisateur n'est pas supprimable").".<br>".
                          _t("Cliquer sur 'Droits' pour fixer les droits du profil pour chaque application de cet espace").".<br/>" .
                          _t("Cliquer sur 'Associer' pour associer des utilisateurs de cet espace au profil").".<br/>" .
                          _t("Cliquer sur l'icône précédant le nom du profil pour voir ou supprimer des utilisateurs associés à ce profil").".<br/>");
    } else {
      if( $this->iTypeSheet != ALK_TYPESHEET_POPUP )
        $this->setLabel(_t("Gestion des profils associés à cet espace"));

      $this->setLabelDesc(_t("Possibilité d'ajouter des profils utilisateurs spécifiques à cet espace afin de faciliter la gestion des droits").".<br>".
                          _t("Les profils non cliquables correspondent aux profils généraux").".<br>".
                          _t("Cliquer sur 'Droits' pour fixer les droits du profil pour chaque application de cet espace").".<br/>" .
                          _t("Cliquer sur 'Associer' pour associer des utilisateurs de cet espace au profil").".<br/>" .
                          _t("Cliquer sur l'icône précédant le nom du profil pour voir ou supprimer des utilisateurs associés à ce profil").".<br/>");
    }
    if( $err == "1" ) {
      $this->setLabelWarning(_t("Il est impossible de supprimer ce profil").".<br/>".
                             _t("Veillez à ce qu'il ne soit plus rattaché dans les différentes applications."));
    }
    
    
    
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    AlkFactory::setSQLParamsName();
    
    // liste des profils
    $this->dsProfil = $this->oAppli->oQuery->getDs_listeProfil(-1*$this->profil_cont_id);
    
    $this->strParam = "cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".$this->iTypeSheet.
      "&iSheet=".ALK_SHEET_PROFIL."&iSSheet=".ALK_SHEET_FORM;
    $strToken = AlkRequest::getEncodeParam($this->strParam."&iMode=".ALK_FORM_MODE_ADD);
    $oBtAdd = AlkHtmlFactory::getHtmlButtonPage(ALK_ALKANET."?token=".$strToken, _t("Ajouter"), _t("Ajouter un nouveau profil utilisateur"));
    
    $output = array();
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
      $output = array(
            "sEcho" => AlkFactory::getSQLParamsName("sEcho", ""),
            "iTotalRecords" => $this->dsProfil->getCountTotDr(),
            "iTotalDisplayRecords" => $this->dsProfil->getCountTotDr(),
            "aaData" => array()
          );
          
    AlkFactory::emptySQLParamsName();
    
    $strParamPagine = "cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".$this->iTypeSheet.
                       "&iSheet=".$this->iSheet."&iSSheet=".$this->iSSheet;
    $strUrlPagine = ALK_ALKANET."?token=".AlkRequest::getEncodeParam($strParamPagine."&iMode=4");
    
    $nbElt = $this->dsProfil->getCountTotDr();
    $oTabPage = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, true, $strUrlPagine, "tabPagine");

    $iColspan = 2;
    if( $this->profil_cont_id == "0" ) {
      $oTabPage->SetColumns(array("left",   "300", "PROFIL_INTITULE"),
                            array("center", "80", "", false, false));
    } else {
      $oTabPage->SetColumns(array("left",   "300", "PROFIL_INTITULE"),
                            array("center", "80", "", false, false));
      $iColspan = 3;
    }
    $oTabPage->AddTitleRow(_t("Intitulé des profils"), $oBtAdd->getHtml());
    $oTabPage->setProperty("strTableAlign", "center");
    $oTabPage->setFilter(true);
    $oTabPage->setModeAjax(true);
    $this->addPanel($oTabPage);
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformprofillist.js");
    //$this->setTemplate("annu", "alkhtmlformprofillist.tpl"); 
    $oBlock = $this->addBlock("divAjax");
    $oBlock->addCtrl(AlkHtmlFactory::getHtml("<div id='layerUsersList' style='display:none; text-align:left; overflow:auto; width:490px; height:250px;'></div>"), 
                     ALK_HTMLFORM_1L1C);
    
     // Lecture des données
    $iMode = AlkRequest::getToken("iMode", -1);
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    if ($iMode==4)
      $this->readData(true, $oTabPage, $output);
  }
  
  /**
   * Lecture des données
   */
  private function readData($bModeAjax=false, &$oList, &$output) {
    while( $drProfil = $this->dsProfil->getRowIter() ) {
      $idProfil         = $drProfil->getValueName("PROFIL_ID");
      $strProfil_title  = mb_ereg_replace("/_/", " ", $drProfil->getValueName("PROFIL_INTITULE"));
      $strProfil        = mb_ereg_replace("/_/", " ", $drProfil->getValueName("PROFIL_INTITULE"));
      $profil_effacable = $drProfil->getValueName("PROFIL_EFFACABLE");
      $nbAgent          = $drProfil->getValueName("NB_AG");
      $profil_cont_id   = $drProfil->getValueName("CONT_ID");
      $strHtmlActions   = "";
         
      $bUpdate = ( $profil_effacable == "1" && ($this->profil_cont_id==0 || $this->profil_cont_id==$profil_cont_id) );
      if( $bUpdate ) {
        $strToken = AlkRequest::getEncodeParam($this->strParam."&iMode=".ALK_FORM_MODE_UPDATE."&profil_id=".$idProfil);   
        $strProfil = AlkHtmlFactory::getHtmlButton(ALK_ALKANET."?token=".$strToken, $strProfil_title, "Modifier le profil ".$strProfil_title);
        $strProfil = $strProfil->getHtml();
      }
      if( $this->profil_cont_id!=0 ) {
        // ajout picto pour afficher la liste des utilisateurs ayant ce profil
        $strToken = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_ADMIN.
          "&iSheet=".ALK_SHEET_APPLICATION."&iSSheet=".ALK_SHEET_USERS_LIST."&profil_id=".$idProfil."&idel=".($bUpdate ? "1" : "0"));
        $strProfil = '<a title="'._f("Afficher les %s de cet espace ayant le profil %s ", ALK_S_AGENTS, $strProfil_title).'"'.
                     ' onclick="javascript:showUsers(\''.$strToken.'\')">'.
                     "<img class=\"alkimgicon alkimgiconpriv0\" src='".ALK_MEDIA_URL."images/transp.gif' border='0'></a>&nbsp;".$strProfil;
      } 
      
      $oSuppr = "&nbsp;";       
      if( $bUpdate && $nbAgent==0 ){
        $strToken = AlkRequest::getEncodeParam($this->strParam."&iMode=".ALK_FORM_MODE_DEL."&profil_id=".$idProfil); 
        $oSuppr = AlkHtmlFactory::getHtmlButtonForm("javascript:DeleteData('".$strToken."', '"._t("Veuillez confirmer la suppression de ce profil ?")."');", _t("Supprimer"), _t("Supprimer ce profil"))->getHtml();
      }
      $oDroit = "&nbsp;";
      
      if( AlkFactory::isSpaceAnim() ) {
        $strToken = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                               "&iSheet=".ALK_SHEET_PROFILRIGHT."&profil_id=".$idProfil); 
        $oDroit = AlkHtmlFactory::getHtmlButtonForm("javascript:openProfilRights('".$strToken."')", _t("Droits"), _f("Gérer les droits sur le profil %s", $drProfil->getValueName("PROFIL_INTITULE")))->getHtml(); 
      }
      
      if( $this->profil_cont_id == 0 ) { 
        if ($bModeAjax)
          $output["aaData"][] = array($strProfil, $oSuppr."&nbsp;".$oDroit);
        else
          $oList->addRowByArray(array($strProfil, $oSuppr."&nbsp;".$oDroit));
      
      } else {
        $oAddUser = "&nbsp;";
        if( $profil_cont_id != 0 ) {
          $strTokenSave = AlkRequest::getEncodeParam($this->strParam."&iMode=4&profil_id=".$idProfil);
          $strTokenClose = "reload";
          $strToken = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                 "&iSheet=".ALK_SHEET_USERS_LIST."&cont_id_filtre=".$this->cont_id.
                                                 "&profil_id_exclude=".$idProfil.
                                                 "&tokenSave=".$strTokenSave."&tokenClose=".$strTokenClose);
          $oAddUser = AlkHtmlFactory::getHtmlButtonForm("javascript:selectUsers('".$strToken."')", "Associer", 
                                                        _f("Associer des %s au profil %s", ALK_S_AGENTS, $strProfil_title))->getHtml();
        } 
        if ($bModeAjax)
          $output["aaData"][] = array($strProfil, $oSuppr."&nbsp;".$oDroit."&nbsp;".$oAddUser);
        else
          $oList->addRowByArray(array($strProfil, $oSuppr."&nbsp;".$oDroit."&nbsp;".$oAddUser));
      }
    }
    
  if ( $bModeAjax) {
    echo json_encode( $output );
    exit();
  }
 }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_09_profil_list.htm"); 
  }  

}

?>