<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormProfilForm
 * 
 * Classe de gestion formulaire d'un profil général de l'Annuaire
 */
class AlkHtmlFormProfilForm extends AlkHtmlForm 
{
  /** cont_id associé au profil */
  protected $profil_cont_id;
  
  /** controle de saisie */
  protected $profil_id;
  protected $profil_intitule;
  protected $profil_desc;
  
  protected $cont_id;
  protected $appli_id;
  
  /**
   *  constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formProfilForm"); 

    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_PROFIL, ALK_SHEET_FORM, "&iMode=".$iModeForm);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;
    
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
    
    // prendre en compte le vrai id (inclut la cas où on vient du module collab)
    $this->cont_id  = AlkRequest::getToken("cont_id", "-1");
    $this->profil_cont_id = 0;    
  }

  /**
   * Fixe le cont_id associé aux profils gérés
   * @param profil_cont_id  identifiant de l'espace associé aux profils gérés
   */
  public function setContIdAssoc($profil_cont_id)
  {
    $this->profil_cont_id = $profil_cont_id;
  }

  /**
   * Retourne titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return ( $this->iMode == ALK_FORM_MODE_ADD
             ? _t("Cr&eacute;ation d'un nouveau profil")
             : _t("Modification du profil"));
  }

  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   * @param iTypeInit  type de récupération
   */
  protected function setData($iTypeInit)
  {
    $this->appli_id = AlkRequest::getToken("appli_id", "-1"); // espace=-1, annu=0 ou collab>0
    $this->appli_id = ( $this->profil_cont_id != "0" ? $this->appli_id : "0" );
    
    // si dans le request prend la valeur du request sion va chercher dans le token
  	$profil_id = AlkRequest::getToken("profil_id", AlkRequest::_REQUESTint("profil_id", "-1"));
    
    $this->profil_id        = new AlkFormData($this, "profil_id", $profil_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->profil_intitule  = new AlkFormData($this, "profil_intitule", "", ALK_SQL_TEXT);
    $this->profil_desc      = new AlkFormData($this, "profil_desc", "", ALK_SQL_TEXT);
    
    $tabData = array(null);
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $oDsData = $this->oAppli->oQuery->GetDs_ficheProfil($profil_id);
      $tabData[] = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
      
    foreach ($tabData as $oDrData){
      $this->initData($iTypeInit, $oDrData, $reqMethod);
    }
    
    $this->profil_rang->value = $this->profil_id->value;
  }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {    
    $this->setData(ALK_INIT_MODE_REQUEST);
    if( $this->iMode != ALK_FORM_MODE_DEL ) {
      $tabFields = $this->getTabQuery(array(mb_strtoupper($this->profil_id->name)));
    }

    $strToken = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".$this->iTypeSheet.
                                           "&iSheet=".ALK_SHEET_PROFIL."&iSSheet=".ALK_SHEET_LIST);
    
    $oSpace = $this->oAppli->getProperty("oSpace", null);
    
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD:
      $profil_id = $this->oAppli->addProfil($tabFields, $this->profil_cont_id);
      

      $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuProfilForm", $this, $profil_id, $tabFields);
      break;
      
    case ALK_FORM_MODE_UPDATE:    
      $this->oAppli->oQueryAction->updateWithTabQuery($this, $tabFields, "SIT_PROFIL");
      $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuProfilForm", $this, $this->profil_id->value, $tabFields);
      break;
    
    case ALK_FORM_MODE_DEL:
      $this->oAppli->delProfil($this->profil_id->value);
      $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuProfilForm", $this, $this->profil_id->value, array());
      break;
      
    case 4: // association agent-profil secondaire spécifique
      $tabListUserId = $this->oAppli->oQueryAction->deladdUsersToProfil($this->profil_id->value);
      $oSpace->setProfilRightToUser($tabListUserId);
      $strTokenSave = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".$this->iTypeSheet.
        "&iSheet=".ALK_SHEET_PROFIL."&iSSheet=".ALK_SHEET_FORM."&iMode=4&profil_id=".$this->profil_id->value);
      $strTokenClose = "reload";
      $strToken = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                             "&iSheet=".ALK_SHEET_USERS_LIST."&cont_id_filtre=".$this->cont_id.
                                             "&profil_id_exclude=".$this->profil_id->value.
                                             "&tokenSave=".$strTokenSave."&tokenClose=".$strTokenClose);
      break;
    }

    return ALK_ALKANET."?token=".$strToken;
  }  
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    
    $iTxtWidth  = 48;
    $iMemoWidth = 46;
    $iMemoHeight = 4;

    if( $this->profil_cont_id == "0" ) {
      $strTitle = ( $this->iMode == ALK_FORM_MODE_ADD
                    ? _t("Cr&eacute;ation d'un nouveau profil général")
                    : _t("Modification du profil général"));
    } else {
      $strTitle = ( $this->iMode == ALK_FORM_MODE_ADD
                    ? _t("Cr&eacute;ation d'un nouveau profil spécifique pour cet espace")
                    : _t("Modification du profil spécifique à cet espace"));
    }
      
    $oHide = AlkHtmlFactory::getHtmlHidden($this->profil_id);
    
    $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->profil_intitule, _t("Intitulé"), 1, $iTxtWidth, 80);
    $oCtrlTxt->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    
    $oCtrlMemo = AlkHtmlFactory::getHtmlText($this->profil_desc, _t("Description"), $iMemoHeight, $iMemoWidth, 255);
    $oCtrlMemo->addValidator(ALK_VERIF_MEMO);

    $oBlock = $this->addBlock("block_profil", $strTitle, "", "100", "390", true);
    $oBlock->addCtrl($oCtrlTxt);
    $oBlock->addCtrl($oCtrlMemo);

    /** Elements spécifiques aux applications de l'espace */
    $oSpace = $this->oAppli->getProperty("oSpace", null);
    if ( !is_null($oSpace) )
      $oSpace->callService($this->oAppli->atype_id, "getHtmlAnnuProfilForm", $this, $this, $this->profil_id->value);

    $strToken = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".$this->iTypeSheet.
                                           "&iSheet=".ALK_SHEET_PROFIL."&iSSheet=".ALK_SHEET_FORM."&iMode=".$this->iMode);
    $oBtValid = $this->addButtonPage("btValid", "javascript:Valider('".$strToken."')", _t("Valider"), _t("Valider le profil"));
    $this->addSubmitButton($oBtValid);

    $strToken = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".$this->iTypeSheet.
                                           "&iSheet=".ALK_SHEET_PROFIL."&iSSheet=".ALK_SHEET_LIST);
    $oBtCancel = $this->addButtonPage("btCancel", ALK_ALKANET."?token=".$strToken, _t("Annuler"), _t("Retour à la liste"));

    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformprofilform.js");
  }  
}

?>