<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormMissionList
 * 
 * Classe de gestion de la liste des missions de l'Annuaire
 */
class AlkHtmlFormMissionList extends AlkHtmlForm 
{
  /** ctrl text de recherche */
  protected $strRecherche;
  
  /**
   *  constructeur par défaut
   * @param oAppli Référence sur l'application associée 
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formMissionList"); 

    $this->strParam  = "cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_ADMIN.
      "&iSheet=".ALK_SHEET_MISSION."&iSSheet=".ALK_SHEET_LIST;    
    $strAction = ALK_ALKANET."?token=".AlkRequest::getEncodeParam($this->strParam);
    
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, $strAction);    
  }

  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   * @param iTypeInit  Type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql(){ }
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
     $strRecherche = AlkRequest::getToken("strRecherche", strtolower(AlkRequest::_REQUEST("strRecherche", "")));
    $this->strRecherche = new AlkFormData($this, "strRecherche", $strRecherche, ALK_SQL_TEXT);

    $page = ALKRequest::_GETint("page", 1);
    $nbEltParPage = AlkRequest::_GETint("nbItemsPerPage", ALK_ITEMS_PER_PAGE);
    
    $this->strParam = "&strRecherche=".$strRecherche."&iMode=";
    
    $this->setLabel(_t("Gestion des missions"));
    $this->setLabelDesc(_t("Il est possible de modifier l'intitul&eacute; d'une mission ainsi que de supprimer une mission non utilis&eacute;e."));
    
    $iFirst = ($page-1)*$nbEltParPage;
    $iLast  = $page*$nbEltParPage-1;
    
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    AlkFactory::setSQLParamsName();
    
    $this->dsMission = $this->oAppli->oQuery->GetDs_listeMission($strRecherche, $iFirst, $iLast);
    $nbElt  = $this->dsMission->getCountTotDr();
    
    $output = array();
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
      $output = array(
            "sEcho" => AlkFactory::getSQLParamsName("sEcho", ""),
            "iTotalRecords" => $this->dsMission->getCountTotDr(),
            "iTotalDisplayRecords" => $this->dsMission->getCountTotDr(),
            "aaData" => array()
          );
    AlkFactory::emptySQLParamsName();
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_MISSION, ALK_SHEET_FORM, $this->strParam.ALK_FORM_MODE_ADD."&page=".$page);
    $oBtAdd = AlkHtmlfactory::getHtmlButtonPage(ALK_ALKANET."?token=".$strToken, _t("Ajouter"), _t("Ajouter une nouvelle mission"));
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_MISSION, ALK_SHEET_LIST, $this->strParam.ALK_FORM_MODE_UPDATE);
    $strUrlPagine = ALK_ALKANET."?token=".$strToken;
    
    $oTabPage = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, true, $strUrlPagine);
    $oTabPage->setFilter(true);
    $oTabPage->setModeAjax(true);
   
    $oTabPage->SetColumns(array("left",   "430", "MISSION_INTITULE"),
                          array("center", "120", "", false, false));
    $oTabPage->AddTitleRow( _t("Liste des missions"), $oBtAdd->getHtml());
    
    $oTabPage->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformmissionlist.js");
    $this->addPanel($oTabPage);
    
    $iMode = AlkRequest::getToken("iMode", -1);
     
    // Lecture des données
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    if ($iMode==ALK_FORM_MODE_UPDATE)
      $this->readData(true, $nbElt, $page, $nbEltParPage, $oTabPage, $output);
  }
  
  /**
   * Lecture des données
   */
  private function readData($bModeAjax=false, $nbElt, $page, $nbEltParPage, &$oList, &$output) {
    
    while( $drMission = $this->dsMission->getRowIter() ) {
      $nbAgent = $drMission->getValueName("NB_AG");
      $idMission = $drMission->getValueName("MISSION_ID");
      $strMission = $drMission->getValueName("MISSION_INTITULE");
    
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_MISSION, ALK_SHEET_FORM, 
                                          "&mission_id=".$idMission.$this->strParam.ALK_FORM_MODE_UPDATE."&page=".$page);    
      $oMission = AlkHtmlFactory::getHtmlButton(ALK_ALKANET."?token=".$strToken, $strMission, _f("Modifier la mission %s", $strMission));
 
      $oSuppr = "&nbsp;";
      if($nbAgent == "0" ) {
        $iPage = ( $nbElt-1 <= ($page-1)*$nbEltParPage ? ($page-1>0 ? $page-1 : 1) : $page);
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_MISSION, ALK_SHEET_FORM, 
                                            "&mission_id=".$idMission.$this->strParam.ALK_FORM_MODE_DEL."&page=".$iPage);
        $oSuppr = AlkHtmlFactory::getHtmlButtonForm("javascript:DeleteData('".$strToken."', '"._t("Veuillez confirmer la suppression de cette mission ?")."');", 
                                                    _t("Supprimer"), _f("Supprimer la mission %s",$strMission));
      }
      
       if ($bModeAjax)
        $output["aaData"][] = array($oMission, $oSuppr);
      else
        $oList->addRowByArray(array($oMission, $oSuppr));
    }
    
    if ( $bModeAjax) {
      echo json_encode( $output );
      exit();
    }
  }
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_06_mission_list.htm"); 
  }    
}
?>