<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * la version 3.5.0_RELEASE correspond à la marquée 3.4.9
 */
$strNum = "3.5.0";
$tabIns[$strNum][] = "";

/**
 * BFE : ajout de la colonne service_valide correspondant au statut actif(1), inactif(0), en attente d'activation(-2)
 * BFE : gestion du statut de services sur les différentes interfaces de l'annuaire (seul les services actifs sont affichés)
 * BFE : compatiblite PHP 5.3 
 */
$strNum = "3.5.1";
$tabAlterTable[$strNum]["sit_service"] = array(
  array("action"    => "add", 
        "column"    => "service_valide", 
        "type"      => "int", "length" => "", "default" => "1", "nullable" => -1));

/**
 * MTO : alkappliannu.class.php : correction fonction addUserToSpace(), prise en compte des cas cont_id=-1 et cont_id=-2
 *                                correction fonction removeUserFromSpace(), prise en compte du cas cont_id=-1
 * BFE : alkhtmlformprofillist.class.php : correction fonction php mb_preg_replace
 * LGD : alkqueryannu_action.class.php : dans le addListe() limitation de la longueur l'intitule de la liste à 80 carac
 * VDR : alkhtmlformserviceform.class.php : ajout de la date de création du service
 *       alkqueryannu_action.class.php : ajout de la date de creation dans la fonction addService()
 *       alkqueryannu.class.php : ajout de la fonction getNombreAgent($service_id)
 * BFE : alkpopupuserfiche.class.php,  alkpopupservicefiche passage en mode ALK_FORM_MODE_READ de la fiche popup agent
 * LGD : alkhtmlformagentform.class.php : ajout d'une fonction getTokenAction permettant de communiquer avec collab (token retourné par collab pour fermeture popup)
 * BFE : alkappliannu.class.php : ajout de la méthode getHelp permettant d'obtenir l'intitulé de la rubrique d'aide associée à l'appli
*/
$strNum = "3.5.2";
$tabIns[$strNum][] = "";
$tabAlterTable[$strNum]["sit_service"] = array(
    array("action"    => "add",
        "column"    => "service_date_creation",
        "type" => "datetime", "length" => "", "default" => "", "nullable"  => 0));


/**
 * MTO : alkhtmlformagentform.class.php : déplacement et création des tokens add, mail, update, back dans des méthodes de la classe pour faciliter la surchage/redéfinition (par collab)
 * VDR : modification taille champ "abonne_pwd" table "sit_abonne"
*/
$strNum = "3.5.3";
$tabIns[$strNum][] = "";
$tabAlterTable[$strNum]["sit_abonne"] = array(
  array("action"    => "update", 
        "column"    => "abonne_pwd",
        "newcolumn" => "abonne_pwd",
        "type"      => "varchar(80)", "dn" => ""));

/**
 * MTO : alkqueryannu.class.php : correction de la gestion des droits => l'utilisateur doit pouvoir voir ses listes qui sont privées pour tous les espaces
 *     : alkhtmlpopuplsdif.class.php : correction de la sauvegarde d'une liste => sauvegarde la liste dans son espace et non dans l'espace courant
 *                                   : modification des droits de gestion des abonnées d'une liste => possibilité de gérer les abonnées d'une liste à tout utilisateur accédant à celle-ci
 *     : alkhtmllistabonne.class.php, alkhtmlpopupabonnement.class.php : modification des paramètres de l'appel de la fonction getDsListes() => récupère toutes les listes de type "liste diff" ($liste_type=0) et "liste d'abonnement explicite (lettre d'information)" ($liste_type=3) visibles pour l'utilisateur connecté
 *     : alkhtmlpopupabonnement.js : ajout vérification existence attribut "name"
 *     : alkhtmlpopupabonnement.class.php : ajout paramètre bCollab manquant
*/
$strNum = "3.5.4";
$tabIns[$strNum][] = "";

/**
 * MTO : alkhtmlformagentform.class.php : déplacement et création des tokens add, mail, update, del, back dans des méthodes de la classe pour faciliter la surchage/redéfinition (par collab)
 *     : alkhtmlpopuplsdif.class.php : désactivation du champ "visible" car non utilisé dans la gestion de visibilité des listes + valeur par défaut à 1
*/
$strNum = "3.5.5";
$tabIns[$strNum][] = "";

/**
 * MTO : alkhtmlformrechercheform.class.php : suppression du nombre de caractères maximal du champ de recherche ragent_nom
*/
$strNum = "3.5.6";
$tabIns[$strNum][] = "";

/**
 * EGD : 03_annu.sql.php : correction du script d'initialisation pour que le sit_abonne correspondant au sit_agent de l'administrateur Alkante soit valide
*/
$strNum = "3.5.7";
$tabIns[$strNum][] = "";
$tabIns[$strNum][] = "update SIT_ABONNE set ABONNE_VALIDE = 1 where AGENT_ID = 1";

/**
 * EGD : Modification du mot de passe Alkante attribué par défaut à l'initialisation
 * MTO : ajout du champ ABONNE_DESC dans la table SIT_ABONNE car celui-ci a été ajouté en 3.3.9 mais n'a pas été intégré dans le patch d'install
 *     : alkhtmlformabonne.class.php : modification token + fonction javascript de l'action de validation
 *     : alkhtmlformagentform.class.php, alkhtmlformagentform.js : modifications de la gestion des profils pour les administrateurs annuaire de service
 *                                                                   - un administrateur annuaire de service ne peut pas modifier ses propres profils
 *                                                                   - un administrateur annuaire de service ne peut ajouter/modifier/supprimer les profils d'un agent que s'il possède lui-même ces profils
*/
$strNum = "3.5.8";
$tabIns[$strNum][] = "";

$tabAlterTable[$strNum]["sit_abonne"] = array(
  array("action"    => "add", 
        "column"    => "abonne_desc",
        "type"      => "varchar", "length" => "255", "default" => "", "nullable"  => -1));

/**
 * MTO : alkhtmlpopupservicefiche.class.php : correction navigation vers un autre service de l'arborescence
 *     : alkqueryannu_action.class.php : modif addAbonne() updateAbonne() => rétablissement champ ABONNE_DESC
 */
$strNum = "3.5.9";
$tabIns[$strNum][] = "";

/**
 * MTO : alkapppliannu.class.php : ajout fonction syncEspaceListe() pour synchroniser la liste de diffusion des utilisateurs d'un espace
 *     : alkhtmlformagentform.js : modif fonction fnLoadSaveEnd() => suppression commentaire
 * ALC : alkimportabonne.class.php : Passage de php 5.3 à php 5.4
 *     + alkhtmlformabonne.class.php
 *     + alkhtmlpopupabonnement.class.php
 */
$strNum = "3.5.10";
$tabIns[$strNum][] = "";

/**
 * EMA : Intégration du Jquery DATATABLE
 */
$strNum = "3.5.11";
$tabIns[$strNum][] = "";


/**
 * EMA : Corrections sur les listes Jquery DATATABLE
 * MTO : alkhtmlpopupuserslist.js : ajout d'un message d'alerte informant des utilsateurs ajoutés (mode JS uniquement)
 *     : modification de la fonction getDsAbonnesByListe() => couplage lié à une union dans alkhtmlpopuplsdifdestlist.class.php avec la fonction getStrDsListeAgentMailForLsDif()
 *     : correction orthographe "utilisteurs" par "utilisateurs"
 *     : alkhtmlpopupabonnement.class.php : ajout du caractère ":" pour séparer les labels des champs
 * BFE : alkappliannu.class.php : ajout d'une constante ALK_B_ANNU_ABONNES par défaut à vrai qui gère l'affichage des onglets mes listes et Abonnés
 * BFE : alkqueryannu.class.php : ajout de SERVICE_INTITULE au résultat de la requête getDsListUserByServ
 * EMA/MTO : alkhtmlpopuplsdif.class.php : Corrections sur les listes Jquery DATATABLE
 */
$strNum = "3.5.12";
$tabIns[$strNum][] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_ABONNES','true',3,'Prise en compte des abonnés ',2)";

$tabIns[$strNum][] = "update SIT_LISTE set LISTE_INTITULE_FR=replace(LISTE_INTITULE_FR, 'utilisteurs', 'utilisateurs')";

/**
 * ALC : alkappliannu.class.php : Ajout de la possibilité d'ajouter un logo à un service, affichage de ce logo dans le fiche du service quand présent
 *     + alkhtmlformserviceform.class.php
 *     + alkhtmlpopupservicefiche.class.php
 *     + alkqueryannu_action.class.php
 *     + alkqueryannu.class.php
 *       Ajout de la colonne service_logo dans la table sit_service
 *       Ajout de la constante ALK_B_ANNU_SERVICE_LOGO dans la table sit_constante pour permettre à l'utilisateur d'affecter un logo à un service
 */
$strNum = "3.5.13";
$tabAlterTable[$strNum]["sit_service"] = array(
	array("action"	=> "add",
		  "column"	=> "service_logo",
        "type"      => "varchar", "length" => "255", "default" => "", "nullable"  => -1));
		

$tabIns[$strNum][] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) 
 values (1,-1,'ALK_B_ANNU_SERVICE_LOGO','false',3,'".$dbConn->analyseSql("Permettre à l'utilisateur de sélectionner un logo pour un service")."',2)";

/**
 * EMA : Corrections Jquery DATATABLE
 * remplacement des constantes définissant les chemins vers les modues, /templates/, classes/form, classes/pattern
 * ALC : alkhtmlformimportuser.class.php : correction instanciation AlkImportAnnu : passage par variable oQuery, oQueryAction, oSpace, oAppli pour passage php 5.3 a ph 5.4
 * MTO : alkhtmlformagentform.class.php : utilisation de la métode getTokenBack()
 * MTO : alkhtmlpopuplsdif.class.php : ajout méthode getTokenAddUsers() pour mutualiser le code de construction du token du formulaire d'ajout d'utilisateurs car le paramètre abonne_id_filtre=1 était manquant dans un cas,impliquait un disfonctionnement lors du filtre et de l'ajout successif de plusieurs utilisateurs 
 */
$strNum = "3.5.14";
$tabIns[$strNum] = "";

/**
 * EGD : alkqueryannu_action.class.php : Corrections de updateService() et de addService(), une variable agent_id non déclaré était utilisée dans l'appel à la méthode doUpload()
 * ALC : Ajout de la constante ALK_B_ANNU_CLOISONNEMENT_SERVICE pour authoriser le cloisonnement complet des informations entre services
 * BFE : alkappliannu.class.php : correction syntaxique
 */
$strNum = "3.5.15";
$tabIns[$strNum] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_CLOISONNEMENT_SERVICE','false',3,'Permettre le cloisonnement des informations entre services',2)";
?>