#!/usr/bin/perl -w

#/*licence/ 
#
# Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>
#
# Nom du module : Alkanet::Module::Alkanet
# Module cgifournissant les pages adressables Alkanet.
# Ce module appartient au framework Alkanet.

# Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
# respectant les principes de diffusion des logiciels libres. Vous pouvez
# utiliser, modifier et/ou redistribuer ce programme sous les conditions
# de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
# sur le site http://www.cecill.info.
#
# En contrepartie de l'accessibilité au code source et des droits de copie,
# de modification et de redistribution accordés par cette licence, il n'est
# offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
# seule une responsabilité restreinte pèse sur l'auteur du programme, le
# titulaire des droits patrimoniaux et les concédants successifs.

# A cet égard l'attention de l'utilisateur est attirée sur les risques
# associés au chargement, à l'utilisation, à la modification et/ou au
# développement et à la reproduction du logiciel par l'utilisateur étant
# donné sa spécificité de logiciel libre, qui peut le rendre complexe à
# manipuler et qui le réserve donc à des développeurs et des professionnels
# avertis possédant des connaissances informatiques approfondies. Les
# utilisateurs sont donc invités à charger et tester l'adéquation du
# logiciel à leurs besoins dans des conditions permettant d'assurer la
# sécurité de leurs systèmes et ou de leurs données et, plus généralement,
# à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

# Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
# pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
# termes.
#
#/licence*/

#
# Note d'installation : suppose que les paramètre php.ini :
# session.save_path et upload_tmp_dir pointent sur le même répertoire 
# correspondant au paramètre cgi dtmp
# 

use CGI;
use Fcntl qw(:DEFAULT :flock);
use File::Temp qw/ tempfile tempdir /;

#
# Constantes
#

print "Content-type: text/html\r\n\r\n";
print "<html><body>";

$maxUploadSize = 1024*1024*1024; # 1Go
$blockSize     = 4096;

#
# Paramètres de l'url
#

@tabQueryString = split(/&/, $ENV{'QUERY_STRING'});
@tabParam = ();
my $i;
my $iParamCount = 0;
for $i (0..$#tabQueryString) { 
  @tabTmp = split(/=/, $tabQueryString[$i]);
  if( $tabTmp[0] eq "ids" || $tabTmp[0] eq "dtmp" ) {
    $tabParam{$tabTmp[0]} = $tabTmp[1];
    $iParamCount++;
  }
}

if( $iParamCount != 2 ) {
  # éviter d'avoir un message d'erreur trop explicite = securité
  print "Paramètres non valides.</body></html>";
  exit;
}

$strPathTmp = $tabParam{"dtmp"};
@tabSession = split(/_/, $tabParam{"ids"}, 3);

# identifiant unique permettant de nommer le fichier temporaire
$idSession  = $tabSession[0];

# fichier de session php
$strFileSession = "sess_NONE";
if( exists($tabSession[1]) ) {
  $strFileSession = "sess_$tabSession[1]";
}

# nom du ctrl file posté
$strCtrlName = "ctrlNameNONE";
if( exists($tabSession[2]) ) {
  $strCtrlName = $tabSession[2];
}

if( !(-d "$strPathTmp") ) {
	print "Le répertoire de destination n'existe pas.</body></html>";
	exit;
}

if( !(-f "$strPathTmp/$strFileSession") ) {
  # le fichier de session php n'est pas trouvé, éviter d'avoir un message d'erreur trop explicite = securité
	print "Sécurité non assurée.</body></html>";
	exit;
}

# don't change the next few lines unless you have a very good reason to.

$post_data_file = "$strPathTmp/$idSession"."_postdata";
$monitor_file   = "$strPathTmp/$idSession"."_flength";
$error_file     = "$strPathTmp/$idSession"."_err";

#
# Fonction de fin de traitement
#
sub quitUpload 
{
	$mes = shift;
	
	# Try to open error file to output message too
	$err_ok = open (ERRFILE, ">$error_file");
	if( $err_ok ) {
		print ERRFILE $mes; 
		close (ERRFILE);
	}
  print "Ko</body></html>";
	exit();
}

#
# Ecrit dans monitor_file, la taille totale et la taille en cours
#
sub writeLength
{
  $iLen = shift;
  $iCur = shift;
	
	open(FH, ">$monitor_file");
	print FH "$iLen|$iCur";	
	close(FH);	
}

$content_type = $ENV{'CONTENT_TYPE'};

# lecture du séparateur d'information
$boundary = $content_type;
$boundary =~ s/boundary=(.*)/$1/is;
$boundary = "\r\n--".$1;
 
$iLength = $ENV{'CONTENT_LENGTH'};
$iSizeRead = 0;
$|=1;

# see if we are within the allowed limit.

if( $iLength > $maxUploadSize ) {
	close(STDIN);
	my $iSize = $maxUploadSize/1024/1024;
	quitUpload("Le transfert est limité à $iSize Mo.");
}

#
# The thing to watch out for is file locking. Only
# one thread may open a file for writing at any given time.
# 

if (-e "$post_data_file") {
	unlink("$post_data_file");
}

if (-e "$monitor_file") {
	unlink("$monitor_file");
}

if (-e "$error_file") {
  unlink("$error_file");
}

#
# Mémorise la taille du fichier à transferer
#
writeLength($iLength, 0);

open(TMP,">","$post_data_file") 
  or &quitUpload ("Impossible de créer le fichier sur le serveur");
binmode TMP, ':raw';

#
# Récupération du fichier à transférer dans le fichier temporaire
#
$ofh = select(TMP); $| = 1; select ($ofh);

$iEnd = 0;
# recherche le début du contenu du fichier
while( ($iEnd==0) && ($strLine = readline(STDIN)) ) {
  if( $strLine =~ s/^Content-Disposition: form-data; name="(([^"]*)*)"; filename="([^"]*)"/$1/is ) {
    if( $strCtrlName eq $1 ) {
      $strLine = readline(STDIN); # lecture de la ligne content-type
      $strLine = readline(STDIN); # lecture de la ligne vide
      $iEnd = 1;
    }
  }
}
if( $iEnd == 0 ) {
  # éviter d'avoir un message d'erreur trop explicite = securité
  &quitUpload("Aucun fichier transmis.");
}

$iTime = time()+1;
$lastBlock = "";
$iSizeRead = 0;
$iEnd = 0;
while( ($iEnd == 0) && ($iSizeBlockRead = read(STDIN ,$LINE, $blockSize)) ) {

	$iSizeRead += $iSizeBlockRead;

  my $pid_child = 0;
  if( $iTime < time() ) {
    $pid_child = fork();
    $iTime = time()+1;
  } 
  if( $pid_child ) {
    # processus enfant
    writeLength($iLength, $iSizeRead);
    exit(0);
  } else {
    # processus parent
    $blockTmp = "$LINE";
    my @tabTmp = split(/$boundary/, $blockTmp);
    if( exists($tabTmp[1]) ) { 
      # détection de fin sur le block courant
      print TMP $lastBlock.$tabTmp[0];
      $iEnd = 1;
    } else {
      $blockTmp = "$lastBlock$LINE";
      my @tabTmp2 = split(/$boundary/, $blockTmp);
      if( exists($tabTmp2[1]) ) {
        # détection de fin sur la concaténation du block précédent et courant
        print TMP $tabTmp2[0];
        $iEnd = 1;
      } else {
        # écriture différée
        if( lastBlock ne "" ) {
          print TMP $lastBlock;
        }
      
        # mémorise le dernier bloc
        $lastBlock = $LINE;
      }
    }

    # attent la fin du processus fils
    waitpid($pid_child, 0);
  }
}
close (TMP);

# Response
if( $iEnd == 0 ) {
  writeLength($iLength, $iLength+1);
  print "Ko";
} else {
  writeLength($iLength, $iLength);
  print "Ok";
}
print "</body></html>";
