<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Alkanet
Module fournissant une image de sécurité, A appeler dans la balise src du tag html <image>
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * @file alkanet_security_image.php
 * @package Alkanet_Appli
 * @brief Page appelée qui retourne sur la sortie standard, 
 *        une image de hauteur 25px et de longueur 17 fois la longueur du code affiché
 *        Appeler AlkFactory::initSecurityCode() pour initialiser un code
 */

session_start();
require_once("../../"."libconf/app_conf.php");
require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkfactory.class.php");

$iVerif       = ( isset($_GET["v"]) ? $_GET["v"] : "0" );
$strCodeVerif = ( isset($_GET["c"]) ? $_GET["c"] : "" );

if( $iVerif == "1" && $strCodeVerif!="" ) {
  // mode vérification
  if( $strCodeVerif == AlkFactory::getLastSecurityCode() ) {
    echo "ok";
  } else {
    echo "false"; 
  }
  exit(); 
} 

// mode génération d'image de sécurité
$strLetters = ( defined("ALK_SECURITY_LETTERS") 
                ? ALK_SECURITY_LETTERS
                : "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz£\$" );
$code = AlkFactory::initSecurityCode(6, $strLetters); 

if( $code == "" ) {
  die("Aucun code &agrave; afficher."); 
} 

$iWidth  = 17*strlen($code);
$iHeight = 25;

// Initialisation de l'image
$img = imageCreate($iWidth, $iHeight) or die ("Probl&egrave;me GD");
$backgroundColor = imagecolorallocate ($img, 238, 238, 238);
$fontColor       = imagecolorallocate ($img, 0, 0, 0);
$borderColor     = imagecolorallocate ($img, 0, 0, 0);
//$fontFile        = "./font/arial.ttf";
$fontFile        = "./font/timesi.ttf";
$tabSizePt       = array(10, 12, 14);  // taille possible des polices
$tabDegres       = array(-30, -20, -10, 0, 10, 20, 30);  // taille possible des polices

imagefilledrectangle($img, 0, 0, $iWidth-1, $iHeight-1, $borderColor);
imagefilledrectangle($img, 1, 1, $iWidth-2, $iHeight-2, $backgroundColor);

$iX = -10;
for($i=0; $i<strlen($code); $i++) {
  
  $iX += rand(12, 17);
  $iY = rand($iHeight-5, $iHeight-10);

  imagefttext($img, 
              $tabSizePt[rand(0, count($tabSizePt)-1)], 
              $tabDegres[rand(0, count($tabDegres)-1)], 
              $iX, $iY, 
              $fontColor, $fontFile, 
              $code[$i]);
}

// on créé une image avec une qualité médiocre de 30%
// pour éviter qu'un robot puisse la lire
$strFileImg = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."cache/imagesecure".uniqid().".jpg";
imagejpeg($img, $strFileImg, 30);

// on libère la mémoire
imageDestroy($img);
header("location:".str_replace(ALK_ALKANET_ROOT_PATH, ALK_ALKANET_ROOT_URL, $strFileImg));
?>