<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Alkanet
Module fournissant les pages adressables Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once("../../lib/lib_session.php");

AlkRequest::readToken();
$atype_id   = AlkRequest::getToken("atype_id", "-1");
$strModulePath = AlkFactory::getModulePath($atype_id);
$iAppliOnly = 0;
if( $atype_id != "-1" && $strModulePath != "" ) {
  $iAppliOnly = AlkRequest::getToken("appliOnly", "0");
}
 
//---------------------------------------------
// parcours recursif
//---------------------------------------------
$tabFileIndex = array();
function readModules($strPathName, $iNiv)
{
  global $tabFileIndex;
   
  if( $strPathName[strlen($strPathName)-1] != '/' )
    $strPathName .= '/';

  if( !file_exists($strPathName) )
    return $strPathName." n'existe pas.";

  $handle = opendir($strPathName);
  while( $strFile = readdir($handle) ) {
    if( $strFile=='.' || $strFile=='..' )
      continue;
    if( is_dir($strPathName.$strFile) ) {
      if( $iNiv == 0 && $strFile!="alkanet" && $strFile!="ident" ) {
        readModules($strPathName.$strFile, 1);
      } elseif( $iNiv == 1 && $strFile=='help' ) {
        readModules($strPathName.$strFile, 2);
      }
    } else {
      if( $strFile == "index.txt"  ) {
        $tabFileIndex[] = $strPathName.$strFile;
      }
    }
  }
  closedir($handle);
}

/**
 * incrémente l'index caractère en évitant les caractères spéciaux
 * @param iChar  indice du caractère courant passé par référence
 */
function incChar(&$iChar)
{
  $iChar++;
  if( chr($iChar) == "\\" ) {
    $iChar++;
  }  
}

/**
 * Retourne le code js pour les noeuds de niveau 3
 * @param tabContents   contenu du fichier index (la première ligne contient le titre de niveau 2, les autres : titre|url du niveau 3
 * @param strPathModule chemin relatif vers le répertoire help du module concerné
 * @return string
 */
function writeLevel3($tabContents, $strPathModule, $bLast=false)
{
  global $tabLevel;

  if( trim($tabContents[count($tabContents)-1]) == "" ) {
    unset($tabContents[count($tabContents)-1]); 
  }
  
  $strTitle = trim($tabContents[0]);
  $strFunction = ( !$bLast ? "sub_Book" : "lastBook" );
  $strHtmlJs = $strFunction."(\"".$strTitle."\", \"".chr($tabLevel[0]).chr($tabLevel[1])."\");\n";

  for($i=1; $i<count($tabContents); $i++) {
    $tabInfoPage = explode("|", $tabContents[$i]);
    $strTitlePage = trim($tabInfoPage[0]);
    $strUrlPage = ( isset($tabInfoPage[1]) ? trim($tabInfoPage[1]) : "" );
    $strFunction = ( $i<count($tabContents)-1 ? "sub_Page" : "lastPage" );
     
    $strHtmlJs .= $strFunction."(\"".$strTitlePage."\", \"".chr($tabLevel[0]).chr($tabLevel[1]).chr($tabLevel[2])."\", \"../".$strPathModule."".$strUrlPage."\");\n";
    incChar($tabLevel[2]);
  }
  
  $strHtmlJs .= "end_Book();\n";
  return $strHtmlJs; 
}

$strPathScripts = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."";
if( $iAppliOnly == "0" ) {
  readModules($strPathScripts, 0);
} else {
  readModules($strModulePath, 1);
}
sort($tabFileIndex);
$strHtmlJs = "";

$tabLevel = array(ord("C"), ord("D"), ord("E"), ord("A"));
for($f=0; $f<count($tabFileIndex); $f++) {
  $strPathFileNameIndex = $tabFileIndex[$f];
  $tabPathDir = explode("/", $strPathFileNameIndex);
  $strPathModule = $tabPathDir[count($tabPathDir)-3]."/".$tabPathDir[count($tabPathDir)-2];

  $tabContents = file($strPathFileNameIndex);
  $strModuleName = trim($tabContents[0]);
    
  $strFunction = ( $f<count($tabFileIndex)-1 ? "sub_Book" : "lastBook" );
  $strHtmlJs .=  $strFunction."(\"".$strModuleName."\",\"".chr($tabLevel[0])."\");\n";

    
  for($i=1; $i<count($tabContents); $i++) {
     $tabInfoPage = explode("|", $tabContents[$i]);
     $strTitlePage = trim($tabInfoPage[0]);
     $strUrlPage = trim($tabInfoPage[1]);
     $strFunction = ( $i<count($tabContents)-1 ? "sub_Page" : "lastPage" );
     
     $strHtmlJs .=  $strFunction."(\"".$strTitlePage."\", \"".chr($tabLevel[0]).chr($tabLevel[1])."\", \"../".$strPathModule."/".$strUrlPage."\");\n";
     incChar($tabLevel[1]);
     
  }
  $strPathModule .= "/";
  $strFileNameIndexConsult = $strPathScripts.$strPathModule.substr($strPathFileNameIndex, -9, 5)."_consult.txt";
  $strFileNameIndexAdmin= $strPathScripts.$strPathModule.substr($strPathFileNameIndex, -9, 5)."_admin.txt";
  $strFileNameIndexProp = $strPathScripts.$strPathModule.substr($strPathFileNameIndex, -9, 5)."_prop.txt";

  $tabLastBook = array(false, false, false);
  $tabLastBook[2] = file_exists($strFileNameIndexProp);
  $tabLastBook[1] = !$tabLastBook[2] && file_exists($strFileNameIndexAdmin);
  $tabLastBook[0] = !$tabLastBook[1] && file_exists($strFileNameIndexConsult);

  if( file_exists($strFileNameIndexConsult) ) {
    $tabContentsC = file($strFileNameIndexConsult);
    $strHtmlJs .= writeLevel3($tabContentsC, $strPathModule, $tabLastBook[0]);
  } 

  if( file_exists($strFileNameIndexAdmin) ) {
    $tabContentsA = file($strFileNameIndexAdmin);
    $strHtmlJs .= writeLevel3($tabContentsA, $strPathModule, $tabLastBook[1]);
  } 
  
  if( file_exists($strFileNameIndexProp) ) {
    $tabContentsP = file($strFileNameIndexProp);
    $strHtmlJs .= writeLevel3($tabContentsP, $strPathModule, $tabLastBook[2]);
  } 
  
  $strHtmlJs .= "end_Book();\n";
  incChar($tabLevel[0]);
}

/*
echo "<br><br>".$strHtmlJs;
exit();
*/

?>
<html>
<head><title>Aide</title>
<meta http-equiv="content-type"  content="text/html;charset=utf8" >
<style>
  font {font-family: Arial, Helvetica, sans-serif; font-size:10pt;}
  a {font-family: Arial; font-size:10pt; color:#878787; text-decoration:underline;}
  a:hover { color:#696969; }
</style></head>
<body bgcolor"#FFFFFF" text="#000000" link="#CC0000" vlink="#990066"
      alink="#CC0000" onload="loaded=true;">
<div id="preamble" style="position:absolute; top:auto;" align="center">

</div>
<script type="text/javascript"> 

/* ### LOCAL DEFINITIONS ### */
UniqueID = "JS_TreeView_docu";
DocRoot = "./";
ImgRoot = "../../media/help/";
FrameSet = "index.html";
ImgWidth = 14;
ImgHeight = 18;
EntryHeight = ImgHeight;
InitialKey = "d+0";
CurrPageBG = "#000099";
CurrPageFG = "#000000";
LinkCurrPage = true;
TreeRootHint = "";
NormalPageHint = "";
LinkedPageHint = "";
OpenBookHint = "close"; // "schlie&szlig;en";
ClosedBookHint = "open"; // "&ouml;ffnen";
OpenBookStatus = "Close sub-list"; // "Ebene ausblenden";
ClosedBookStatus = "Open sub-list"; // "Ebene einblenden";
window.defaultStatus = "JavaScript TreeView documentation";
navExplain = "\nThis page normally belongs inside a navigation"
 +" frame.\n\nIs it OK to reload the page as designed?";
// navExplain = "Wenn ihr Browser Frames und JavaScript unterst"
//  +unescape("%FC")+"tzt,\nempfehlen wir die Nutzung der deutlich "
//  +"komfortableren\nFrameset-Version dieser Homepage."
waitText = "Rendering tree, please wait...";
// waitText = "Baumstruktur wird aktualisiert. Bitte warten ...";
FontFace = "'Garamond Condensed','Times New Roman',Times,serif";
cellStyle = "font-size:9pt";
compactTree = false;
viewMatchCnt = 0;
singleBranch = false;
checkFrames = true;
linkTarget = "main";
leftMargin = 10;
preambleHeight = 10;

/* ### ENTER YOUR TREEVIEW INDEX HERE ###
 * Note for TEXT: Use \" for quotes, NOT &quot; ! */

initTree("Aide","","") // BEGIN
<?php if( $iAppliOnly == "0" ) { ?>
sub_Page("Introduction","A","../ident/help/extranet_intro.htm"); 
sub_Book("Démarrage rapide","B"); 
sub_Page("Lancement et prise en main","BA","../ident/help/extranet_lancement.htm");
/*sub_Page("Notions de base","BB","../ident/help/extranet_notion.htm");*/
lastBook("Interface Extranet","BC");
sub_Page("L'interface utilisateur","BCA","../ident/help/extranet_interface.htm");
sub_Page("Le bandeau haut","BCB","../ident/help/extranet_bandeauhaut.htm");
sub_Page("Le menu espace de travail","BCC","../ident/help/extranet_menuespace.htm");
lastPage("Le cadre d'application","BCD","../ident/help/extranet_cadreappli.htm");
end_Book();
end_Book();
<?php } ?>
  
<?php echo $strHtmlJs; ?>

end_Tree();
function TVversion() { /* print version info */
 return "TreeView v.3.3 BETA (2004-05-13) [http://www.jSh.de/treeview/]"; }

/* read params, split key and viewKey etc. */
function initTreeView() { if (self.TVinitd) return;
 if (self.checkFrames && (""+window.innerWidth != "0")) { // not printing
  tmpTopName = top.name; cutPos = UniqueID.length;
  if (tmpTopName.length > cutPos)
   tmpTopName = tmpTopName.substring(0, cutPos);
  if ((tmpTopName == UniqueID && top.frames.length == 0)
   || (tmpTopName != UniqueID)) // check we're feeling at home ...
   if (confirm(navExplain)) { if (window.stop) window.stop();
    if (document.images) top.location.replace(FrameSet);
    else top.location.href = FrameSet; }}
 isOpera = (myIndexOf(navigator.userAgent, "Opera") > -1);
 if ((navigator.appName == "Netscape")
  && (navigator.appVersion.charAt(0) == "2")) // Doesn't know
  CurrPageFG = '#339933"><B><CurrPage="YES'; // TD with BGCOLOR
 isDHTML = (document.all || document.layers || document.getElementById);
 if ((navigator.appName == "Netscape") // Mac display refresh
  && (navigator.appVersion.charAt(0) == "4") // bug workaround
  && (myIndexOf(navigator.userAgent, "Macintosh") > -1)) isDHTML = false;
 if (document.layers && document.preamble)
  TVtop = document.preamble.clip.bottom;
 else if (document.getElementById && document.getElementById('preamble'))
  TVtop = document.getElementById('preamble').height;
 else if (document.all && document.all.preamble)
  TVtop = document.all.preamble.offsetHeight;
 if (!self.preambleHeight) preambleHeight = 125;
 if (isNaN(TVtop)) TVtop = preambleHeight;
 if (!self.waitText) waitText = "Rendering tree, please wait...";
 if (!self.leftMargin) leftMargin = 0; currPosY = TVtop;
 if (!self.cellStyle) cellStyle = '';
 else cellStyle = ' STYLE="'+ cellStyle +'"';
 TVentries = new Array(); TVkeys = new Array(); TVcount = 0;
 showKey = printBuffer = ""; splitPrm(); TVinitd = true; }

/* split input to prm and viewKey */
function splitPrm() { input = ""; if (top.key) input = ""+ top.key;
 if ((input == "") || (myIndexOf(input, "<object") > -1)) input = InitialKey;
 pos = myIndexOf(input, "+"); if (pos <0) viewKey = "";
 else { viewKey = input.substring(pos+1); input = input.substring(0, pos); }
 if (input == "") input = ".+."; prm = input; dontVKey = false; }

/* set visibility if isDHTML */
function DHTMLTreeView(currKey) { // must return true ...
 if (!isDHTML) return false; // ... only if display handled.
// TVentries[count](status{0=final,1=redraw}, text, key, link, TreePfx,
//  prefix, code, isCurrVisible, currTop); TVkeys[key](showSubs);
 TVkeys[currKey] = newVis = (!TVkeys[currKey]);
 if (self.singleBranch) for (var i = 1; i <= TVcount; i++)
  if (TVkeys[TVentries[i][2]] && (myIndexOf(currKey, TVentries[i][2]) != 0))
   TVkeys[TVentries[i][2]] = TVentries[i][0] = false;
 currPosY = TVtop; TVelemTop = TVelemBtm = 0;
 for (var j = 1; j <viewKey.length; j++) if (!dontVKey) {
  var viewSub = viewKey.substring(0, j);
  for (var i = 1; i <= TVcount; i++) if (!TVkeys[viewSub])
   TVentries[i][0] &= (TVentries[i][2] != viewSub);
  TVkeys[viewSub] = true; }
 if (TVkeys[currKey] != newVis) dontVKey = true;
 TVkeys[currKey] = newVis;
 for (var i = 1; i <= TVcount; i++) {
  var tmpKey = TVentries[i][2]; var isVisible = true;
  for (var j = 1; j <tmpKey.length; j++)
   isVisible &= TVkeys[tmpKey.substring(0, j)];
  if (self.viewMatchCnt && tmpKey != "*") isVisible
   &= (tmpKey.substring(0, viewMatchCnt)
   == viewKey.substring(0, viewMatchCnt));
  if (isVisible) {
   TVentries[i][0] &= ((tmpKey != currKey) && (tmpKey != viewKey));
   if (TVentries[i][8] != currPosY) { TVentries[i][8] = currPosY;
    if (document.layers) document.layers["TV"+i].top = currPosY;
    else if (document.all) document.all["TV"+i].style.top = currPosY;
    else document.getElementById("TV"+i).style.top = currPosY; }
   if (tmpKey == showKey) TVelemTop = TVelemBtm = currPosY;
   if ((tmpKey.substring(0, showKey.length) == showKey)
    && (currPosY > TVelemBtm)) TVelemBtm = currPosY;
   currPosY += EntryHeight;
   if (!TVentries[i][0]) { treePfx = TVentries[i][4];
    prm = (TVkeys[tmpKey] ? tmpKey : tmpKey.substring(0, tmpKey.length-1));
    var retVal = wrtIdx(TVentries[i][1], tmpKey,
     TVentries[i][3], TVentries[i][5], TVentries[i][6]);
    if (document.getElementById) document.getElementById("TV"+i).innerHTML = retVal;
    else if (document.all) document.all["TV"+i].innerHTML = retVal;
    else with (document.layers["TV"+i].document) { clear(); write(retVal); close(); }
    TVentries[i][0] = (tmpKey != viewKey); }}
  if (TVentries[i][7] != isVisible) { TVentries[i][7] = isVisible;
   if (document.layers)
    document.layers["TV"+i].visibility = (isVisible ? "show" : "hide");
   else if (document.getElementById)
    document.getElementById("TV"+i).style.visibility = (isVisible ? "visible" : "hidden");
   else document.all["TV"+i].style.visibility = (isVisible ? "visible" : "hidden");
 }} // scroll new entry into view
 if (TVelemTop > 0) { TVelemBtm += EntryHeight;
  if (document.layers) { var ScreenTop = window.pageYOffset;
   var ScreenBtm = ScreenTop + window.innerHeight; }
  else { var ScreenTop = document.body.scrollTop;
   var ScreenBtm = ScreenTop + document.body.clientHeight; }
  if ((TVelemBtm > ScreenBtm) || (TVelemTop <ScreenTop)) {
   var scrollTo = ScreenTop + TVelemBtm - ScreenBtm;
   if (TVelemTop <scrollTo) scrollTo = TVelemTop;
   window.scrollTo(0, scrollTo); }
 } return true; }

/* expands an image */
function img(image, hint) { return '<IMG SRC="'
 + ImgRoot +'ix_'+ image +'.gif" ALT="'+ hint +'" BORDER="0"'
 +' WIDTH="'+ ImgWidth +'" HEIGHT="'+ ImgHeight +'">'; }

/* expands a tree-code */
function tree(code) { var ret = "";
 if (myIndexOf(code, "null") > -1) return "";
 for (var i = 0; i <code.length; i++) { var c = code.charAt(i);
  if (c == '.') ret += img("space",""); if (c == '/') ret += img("line","");
  if (c >= '0' && c <= '9') ret += img(xImgs[c],""); if (!self.compactTree) {
   if (c == 'l') ret += img("list",""); if (c == 'L') ret += img("end", "");
   if (c == '+') ret += img("listp",ClosedBookHint);
   if (c == '*') ret += img("endp", ClosedBookHint);
   if (c == '-') ret += img("listm",OpenBookHint);
   if (c == '_') ret += img("endm", OpenBookHint); }
  if (c == 'r') ret += img("open", TreeRootHint);
  if (c == 'R') ret += img("link", TreeRootHint);
  if (c == '#') ret += img("leaf", NormalPageHint);
  if (c == 'x') ret += img("link", LinkedPageHint);
  if (c == 'b') ret += img("book", ClosedBookHint);
  if (c == 'o') ret += img("open", OpenBookHint);
 } return ret; }

/* removes quotes and HTML-Tags in status-text. */
function unquote(text) {
 var pos = myIndexOf(text, '"');
 while (pos > -1) { text = text.substring(0, pos) +"`"+
  text.substring(pos+1); pos = myIndexOf(text, '"'); }
 var pos = myIndexOf(text, "'");
 while (pos > -1) { text = text.substring(0, pos) +"`"+
  text.substring(pos+1); pos = myIndexOf(text, "'"); }
 var pos = myIndexOf(text, "<"); var pos2 = myIndexOf(text, ">");
 while ((pos > -1) && (pos2 > -1) && (pos <pos2)) {
  text = text.substring(0, pos) + text.substring(pos2+1);
  pos = myIndexOf(text, "<"); pos2 = myIndexOf(text, ">");
 } return text; }

/* expands a link */
function lnk(xHref, onOver, misc, xText) { return '<A H'+'REF="'
 + xHref +'" ONMOUSEOVER="window.status=\''+ onOver +'\'; return true" '
 +'ONMOUSEOUT="window.status=\'\'; return true"'+ misc +'>'+ xText +'<\/A>'; }

/* writes tree code, marks active doc, adds link and text */
function wrtEntry(tree, key, link, text) {
 var split = myIndexOf(text, "|"); // split text and status
 if (split <0) { var statusText = unquote(text); var tipText = ""; }
 else { var statusText = unquote(text.substring(split+1));
  var tipText = ' TITLE="'+ statusText +'"';
  text = text.substring(0, split); } tipText += cellStyle;
 var pos = myIndexOf(text, " "); // make text non-breaking
 while (pos > -1) { text = text.substring(0, pos) +"&#160;"+
  text.substring(pos+1); pos = myIndexOf(text, " "); }
 var isCurr = (viewKey == key); if (link)
  link = (link.charAt(0) == "|" ? link.substring(1) : DocRoot + link);
 if (link && !(isCurr && (isOpera || !LinkCurrPage))) text = lnk(link,
  statusText, (isCurr ? ' STYLE="color:'+ CurrPageFG +';"' : '') + tipText,
  (isCurr ? '<FONT COLOR="'+ CurrPageFG +'">'+ text +'<\/FONT>' : text));
 tableBeg = '<TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0"><TR>';
 return tableBeg +'<TD><FONT SIZE="1">&#160;<\/TD><TD NOWRAP><NOBR>'+ tree
 +'<\/NOBR><\/TD><TD><FONT SIZE="1">&#160;<\/TD><TD NOWRAP>'+ tableBeg
 +'<TD NOWRAP'+ (isCurr ? ' BGCOLOR="'+ CurrPageBG +'"' : '') + cellStyle
 +'><NOBR><FONT SIZE="-1"'+ (isCurr ? ' COLOR="'+ CurrPageFG +'"' : '')
 + cellStyle +' FACE="'+ FontFace +'">&#160;'+ text +'&#160;<\/FONT>'
 +'<\/NOBR><\/TD><\/TR><\/TABLE><\/TD><\/TR><\/TABLE>'; }

/* performs a reload-index-instruction with the new key */
function index(newKey, currKey, doneMouse) { window.status = waitText;
 if (document.all && document.all.waitMsg && !doneMouse) {
  document.all.waitMsg.style.top = document.body.scrollTop + 5;
  document.all.waitMsg.style.visibility = "visible";
  window.setTimeout("index('"+newKey+"','"+currKey+"','true');", 50);
  return; }
 else if (document.getElementById && document.getElementById('waitMsg')
  && !doneMouse) {
  document.getElementById('waitMsg').style.top = document.body.scrollTop + 5;
  document.getElementById('waitMsg').style.visibility = "visible";
  window.setTimeout("index('"+newKey+"','"+currKey+"','true');", 50);
  return; }
 if (!self.currKey) showKey = ""; else showKey = currKey;
 if ((!self.currKey && (""+ currKey == "undefined")) || !isDHTML) {
  var pos = myIndexOf(newKey, "+");
  if (pos <0) newHash = newKey +"+"+ viewKey; // missing viewKey
  else { if (pos > 0) newHash = newKey; // new prm & viewKey
   else { // keep prm, new viewKey
    var KeyAdd = newKey.substring(1); showKey = KeyAdd;
    if (myIndexOf(":"+prm+":", ":"+KeyAdd+":") > -1) newHash = prm + newKey;
    else // newKey needs to be added to prm
     newHash = ((prm == ".+.") ? "" : prm +":") + KeyAdd + newKey;
  }} top.key = newHash; splitPrm(); currKey = ""; TVkeys[viewKey] = true; }
 if (!DHTMLTreeView(currKey)) { // need to redisplay
  if (isOpera) location.reload(); else
   if (document.images) location.replace(location.href);
   else location.href = location.href;
 } else if (document.all && document.all.waitMsg)
  document.all.waitMsg.style.visibility = "hidden";
  else if (document.getElementById && document.getElementById('waitMsg'))
  document.getElementById('waitMsg').style.visibility = "hidden";
 window.status = ""; }

/* compute the new prm for a book */
function makePrm(currPrm, add, sub) {
 if (myIndexOf(currPrm, " ") > -1) currPrm = ".+."; // catch NS2-bug
 if (add != "") // put in a key
  var newPrm = ((currPrm == ".+.") ? "" : currPrm +":") + add;
 if (sub != "") { // take out a key _and_it's_children_
  var newPrm = ":"+currPrm+":"; var cutPos = myIndexOf(newPrm, ":"+sub);
  while(cutPos > -1) { newPrm = newPrm.substring(0, cutPos) +
   newPrm.substring(myIndexOf(newPrm, ":", cutPos+1));
   cutPos = myIndexOf(newPrm, ":"+sub); } if (newPrm == ":") newPrm = ":*:";
  newPrm = newPrm.substring(1, newPrm.length-1);
 } if (myIndexOf(newPrm, " ") > -1) newPrm = currPrm;
 return newPrm; }

/* expands a reload-index-instruction with new prm */
function rld(currKey, newPrm, treecode, hint) {
 return lnk('#" ONCLICK="index(\''+ newPrm +"+"+ viewKey +"', '"
 + currKey +'\');return false" TARGET="_self', hint, "", treecode); }

/* generate the HTML tables */
function wrtIdx(text, key, link, prefix, code) { var idxRet = "";
 var pos = myIndexOf(key, " "); if (pos > -1) key = key.substring(0, pos);
 var subKey = (key.length > 1 ? key.substring(0, key.length-1) : "");
 currIsVisible = (myIndexOf(":"+prm+":", ":"+subKey) > -1);
 if (self.viewMatchCnt && subKey != "") currIsVisible
  &= (subKey.substring(0, viewMatchCnt)
  == viewKey.substring(0, viewMatchCnt));
 if (currIsVisible || isDHTML) { var codePos = myIndexOf(code, "|");
  if (codePos > -1) { var prefixPos = myIndexOf(prefix, "|"); // isBook
   if (myIndexOf(":"+prm+":", ":"+key) <0) // isCollapsed
    idxRet = tree(treePfx + (prefixPos <0 ? prefix :
    prefix.substring(prefixPos+1))) + rld(key, makePrm(prm, key, ""),
    tree(code.substring(codePos+1)), ClosedBookStatus);
   else idxRet = tree(treePfx + (prefixPos <0 ? prefix :
    prefix.substring(0, prefixPos))) + rld(key, makePrm(prm, "", key),
    tree(code.substring(0, codePos)), OpenBookStatus);
  } else idxRet = tree(treePfx + prefix + code); // isLeaf
  return wrtEntry(idxRet, key, link, text);
 } else return ""; }

/* adds the initial TreeView entries */
function idx(text, key, link, prefix, code, opts) {
 if (!key) key = "*"; if (!text) text = "";
 if (link) link += '" TARGET="'+ xTarget(opts); TVcount++;
 var retVal = wrtIdx(text, key, link, prefix, code);
 if (document.layers) retVal = '<LAYER ID="TV'+ TVcount
 +'" TOP="'+ currPosY +'" LEFT="'+ leftMargin +'" VISIBILITY="'
 + (currIsVisible ? "show" : "hide") +'">'+ retVal +"<\/LAYER>";
 else if (document.all || document.getElementById)
  retVal = '<DIV ID="TV'+ TVcount +'"'
 +' STYLE="position:absolute; top:'+ currPosY +"px; left:"
 + leftMargin +"px; visibility:"+ (currIsVisible ? "visible" : "hidden")
 +';">'+ retVal +"<\/DIV>";
 if (isDHTML) { TVkeys[key] = false; TVentries[TVcount] = new Array
  ((viewKey != key), text, key, link, treePfx, prefix, code, currIsVisible,
  currPosY); TVkeys[key.substring(0, key.length-1)] = currIsVisible; }
 wrt(retVal); if (currIsVisible) currPosY += EntryHeight; }

/* a 'clean' version of indexOf */
function myIndexOf(text, srch, start) {
 if (!start) start = 0; var pos = (""+ text).indexOf(srch, start);
 return (""+ pos != "" ? pos : -1); }

/* write to prnBuffer */
function wrt(text) { printBuffer += text +"\n"; }

/* writes the printBuffer */
function flush() { document.writeln(printBuffer); printBuffer = ""; }

/* test for option */
function is(opts, keyword) { return (myIndexOf(""+ opts, keyword) > -1); }

/* get custom target */
function xTarget(opts) { if (opts && is(opts, "target")) {
  opts += ","; startPos = myIndexOf(opts, "target=") + 7;
  return opts.substring(startPos, myIndexOf(opts, ",", startPos)); }
 else return "main"; }

/* get custom image */
function xImg(opts) { return (opts ? opts.substring
 (myIndexOf(opts, "img") + 3, myIndexOf(opts, "img") + 4) : ""); }

/* functions for building the tree with */
function initTree(text, key, link, opts) { initTreeView(); treePfx = "";
 idx(text, key, link, (is(opts, "cntd.") ? "/" : (is(opts, "img")
 ? xImg(opts) : (is(opts, "link") ? "R":"r") ) ), "", opts); }
function sub_Book(text, key, link, opts) {
 if (is(opts, "cntd.")) idx(text, key, link, "/|.", "|", opts);
 else { idx(text, key, link, "", (is(opts, "img") ? (is(opts, "last")
 ? "_"+xImg(opts)+"|*"+xImg(opts):"-"+xImg(opts)+"|+"+xImg(opts))
 : (is(opts, "last") ? "_o|*b":"-o|+b") ), opts );
 treePfx += (is(opts, "last") ? ".":"/"); }}
function lastBook(text, key, link, opts) {
 sub_Book(text, key, link, "last,"+ opts); }
function end_Book() { treePfx = treePfx.substring(0, treePfx.length-1); }
function sub_Page(text, key, link, opts) {
 idx(text, key, link, "", (is(opts, "cntd.") ? (is(opts, "last")
 ? "..":"/.") : (is(opts, "last") ? "L":"l") + (is(opts, "img")
 ? xImg(opts) : (is(opts, "link") ? "x":"#") ) ), opts); }
function lastPage(text, key, link, opts) {
 sub_Page(text, key, link, "last,"+ opts); }
function end_Tree() { idx(); if (document.layers) wrt('<LAYER ID="bottom"'
 +' TOP="'+ (TVtop + EntryHeight * (TVcount-1)) +'">&#160;<\/LAYER>');
 wrt('<INFO TEXT="'+ TVversion() +'">'); flush(); treePfx = ""; }

/* close all subtrees */
function closeAll() { if (isDHTML) {
 for (var i = 1; i <= TVcount; i++) if (TVkeys[TVentries[i][2]]) {
  TVkeys[TVentries[i][2]] = TVentries[i][0] = false; } index();
 if (document.layers) { ScreenTop = window.pageYOffset; scrollMax = 50
  - window.innerHeight + document.layers["TV"+TVcount].pageY;
 } else { ScreenTop = document.body.scrollTop;
  if (document.all) scrollMax = 50 - document.body.clientHeight
   + document.all["TV"+TVcount].offsetTop;
  else scrollMax = 50 - document.body.clientHeight
   + document.getElementById("TV"+TVcount).offsetTop;
 } if (ScreenTop > scrollMax) window.scrollTo(0, scrollMax); }}

/* open all subtrees */
function openAll() { if (isDHTML) { for (var i = 1; i <= TVcount; i++)
 if ((myIndexOf(TVentries[i][6], "|") > -1) && (!TVkeys[TVentries[i][2]])) {
  TVkeys[TVentries[i][2]] = true; TVentries[i][0] = false; } index(); }}

 </script></div><div id="waitMsg" style="cursor:wait;
 position:absolute; left:5px; height:100%; width:100%; visibility:hidden;">
<table height="100%" width="100%"><tr><td><br/></td></tr></table>
</div></body></html>
