#!/usr/bin/php-cgi
<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Alkanet
Module CGI fournissant les pages adressables Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

set_time_limit(0);

//require_once("../../../lib/lib_session.php");	// ce chargement semble empêcher les appels Ajax en parallèles 
require_once("../../libconf/app_conf.php");
require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkfactory.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkrequest.class.php");

/* Récupération des paramètres */
AlkRequest::readToken();
$tabParam = array();
$tabParam["ids"] 						= AlkRequest::getToken("ids", AlkRequest::_REQUEST("ids", ""));
$tabParam["idUnique"]				= AlkRequest::getToken("idUnique", AlkRequest::_REQUEST("idUnique", ""));
$tabParam["dtmp"]						= AlkRequest::getToken("dtmp", AlkRequest::_REQUEST("dtmp", ""));
$tabParam["data_id"]			  =	AlkRequest::getToken("data_id", AlkRequest::_REQUEST("data_id", ""));
$tabParam["pj_id"]		 			= AlkRequest::getToken("pj_id", AlkRequest::_REQUEST("pj_id", ""));
$tabParam["strFileName"]		= AlkRequest::getToken("strFileName", AlkRequest::_REQUEST("strFileName", ""));
$tabParam["tableName"]			=	AlkRequest::getToken("tableName", AlkRequest::_REQUEST("tableName", ""));
$tabParam["champName"]			= AlkRequest::getToken("champName", AlkRequest::_REQUEST("champName", ""));
$tabParam["dirUpload"]			= AlkRequest::getToken("dirUpload", AlkRequest::_REQUEST("dirUpload", ""));
$tabParam["lang_id"]			  =	AlkRequest::getToken("lang_id", AlkRequest::_REQUEST("lang_id", ""));
$tabParam["versionning"]		= AlkRequest::getToken("versionning", AlkRequest::_REQUEST("versionning", ""));
$tabParam["user_id"]			  =	AlkRequest::getToken("user_id", AlkRequest::_REQUEST("user_id", ""));
$tabParam["strDirPath"]			= AlkRequest::getToken("strDirPath", AlkRequest::_REQUEST("strDirPath", ""));
//print_r($tabParam);die();

/* Vérification des paramètres (tous obligatoires) */
foreach ( $tabParam as $param ) {
	if ( $param == "" ) {
		writeError("Paramètres non valides.");
		exit();
	}
}

/* Fichier de session php */
$strFileSession = "sess_".$tabParam["ids"];
if ( !(file_exists($tabParam["dtmp"]."/".$strFileSession) && is_file($tabParam["dtmp"]."/".$strFileSession)) ) {
	writeError("Sécurité non assurée.");
	exit();
}

$file_error = $tabParam["dtmp"]."/".$tabParam["idUnique"]."_addpj_error";
@unlink($file_error);
$file_progress = $tabParam["dtmp"]."/".$tabParam["idUnique"]."_addpj_progress";
@unlink($file_progress);

/* Vérifie les emplacements */
if ( !(file_exists($tabParam["strDirPath"]) && is_dir($tabParam["strDirPath"])) ) {
	writeError("Le répertoire n'existe pas.");
}

/* Ajout des pièces jointes */
$oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ALKANET);

$nbFilesAdded = 0;
$nbFilesTotal = getNbFiles($tabParam["strDirPath"]);
writeProgress($nbFilesAdded, $nbFilesTotal);

$tabFilesNotAdded = array();
$tabDir = array();
$tabDir[]["dir"] = $tabParam["strDirPath"];
$tabFilesNotAdded = AddPjForDirs($tabDir);

if ( !empty($tabFilesNotAdded) ) {
	writeError("Des pièces jointes n'ont pas pu être ajoutées");
} else {
	$oQuery->DelPj($tabParam["pj_id"], $tabParam["strFileName"], $tabParam["tableName"], ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD, $tabParam["dirUpload"], $tabParam["versionning"], $tabParam["champName"]);
}

exec("rm -r ".$tabParam["strDirPath"]);

/* fonction qui ajoute les fichiers des répertoires passés en paramètre */
function AddPjForDirs($tabDir=array())
{
  global $nbFilesAdded;
  global $nbFilesTotal;
  global $tabParam;
  global $oQuery;
  $tabFilesNotAdded = array();
  foreach ( $tabDir as $tabDirInfo ) {
    $tabFiles = getTabFilesByDir($tabDirInfo["dir"], array(), false, array(), true);
    foreach ( $tabFiles as $file => $filePath ) {
      if ( copyFile($filePath, ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$tabParam["dirUpload"].$file) === TRUE ) {
        $iRes = $oQuery->AddPj($tabParam["tableName"], $tabParam["data_id"], $tabParam["champName"], $tabParam["user_id"], ALK_ALKANET_ROOT_PATH, ALK_ROOT_UPLOAD.$tabParam["dirUpload"], $tabParam["lang_id"], true, $file, $tabParam["versionning"]);
        if ( $iRes == 0 ) {
          $tabFilesNotAdded[] = $file;
        } else {
        	$nbFilesAdded++;
        	writeProgress($nbFilesAdded, $nbFilesTotal);
        }
      } else {
        $tabFilesNotAdded[] = $file;
      }
    }
    $tabDir = getTabDir($tabDirInfo["dir"], false, true);
    $tabFilesNotAdded = array_merge($tabFilesNotAdded, AddPjForDirs($tabDir));
  }
  return $tabFilesNotAdded;
}

/**
 * Retourne le nombre de fichiers dans un répertoire
 */
function getNbFiles($strPath)
{
	$nbFiles = 0;
	
	if( $strPath!="" && $strPath[strlen($strPath)-1] != '/' )
    $strPath .= '/';
  
  if( !(@file_exists($strPath) && @is_dir($strPath)) )
  	return $nbFiles;
 	
 	$hDir = opendir($strPath);
 	while( $strFile = readdir($hDir) ) {
 		if( $strFile=='.' || $strFile=='..' )
      continue;
    if( @is_dir($strPath.$strFile) ) {
    	$nbFiles+= getNbFiles($strPath.$strFile);
    } else {
    	$nbFiles++;
    }
 	}
 	
 	return $nbFiles;
}

/**
 * Ecrit l'avancement dans le fichier d'avancement
 */
function writeProgress($nbFilesExtracted=0, $nbFileTotal=0)
{
	global $tabParam;
	global $file_progress;
	$fileProgress = fopen($file_progress, "w");
	if ( $fileProgress !== FALSE ) {
		fwrite($fileProgress, $nbFilesExtracted."|".$nbFileTotal);
		fclose($fileProgress);
	} else {
  	writeError("Impossible d'initialiser l'extraction.");
  }
}

/**
 * Ecrit dans le fichier d'erreur et quitte le script
 */
function writeError($strMsg="")
{
	global $tabParam;
	global $file_error;
	$fileError = fopen($file_error, "w");
	if ( $fileError !== FALSE ) {
		fwrite($fileError, $strMsg);
		fclose($fileError);
	}
	echo -1;
	exit();
}
?>