<?php
/**
 * @file 		readtoken.php
 * @package	package_name
 * @brief		
 */
/** Chargement des fichiers de config */
require_once("../../"."libconf/app_conf.php");
require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkrequest.class.php");

function include_config($directory, &$tabRes, $iDepth=0){
  $dir = opendir($directory);
  while ($file = readdir($dir)){
    if ( preg_match("!^app_conf_.+\.php$!", $file) ){
      $tabRes[$iDepth][] = ($directory."/".$file);
    }
    else if ( $file!="." && $file!=".." && is_dir($directory."/".$file) )
      include_config($directory."/".$file, $tabRes, $iDepth++);
  }
}

$path = AlkRequest::_POST("path", ALK_ALKANET_ROOT_PATH);
require_once($path.ALK_ROOT_CLASSE."pattern/alkfactory.class.php");
$iMode = AlkRequest::_GETint("iMode", 0);
$token = AlkRequest::_POST("token", "");
$traduction = "";
if ( $iMode==1 && $token!="" ){
  $traduction = AlkRequest::decodeValue($token);
}


?>

<html>
<head>
  <title>Décodage d'un token</title>
  <link rel='stylesheet' href='styles/sit.css' type='text/css'/>
</head>
<body style='margin:10px'>
  <form name='readToken' method='post' action='token_read.php?iMode=1'>
  <br/><div class='divContenuTexte'>
  Chemin des fichiers : <input type='text' class='formCtrl' style='width:80%' name='path' value="<?php echo $path;?>"/>
  </div><br/>
  <br><div class='divContenuTexte'>
  Token : <input type='text' class='formCtrl' style='width:80%' name='token'/><input type='submit' name='submitToken'/>
  </div>
  </form>
  <br>
<?php if ( $iMode==1 ){ ?>
  <br>
  <div class='divContenuTexte'>
  <br/>Token = <b><?php echo $token; ?></b>
  <br/>Traduction = <b><?php echo $traduction; ?></b> 
  <br/><br/>
  Fichiers de configuration inclus : <br/>
  <?php
    $tabFiles = array();
    include_config($path, $tabFiles);
    ksort($tabFiles);
    foreach($tabFiles as $tabFileDepth){
      foreach($tabFileDepth as $file){
        echo "<li>".str_replace("//", "/", $file)."</li>";
        require_once($file);
      }
    }
    AlkRequest::readToken();
    $iTypeSheet = AlkRequest::getToken("iTypeSheet", -1);
    $iSheet = AlkRequest::getToken("iSheet", -1);
    $iSSheet = AlkRequest::getToken("iSSheet", -1);
    
    $tabTypeSheet = array();
    $tabSheet = array();
    $tabSheet = array();
    
    foreach (get_defined_constants() as $name=>$value){
      if ( preg_match("!^ALK_TYPESHEET.+$!", $name) ){
        if ( $value==$iTypeSheet )
          $tabTypeSheet[] = $name;
      }
      if ( preg_match("!^ALK_SHEET.+$!", $name) ){
        if ( $value==$iSheet )
          $tabSheet[] = $name;
        if ( $value==$iSSheet )
          $tabSSheet[] = $name;
      }
    }
  ?>
  <br/>
  Constantes possibles :
    <ul>
      <li><b>pour iTypeSheet : </b><?php echo implode(", ", $tabTypeSheet); ?></li>
      <li><b>pour iSheet : </b><?php echo implode(", ", $tabSheet); ?></li>
      <li><b>pour iSSheet : </b><?php echo implode(", ", $tabSSheet); ?></li>
    </ul> 
<?php } ?>
</body>
</html>
