<?php 
/**
 * Script de génération automatique de l'aide SIT en LaTeX/PDF
 */
error_reporting(E_ALL);
include_once("lib/lib_session.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkxml.class.php");

$doGenerate = isset($_POST["doGenerate"]) ? $_POST["doGenerate"] : 0;

/** CONFIG */ 
$admin_dir  = dirname(__FILE__)."/";
$tex_dir    = $admin_dir."tex/";
$tmp_dir    = $tex_dir."tmp/";
$styles_dir = $admin_dir.ALK_ROOT_STYLE;
$script_dir = dirname($admin_dir)."/";
$sit_dir    = dirname($script_dir)."/";
$scripts_dir_name = ALK_ROOT_MODULE;
$start_dir_name   = "ident";
$tab_unparsed     = array("admin");

$fileHelpCss = "../../../styles/help.css";
$pathHelpCss = $sit_dir.ALK_ROOT_STYLE."help.css";

$enable_pdf_img = false;

$bPhp4 = false; // if project is php4 specific (old help structure)

$sel_all_default = "checked"; // 'checked' ou ''

$texFileName  = $tmp_dir."out.tex";
$xslFileName  = $styles_dir."latex_help.xsl";
$blankImage   = $styles_dir."blank.png";

$filePathTexHeader = $styles_dir."help_header.tex";
$filePathTexFooter = $styles_dir."help_footer.tex";

$tabChar = array("à", "â", "ç", "è", "é", "ê", "ë", "î", "ï", "ô", "€", "ù", "\"", "&", "<", ">", "'", " ");
$tabISO  = array("&#224;", "&#226;", "&#231;", "&#233;", "&#234;", "&#235;", "&#238;", "&#239;", "&#244;", "&#128;", "&#249;", "&#34;", "&#139;", "&#155;", "&#180;", "&#160;");
$tabHTML = array("&agrave;", "&acirc;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&icirc;", "&iuml;", "&ocirc;", "&euro;", "&ugrave;", "&quote;", "&amp;", "&lt;", "&gt;", "&acute;", "&nbsp;");
/** CONFIG */ 

// store errors or any output
$errors = array();

if($doGenerate) {

$strTex = "\documentclass[a4paper, 10pt]{article}\n\n".
          "% general packages\n".
          "\usepackage{a4wide}\n".
          "\usepackage[utf8]{inputenc}\n".
          "\usepackage[T1]{fontenc}\n".
          "%\usepackage[cyr]{aeguill}\n".
          "\usepackage[frenchb]{babel}\n\n".
          "% color and graphics packages\n".
          "\usepackage{graphicx}\n".
          "\usepackage[dvipsnames,svgnames]{xcolor}\n\n".
          "% customisation packages\n".
          "\usepackage{hyperref}\n".
          "\usepackage{lastpage}\n".
          "\usepackage[sf]{titlesec}\n".
          "\usepackage{fancyhdr}\n\n".
          "\begin{document}\n".
          "\sloppy % try to reduce 'overfull hbox' warnings\n\n";

$doc_title = isset($_POST["doc_title"]) ? $_POST["doc_title"] : "";
$strTex .= "\def\DocTitle{".$doc_title."}\n\n";

$graphics_path = array();
$temp_strTex   = "";

// make tmp directory if not exists
if(!file_exists($tmp_dir)) { mkdir($tmp_dir); sleep(1); }

// copy header & footer to tex directory
copy($filePathTexHeader, $tmp_dir.basename($filePathTexHeader));
copy($filePathTexFooter, $tmp_dir.basename($filePathTexFooter));
copy($blankImage, $tmp_dir.basename($blankImage));

// index filenames
$index_filenames = array("INTRO"  =>"index.txt", 
                         "CONSULT"=>"index_consult.txt", 
                         "ADMIN"  =>"index_admin.txt", 
                         "PROP"   =>"index_prop.txt");

// load modules paths
//$modules = readModules($script_dir);

// load modules paths from POST data
foreach($_POST as $key=>$value) {
  if(preg_match("!^cb_.*$!", $key)) {
    $modules[str_replace("cb_", "", $key)] = $value;
  }
}
if(empty($modules)) die("nothing to do.");

// parse all modules
foreach($modules as $name=>$path) {
  $str = "";
  
  $out_tex = $tmp_dir.$name.".tex";
  
  $help_dir = $path."help/";
  foreach($index_filenames as $indexKey=>$index) {
    
    if(file_exists($help_dir.$index) && is_readable($help_dir.$index)) {
      $farray = file($help_dir.$index);
      $curLevel = 1;
      foreach($farray as $key=>$line) {
        if(strlen($line)>0 && $line[0]=="#") continue;
        
        // if php4, test if line is a top section
        if($bPhp4 && strpos($line, "|")===false) $key = 0;
        
        if($key==0) {
          // write section $line in global tex
          
          // if php4, get level of the node
          if($bPhp4) {
            if(preg_match("/(.*)\s*\[NIV-1\]\s*/", $line)) { $curLevel=1; $str .= "\section{".preg_replace("/(.*)\s*\[NIV-1\]\s*/", "\\1", trim($line))."}\n\n"; }
            if(preg_match("/(.*)\s*\[NIV-2\]\s*/", $line)) { $curLevel=2; $str .= "\subsection{".preg_replace("/(.*)\s*\[NIV-2\]\s*/", "\\1", trim($line))."}\n\n"; }
            if(preg_match("/(.*)\s*\[NIV-3\]\s*/", $line)) { $curLevel=3; $str .= "\subsubsection{".preg_replace("/(.*)\s*\[NIV-3\]\s*/", "\\1", trim($line))."}\n\n"; }
          } else {
            if($indexKey=="INTRO") $str .= "\section{".trim($line)."}\n\n";
            else                   $str .= "\subsection{".trim($line)."}\n\n";
          }
        } else {
          $tabList = explode("|", $line);
          if(count($tabList)!=2) {
            $errors[] = "ERROR : ".$help_dir.$index." is malformed at line ".($key+1)." - '&lt;TITLE&gt; | &lt;FILENAME&gt;' expected";
            continue;
          }
          $title    = trim($tabList[0]);
          $fileName = trim($tabList[1]);
          // write subsection $title
          if($bPhp4) {
            if($curLevel==1)      $str .= "\subsection{".$title."}\n";
            else if($curLevel==2) $str .= "\subsubsection{".$title."}\n";
            else if($curLevel==3) $str .= "\paragraph{".$title."}~~\\newline\n";
          } else {
            if($indexKey=="INTRO") $str .= "\subsection{".$title."}\n";
            else                   $str .= "\subsubsection{".$title."}\n";
          }
          
          // call transformation of HTML help file
          if(!file_exists($help_dir.$fileName)) {
            $errors[] = "INFO : File ".$help_dir.$fileName." does not exist - skipped ! - check ".$help_dir.$index;
            continue;
          }
          $ret = html2latex($tmp_dir, $xslFileName, $help_dir, $fileName);
          // write \inpu{$fileName} command
          $tex_import = mb_ereg_replace("^(.*)\.[a-zA-Z]{3,4}$", "\\1.tex", $fileName);
          $str .= "\input{".$tex_import."}\n\n";
        }
      }
      
    } else {
      $errors[] = "INFO : ".$help_dir.$index." does not exist or is not readable - skipped !";
    }
  }
  
  // write module tex
  if($str!="") {
    $tex_import = mb_ereg_replace("^(.*)\.[a-zA-Z]{3,4}$", "\\1", basename($out_tex));
    file_put_contents($out_tex, $str);
    $help_dir_rel = preg_replace("!.*$scripts_dir_name/(.*)!", "../../../../$scripts_dir_name/\\1", $help_dir);
    
    $graphics_path[] .= "{".$help_dir_rel."}";
    $temp_strTex   .= "\include{".$tex_import."}\n";
  }
  
}

// set all graphics_path first, then add all includes
// dans la regex ci-dessous : ALK_ROOT_MODULE contient le slash qui sera présent avant le .*)!
$graphics_path[] = preg_replace("!.*(/".ALK_ROOT_MODULE.".*)!", "{../../../..\\1}", $styles_dir); // add styles directory where local images are stored
$graphics = "\graphicspath{\n".implode(",\n", $graphics_path)."}\n";
$strTex .= $graphics."\n"."\include{help_header}\n\n".$temp_strTex;

// write $strTex to $texFileName
$strTex .= "\n\include{help_footer}\n\n";
$strTex .= "\n\end{document}\n";
file_put_contents($texFileName, $strTex);

// launch pdflatex on out.tex
$output = array();
sleep(1); // give some extra time
if($enable_pdf_img) {
  exec("cd $tmp_dir; convert blank.png blank.pdf");
}
// exec("cd $tmp_dir; pdflatex -output-directory=$tex_dir $texFileName", $output);
// exec("cd $tmp_dir; pdflatex -output-directory=$tex_dir $texFileName", $output); // always do it twice

$errors = array_merge($errors, $output);

// get the pdf output for download
echo "<p>Télécharger le fichier PDF : <a href='".$tex_dir."out.pdf'>out.pdf</a></p>";
echo "<p># cd $tmp_dir<br/>";
echo "# pdflatex -interaction=nonstopmode -output-directory=$tex_dir $texFileName<br/>";
echo "# pdflatex -interaction=nonstopmode -output-directory=$tex_dir $texFileName</p>";

// last but not least, display output info & errors
echo "<p>";
foreach($errors as $line) {
  echo $line."<br>";
}
echo "</p>";

} else {

  // load modules paths
  $modules = readModules($script_dir);

  ?>
  <html>
  <head><title>Génération PDF de la documentation SIT</title></head>
  <link rel='stylesheet' href='styles/sit.css' type='text/css'/>
  <script type='text/javascript'>
    <!--
    function selAll(oCheck) {
      var f = document.forms[0];
      for(var i=0; i<f.elements.length; i++) {
        if(f.elements[i].name.match(/^cb_.*$/)) {
          f.elements[i].checked = oCheck.checked;
        }
      }
    }
    -->
  </script>
  </head>
  <body style='padding:10px;'>
    <form name="formGenerate" action="<?php echo $_SERVER["PHP_SELF"]?>" method="POST" target="generate">
      <h3>Script de génération PDF de la documentation SIT</h3>
      <label for="title">Titre du document (page de garde) </label><input type="text" name="doc_title" size="62" value="Documentation SIT"/>
      <p>Sélection des modules disponibles : </p>
      <table style="border:1px solid black; background:lightgrey;" width="600px">
        <tr height="0"><th>Générer <input type='checkbox' <?php echo $sel_all_default; ?> name='sel_all' onclick='javascript:selAll(this);'/></th><th>Nom</th><th>Chemin</th></tr>
        <?php
        foreach($modules as $name=>$path) {
          echo "<tr><td align='center'>";
          //if ($name==$start_dir_name)
          //  echo "auto<input type='hidden' name='cb_$name' value='$path'>";
          //else
            echo "<input type='checkbox' $sel_all_default name='cb_$name' value='$path'/>";
          echo "</td><td>$name</td><td>$path</td></tr>";
        }
        ?>
      </table>
      <br>
      <input type="hidden" name="doGenerate" value="1"/>
      <input type="submit" name="submit" value="Generate"/>
    </form>
    <h4>Résultat</h4>
    <iframe name="generate" width="100%" height="300px"></iframe>
  </body>
  </html>
  <?php

}


// -------------------------------------------
// FUNCTIONS
// -------------------------------------------

/**
 * Read all modules available in the script directory
 * @param $script_dir the script directory
 * @return array of readable modules {module_name => module_path, ...}
 */
function readModules($script_dir) {
  global $errors;
  global $start_dir_name;
  global $tab_unparsed;
  
  $modules = array();
  $dh = @opendir($script_dir);
  if($dh !== false) {
  
    while(($file = readdir($dh)) !== false) {
      if($file=="." || $file==".." || strtoupper($file)=="CVS" || strtoupper($file)=="VIDE") continue;
      if(strtolower($file)==$start_dir_name) continue; // append $start_dir_name as first elt
      if(in_array(strtolower($file), $tab_unparsed)) continue;
      
      // TEST only atlas
      // if(strtolower($file)!="atlas") continue;
    
      $modules[$file] = $script_dir.$file."/";
    }
    ksort($modules);
    $modules = array_merge(array($start_dir_name=>$script_dir.$start_dir_name."/"), $modules);
  
    closedir($dh);
  } else {
    $errors[] = "INFO : Can't open $script_dir - skipped !";
  }
  
  // return the array of readable modules 
  return $modules;
}

/**
 * Execute a XSL transformation on a HTML help page to generate the matching help file in Latex format
 * @param $tmp_dir directory where tex files are geneated
 * @param $xslFileName absolute path to the XSL stylesheet
 * @param $dir directory where HTML help file is stored
 * @param $fileName name of the HTML help file, located in $dir
 * @return boolean - true for a successful transformation, false otherwise
 */
function html2latex($tmp_dir, $xslFileName, $dir, $fileName) {
  global $errors;
  global $enable_pdf_img;
  global $tabChar, $tabISO, $tabHTML;
  
  // transform help_file.htm to help_file.tex
  $outTex = $tmp_dir.preg_replace("!^(.*)\.[a-zA-Z]{3,4}$!", "\\1.tex", $fileName);
  
  // clean html with tidy
  $config = array(
             'indent'         => false,
             'output-xhtml'   => true, 
             'drop-font-tags' => true,
             'alt-text'       => 'img',
             'char-encoding'  => 'utf8',
             'tidy-mark'      => true,
             'doctype'        => 'transitional'); // omit
  
  $tidy = new tidy();
  $tidy->parseFile($dir.$fileName, $config, 'utf8');
  $tidy->cleanRepair();
  $strXml = $tidy->value;
  // TODO TEST - save cleaned html - to remove
  file_put_contents($tmp_dir.$fileName, $strXml);
  //var_dump($tidy);
  // re-clean cleaned html
  // remove xmlns attribute from html tag (cause xslt to fail)
  $strXml = preg_replace("!<html[^>]*>!", "<html>", $strXml);
  // remove &nbsp; entities
  $strXml = preg_replace("!&nbsp;!", " ", $strXml);
  // remove \n
  $strXml = preg_replace("!\n!", " ", $strXml);
  
  /*
  // try adding css help stylesheet if available
  if(file_exists($pathHelpCss)) {
    // if help css is not already present, add it
    if(!preg_match("/<link[^>]*href[^>]*".basename($pathHelpCss)."[^>]*\/?>/", $strXml)) {
      $strXml = preg_replace("/<\/head>/", "<link rel='stylesheet' type='text/css' href='".$fileHelpCss."'/>\n</head>", $strXml);
    }
  }
 */
  
  // replace ISO or HTML entities with normal characters
  $strXml = ereg_replace($tabISO, $tabChar, $strXml);
  $strXml = ereg_replace($tabHTML, $tabChar, $strXml);
  
  // find image relative to other directories
  $excludes = array();
  $matches = array();
  preg_match_all('!src\s*=\s*"((\./)?(\.\./)+[^"]*/([^"]*\.PNG))"!m', $strXml, $matches);
  for($i=0; $i<count($matches[0]); $i++) {
    $excludes[] = $img = $matches[4][$i];
    $img_path = $matches[1][$i];
    if(!file_exists($dir.$img_path)) {
      // remove bad image
      $strXml = preg_replace("!".$img_path."!", "blank.png", $strXml);
      $errors[] = "ERROR : ".$dir.$fileName." - Relative image ".$dir.$img_path." can't be found - Please correct this !";
    } else {
      $strXml = preg_replace("!".$img_path."!", $img, $strXml);
    }
  }

  // find bad linked images and change them
  $matches = array();
  preg_match_all('!src\s*=\s*"([^"]*)"!m', $strXml, $matches);
  foreach($matches[1] as $img) {
    if(in_array($img, $excludes)) continue;
    
    if(!file_exists($dir.$img)) {
      // remove bad image
      $strXml = preg_replace("!".$img."!", "blank.png", $strXml);
      $errors[] = "ERROR : ".$dir.$fileName." - Image ".$dir.$img." can't be found - Please correct this !";
    }
  }
  
  if($enable_pdf_img) {
    // replace all PNG ref to PDF ref
    $strXml = preg_replace("!\.PNG!i", ".pdf", $strXml);
  }  

  /*
  // load xml factory - does not work so well !!!
  $alkXml = new AlkXml($strXml, "", "", $xslFileName);
  
  // apply xsl transformation on html
  $bool = $alkXml->setTransformation();
  if($bool) {  }
  else      { $errors[] = "INFO : Transformation : NOk - $fileName - [".$alkXml->getLastError()."] - file might be empty, no ?"; }
  
  // create tex file with result
  file_put_contents($outTex, $alkXml->getHtml());
  */
  
  error_reporting(0);
  $doc = new DOMDocument();
  $xsl = new XSLTProcessor();
  
  $doc->load($xslFileName);
  $xsl->importStyleSheet($doc);
  
  $doc->loadHTML($strXml);
  $strOut = $xsl->transformToXML($doc);
  file_put_contents($outTex, $strOut);
  $bool = true;
  error_reporting(E_ALL);
  
  return $bool;
}

?>