<?php 
include_once("lib/lib_session.php");
include_once("api/gen_con.php");
include_once("lib/lib_admin.php");

$strPathScripts = $_SERVER["PHP_SELF"];
$iPos = mb_strpos($strPathScripts, ALK_ROOT_MODULE."");
$strPathScripts = $_SERVER["DOCUMENT_ROOT"].mb_substr($strPathScripts, 0, $iPos/*+8*/); // +8 adds 'scripts/'

$iMode = Request("iMode", REQ_POST_GET, "0", "is_numeric");
$changeDirCalled = Request("changeDirCalled", REQ_POST_GET, "0", "is_numeric");
$rep_classes = Request("rep_classes", REQ_POST, $strPathScripts);
$inc_parent = Request("inc_parent", REQ_POST, false);
$override_test = Request("override_test", REQ_POST, false);
$override_runtest = Request("override_runtest", REQ_POST, false);

$unittestsDir = "unit_tests"; // change to "" if you want tests to be added at the same level as theirs classes

// modify the include_path temporary to include 
ini_set('include_path', ini_get('include_path').":".$strPathScripts."/".ALK_ROOT_CLASSE."");
require_once './include_temp.php';

//require_once 'appli/alkappliinterface.class.php';

echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">". 
  "<html><head>".
  "<meta http-equiv=\"content-type\" content=\"text/html; charset=".ALK_HTML_ENCODING."\" />" .
  "<link rel='stylesheet' href='styles/sit.css' type='text/css'/>".
   "<script language='javascript'>".
   " function Generate() {".
   "  var f = document.formScript;".
   "  f.iMode.value = '1';".
   "  f.submit();".
   " }".
   " function Copy() {".
   "  var f = document.formScript;".
   "  f.iMode.value = '2';".
   "  f.submit();".
   " }".
   " function SelectDir() {".
   "  var f = document.formScript;".
   "  if(f.select_dir.options.lenght==0) {".
   "  } else { ".
   "   var index = f.select_dir.options.selectedIndex;".
   "   var dir = f.select_dir.options[index].text;".
   "   f.rep_classes.value += '/' + dir; ".
   "  }".
   "  f.changeDirCalled.value='1';".
   "  f.submit();".
   " }";
   
echo "</script></head><body style='margin:10px'>".
   "<form name='formScript' action='creer_templates_test_unit.php' method='post'>".
   "<h2>Script de Cr&eacute;ation des templates de test unitaire</h2>";

if( $iMode == "0" ) {
   
  if( $iPos === false ) {
    echo "<div class='divContenuTexteGras'><font color='red'>Impossible de trouver le répertoire scripts.</font></div>";
    echo "</form></body></html>";
    exit();
  }
  
  echo "<table border='0' cellpadding='2' cellspacing='0'>".
   "<tr>".
   "<td class='formLabel'>Répertoire des classes à tester :</td>".
   "<td><input class='formCtrl' type='text' name='rep_classes' value='$rep_classes' size='60'></td>".
   "</tr>".
   "<td class='formLabel'></td>".
   "<td><select class='formCtrl' name='select_dir' size='1' onchange='SelectDir()'>";
   //if($changeDirCalled==0) {
   //  echo "<option></option><option>click me to update directory choice</option>";
   //} else {
     echo makeOptions($rep_classes);
   //}
   echo "</select></td></tr>".
   "<tr><td colspan='2'><hr noshade></td></tr>".
   "<tr><th colspan='2' align='left'>Option 1 : génération automatique</th></tr>".
   "<tr><td></td>".
   "<td class='formLabel'><input class='formCtrl' type='checkbox' name='inc_parent'";
   if($inc_parent) echo " checked";
   echo ">Inclure les méthodes des classes parentes.</td>".
   "</tr><tr><td colspan='2'><td></tr>".
   "<tr><td></td>".
   "<td class='formLabel'><input class='formCtrl' type='checkbox' name='override_test'";
   if($override_test) echo " checked";
   echo ">Ecraser les tests unitaires existants.</td>".
   "</tr>".
   "<tr><td></td>".
   "<td class='formLabel'><input class='formCtrl' type='checkbox' name='override_runtest'";
   if($override_runtest) echo " checked";
   echo ">Ecraser le fichier runtest.php si il existe.</td>".
   "</tr>".
   "<tr><td></td><td></td></tr>".
   "<tr>".
   "<td colspan='2' class='formLabel'>Note : la génération est fonctionnelle pour les classes des modules (répertoire classes/)</td>".
   "</tr>".
   "<tr><td colspan='2' align='center' style='padding-top:8px'>".
   "<a class='aContenuLien' href='javascript:Generate()'>Valider</a>".
   "</td>".
   "</tr>".
   "<tr><td colspan='2'><hr noshade></td></tr>".
   "<tr><th colspan='2' align='left'>Option 2 : copier les templates génériques</th></tr>".
   "<tr><td colspan='2' align='center' style='padding-top:8px'>".
   "<a class='aContenuLien' href='javascript:Copy()'>Copier</a>".
   "</td>".
   "</tr>".
   "</table>".
   "<input type='hidden' name='iMode' value='0'>".
   "<input type='hidden' name='changeDirCalled' value='0'>".
   "</form><br></body></html>";

 exit();

} else if($iMode == "1"){
  $fail = false;
  if(@is_readable($rep_classes)) {
    if(@is_dir($rep_classes)) {
      
      // rep seems to be ok, produce unit test skeleton for those classes
      if($dir = opendir($rep_classes)) {
        $files = array(); // store files that will be treated  
        $has_unit_test_dir = false;
        
        while($filename = readdir($dir)) {
          if($filename!="." && $filename!=".." && $filename!="CVS") {
            $filepath = $rep_classes."/".$filename;
            // do not override tests if unit_test directory is already here
            if(is_dir($filepath) && $filename===$unittestsDir) {
              $has_unit_test_dir = true;
            }
            if(is_file($filepath)) {
              $files[] = $filepath;
            }       
          }
        }
        closedir($dir);
        
        //var_dump($files);
        // generate skeletons of unit tests
        if(!$has_unit_test_dir) {
          echo "<div><span>Création du répertoire $unittestsDir/ ($rep_classes/$unittestsDir)</span></div>";
          mkdir($rep_classes."/unit_tests");
        } else {
          echo "<div><span>Le répertoire $unittestsDir/ est déjà présent ($rep_classes/$unittestsDir)</span></div>";
        }
        
        // prepare the runtest file
        $runtestFile = "$rep_classes/$unittestsDir/runtest.php";
        
        // get the phpunit relative classpath to unit_tests directory
        //$firstOccurScripts = ALK_ROOT_MODULE.""; // WARNING, unit tests are in modules from the scripts/ dir.
        //$opos2 = mb_strpos($runtestFile, $firstOccurScripts) + mb_strlen($firstOccurScripts);
        //$inodes = explode("/", stripslashes(mb_substr($runtestFile, $opos2)));
        $inodes = explode("/", mb_substr($runtestFile, mb_strlen($strPathScripts)));
        array_pop($inodes); // need to remove 1 entry to compute correct path
        $phpUnitBasePath = "./classes/tests/";
        foreach($inodes as $inode) {
          if(mb_strlen(trim($inode))>0) {
            $tmp = "../$phpUnitBasePath";
            $phpUnitBasePath = $tmp;
          }
        }
        
        $contents = "";
        $writeRuntest = true;
        if(file_exists($runtestFile) && !$override_runtest) {
          echo "<br><div><span>Le fichier $runtestFile existe déja !</span></div>";
          $writeRuntest = false;
        } else {
          $fp = fopen($runtestFile, 'w');
          // header
          $header = "<?php\n/**\n* File : runtest.php\n* Created on ".date('Y-m-d')."\n".
                    "*\n* This file creates a TestSuite, adds unit test classes to it, \n".
                    "* and shows the test result in a Html page.".
                    "\n* @author \n* @version \n* @version \n*/\n";
          // require
          $require = "require_once '".stripslashes($phpUnitBasePath)."/PHPUnit.php';\n".
                     "require_once '".stripslashes($phpUnitBasePath)."/PHPUnit/GUI/ALKHTML.php';\n\n";
          // contents
          $suites = "\$suites = array();\n\n\$suite = new PHPUnit_TestSuite();\n".
                      "\$suite->setName('Main Suite');\n\n";
          $contents .= $header.$require.$suites;
        }
        
        
        foreach($files as $file) {
          echo "<br><div><span>Génération du template pour $file</span>";
          
          // transform class.php in classTest.php
          $opos = mb_strpos(basename($file), ".");
          $testfilepath = stripslashes(dirname($file) . "/$unittestsDir/" . sprintf("%sTest.php", mb_substr(basename($file), 0, $opos)));
          echo "<br><div><span>($testfilepath)</span>";
          
          
          if(file_exists($testfilepath) && !$override_test) {
            echo "<br><span>... Echec : le fichier $testfilepath existe déjà !<span></div>";
          } else {
            // generate skeleton using PHPUnit_Skeleton
            require_once '../../classes/tests/PHPUnit/Skeleton.php';
            
            // need to compute a relative classpath to PHPUnit.php
            $phpunitRelPath = "$phpUnitBasePath/PHPUnit.php";
            // need to compute a relative classpath to tested class
            $relClassPath = "../".basename($file);
            $testFilename = mb_substr(basename($file), 0, $opos);
            
            // skeleton generation 
            $sk = new PHPUnit_Skeleton($testFilename, $file, $inc_parent, true, $phpunitRelPath, $relClassPath);
            $sk->createTestClass();
            //echo "<br>TEST CLASS<br><br>" . nl2br($sk->testClass);
            $sk->writeTestClass(dirname($testfilepath)."/", false);
            
            //echo "saving test file to $testfilepath";
            if(!$override_test) echo "<br><span>... OK<span></div>";
            else echo "<br><span>... OK (version précédente écrasée)<span></div>";
            
            if($writeRuntest) {
              // add this test in the main suite of the runtest
              $test = "require_once '".stripslashes($testFilename)."Test.php';\n".
                       "\$suite->addTestSuite(\"".$testFilename."Test\");\n\n";
              $contents .= $test;
            }
          }
        } // end foreach
        
        // now write the runtest.php
        if($writeRuntest) {
          echo "<br><div><span>Génération du fichier runtest.php</span>";
          
          $footer = "\$suites[] = \$suite;\n\n".
                    "\$htmlgui = new PHPUnit_GUI_ALKHTML(\$suites);\n".
                    "\$htmlgui->show();\n\n?>\n";
          $contents .= $footer;
          fwrite($fp, $contents);
          fclose($fp);
          if(!$override_runtest) echo "<br><span>... OK</span></div>";
          else echo "<br><span>... OK (version précédente écrasée)</span></div>";
        }
        
      } else {
        $fail = true;
      echo "<div class='divContenuTexteGras'><font color='red'>Erreur : Impossible de lire le contenu du répertoire $rep_classes</font></div>";
      }
      
    } else {
      $fail = true;
      echo "<div class='divContenuTexteGras'><font color='red'>Errreur : $rep_classes n'est pas un répertoire.</font></div>";
    }
  } else {
    $fail = true;
    echo "<div class='divContenuTexteGras'><font color='red'>Erreur : Le répertoire $rep_classes n'est pas accessible en lecture.</font></div>";
  }
  
  if($fail)
    echo "<br><div'><h3>La création des tests unitaires a échoué !</h3></div>";
  else
    echo "<br><div><h3>La création des tests unitaires a réussi !</h3></div>"; 
      
  // links to previous pages
  echo "<table border='0' cellpadding='2' cellspacing='0'>".
   "<tr>".
   "<td colspan='2' align='center' style='padding-top:8px'>".
   "<a class='aContenuLien' href='creer_templates_test_unit.php'>Retour</a>".
   "</td>".
   "</td>".
   "</tr>".
   "</table>".
   "</form><br></body></html>";
  
  echo "</div></body></html>";

} else if($iMode == "2") {
  
  // copy generic templates in $rep_classes
  $strPathSrc = $strPathScripts.ALK_ROOT_MODULE."unit_tests_template/";
  
  if(@is_readable($rep_classes) && @is_dir($rep_classes)) {
    $strPathDest = $rep_classes."/$unittestsDir/";
  
    echo "<div class='divContenuTexte'>Création du répertoire : <b>$strPathDest</b>";
    $bRes = mkdir($strPathDest);
    echo ", res = ".($bRes ? "ok" : "<font color='red'>ko</font>")."<br><br>";
    if($bRes) {
      echo "Recopie des fichiers : <br>";
      
      $iDateMin = mktime(0, 0, 0, 1, 1, 2000);
      $iDateMax = mktime(0, 0, 0, 12, 31, 2030);
      CopyMoveDirectory($strPathSrc, $strPathDest, $iDateMin, $iDateMax, "");
      
      echo "<h3>Les templates génériques ont été copiés</h3>";
    }
  } else {
    echo "<div class='divContenuTexteGras'><font color='red'>Erreur : Le répertoire $rep_classes n'existe pas ou n'est pas accessible'.</font></div>";
  }
    
}

/**
 * retourne la liste des répertoires d'un répertoire donné ($basedir)
 * sous la forme d'options (<option>dirname</option>)
 * @return string list of option tags
 */
function makeOptions($basedir) {
  $options = "<option></option>"; // add empty option to force onchange
  if(@is_readable($basedir)) {
    if(@is_dir($basedir)) {
      
      if($dir = opendir($basedir)) {
        
        while($filename = readdir($dir)) {
          if($filename!="." && $filename!=".." && $filename!="CVS") {
              $filepath = $basedir."/".$filename;
              // do not override tests if unit_test directory is already here
              if(is_dir($filepath)) {
                $options .= "<option>$filename</option>";
              }
          }
        }
        
        closedir($dir);
      }
    }
    return $options;
  }
  
}
?>