<?php
/**
 * création d'une image et de sa css associée
 */

require_once("../../libconf/app_conf.php");
require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");

header("content-type: text/html; charset=utf-8");

$strPathBase = ALK_ALKANET_ROOT_PATH;

$strPrefix = "alkimg";

$tabParams = 
  array("picto" => array("path"           => "media/images/",
                         "pattern"        => "picto[\d]+_[\w]+.gif",
                         "typeDest"       => "png",
                         "tabFilesImg"    => array(),
                         "forceCTransp"   => array("red" => 255, "green" => 255, "blue" => 253),
                         "reduceWidthGD"  => true,
                         "reduceWidthIM"  => false,
                         "widthMaxImg"    => 0,
                         "heightMaxImg"   => 0),
        "pic" => array("path"           => "media/images/",
                       "pattern"        => "pic_[\w]+.gif",
                       "typeDest"       => "png",
                       "tabFilesImg"    => array(),
                       "forceCTransp"   => array("red" => 255, "green" => 255, "blue" => 253),
                       "reduceWidthGD"  => true,
                       "reduceWidthIM"  => false,
                       "widthMaxImg"    => 0,
                       "heightMaxImg"   => 0),
        "icon" => array("path"           => "media/images/",
                        "pattern"        => "(icon_[\w]+.(gif|png))|(bullet_[\w]+.(gif|png))",
                        "typeDest"       => "png",
                        "tabFilesImg"    => array(),
                        "forceCTransp"   => array("red" => 255, "green" => 255, "blue" => 253),
                        "reduceWidthGD"  => false,
                        "reduceWidthIM"  => false,
                        "widthMaxImg"    => 0,
                        "heightMaxImg"   => 0),
       ); 
  

foreach($tabParams as $strImgDest => $tabParam) {
  // récupère la liste des images                           
  $tabFilesImg = scandir($strPathBase.$tabParam["path"]);
  foreach($tabFilesImg as $strFileImg ) {
    if( $strFileImg === "." || $strFileImg === ".." ) continue;
    if( preg_match("/".$tabParam["pattern"]."/i", $strFileImg) > 0) {
      $tabImgInfo = getimagesize($strPathBase.$tabParam["path"].$strFileImg);
      if( !is_array($tabImgInfo) ) continue;
      
      $tabParam["widthMaxImg"]  = max($tabParam["widthMaxImg"], $tabImgInfo[0]);
      $tabParam["heightMaxImg"] = max($tabParam["heightMaxImg"], $tabImgInfo[1]);
      
      $tabParam["tabFilesImg"][] = array("name" =>$strFileImg, "width" => $tabImgInfo[0], "height" => $tabImgInfo[1]); 
    }
  }

  $nbImg = count($tabParam["tabFilesImg"]);
  if( $nbImg == 0 ) {
    echo '<font color="red">Pas d\'image pour '.$strImgDest.'</font><br>';
    continue;
  }

  $iWidthSrc  = $tabParam["widthMaxImg"];
  $iHeightSrc = $tabParam["heightMaxImg"];

  $strFileNameImgDest = $strPrefix.$strImgDest.".".$tabParam["typeDest"];
  $strFileNameCssDest = $strPrefix.$strImgDest.".css";
  echo 'Création de '.$strFileNameImgDest.' et de '.$strFileNameCssDest.'<br>';
  echo ' - widthMax='.$iWidthSrc.', heightMax='.$iHeightSrc.', nbImages='.count($tabParam["tabFilesImg"]).'<br>';
 
  $rImgDest = imagecreatetruecolor($nbImg*$iWidthSrc, $iHeightSrc);
  //imagealphablending($rImgDest, false);
  //imagesavealpha($rImgDest, true);
  $iPosXDest = 0;
  // indice = 0 : couleur de transparence
  $tabColorDest = array(); 
  $iColorTransDest = -1;
  $indexColorTransDest = -1;
  
  $strCss = ".".$strPrefix.$strImgDest.
    "{background-image:url(../../../".ALK_ROOT_MODULE."alkanet/images/".$strFileNameImgDest.");" .
    " background-repeat:no-repeat;" .
    " width:".$iWidthSrc."px;" .
    " height:".$iHeightSrc."px}\n";
  foreach($tabParam["tabFilesImg"] as $tabFileImg) {
    $strFileImg = $tabFileImg["name"];
    $iWidthImg  = $tabFileImg["width"];
    $iHeightImg = $tabFileImg["height"];

    switch( substr($strFileImg, -3) ) {
    case "gif":
      $rImgSrc = imagecreatefromgif($strPathBase.$tabParam["path"].$strFileImg);
      break;
    case "png":
      $rImgSrc = imagecreatefrompng($strPathBase.$tabParam["path"].$strFileImg);
      break;
    }
    
    if( $rImgDest ) {
      $bSrcTrueColor = imageistruecolor($rImgSrc);
      $nbColorsSrc = ( $bSrcTrueColor ? 256*256*256 : imagecolorstotal($rImgSrc) );
       
      echo "<b>".$strFileImg." : x=-".$iPosXDest."</b><br>";
      echo " - Palette source : ".( $bSrcTrueColor ? "RVB" : "indexée" )."<br>";
      echo " - nb couleurs source : ".$nbColorsSrc."<br>";
      
      // Récupère la couleur utilisée pour la transparence de l'image source
      if( $bSrcTrueColor ) {
        $iColorTranspSrc = imagecolortransparent($rImgSrc);
        echo " - couleur src transp : ".$iColorTranspSrc.", #".dechex($iColorTranspSrc)."<br>";
        $tabRGVA = array();
        $tabRGVA["red"]   = ($color >> 16) & 0xFF;
        $tabRGVA["green"] = ($color >> 8) & 0xFF;
        $tabRGVA["blue"]  = $color & 0xFF;
      } else {
        $indexColorTranspSrc = imagecolortransparent($rImgSrc);
        echo " - index src transp : ".$indexColorTranspSrc."<br>";
        if( $indexColorTranspSrc >= 0 && $indexColorTranspSrc < $nbColorsSrc ) { 
          $tabRGVA = imagecolorsforindex($rImgSrc, $indexColorTranspSrc);
        } elseif( !empty($tabParam["forceCTransp"]) ) {
          $tabRGVA = $tabParam["forceCTransp"];
        } else {
          $tabRGVA = array("red" => 255, "green" => 255, "blue" => 253);
        }
        $iColorTranspSrc = ($tabRGVA["red"] << 16) + ($tabRGVA["green"] << 8) + $tabRGVA["blue"];
        
      }
      if( $iColorTransDest == -1 ) {
        // ajoute la couleur de transparence à la palette de l'image destination
        if( !empty($tabParam["forceCTransp"]) ) {
          $tabRGVA = $tabParam["forceCTransp"];
        }
        $iColorTransDest = imagecolorallocate($rImgDest, $tabRGVA["red"], $tabRGVA["green"], $tabRGVA["blue"]);
        $indexColorTransDest = imagecolorexact($rImgDest, $tabRGVA["red"], $tabRGVA["green"], $tabRGVA["blue"]);
        //$tabColorDest["_".$iColorTransDest] = $indexColorTransDest; 
        echo " - Ajout transparence : ".$iColorTransDest.", #".dechex($iColorTransDest).", index=".$indexColorTransDest."<br>";
        imagecolortransparent($rImgDest, $indexColorTransDest);
        imagefill($rImgDest, 0, 0, $indexColorTransDest);
      }      
      
      echo " - couleur transp : ".$iColorTranspSrc." #".dechex($iColorTranspSrc)."<br>";
      
      for($w=0; $w<$iWidthImg; $w++) {
        for($h=0; $h<$iHeightImg; $h++) {
          if( $bSrcTrueColor ) {
            $iColorSrc = imagecolorat($rImgSrc, $w, $h);
            $bTrans = ( $iColorTranspSrc == $iColorSrc );
          } else {
            $iIndexColorSrc = imagecolorat($rImgSrc, $w, $h);
            $tabRGVA = imagecolorsforindex($rImgSrc, $iIndexColorSrc);
            $iColorSrc = ($tabRGVA["red"] << 16) + ($tabRGVA["green"] << 8) + $tabRGVA["blue"];
            $bTrans = ( $indexColorTranspSrc == $iIndexColorSrc );
            //echo $iIndexColorSrc." ".$iColorSrc."<br>";
          }
          
          if( $bTrans ) {
            //$iColor = $iColorTransDest;
            $indexColor = $iColorTransDest;
          } elseif( isset($tabColorDest["_".$iColorSrc]) ) {
            $indexColor = $tabColorDest["_".$iColorSrc];
            //$tabRGVA = imagecolorsforindex($rImgDest, $indexColor);
            //$iColor = ($tabRGVA["red"] << 16) + ($tabRGVA["green"] << 8) + $tabRGVA["blue"];
          } else {
            // ajout une couleur à la palette dest
            $red   = ($iColorSrc >> 16) & 0xFF;
            $green = ($iColorSrc >> 8) & 0xFF;
            $blue  = $iColorSrc & 0xFF;
            if( $bSrcTrueColor ) {
              $alpha = ($iColorSrc & 0x7F000000) >> 24;
              $iColor = imagecolorallocatealpha($rImgDest, $red, $green, $blue, $alpha);
              $indexColor = imagecolorexactalpha($rImgDest, $red, $green, $blue, $alpha);
            } else {
              $iColor = imagecolorallocate($rImgDest, $red, $green, $blue);
              $indexColor = imagecolorexact($rImgDest, $red, $green, $blue);
            }
            $tabColorDest["_".$iColor] = $indexColor;
            echo " - Ajout de ".$iColor." #".dechex($iColor).", index=".$indexColor.", (Couleur src=".$iColorSrc.")<br>";
          }
          imagesetpixel($rImgDest, $iPosXDest+$w, $h, $indexColor);
        }
      }
      $bRes = true;
      
      echo ' - Intégration de '.$strFileImg.' : '.( $bRes ? '<font color="green">Ok</font>' : '<font color="red">Ko</font>' ).'<br>';
      $strCss .= ".".$strPrefix.str_replace("_", "", substr($strFileImg, 0, -4)).
        "{background-position:".($iPosXDest>0 ? -$iPosXDest : $iPosXDest)."px 0px" .
        ( $iWidthSrc != $iWidthImg ? ";width:".$iWidthImg."px" : "" ).
        ( $iHeightSrc != $iHeightImg ? ";height:".$iHeightImg."px" : "" ).
        "}\n";
      $iPosXDest += $iWidthSrc;
      imagedestroy($rImgSrc);
    }
  }
  
  // création du fichier css
  $bRes = false;
  $hFileCss = fopen($strPathBase.ALK_ROOT_MODULE."alkanet/styles/".$strFileNameCssDest, "w");
  if( $hFileCss ) {
    fwrite($hFileCss, $strCss);
    fclose($hFileCss);
    $bRes = true;
  }
  echo '<br><b>Création de '.$strFileNameCssDest.' :</b> '.
    ( $bRes 
      ? '<font color="green">Ok</font>' 
      : '<font color="red">Ko</font>' ).
    '<br>';
  
  // création de l'image dest
  switch( $tabParam["typeDest"] ) {
  case "png":
    $nbCouleurMax = count($tabColorDest)+1;
    echo '<br> - nb couleurs : '.$nbCouleurMax.'<br/>';
    if( $tabParam["reduceWidthGD"] ) {
      $bRes = imagetruecolortopalette($rImgDest, false, $nbCouleurMax);
      echo '- Réduction du nombre de couleurs avec GD : '.
        ( $bRes 
          ? '<font color="green">Ok</font>' 
          : '<font color="red">Ko</font>' ).
        '<br>';
    }
  
    $bRes = imagepng($rImgDest, $strPathBase.ALK_ROOT_MODULE."alkanet/images/".$strFileNameImgDest, 9);
    imagedestroy($rImgDest);

    echo '<br> - Création de '.$strFileNameImgDest.' : '.
      ( $bRes 
        ? '<font color="green">Ok</font>' 
        : '<font color="red">Ko</font>' ).
      '<br>';

    if( $bRes && $tabParam["reduceWidthGD"] ) {
      // reduit la palette 
echo      $strCmd = "convert ".$strPathBase.ALK_ROOT_MODULE."alkanet/images/".$strFileNameImgDest." -colors ".$nbCouleurMax." ".$strPathBase.ALK_ROOT_MODULE."alkanet/images/".$strFileNameImgDest;
      //$strRes = shell_exec($strCmd);

      echo ' - Réduction du nombre de couleurs avec CONVERT : '.$strRes.'<br>';
    }

    break;
  default:
    $bRes = false;
    break;
  }


  echo '<br>';
}

?>
