<?php
/**
 * @file
 * @class
 * @namespace
 * 
 * @brief 
 */

class PHPUnitWrapper {

  const PHPUNIT_SCRIPT        = "phpunit2";
  
  const PHPUNIT_TEST_SUFFIX   = "test.php";
  const PHPUINT_CLASS_SUFFIX  = ".class.php";
  
  private static $firtsCall = true; 
  private static $tabTestClasses;
  private static $tabAllTests;

  private function __construct() {
    
  } 
  
  public static function execute($command="") {
    if(self::$firtsCall) {
      self::$firtsCall = false;
      
      // need to know all generic classes
      $path = ini_get("include_path");
      // replace with ALK_ALKANET_ROOT_PATH ...
      // app_conf.php is supposed to be included
      ini_set("include_path", ALK_ALKANET_ROOT_PATH."/classes:".$path);
      
    }
    
    if(mb_strlen($command)==0) return;
    return shell_exec($command);
  }
  
  public static function getPHPUnitUsage() {
    $cmd = "phpunit2 --version";
    return self::execute($cmd);
  }
  
  public static function createSkeleton($className, $filePath) {
    /*
    include_once ALK_ALKANET_ROOT_PATH."/classes/pattern/alkobject.class.php";
    
    $cmd = "cd ".dirname($filePath)."; ";
    $cmd .= self::PHPUNIT_SCRIPT." --skeleton ";
    $cmd .= $className." ".$filePath;
    return self::execute($cmd);
    */
    
    
    if(self::$firtsCall) {
      self::$firtsCall = false;
      
      // need to know all generic classes
      $path = ini_get("include_path");
      // replace with ALK_ALKANET_ROOT_PATH ...
      // app_conf.php is supposed to be included
      ini_set("include_path", ALK_ALKANET_ROOT_PATH."/classes:".$path);
      
      //include_once 'PHPUnit2/Util/Skeleton.php';
      //include_once 'pattern/alkobject.class.php';
    }
    
    try {
      require_once("PHPUnitSkeleton.php");
      $sk = new PHPUnitSkeleton($className, $filePath);
      echo "create sk ... ok<br/>";
      $toFile = dirname($filePath)."/".mb_strtolower($className."Test.php");
      $sk->write($toFile);
      echo "writing to ".$toFile."... ok<br/>";
    } catch(Exception $e) {
      echo "Exception : ".$e->getMessage()."<br/>";
    }
    
  }
  
  public static function testFile($className, $filePath) {
    $cmd = "cd ".dirname($filePath)."; ";
    $cmd .= self::PHPUNIT_SCRIPT." --log-xml ".dirname($filePath)."/report.xml ";
    $cmd .= $className." ".$filePath;
    //return self::execute($cmd);
    
    
    try {
      require_once("PHPUnitRunner.php");
      $xmlLogfile = dirname($filePath)."/report.xml";
      PHPUnitRunner::run($className, $filePath, $xmlLogfile);
      return $xmlLogfile;
    } catch(Exception $e) {
      return false;
    }
    
  }
  
  public static function generateAllTests() {
    $return = false;
    $doc_root = ALK_ALKANET_ROOT_PATH; // /path/to/sit_alk
    
    echo "Generating test files... ";
    self::$tabTestClasses = array();
    self::$tabAllTests = array();
    self::processDir($doc_root);
    
    if(count(self::$tabAllTests)>0) {
      $file = self::writeMainAllTestsFile(self::$tabAllTests);
      //$file = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE.ALK_ROOT_MODULE."unit_tests_report/AllTests.php";
      if($file !== false) {
        echo "done !<br/><br/>";
        
        echo "Generating html report... ";
        $className = "AllTests";
        $xmlLogfile = self::testFile($className, $file);
        
        if($xmlLogfile!==false) {
          
          echo "done! <br/><br/>";
          echo "<a href='unit_tests_report/report.html'>Open the html report</a>";
          
        }
        
      } else {
        $return = false;
      }
    } else {
      echo "no test class found.";
      $return = false;
    }
    
    
    return $return;
    
  }
  
  private static function processDir($root_dir) {
    if(@is_dir($root_dir) && @is_readable($root_dir)) {
      if($handle = opendir($root_dir)) {
        
        self::$tabTestClasses = array();
        while (false !== ($file = @readdir($handle))) {
          if($file!="." && $file!=".." && $file!="runtest.php") {
            $filePath = $root_dir."/".$file;
            if(@is_dir($filePath)) {
              // recursively precess directories
              self::processDir($filePath);
              
            } else if(@is_file($filePath)) {
              // search for all *.class.php files
              if( (mb_strpos($file, PHPUnitWrapper::PHPUNIT_TEST_SUFFIX)>0) 
                  && mb_substr($file, mb_strlen($file)-mb_strlen(".php"), mb_strlen($file)-1)==".php") {
                //echo "FOUND TEST CLASS : ".$filePath."<br/>";
                $file = mb_substr($file, 0, -mb_strlen(".php"));
                self::$tabTestClasses[$file] = $filePath;
              }
            }
          }
        } // end while
        if(count(self::$tabTestClasses)>0) {
          //echo "generate AllTests.php in $root_dir<br/>";
          //echo print_r(self::$tabTestClasses)."<br/>";
          
          $testFile = $root_dir."/AllTests.php";
          self::writeAllTestsFile($testFile, self::$tabTestClasses);
        }
        closedir($handle);
      } // end if
    } // end if
  }
  
  private static function writeAllTestsFile($file, $tab) {
    if($handle = @fopen($file, "w+")) {
      $testClassName = basename(dirname($file))."Tests";
      fwrite($handle, "<?php \n\n");
      fwrite($handle, "if (!defined('PHPUnit2_MAIN_METHOD')) { \n");
      fwrite($handle, "  define('PHPUnit2_MAIN_METHOD', '".$testClassName."::main'); \n");
      fwrite($handle, "} \n\n");
      fwrite($handle, "require_once(\"PHPUnit2/Framework/TestSuite.php\"); \n");
      fwrite($handle, "require_once(\"PHPUnit2/TextUI/TestRunner.php\"); \n\n");
      fwrite($handle, "require_once(\"PHPUnit2/Util/Filter.php\"); \n");
      foreach($tab as $className=>$filePath) {
        $newPath = mb_substr($filePath, mb_strlen(ALK_ALKANET_ROOT_PATH), mb_strlen($filePath));
        fwrite($handle, "require_once(ALK_ALKANET_ROOT_PATH.\"".$newPath."\"); \n");
      }
      fwrite($handle, "/** \n");
      fwrite($handle, " * @package Alkanet_Unit_Tests\n");
      fwrite($handle, " */ \n");
      fwrite($handle, "\nclass ".$testClassName." { \n\n");
      fwrite($handle, "  public static function main() { \n");
      fwrite($handle, "    PHPUnit2_TextUI_TestRunner::run(self::suite());\n");
      fwrite($handle, "  } \n\n");
      fwrite($handle, "  public static function suite() { \n");
      fwrite($handle, "    \$suite = new PHPUnit2_Framework_TestSuite('".basename(dirname($file))."'); \n");
      foreach($tab as $className=>$filePath) {
        fwrite($handle, "    \$suite->addTestSuite(\"".$className."\"); \n");
      }
      /*
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/Assert.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/AssertionFailedError.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/ComparisonFailure.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/IncompleteTest.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/IncompleteTestError.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/Test.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/TestCase.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/TestFailure.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/TestListener.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/TestResult.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/TestSuite.php'); \n");
      fwrite($handle, "    PHPUnit2_Util_Filter::removeFileFromFilter('PHPUnit2/Framework/Warning.php'); \n");
      */
      fwrite($handle, "    return \$suite; \n");
      fwrite($handle, "  } \n");
      fwrite($handle, "} \n\n");
      fwrite($handle, "if (PHPUnit2_MAIN_METHOD == '".$testClassName."::main') { \n");
      fwrite($handle, "  ".$testClassName."::main(); \n");
      fwrite($handle, "} \n\n");
      fwrite($handle, "?> \n");
      
      fclose($handle);
      
      self::$tabAllTests[$testClassName] = $file;
    }
  }
  
  private static function writeMainAllTestsFile($tab) {
    $file = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE.ALK_ROOT_MODULE."unit_tests_report/AllTests.php";
    if($handle = @fopen($file, "w+")) {
      fwrite($handle, "<?php \n\n");
      fwrite($handle, "if (!defined('PHPUnit2_MAIN_METHOD')) { \n");
      fwrite($handle, "  define('PHPUnit2_MAIN_METHOD', 'AllTests::main'); \n");
      fwrite($handle, "} \n\n");
      fwrite($handle, "require_once(\"PHPUnit2/Framework/TestSuite.php\"); \n");
      fwrite($handle, "require_once(\"PHPUnit2/TextUI/TestRunner.php\"); \n\n");
      foreach($tab as $className=>$filePath) {
        $newPath = mb_substr($filePath, mb_strlen(ALK_ALKANET_ROOT_PATH), mb_strlen($filePath));
        fwrite($handle, "require_once(ALK_ALKANET_ROOT_PATH.\"".$newPath."\"); \n");
      }
      fwrite($handle, "/** \n");
      fwrite($handle, " * @package Alkanet_Unit_Tests\n");
      fwrite($handle, " */ \n");
      fwrite($handle, "\nclass AllTests { \n\n");
      fwrite($handle, "  public static function main() { \n");
      fwrite($handle, "    PHPUnit2_TextUI_TestRunner::run(self::suite()); \n");
      fwrite($handle, "  } \n\n");
      fwrite($handle, "  public static function suite() { \n");
      fwrite($handle, "    \$suite = new PHPUnit2_Framework_TestSuite('all tests'); \n");
      foreach($tab as $className=>$filePath) {
        fwrite($handle, "    \$suite->addTest(".$className."::suite()); \n");
      }
      fwrite($handle, "    return \$suite; \n");
      fwrite($handle, "  } \n");
      fwrite($handle, "} \n\n");
      fwrite($handle, "if (PHPUnit2_MAIN_METHOD == 'AllTests::main') { \n");
      fwrite($handle, "  AllTests::main(); \n");
      fwrite($handle, "} \n\n");
      fwrite($handle, "?> \n");
      
      fclose($handle);
      
      return $file;
    } else {
      return false;
    }
  }
  
} 
?>