<?php

require_once("PHPUnit2/Util/Skeleton.php");

class PHPUnitSkeleton extends PHPUnit2_Util_Skeleton {

  protected $templateClassHeader =
'<?php
// Call {className}Test::main() if this source file is executed directly.
if (!defined("PHPUnit2_MAIN_METHOD")) {
    define("PHPUnit2_MAIN_METHOD", "{className}Test::main");
}

require_once "PHPUnit2/Framework/TestCase.php";
require_once "PHPUnit2/Framework/TestSuite.php";

// You may remove the following line when all tests have been implemented.
require_once "PHPUnit2/Framework/IncompleteTestError.php";

require_once {classFile};

/**
 * Test class for {className}.
 * Generated by PHPUnit2_Util_Skeleton on {date} at {time}.
 *
 * @package Alkanet_[namespace]_Test
 */
class {className}Test extends PHPUnit2_Framework_TestCase {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit2/TextUI/TestRunner.php";

        $suite  = new PHPUnit2_Framework_TestSuite("{className}Test");
        $result = PHPUnit2_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }
';

  public function __construct($className, $classSourceFile = '') {
    parent::__construct($className, $classSourceFile);
  }
  
  /**
   * @param  string  $className
   * @param  string  $classSourceFile
   * @access protected
   */
  protected function testClassHeader($className, $classSourceFile) {
    return str_replace(
      array(
        '{className}',
        '{classFile}',
        '{date}',
        '{time}'
      ),
      array(
        $className,
        mb_ereg_replace (ALK_ALKANET_ROOT_PATH, "ALK_ALKANET_ROOT_PATH.\"", $classSourceFile."\""),
        date('Y-m-d'),
        date('H:i:s')
      ),
      $this->templateClassHeader
    );
  }

}
?>