<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::{$appli_abrev_classe}
Module {$appli_abrev_classe}.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_{$appli_abrev_classe}
 * @class AlkQuery{$appli_abrev_classe}Action
 * 
 * Ensemble des requetes actions de l'application
 */
class AlkQuery{$appli_abrev_classe}Action extends AlkQuery
{
  /**
   * Constructeur par défaut
   * 
   * @param dbConn     Classe de connection à la base
   */ 
  public function __construct(&$dbConn)
  {
    parent::__construct($dbConn);
  }

  /**
   * Ajoute une donnée. Retourne son identifiant
   *
   * @param tabQuery tableau contenant l'ensemble des champs utilisés par la requête
   * @return Retourne un entier
   */
  function add_data($tabQuery)
  {
    $tabValue = $tabQuery["field"];
    $tabValue["CHAMP_ID"][1] = $this->dbConn->getNextId("NOM_TABLE", "CHAMP_ID", "SEQ_NOM_TABLE");

    $strSql = "insert into NOM_TABLE ".$this->getPartInsertSql($tabValue);
    $this->dbConn->ExecuteSql($strSql);
    
    return $tabValue["CHAMP_ID"][1];
  }
  
  /**
   * Modifie une donnée
   */
  function update_data($tabQuery)
  {
    
  }
  
  /**
   * Suppime une donnée
   */
  function del_data($champ_id)
  {
    
  }

}

?>