<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::{$appli_abrev_classe}
Module {$appli_abrev_classe}.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @class AlkHtmlFormConsult{$appli_abrev_classe}List
 * @brief Description de la classe
 */
class AlkHtmlFormConsult{$appli_abrev_classe}List extends AlkHtmlForm 
{
  
  /**
   * Constructeur
   * @param oAppli    Application appelante
   */
  public function __construct(AlkAppli &$oAppli) 
  {
    parent::__construct($oAppli, "form{$appli_abrev_classe}List");
  }
  
  /**
   *  Abstract : Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { /** rien à faire **/ }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql() { /** rien à faire **/ }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setLabel("Mémento AlkHtmlFactory, Db et Query");
    $this->setLabelDesc("La classe AlkHtmlFactory permet de construire des élements de 
                         formulaire HTML (champs texte, listes de sélection, etc...).");
    
    $this->addBlockAlkHtmlFactory();
    $this->addBlockQuery();
  }
  
  private function addBlockAlkHtmlFactory() {
    $strTitle = "Liste des contrôles HTML (héritage de AlkHtmlPanel)";
    
    $oBlock = $this->addBlock("block_fact", $strTitle, "", "200", "490", true);
    $oBlock->addCtrl(AlkHtmlFactory::getHtml(AlkHtmlFactory::getHtml("<b>Code</b> <i>Html</i> <b>brut</b>")->getHtml(), "AlkHtmlFactory::getHtml()"));
    $oBlock->addCtrl(AlkHtmlFactory::getHtml(AlkHtmlFactory::getHtmlPanel("Nom du panel", "label du panel")->getHtml(), "AlkHtmlFactory::getHtmlPanel()"));
    $oBlock->addCtrl(AlkHtmlFactory::getHtml(AlkHtmlFactory::getHtmlPanelFilterLink("Filtre", "isSelect")->getHtml(), "AlkHtmlFactory::getHtmlPanelFilterLink()"));
    
    $checkbox = new AlkFormData($this, "checkbox", "", ALK_SQL_NONE);
    $oBlock->addCtrl(AlkHtmlFactory::getHtmlCheckbox($checkbox, "AlkHtmlFactory::getHtmlCheckbox()"));
    
    $color = new AlkFormData($this, "color", "", ALK_SQL_NONE);
    $oBlock->addCtrl(AlkHtmlFactory::getHtmlColor($color, "AlkHtmlFactory::getHtmlColor()"));
    
    $symbolcolor = new AlkFormData($this, "symbolcolor", "", ALK_SQL_NONE);
    $oBlock->addCtrl(AlkHtmlFactory::getHtmlSymbolColor($symbolcolor, "AlkHtmlFactory::getHtmlSymbolColor()"));
    
    $date = new AlkFormData($this, "date", "", ALK_SQL_NONE);
    $oBlock->addCtrl(AlkHtmlFactory::getHtmlDate($date, "AlkHtmlFactory::getHtmlDate()"));
    
    $slider = new AlkFormData($this, "slider", "100", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $oBlock->addCtrl(AlkHtmlFactory::getHtmlSlider($slider, "AlkHtmlFactory::getHtmlSlider()", 1, 4, 3, 100));
    
    //$calendar = new AlkFormData($this, "calendar", "", ALK_SQL_NONE);
    //$oBlock->addCtrl(AlkHtmlFactory::getHtmlCalendar($calendar, "AlkHtmlFactory::getHtmlCalendar()", date("d"), date("m"), date("Y"), ""));
    $oBlock->addCtrl(AlkHtmlFactory::getHtml("", "AlkHtmlCalendar()"));

    $file = new AlkFormData($this, "file", "", ALK_SQL_NONE);
    $oBlock->addCtrl(AlkHtmlFactory::getHtmlFile($file, "AlkHtmlFactory::getHtmlFile()"));
    
    $hidden = new AlkFormData($this, "hidden", "valeur_hidden", ALK_SQL_TEXT);
    $oBlock->addCtrl(AlkHtmlFactory::getHtml(AlkHtmlFactory::getHtmlHidden($hidden)->getHtml(), "AlkHtmlFactory::getHtmlHidden()"));
    
    $radio = new AlkFormData($this, "radio", "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $oCtrlRadio = AlkHtmlFactory::getHtmlRadio($radio, "AlkHtmlFactory::getHtmlRadio()");
    $oCtrlRadio->AddRadio(0, "Radio 1");
    $oCtrlRadio->AddRadio(1, "Radio 2");
    $oBlock->addCtrl($oCtrlRadio);
    
    $select = new AlkFormData($this, "select", "", ALK_SQL_NONE);
    $oCtrlSelect = AlkHtmlFactory::getHtmlSelect($select, "AlkHtmlFactory::getHtmlSelect()");
    $oCtrlSelect->setProperty("tabValTxt", array("option 1"=>"option 1", "option 2"=>"option 2"));
    $oBlock->addCtrl($oCtrlSelect);
    
    $text = new AlkFormData($this, "text", "un champ texte", ALK_SQL_TEXT);
    $oBlock->addCtrl(AlkHtmlFactory::getHtmlText($text, "AlkHtmlFactory::getHtmlText()"));
    
    //$upload = new AlkFormData($this, "upload", "", ALK_SQL_NONE);
    //$oBlock->addCtrl(AlkHtmlFactory::getHtmlUpload($upload, "AlkHtmlFactory::getHtmlUpload()", "TABLE_NAME", "CHAMP_ID", "DIR_UPLOAD"));
    $oBlock->addCtrl(AlkHtmlFactory::getHtml("", "AlkHtmlUpload()"));
    
    $oCtrlList = AlkHtmlFactory::getHtmlList($this, 2, 1, 20, true, ALK_ALKANET, "Aucune liste.", false, "tabList", false);
    $oCtrlList->SetColumns(array("left",   "50"),array("center", "200"));
    $oCtrlList->AddTitleRow(array("Id",1), array("Description",1));
    $oCtrlList->addRowByArray(array("12345", "test test test"));
    $oBlock->addCtrl(AlkHtmlFactory::getHtml($oCtrlList->getHtml(), "AlkHtmlFactory::getHtmlList()"));
    
    $oBlock->addCtrl(AlkHtmlFactory::getHtml(AlkHtmlFactory::getHtmlLink("http://www.alkante.com", "lien")->getHtml(), "AlkHtmlFactory::getHtmlLink()"));
    
    $oBlock->addCtrl(AlkHtmlFactory::getHtml(AlkHtmlFactory::getHtmlButton("http://www.alkante.com", "Valider", "tooltip")->getHtml(), "AlkHtmlFactory::getHtmlButton()"));
    
    $oBlock->addCtrl(AlkHtmlFactory::getHtml(AlkHtmlFactory::getHtmlButtonForm("http://www.alkante.com", "Valider", "tooltip")->getHtml(), "AlkHtmlFactory::getHtmlButtonForm()"));
    
    $oBlock->addCtrl(AlkHtmlFactory::getHtml(AlkHtmlFactory::getHtmlButtonPage("http://www.alkante.com", "Valider", "tooltip")->getHtml(), "AlkHtmlFactory::getHtmlButtonPage()"));
    
    $oBlock->addCtrl(AlkHtmlFactory::getHtml("", "AlkHtmlFactory::getHtmlTreeTable()"));
    $oTree = AlkHtmlFactory::getHtmlTreeTable($this, "tree", "TreeTable");
    $parent = $oTree->addNode(null, null, "parent", array("Dossier parent"));
    $node = $oTree->addNode($parent, null, "fils1", array("Noeud fils 1"));
    $node = $oTree->addNode($parent, null, "fils2", array("Noeud fils 2"));
    $node->addAction("iDroitLink", 2);
    $node->addAction("iDroitAction", 2);
    $node->addAction(ALK_TREEACTION_URL, "javascript:alkAlert('".$node->tabData[0]."');");
  }
  
  private function addBlockQuery() {
    $strTitle = "Utilisation des classes Db et Query";
    
    $oBlock = $this->addBlock("block_query", $strTitle, "", "200", "490", true);
    
    $contents[] = array("Accéder aux objets Query et QueryAction de l'application courante", 
                        "<pre>\$this->oAppli->oQuery</pre> et <pre>\$this->oAppli->oQueryAction</pre>");
    $contents[] = array("Accéder aux objets Query et QueryAction d'une autre application", 
                        "<pre>AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE)</pre> et <pre>AlkFactory::getQueryAction(ALK_ATYPE_ID_ESPACE)</pre>");
    $contents[] = array("Récupérer un Dataset depuis une classe Query", 
                        "<pre>\$dsXXX = \$this->oAppli->oQuery->getDsXXX();</pre>");
    $contents[] = array("Itérer sur un objet de type Dataset",
                        "<pre>
while (\$drXXX = \$dsXXX->getRowIter()) {<br>
  \$champ_1 = \$drXXX->GetValueName(\"CHAMP_1\");<br>
  \$champ_2 = \$drXXX->GetValueName(\"CHAMP_2\");<br>
  etc...<br>
}</pre>");
    $contents[] = array("Construire une liste (AlkHtmlList) à partir d'un Dataset",
                        "<pre>
\$dsXXX = \$this->oAppli->oQuery->getDsXXX();<br>
\$nbElts = \$dsXXX->getCountTotDr();
\$oList = AlkHtmlFactory::getHtmlList(\$this, \$nbElts, 1, \$nbElts, false, <br>
                                     \"\", \"Vide\", \"\", \"nomliste\");<br>
\$oList->SetColumns(array(\"left\",\"180\"), array(\"center\",\"400\"));<br>
while (\$drXXX = \$dsXXX->getRowIter()) {<br>
  \$champ_1 = \$drXXX->GetValueName(\"CHAMP_1\");<br>
  \$champ_2 = \$drXXX->GetValueName(\"CHAMP_2\");<br>
  \$oList->addRowByArray( array(\$champ_1, \$champ_2) );
}<br>
\$oList->getHtml();</pre>");
    $nbElts = count($contents)+1; // contentu + titre
    
    $oCtrlList=AlkHtmlFactory::getHtmlList($this, $nbElts, 1, 20, true, ALK_ALKANET, "Aucune liste.", false, "tabListQ", false);
    $oCtrlList->SetColumns(array("left",   "200"),array("left", "490"));
    $oCtrlList->AddTitleRow(array("Objectifs",1), array("Exemples d'utilisation",1));
    
    // remplir la liste avec le contenu du tableau
    for($i=0; $i<count($contents); $i++) {
      $oCtrlList->addRowByArray($contents[$i]);
    }
    
    $oBlock->addCtrl(AlkHtmlFactory::getHtml($oCtrlList->getHtml(),""), ALK_HTMLFORM_1L1C);
    
  }
  
  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."{$appli_dir}/help/{$appli_abrev_fichier}_01_consult_list.htm");
  }
}
?>