<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


/** 
 * @file lib_session.php
 * @package Alkanet_Library
 * @brief Charge les fichiers de définition de constantes et vérifie l'état de session
 */

if( session_id() == "") {
  session_start();
}

ini_set("display_errors", "on");
error_reporting(E_ALL);
 
/** Chargement des fichiers de config */
if( !@include_once("../../../../../"."libconf/app_conf.php") ) {
  if( !@include_once("../../../../"."libconf/app_conf.php") ) {
    if( !@include_once("../../../"."libconf/app_conf.php") ) {
      if( !@include_once("../../"."libconf/app_conf.php") ) {
        if( !@include_once("../"."libconf/app_conf.php") ) {
          require_once(""."libconf/app_conf.php");
        }
      }
    }
  }
}

require_once(ALK_ALKANET_ROOT_PATH."lib/lib_locales.php");

// Initialise la prise en change de la langue et de la locale courante
$bFrontOffice = false;
initAlkLocale();


require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."app_conf_sig.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkrequest.class.php");

/** Chargement des classes de bases */
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkfactory.class.php");
require_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkmailing.class.php";

if( PHP_SAPI == "cli" ) {
  echo "Erreur : il faut appeler lib_session_cli.php.";
  exit(); 
}
$PHP_SELF = $_SERVER["PHP_SELF"];
$strPageCur = substr($PHP_SELF, 1); // enleve le premier caractère = /

// on interdit l'appel direct au lib_session.php
if( !(strpos($strPageCur, "lib_session.php") === false) ) {
  exit();
}

$bAlkanet = !(strpos($strPageCur, "/alkanet.php")===false && strpos($strPageCur, "/alkanet_sql.php")===false);

if( strpos($strPageCur, "/alkanet_sql.php")===false && strpos($strPageCur, "/alkanet_site_sql.php")===false ) {
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlfactory.class.php");
} 
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");


/** 
 * Vérification présente au non de l'utilisateur anonyme ou internet 
 */
$bUserInternetExists = !( !defined("ALK_B_USER_INTERNET_EXISTS") || 
                          defined("ALK_B_USER_INTERNET_EXISTS") && !ALK_B_USER_INTERNET_EXISTS );
$bUserInternetCanConnectAlkanet = ( defined("ALK_B_USER_INTERNET_CANCONNECT_ALKANET") && ALK_B_USER_INTERNET_CANCONNECT_ALKANET == true );

/**
 * @brief Controle de sécurité
 */

if( defined("ALK_AUTH") && 
    ( defined("ALK_AUTH_NTLM_NAV") && ALK_AUTH == ALK_AUTH_NTLM_NAV ||   
      defined("ALK_AUTH_NTLM_APACHE") && ALK_AUTH == ALK_AUTH_NTLM_APACHE ) ) {
  
  if( !( isset($_SESSION["alk_ldapuser"]) && $_SESSION["alk_ldapuser"]==true) ) {
    // authentification NTLM via la connexion active windows sur le domaine active directory paramétré 
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_activedirectory.php");
  }

  // l'utilisateur est forcément connecté, sauf si le compte anonyme n'est pas valide
  // Dans ce cas, redirection vers une page "Access denied"
  if( $_SESSION["alk_ldapuser"] == false ) {
    header("HTTP/1.0 401 Unauthorized");
    exit(); 
  }
} 
elseif( defined("ALK_AUTH") && defined("ALK_AUTH_SSO") && ALK_AUTH==ALK_AUTH_SSO && 
          !( isset($_SESSION["alk_ssoUser"]) && $_SESSION["alk_ssoUser"]==true) ) {
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."auth_cas/CAS.php");
  
  if( strpos($strPageCur, "/alkanet_verif.php")===false )  {
    phpCAS::proxy(CAS_VERSION_2_0, ALK_SSO_URL, ALK_SSO_PORT, ALK_SSO_URI, false);
    phpCAS::setFixedServiceURL(ALK_ALKANET_VERIF."?sso=1".(defined("ALK_SSO_REDIRECT") ? "&url=".AlkRequest::getEncodeParam(ALK_SSO_REDIRECT) : ""));
    phpCAS::setNoCasServerValidation();
    phpCAS::forceAuthentication();
    exit();
  }
  
  phpCAS::client(CAS_VERSION_2_0, ALK_SSO_URL, ALK_SSO_PORT, ALK_SSO_URI, false);
  phpCAS::setNoCasServerValidation(); 

  // utilisateur temporaire le temps d'exécuter alkanet_verif.php pour charger le profil
  AlkFactory::initAnonymousSession();
} 
else {
  // authentification par login/mot de passe
  /** $tabFileSession est déclaré dans app_conf_alkanet.php */
  
  /** evite d'afficher la popup d'identification pour les pages suivantes */
  $bTestPage = true;
  if( isset($tabFileSession) && is_array($tabFileSession) ) {
    foreach($tabFileSession as $strFileName) {
      $bTestPage = $bTestPage && ( strpos($strPageCur, $strFileName)===false );
    }
  }
  
  if( $bTestPage && !(isset($_SESSION["alk_idUser"]) && is_numeric($_SESSION["alk_idUser"])) ) {
    // il est nécessaire d'initialiser $_SESSION["alk_xxxx"]
    if( $bUserInternetExists &&
        ( !$bAlkanet || $bAlkanet && $bUserInternetCanConnectAlkanet) ) {
      // l'utilisateur internet existe et est autorisé à se connecter automatiquement
      AlkFactory::initAnonymousSession();
    }
  }
  
  // la session n'est toujours pas donnée : on redirige vers la page d'authentification
  if( !(isset($_SESSION["alk_idUser"]) && is_numeric($_SESSION["alk_idUser"])) ) {
    if( $bTestPage ) {
      // demande la page d'authentification
      echo '<html><head>'.
        '<script type="text/javascript" src="../../lib/lib_js.js"></script>'.
        '<script type="text/javascript">'.
        ' /*ALK_RECONNECT | top.window.location = "/index.php?err=2&url='.AlkRequest::getEncodeParam($_SERVER["REQUEST_URI"]).'"; */'.
        ' function OpenWindowLogin() {'.
        '   if( !closeAllWindow("/index.php?err=2&url='.AlkRequest::getEncodeParam($_SERVER["REQUEST_URI"]).'") )'.
        '     top.window.location = "/index.php?err=2&url='.AlkRequest::getEncodeParam($_SERVER["REQUEST_URI"]).'";'.
        ' }'.
        '</script></head>'.
        '<body onload="OpenWindowLogin()"></body>'.
        '</html>';
      exit();
    } else {
      // on continue en anonyme le temps d'exécuter alkanet_verif.php pour charger le profil
      AlkFactory::initAnonymousSession();
    }
  }  
}

/** vérification de l'état connecté avec le mode https */
if( defined("ALK_B_HTTP_SWITCH_PROTOCOL") && ALK_B_HTTP_SWITCH_PROTOCOL==true ) {
  if( $_SESSION["alk_idUser"] != ALK_USER_ID_INTERNET && !(isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"]=="on") ) {
    header("location: http://".( defined("ALK_HTTP_HOST") ? ALK_HTTP_HOST : $_SERVER["HTTP_HOST"])."/");
    exit(); 
  }
}

if( !isset($_SESSION["alk_userAdminAuth"]) || 
    (isset($_SESSION["alk_userAdminAuth"]) && $_SESSION["alk_userAdminAuth"] == "0" && $bAlkanet && !$bFrontOffice) ) {
  // on est arrivé ici sans autorisation d'accès au back-office : accès refusé
  echo '<html><head><script type="text/javascript">'.
    ' function onLoadWind() {'.
    '   window.top.location = "'.ALK_ALKANET_IDENT.'?err=1";'.
    ' } </script></head><body onload="onLoadWind()"></body></html>';
  exit();  
}

// mémorisation des infos de l'utilisateur connecté
AlkFactory::initUserSProperties();

AlkFactory::setSProperty("bInternet",  (!$bUserInternetExists && $_SESSION["alk_idUser"] == ALK_USER_ID_INTERNET) );

/** 
 * Chargement ensuite du lib_global 
 *   - chargement des constantes générales + espace + annu + celles de l'appli utilisée 
 */

?>