<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * @brief retourne le code html du header des fichiers générés pour l'indexation par htdig
 * @param strtitre          titre de la page
 * @param strUrlRedirect    url de la page au sein d'alkanet
 * @param bIndex            booléen indiquant si ce fichier doit être indexé (noindex) ou suivi (follow) (par défaut true = follow)
 * @param cont_id           identifiant de l'espace
 * @return string
 * 
 */
function getHeader($strtitre, $strUrlRedirect="", $bIndex=true, $cont_id=1)
{
	$strHeader = "<html>\n<head>\n".
		"<title>".$strtitre."</title>\n".
		"<meta name=\"title\" content=\"\">\n".
		"<meta name=\"description\" content=\"\">\n".
		"<meta NAME=\"language\" content=\"FR\">\n".
		"<meta name=\"robots\" content=\"".(($bIndex==false)?"noindex, follow":"")."\">\n".
    "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".ALK_HTML_ENCODING."\">\n".
		"<link rel=\"stylesheet\" href=\"".ALK_ROOT_URL."/styles/site_gen.css\" type=\"text/css\">\n".
		"</head>\n";
		
	if ( $strUrlRedirect!="")
		$strHeader .= "<script language=javascript>\n".
      "window.document.location='".$strUrlRedirect."'\n".
      "</script>\n";
	
	$strHeader .= "<body leftmargin=\"0\" topmargin=\"0\" marginwidth=\"0\" marginheight=\"0\">\n";
	
	return $strHeader;
}

/**
 * @brief retourne le code html du footer des fichiers générés pour l'indexation par htdig
 * @return string
 * 
 */
function getFooter()
{
	$strFooter = "</body>\n</html>\n";
	
	return $strFooter;
}

/**
 * @brief retourne le contenu extrait du fichier passer en paramètre pour l'indexation par htdig
 * @param type              extension du fichier (dot, rtf, doc, pdf, sxc, sxw, xlt et xls)
 * @param fichier           chemin complet du fichier
 * @return string
 * 
 */
function getFileContenu($type, $fichier)
{
  $res = "";
  $resultat = "";

  switch ($type){
    case "dot":
		case "rtf":
    case "doc":
      exec("/usr/bin/catdoc -scp1250 -d8859-1 ".$fichier, $res, $i);
			break;
    case "pdf":
      exec("/usr/bin/pdftotext ".$fichier." - ", $res, $i);
			break;
    case "sxc":
    case "sxw":
      exec("/usr/bin/unzip -p ".$fichier, $res, $i);
      break;
    case "xlt":
    case "xls":
      exec("/usr/bin/xls2csv -scp1250 -d8859-1 ".$fichier, $res, $i);
			break;
  }

  for ($i=0; $i<count($res)-1; $i++) {
    $resultat .= $res[$i]."\n"; 
  }

  return $resultat;
}

/**
 * @brief créé un fichier html correspondant au contenu du fichier passé en paramètre
 * retourne le lien html vers le fichier créé
 * @param fichier   nom du fichier
 * @param strAppli  intitulé de l'application
 * @param chemin    chemin du fichier
 * @param cont_id   identifiant de l'espace
 * @param appli_id  identifiant ed l'application
 * @param rub_id    identifiant de la rubrique à intégrer dans le nom du fichier créé pour pouvoir
 *                  limiter les résultats de la recherche htdig en fonction des droits de l'utilisateur connecté 
 *                  par défaut ""
 * @return string
 * 
 */
function creationFicHtml($fichier, $strAppli, $chemin, $cont_id, $appli_id, $rub_id="")
{
  $chaine = "";
  $ext = strtolower(substr($fichier,strrpos($fichier,".")+1,strlen($fichier)-strrpos($fichier,".")-1));
  //si l'extension correspond aux types affiches
  switch(strtolower($ext)) {
    case "txt":
    case "dot":
    case "rtf":
    case "doc":
    case "pdf":
    case "xlt":
    case "xls":
      //on créé un fichier htm correspondant à ce fichier
      $strTitre = substr($fichier, 0, strpos($fichier, '.'));
      $strTitreFic = verifyFileName(trim($strTitre));
      $strFile = $appli_id.(($rub_id=="")?"":"_".$rub_id)."_".$strTitreFic."-pj.html";
      
      $strUrl = ereg_replace(ALK_ROOT_PATH, ALK_ROOT_URL, $chemin.$fichier);

      //on ajout un lien vers ce fichier dans le fichier index_pj.hml
      $chaine = "<a href=\"".ALK_ROOT_HTDIG_URL.( defined("ALK_VIRTUAL_DIR") ? ALK_VIRTUAL_DIR : ALK_ROOT_DIR).ALK_ROOT_UPLOAD."search/".$cont_id."/".$strFile."\" class=\"txt\">".$strTitre."</a><br>\n";

      //on créé le fichier html correspondant
      if (file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."search/".$cont_id."/" . $strFile)){
        unlink(ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."search/".$cont_id."/" . $strFile);
      }

      $file=fopen(ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."search/".$cont_id."/" . $strFile ,"wb"); // Ouverture du fichier avec le mode écriture
      $result = fread($file,8192);

      echo "Création du fichier /upload/search/".$cont_id."/".$strFile."<br>\n";

      $strContenu = getHeader("Pièce jointe - ".$strAppli." - ".$strTitre, $strUrl).getFileContenu($ext, $chemin.$fichier).getFooter();
      fwrite($file, $strContenu); 
      break;

      default:
        //on indique dans un fichier log les fichiers qui ne sont pas indexés
      break;
  }
  return $chaine;
}

/**
 * @brief remplace les entités numériques et littérales d'une chaine de caractères
 * @param string    chaine de caractéres
 * @return string
 * 
 */
function unhtmlentities ($string)
{
   // Remplace les entités numériques
   $string = preg_replace('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $string);
   $string = preg_replace('~&#([0-9]+);~e', 'chr("\\1")', $string);
   // Remplace les entités litérales
   $trans_tbl = get_html_translation_table (HTML_ENTITIES);
   $trans_tbl = array_flip ($trans_tbl);
   return strtr ($string, $trans_tbl);
}