/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

function OpenClosePJMenu(oSrc, destName, action, align, strToken)
{
  var oDiv = document.getElementById(destName);
  if( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv );
  if( action=='over' && oDiv.innerHTML=="" ) {
    var oAjax = new AlkAjax("nameLoadPJMenu", "fnLoadPJMenu", ALK_FORM_METHOD_GET, 
                            ALK_ALKANET_PROCESS+"?token="+strToken+"&iMode=3&ln="+destName, null);
  }
  if( align=='right' ) oStyle.left = "-260px";
  else oStyle.left = "0px";
  oStyle.width="280px";
  oStyle.overflow="hidden";
  if ( !(action=='over' && oDiv.innerHTML=="") )
    oStyle.display = (action=='over' ? 'block' : 'none');
}
function fnLoadPJMenu(strHtmlContent)
{
  // retourne le code html de la liste des blocs de la page
  // le nom du layer est présent avant le premier tag commençant par <
  var strLayerName = "";
  if( strHtmlContent != "" ) {
    var s = new String(strHtmlContent);
    var iPos = s.indexOf("<");
    if( iPos >= 0 ) {
      strLayerName = s.substr(0, iPos);
      strHtmlContent = s.substr(iPos);
    } else {
      return;
    }
  } else {
    return;
  }
  
  var oDiv = document.getElementById(strLayerName);
  if ( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv );
  oDiv.innerHTML = strHtmlContent;
  
  oStyle.display = 'block';
}

function OpenAspic()
{
  if( OpenAspic.arguments.length >= 1 ) {
    // site aspic
    var strUrl = ALK_ASPIC_URL_V2;
    var largeur = screen.width;
  	var hauteur = screen.height;
	  wmaj = window.open(strUrl + OpenAspic.arguments[0],
                       "Identification", 
                       "resizable=yes,toolbar=yes,scrollbars=yes,status=yes,top=0,left=0,width="+largeur+",height="+hauteur+"");
	  wmaj.focus();
  }
}
function OpenAspicCons()
{
  if( OpenAspicCons.arguments.length >= 1 ) {
    // site aspic
    var strUrl = ALK_ASPIC_URL_CONS_V2;
    var largeur = screen.width;
  	var hauteur = screen.height;
	  wmaj = window.open(strUrl + OpenAspicCons.arguments[0],
                       "Identification", 
                       "resizable=yes,toolbar=yes,scrollbars=yes,status=yes,top=0,left=0,width="+largeur+",height="+hauteur+"");
	  wmaj.focus();
  }
}
function OpenActes3()
{
  if( OpenActes3.arguments.length >= 3 ) {
    // site raa
    var strUrl = ALK_ACTES3_URL;
    var largeur = screen.width;
  	var hauteur = screen.height;
	  wmaj = window.open(strUrl + OpenActes3.arguments[0]+"&"+OpenActes3.arguments[1],
                       "_blank", "");
                       //"resizable=yes,toolbar=yes,scrollbars=yes,menubar=yes,status=yes,top=0,left=0,width="+largeur+",height="+hauteur+"");
	  wmaj.focus();
  }
}
function OpenProdigeDist()
{
  if( OpenProdigeDist.arguments.length >= 1 ) {
    var strParam = OpenProdigeDist.arguments[0];
    var strToken = TextEncode(strParam);
    OpenFooterExec("../prodigedist/prodige.php?token="+strToken);
  }
}
function OpenPopupFiche(strType, idEnt)
{
  var ibtUpdate = (arguments.length > 2 ? arguments[2] : 1);
  if( strType == "agent" ) {
    OpenWindow(ALK_ALKANET+"?token="+ALK_TOKEN_POPUPUSERINFO+"&aid="+idEnt+"&u="+ibtUpdate, "480", "480", "windFiche"+strType);
  } 
  else if( strType == "service" ) {
    OpenWindow(ALK_ALKANET+"?token="+ALK_TOKEN_POPUPSERVINFO+"&sid="+idEnt+"&u="+ibtUpdate, "400", "480", "windFiche"+strType);
  } 
  else if( strType == "abonne" ) {
    OpenWindow(ALK_ALKANET+"?token="+ALK_TOKEN_POPUPABONNEINFO+"&aid="+idEnt+"&u="+ibtUpdate, "400", "480", "windFiche"+strType);
  }
}

function OpenCarto()
{
var larg = (document.body.clientWidth);
var haut = (document.body.clientHeight);
  var hauteur_popup = 600;
  var largeur_popup = 800;
  var H = (screen.height - hauteur_popup) / 2;
  var L = (screen.width - largeur_popup) / 2;
  var cont_id = "1";
  var cont_appli_id = "";
  var doc_type = "";
  var doc_id = "";
  var tabArg = OpenCarto.arguments;
  if( tabArg.length >= 2 ) {
    cont_id = tabArg[0];
    cont_appli_id = tabArg[1];
  }
  if( tabArg.length == 4 ) {  
    doc_type = tabArg[2];
    doc_id = tabArg[3];
  }
  var strUrl = ALK_SIALKE_URL+
    "scripts/sig_01/00_appli_load.php?cont_id="+cont_id+
    "&cont_appli_id="+cont_appli_id+"&doc_type="+doc_type+"&doc_id="+doc_id;
  window.open(strUrl, "AppliCarto", 
    "status=no,scrollbars=no,resizable=yes,height="+
    hauteur_popup+",width="+largeur_popup+",top="+H+",left="+L);
}
function OpenCartoExcel()
{
  var hauteur_popup = 600;
  var largeur_popup = 800;
  var H = (screen.height - hauteur_popup) / 2;
  var L = (screen.width - largeur_popup) / 2;
  var cont_id = "1";
  var cont_appli_id = "";
  var doc_type = "";
  var doc_id = "";
  var tabArg = OpenCartoExcel.arguments;
  if( tabArg.length >= 2 ) {
    cont_id = tabArg[0];
    cont_appli_id = tabArg[1];
  }
  if( tabArg.length == 3 ) {
    doc_id = tabArg[2];
  }
  var strUrl = ALK_SIALKE_URL+
    "scripts/cex_01/00_appli_load.php?cont_id="+cont_id+
    "&cont_appli_id="+cont_appli_id+"&doc_id="+doc_id;
  window.open(strUrl, "AppliCartoExcel", 
    "status=no,scrollbars=no,resizable=no,height="+
    hauteur_popup+",width="+largeur_popup+",top="+H+",left="+L);
}
function OpenPrintPreview()
{
  var strUrl = location.href;
  if( strUrl.substr(-4)!=".php" )
    strUrl = strUrl +"&print=1";
  else
    strUrl = strUrl +"?print=1";
  var strName = "PrintPreview";
  var hauteur_popup = 400;
  var largeur_popup = 630;
  var H = (screen.height - hauteur_popup) / 2;
  var L = (screen.width - largeur_popup) / 2;
  popupWindow = window.open(strUrl, strName, 
    "menubar=yes,status=yes,scrollbars=yes,resizable=yes,height="+
    hauteur_popup+",width="+largeur_popup+",top="+H+",left="+L);
}
function AddFavorite()
{
  var bookmarkUrl = ALK_ROOT_URL+"/"+strTitreAliasPage+".htm";
  var bookmarkTitle = strTitrePage;
  if( bookmarkUrl != "" )
    if( document.all )
      window.external.AddFavorite(bookmarkUrl, bookmarkTitle);
    else
      OpenWindow(ALK_SIALKE_URL+"scripts/"+ALK_DIR_ESPACE+
        "favori_info.php?bu="+bookmarkUrl+"&bt="+bookmarkTitle,
        150, 750, "windFavoris");
  else
    alkAlert("Vous n'avez pas le droit d'accéder à cet espace.");
}

function OpenAppliDist()
{
  var hauteur_popup = 700;
  var largeur_popup = 1024;
  var H = (screen.height - hauteur_popup) / 2;
  var L = (screen.width - largeur_popup) / 2;
  var cont_id = "1";
  var cont_appli_id = "";
  var doc_type = "";
  var doc_id = "";
  var tabArg = OpenAppliDist.arguments;
  if( tabArg.length >= 2 ) {
    cont_id = tabArg[0];
    cont_appli_id = tabArg[1];
  }
  if( tabArg.length == 3 ) {
    doc_id = tabArg[2];
  }
  if (ALK_URL_SERVEUR_DIST){  	
    var strUrl = ALK_SIALKE_URL+
      "scripts/espace/call_connexion_dist.php?cont_id="+cont_id+
      "&cont_appli_id="+cont_appli_id+"&appli_id="+cont_appli_id+"&iMode=2";
    window.open(strUrl, "AppliDist", 
      "status=yes,scrollbars=yes,resizable=yes,directories=yes,toolbar=yes,menubar=yes,height="+
      hauteur_popup+",width="+largeur_popup+",top="+H+",left="+L);
      
  }
}

/**
 * h = hostname
 * a = fdoc_appli_id
 * b = agent_id
 * c = profil_id
 * d = rub_id
 * e = doc_id
 * f = strExtent : (tab[xmin]=xmin&tab[ymin]=ymin&tab[xmax]=xmax&tab[ymax]=ymax)
 */
function OpenSiteCarto(h, a, b, c, d, e, f){
  var hauteur_popup = 700;
  var largeur_popup = 1020;
  var H = (screen.height - hauteur_popup) / 2;
  var L = (screen.width - largeur_popup) / 2;
  
  var strUrl = "http://"+h+"/scripts/sig_site/00_gotocarte.php?a="+a;
  if (b!="")
    strUrl += "&b="+b;
  if (c!="")
    strUrl += "&c="+c;
  if (d!="")
    strUrl += "&d="+d;
  if (e!="")
    strUrl += "&e="+e;
  if (f!="")
    strUrl += "&"+f;
  window.open(strUrl, "sig_site", 
    "status=yes,scrollbars=yes,resizable=yes,height="+
    hauteur_popup+",width="+largeur_popup+",top="+H+",left="+L);
} 
function ShowHideFormAide(iNumImgAide)
{
  // rend visible ou non l'aide associé à un controle de saisie

}

function OpenWindEspaceInvite(cont_id)
{
  wmaj = OpenWindow("../espace/contact_animateur_form.php?cont_id="+cont_id, "470", "570", "windContact");
  wmaj.focus();  
}

/**
 * Ouvre l'appli de syndication pour une donnée provenant d'un certain type d'application
 * @param strToken   token permettant d'ouvrir la popup de syndication
 */
function OpenSyndication(strToken)
{
  OpenWindow(ALK_ALKANET+"?token="+strToken, 600, 700, "syndFrame");
}