/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * Surcharge les fonctions du lib_js.js pour afficher les Popups en mode Jquery Dialog
 * 
 */

/**
 * Ferme la dernière popup ouverte
 * @param strUrlToken  url de réaffichage de l'opener. 
 *                     si la chaine ne contient pas .php, le paramètre est considéré comme un token
 *                     sur l'url alkanet.php
 *                     si la chaine = reload, un reload est effectué sur l'opener
 */
function removePopup(strUrlToken)
{ 
  if ( window!=top ){
    top.removePopup(strUrlToken);
    return;
  }
  var iLevel = top.iLevelAlkPopup;
  var oOpenerIFrame = null;
  var iLevelNext = 0;
  var bClose = false;
  top.iLevelAlkPopup = top.iLevelAlkPopup - 1;
  var oPopup = top.document.getElementById("alkIFrameNiv"+iLevel.toString());
  iLevelNext = top.iLevelAlkPopup;
  /* <![CDATA[ */
  oPopup.src = "";
  top.jQuery("#alkIFrameNiv"+iLevel.toString()).dialog('destroy');    
  /* ]]> */
  if( oPopup ) {
   oPopup.parentNode.removeChild(oPopup);
   delete(oPopup);
  }
  bClose = true;
  
  if( typeof(strUrlToken)!="undefined" && strUrlToken != "" ) {
    var iLevelOpener = iLevel-1;
    oOpenerIFrame = top.window;
    if( iLevelOpener >= 1 ) {
      oOpenerIFrame = top.document.getElementById("alkIFrameNiv"+iLevelOpener.toString());
    }

    // le paramètre &r=1 est présent pour éviter l'utilisation du cache navigateur
    if( strUrlToken == "reload" ) {
      if( oOpenerIFrame==top.window ) {
        oOpenerIFrame.location.reload();
      } else {
        oOpenerIFrame.contentWindow.location.reload();
      }
    } else {
      var strUrl = ( strUrlToken.indexOf(".php")>-1 
                     ? strUrlToken+(strUrlToken.substr(-4)==".php" ? "?" : "&")+"r=1"
                     : ( isToken(strUrlToken)
                         ? ALK_ALKANET+"?token="+strUrlToken+"&r=1"
                         : strUrlToken ));
      if( oOpenerIFrame==top.window ) {
        oOpenerIFrame.location = strUrl;
      } else {
        oOpenerIFrame.src = strUrl;
      }
    }
  }
  return bClose;
}

/**
 * @brief Ferme toute les popup ouvertes
 */
function removeAllPopup()
{
  var bClose = false;
  for(iLevel=1; iLevel<=top.iLevelAlkPopup; iLevel++) {
    var oOpenerIFrame = null;
    var oPopup = top.document.getElementById("alkIFrameNiv"+iLevel.toString());
    /* <![CDATA[ */
    top.jQuery('#'+"alkIFrameNiv"+iLevel.toString()).dialog('destroy');    
    /* ]]> */
    if( oPopup ) {
      oPopup.parentNode.removeChild(oPopup);
      delete(oPopup);
      bClose = true;
    }
  }
  top.iLevelAlkPopup = 0;      
  
  return bClose;
}

/**
 * @brief Simule l'ouverture d'une fenêtre popup dans un layer et iframe combinés
 * @param strUrl  url de iframe
 * @param iHeight hauteur de l'iframe
 * @param iWidth  largeur de l'iframe
 * @param strName Nom de l'iFrame
 * @return Une référence sur l'iframe ouverte
 */
function OpenWindow(strUrl, iHeight, iWidth, strName)
{
   
  if( top.iLevelAlkPopup > 4 ) {
    alert("Conception à revoir. Trop de popup.");
    return null;
  }
  
  var oWind = top;
  top.iLevelAlkPopup = top.iLevelAlkPopup + 1;
  var oIFrame = top.document.createElement("iframe");
  var iFrameId = "alkIFrameNiv"+top.iLevelAlkPopup.toString();
  oIFrame.id = iFrameId;
  oIFrame.name = ( !strName ? oIFrame.id : strName );
  var oOpener = window;//GetWindowByNiv(top.iLevelAlkPopup-1);
  AddWindOpener(oIFrame.name, oOpener);
  var oStyle = getStyleObj(oIFrame);
  oStyle.width  = iWidth+"px";
  oStyle.height = iHeight+"px";
  oStyle.display = "none";
  oIFrame.setAttribute("frameBorder", "0");
  
  /*oIFrame.src = strUrl;
  oIFrame.setAttribute("frameBorder", "0");
  top.document.body.appendChild(oIFrame);
  */
  
  function loadIframe(){
  	     
    if ( oIFrame.contentDocument ) { // DOM
      var oDivTitle = oIFrame.contentDocument.getElementById("alkPopupTitle");
      var oDivbClose = oIFrame.contentDocument.getElementById("alkPopupBtClose");
    } else if ( oIFrame.contentWindow ) { // IE win
      var oDivTitle = oIFrame.contentWindow.document.getElementById("alkPopupTitle");
      var oDivbClose = oIFrame.contentWindow.document.getElementById("alkPopupBtClose");
    }
    var strDivTitle = ( oDivTitle ? oDivTitle.innerHTML : "" );
    var strTokenClose = ( oDivbClose ? oDivbClose.innerHTML : "" );       
    /* <![CDATA[ */
    jQuery(document).ready(function() {
      top.jQuery('#'+oIFrame.id).dialog({
  			height: parseInt(iHeight)+20,
  			width: parseInt(iWidth)+20,
  			modal: true,
  			stack: true,
  			zIndex : 20000,
  			title : strDivTitle,
  			close: function(event, ui){ closeWindow(strTokenClose);}
  	  });
  	});
    /* ]]> */
    if( typeof(oIFrame.onreadystatechange) == "undefined" ) {
      oIFrame.onload = null;
    } else {
      oIFrame.onreadystatechange = null;
    }
    oIFrame.src = strUrl;
    //return oIFrame.contentWindow;   
  }
  
  if( typeof(oIFrame.onreadystatechange) == "undefined" ) {
    oIFrame.onload = loadIframe;
  } else {
    oIFrame.onreadystatechange = loadIframe;
  }
  top.document.body.appendChild(oIFrame);
  return oIFrame.contentWindow;   
}


