<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/** 
 * @file lib_global_site.php
 * @package Alkanet_Library
 * @brief Initialise les objects oSpace, oAppli à page d'une page éditoriale
 */

// on interdit l'appel direct au lib_global.php
if( isset($_SERVER["PHP_SELF"]) && !(strpos($_SERVER["PHP_SELF"], "lib_global_site.php") === false) ) {
  exit();
}

// nécessaire de déclarer ces 2 constantes ici pour oAppliGedit->rewriteUrl()
if( !defined("ALK_B_ATYPE_ESPACE") ) define("ALK_B_ATYPE_ESPACE", true);
if( !defined("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE) ) define("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE, "Espace");

$tabCont = array();
$tabAppli = array();
$tabAtype = array();

$tabAtype[] = -1; // chargement à chaque fois
$tabAtype[] = 1; // chargement des cstes annu
$tabAtype[] = 0; // chargement des cstes espace

$tabAppli[] = -1;
$tabCont[]  = -1;

$oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
$tabDataFromToken = array();

if (isset($_GET["ptoken"])){
  // page alias contient l'url demandée sans le nom de domaine, ni le premier slash
  $page_alias      = AlkRequest::_GET("ptoken", "");
  $mode            = AlkRequest::_GET("mode", "");
  $iAdmin          = AlkRequest::_GET("admin", 0);
  
  $user_id         = $_SESSION["alk_idUser"];
  // changement temporaire du user connecté par admin : cas newsletter 
  if ($iAdmin == 1)   {
    // 1.prendre la précaution de récupérer l'ancien user_id depuis le lieu de l'appel 
    // et prendre soin de le rechanger à la fin de l'appel
    $user_id = ALK_USER_ID_ADMINALK;
    AlkFactory::setSProperty("user_id", ALK_USER_ID_ADMINALK);
  }
  define("ALK_B_ATYPE_GEDIT", true);
  $oAppliGedit = AlkFactory::getAppli(ALK_ATYPE_ID_GEDIT);

  $tabDataFromToken = $oAppliGedit->rewriteUrl($page_alias, $mode, $user_id, $iAdmin);
  $lg = $tabDataFromToken["lg"];
  
  $_SESSION["ALK_LG_INTERNET"] = array_search($lg, $GLOBALS["tabLg"]["frontoffice"]);
  
  $strLocaleFrontOffice = ( isset($GLOBALS["tabLocales"]["frontoffice"][$_SESSION["ALK_LG_INTERNET"]]) 
                          ? $GLOBALS["tabLocales"]["frontoffice"][$_SESSION["ALK_LG_INTERNET"]]
                          : $GLOBALS["tabLocales"]["frontoffice"][0] );
  $bRes = setlocale(constant(ALK_LG_CATEGORY), $strLocaleFrontOffice);
  if( $bRes === false ) {
    // arrive si la locale n'est pas installée (retour de setlocale())
    setlocale(constant(ALK_LG_CATEGORY), $GLOBALS["tabLocales"]["frontoffice"][0]);
    $_SESSION["ALK_LG_LOCALE_INTERNET"] = $GLOBALS["tabLocales"]["frontoffice"][0];
  } else {
    $_SESSION["ALK_LG_LOCALE_INTERNET"] = $strLocaleFrontOffice;
  }
  AlkFactory::initLocale();
  
  /**
   * v3.1.23 : La vérification de droit étant trop couteuse en temps mysql, elle a lieu uniquement lors de l'initialisation de la page
   * avec la classe gedit::alkhtmlceditpage
   * v3.1.29 : réinstauration de la vérification de droit sur rewriteUrl()
   */ 

  if( !(isset($tabDataFromToken["page_id"]) && $tabDataFromToken["page_id"]>0) ) {
    // redirection à l'accueil en cas de non droit ou de page inexistante
    $iModeIdent = AlkRequest::_GETint("ident", defined("ALK_REROUTE_AUTHENTIFICATION") && ALK_REROUTE_AUTHENTIFICATION ? "1" : "0");
    if( $iModeIdent == "0" ) { 
      // redirection vers l'accueil
      header("location: ".ALK_ROOT_URL);
    } else {
      /**
       * authentification recommandée
       * dans le template : sur le onload de la page, appeler la fonction js qui affiche l'authentification de la page
       *                    l'authentification doit fonctionner en mode ajax et urlba est utilisé sitôt l'approbation
       * index.php doit rerouter vers l'accueil du site avec les paramètres suivants 
       */ 
      header("location: /index.php?ident=1&urlba=".str_replace("?ident=1", "", str_replace("&ident=1", "", $page_alias)));
    }
    exit();
  }
  
  $cont_id  = $tabDataFromToken["cont_id"];
  $appli_id = $tabDataFromToken["appli_id"];
  $page_id  = $tabDataFromToken["page_id"];
  $cat_id   = $tabDataFromToken["cat_id"];
  $data_id  = $tabDataFromToken["data_id"];
  $iMode    = $tabDataFromToken["iMode"];
  $page_contid  = $tabDataFromToken["page_contid"];
  $page_appliid = $tabDataFromToken["page_appliid"];
  $page_atypeid = $tabDataFromToken["page_atypeid"];
  
  if ($cont_id != "")
    $tabCont[]  = $cont_id;
  if ($page_contid !="")
    $tabCont[]  = $page_contid;
  $tabAppli[] = $appli_id;
  $tabAppli[] = $page_appliid;
  $tabAtype[] = ALK_ATYPE_ID_GEDIT;
  $tabAtype[] = $page_atypeid;

  // récupération des applications liées
  if ($page_atypeid == ALK_ATYPE_ID_COLLAB){
    if (!defined("ALK_B_ATYPE_COLLAB")) define("ALK_B_ATYPE_COLLAB", true);
    $oQueryCollab = AlKFactory::getQuery(ALK_ATYPE_ID_COLLAB);
    $dsAppli = $oQueryCollab->getDsAppliIdLie($page_appliid);
    
    while($drAppli = $dsAppli->getRowIter()){
       $tabAtype[] = $drAppli->getValueName("ATYPE_IDL");
       $tabAppli[] = $drAppli->getValueName("APPLI_IDL");
    }
  }
  
  // mode site avec url rewriting, lire le token et y ajouter les param du ptoken
  $strToken = AlkRequest::_REQUEST("token", "");
  $strParam = ( $strToken != "" ? "&" : "" ).
    "cont_id=".$cont_id."&appli_id=".$appli_id."&page_id=".$page_id.
    "&cat_id=".$cat_id."&data_id=".$data_id."&iMode=".$iMode."&lg=".ALK_LG;
  foreach($_GET as $key=>$value) {
    $strParam .= "&".$key."=".$value;
  }
  $_REQUEST["token"] = AlkRequest::getEncodeParam(AlkRequest::getDecodeParam($strToken).$strParam);
  AlkRequest::readToken();
  
} else {
  //define("ALK_LG", $_SESSION["ALK_LG"]);
  AlkFactory::initLocale();
  
  if ( !AlkRequest::readToken() ) {
    echo "<html><head><script type='text/javascript'>".
      " function onLoadWind() {".
      "   window.top.location = '".ALK_ALKANET_IDENT."?err=7';".
      " } </script></head><body onload='onLoadWind()'></body></html>";
    exit();
  }
  $cont_id = AlkRequest::getToken("cont_id", "-1");
  $appli_id = AlkRequest::getToken("appli_id", "-1");
  $page_contid  = -1;
  $page_appliid = -1;
  $tabCont[]  = $cont_id;
  $tabAppli[] = $appli_id;
  $tabAtype[] = $oQueryEspace->getATypeID($appli_id);
  
  if( !defined("ALK_B_ATYPE_ESPACE") ) define("ALK_B_ATYPE_ESPACE", true);
  if( !defined("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE) ) define("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE, "Espace");
}

/** 
 * @brief applitype_id permet d'instancier une application n'ayant pas de appli_id
 *        comme l'éditeur, le circuit de validation
 *        Ces applis sont instanciés avec le appli_id qui utilise cette sous-appli
 */
$applitype_id = AlkRequest::getToken("applitype_id", "-1");

if( !(is_numeric($cont_id) && floor($cont_id)==$cont_id && $cont_id > 0) ) {
  echo "<html><head><script type='text/javascript'>".
    " function onLoadWind() {".
    "   window.top.location = '".ALK_ALKANET_IDENT."?err=7';".
    " } </script></head><body onload='onLoadWind()'></body></html>";
  exit();
}

if( $applitype_id == "-1" ) {
  switch( $appli_id ) {
  case -3: $atype_id = ALK_ATYPE_ID_FORM; break;
  case -2: $atype_id = ALK_ATYPE_ID_SYND; break;
  case -1: $atype_id = ALK_ATYPE_ID_ESPACE; break;
  case 0:  $atype_id = ALK_ATYPE_ID_ANNU;   break;
  default: $atype_id = $oQueryEspace->getATypeID($appli_id); break;
  }
} else {
  $atype_id = $applitype_id;
}

/** chargement des constantes */
AlkFactory::loadConstants($tabCont, $tabAppli, $tabAtype);

AlkFactory::setSProperty("cont_id", $cont_id);
AlkFactory::setSProperty("appli_id", $appli_id);
AlkFactory::setSProperty("atype_id", $atype_id);

$oSpace = AlkFactory::getSpace($cont_id);
if( $atype_id > 0 ) {
  $oAppli = AlkFactory::getAppli($atype_id, $appli_id);
} else {
  $oAppli = $oSpace;
}

if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."app_conf_template.php") ) { 
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."app_conf_template.php");
}
if( !defined("ALK_ROOT_TEMPLATE") )  define("ALK_ROOT_TEMPLATE",  ALK_ROOT_CONF."templates/");

/**
 * @brief oAppli->verifSecu() 
 *        met à jour user_priv et user_right par rapport 
 *        à l'espace courant et à l'application courante
 */
$binternet = AlkFactory::getSProperty("bInternet", false);
if( ($atype_id == ALK_ATYPE_ID_FORM && $appli_id==-3 && !$binternet) ||
    ($atype_id == ALK_ATYPE_ID_SYND && $appli_id==-2 && !$binternet) ||
    $binternet && $appli_id>0 ) {
  /* utilisateur authentifié, pas de vérification */
  /* on n'autorise pas l'accès aux applis annuaire et espace en mode internet */
} 
elseif( !is_null($oAppli) && !$oAppli->verifSecu()  && !($_SESSION["alk_idUser"]==ALK_USER_ID_INTERNET) ) {
  echo "<html><head><script type='text/javascript'>".
    " function onLoadWind() {".
    "   window.top.location = '".ALK_ALKANET_IDENT."?err=1';".
    " } </script></head><body onload='onLoadWind()'><!--<a href='javascript:onLoadWind()'>Aucun droit, redirection vers l'authentification.</a>--></body></html>";
  exit();
}
else {
  /* l'utilisateur est authentifié et ses droits vérifiés */
  
  /* on autorise $oAppli à null : cas prodigedist par exemple */
}

if( $oSpace != null ) {
  $oSpace->updateStat($cont_id, $appli_id);
  // mise à jour des stats pour les pages gedit
  if( isset($tabDataFromToken["page_id"]) && $tabDataFromToken["page_id"]>0) {
    $oSpace->updateStatAppli(ALK_ATYPE_ID_GEDIT, $appli_id, ALK_SIT_DATATYPE_GEDIT, $tabDataFromToken["page_id"], $_SESSION["alk_idUser"], ALK_STATACTION_CONSULT);
  }
  
  // enregistrement des connexions
  $oSpace->updateConnnexionUser($_SESSION["alk_idUser"], session_id(), $cont_id, $appli_id, $page_contid, $page_appliid);  
}

/* par sécurité, on met oSpace à null également, après enregistrement des stats */
if( is_null($oAppli) ) {
  $oSpace = null; 
}

// traduction des éléments déclarés avant l'appel de AlkFactory::initLocale()
translateConf();

?>